
select tariff_zone,market_segment,tier
        ,date_trunc('week', calday)::date as week --, date_part( 'week', calday) as week2
        ,sum(deliveries_total) as deliveries_total  --Заявок на доставку
        ,sum(deliveries_cnt) as deliveries_cnt     -- Успешные доставки -- CR-- вычислимое
        ,sum(deliveries_expired) as  deliveries_expired -- Заявок сгорело
        ,sum(deliveries_failed) as deliveries_failed -- Заявок с ошибкой
        ,sum(deliveries_cancelled_by_courier) as deliveries_cancelled_by_courier -- Отменено курьером
        ,sum(deliveries_cancelled_by_client) as deliveries_cancelled_by_client -- Отменено клиентом
        ,sum(deliveries_found) as  deliveries_found-- Курьер найден
        ,sum(searching_time_sec) as searching_time_sec
        ,sum(dlv_for_searching_time) as dlv_for_searching_time  --Время поиска -- вычислимое
        ,sum(deliveries_a_arrived) as  deliveries_a_arrived          --Курьер прибыл на A
        ,sum(driving_to_a_time_sec) as driving_to_a_time_sec
        ,sum(dlv_for_driving_to_a_time) as dlv_for_driving_to_a_time  -- Время в пути до А
        ,sum(arrival_time_sec) as arrival_time_sec
        ,sum(dlv_for_arrival_time) as dlv_for_arrival_time -- Время подачи
        ,sum(waiting_a_time_sec) as waiting_a_time_sec
        ,sum(dlv_for_waiting_a_time) as dlv_for_waiting_a_time -- Время ожидания на А
        ,sum(transporting_time_sec) as transporting_time_sec
        ,sum(dlv_for_transporting_time) as dlv_for_transporting_time-- Время развоза
        ,sum(total_time_sec) as total_time_sec
        ,sum(dlv_for_total_time) as  dlv_for_total_time -- Время на доставку
        ,sum(distance) as  distance
        ,sum(deliveries_total_w_distance) as  deliveries_total_w_distance-- Средняя дистанция, км
        ,sum(gmv) as  gmv-- Средняя цена доставки
        ,sum(net_inflow) as net_inflow -- NI %
from snb_b2b.niksm_dash_logdata111
where which_crm=6
and tariff_zone in (
    'moscow','balashiha','podolsk','himki','mytishchi','korolev','lyberci','krasnogorsk','electrostal','zheleznodorozhny','kolomna',
    'odincovo','domodedovo','shelkovo','serpukhov','ramenskoe','orehovozuevo','dolgoprudniy','pushkino','reutov','noginsk','sergievposad',
    'voskresensk','lobnja','ivanteevka','klin','vidnoe','dubna','egorievsk','chehov','dmitrov','narofominsk','stupino','pavlovskyposad',
    'troick','lytkarino','fryazino','shcherbinka','dzerzhinsky','kotelniki','solnechnogorsk','nakhabino','krasnoznamensk','protvino',
    'istra','shatura','aprelevka','lukhovitsy','mozhaysk','likino_dulyovo','krasnoarmeysk','ozery','zaraysk','elektrogorsk','bronnitsi',
    'zvenigorod','hotkovo','chernogolovka','elektrougli','pushino','kurovskoye','monino','kubinka','roshal','volokolamsk','tuchkovo',
    'golicyno','sofrino','ruza','nekrasovskij','mikhnevo')
and calday between '2021-01-01' and '2022-01-23'
group by tariff_zone,market_segment,tier ,date_trunc('week', calday)::date