select fct_order.corp_client_id,
       fct_order.corp_contract_id,
       blnc.service_ids::text as "Сервисы Баланса",
       order_tariff is not null as "Тариф доставки",
       order_source_code,
       claim.api_source_type,
       count() as "Заказы",
       sum(delivery_point_cnt) as "Доставки"
from taxi_cdm_marketplace.fct_order
  left join snb_delivery.logdata_delivery_tariff
    on order_tariff = tariff_class_code
  left join delivery_ods_cargo_claims.claim
    on claim.taxi_order_id = order_id
    and utc_created_dttm >= current_date-90
  left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = fct_order.corp_contract_id
where utc_order_created_dttm >= current_date-90
  and country_name_ru = 'Казахстан'
  and corp_order_flg
  and success_order_flg
group by 1,2,3,4,5,6