drop table IF EXISTS snb_delivery.niksm_temp_partner_ltv_1503_raw;
create table snb_delivery.niksm_temp_partner_ltv_1503_raw as
-- truncate table snb_delivery.niksm_temp_partner_ltv_1503_raw;
-- insert into snb_delivery.niksm_temp_partner_ltv_1503_raw
select person_inn,
       msk_order_created_dt,
       sum(delivery_point_cnt) as deliveries_cnt,
       sum(order_cost) as gmv,
       min(case when manager_group = 'Тир 3' then 'Тир 3' else 'Тир 2' end) as tier
from taxi_cdm_marketplace.fct_order fct
  join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = fct.corp_contract_id
  join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = fct.corp_contract_id
where true
  and fct.utc_order_created_dttm>='2020-01-01'
  and corp_order_flg
  and fct.currency_code = 'RUB'
  and success_order_flg
  and manager_group in ('ГМП 1','ГМП 2','ГМП 3','ГМП 4','Тир 3')
  and person_inn is not null
group by 1,2
-- distributed by (person_inn)
;
analyse snb_delivery.niksm_temp_partner_ltv_1503_raw;
revoke select on snb_delivery.niksm_temp_partner_ltv_1503_raw from ro_snb_delivery;


with init as (
    select person_inn, first_dlv_dt,
           case when first_month_deliveries < 100 then floor(first_month_deliveries/50.)*50
                when first_month_deliveries < 500 then floor(first_month_deliveries/100.)*100
                else 500 end as first_month_deliveries_class
    from (
        select person_inn,
               max(first_dlv_dt) as first_dlv_dt,
               sum(case when msk_order_created_dt<=first_dlv_dt+91 then deliveries_cnt else 0 end)/3. as first_month_deliveries
        from (
            select *,
                   min(msk_order_created_dt) over (partition by person_inn) as first_dlv_dt
            from snb_delivery.niksm_temp_partner_ltv_1503_raw
            ) q
        group by person_inn
        ) qq
)
, t as (
    select raw.person_inn,
           floor((msk_order_created_dt-first_dlv_dt)/91.) as period_id,
           --
           floor((current_date-max(first_dlv_dt))/91.) as hist_len,
           max(tier) as tier,
           max(first_month_deliveries_class) as first_month_deliveries_class,
           sum(deliveries_cnt) deliveries_cnt,
           sum(gmv) gmv
    from snb_delivery.niksm_temp_partner_ltv_1503_raw raw
      join init
        on init.person_inn = raw.person_inn
    group by 1,2
)
select hist_len,
       tier,
       first_month_deliveries_class,
       period_id,
       count(person_inn) as clients_cnt,
       sum(deliveries_cnt) deliveries_cnt,
       sum(gmv) gmv
from t
group by 1,2,3,4;

with t as (
    select person_inn,
           date_trunc('month',msk_order_created_dt)::date as calmonth,
           ctp.tariff_plan_series_id,
           tp.tariff_plan_name,
           tariff_class_code,
           sum(delivery_point_cnt) as deliveries_cnt,
           sum(gmv_amt) as gmv_amt,
           sum(net_inflow_amt) as net_inflow_amt,
           sum(gross_commission_revenue_amt) as gross_commission_revenue_amt,
           sum(incentives_amt) as incentives_amt,
           sum(b2b_decoupling_amt) as b2b_decoupling_amt
    from taxi_cdm_marketplace.fct_order_metric fct
      join snb_b2b.niksm_b2b_contracts_info crm
        on crm.contract_id = fct.corp_contract_id
      join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
        on blnc.contract_external_id = fct.corp_contract_id
      left join taxi_ods_dbcorp.client_tariff_plan ctp
        on ctp.corp_client_id = fct.corp_client_id
        and service_name = 'cargo'
        and fct.utc_order_created_dttm >= ctp.tariff_plan_valid_from_dttm
        and (fct.utc_order_created_dttm < ctp.tariff_plan_valid_to_dttm
             or ctp.tariff_plan_valid_to_dttm is null)
      left join taxi_ods_dbcorp.tariff_plan tp
        on ctp.tariff_plan_series_id = tp.tariff_plan_series_id
        and fct.utc_order_created_dttm >= tp.date_from_dttm
        and (fct.utc_order_created_dttm < tp.date_to_dttm
             or tp.date_to_dttm is null)
    where true
      and fct.utc_order_created_dttm >= '2021-06-30'
      and msk_order_created_dt between '2021-07-01' and '2022-02-28'
      and corp_order_flg
      and fct.currency_code = 'RUB'
      and success_order_flg
      and manager_group in ('ГМП 1','ГМП 2','ГМП 3','ГМП 4','Тир 3')
      and person_inn is not null
    group by 1,2,3,4,5
)
select calmonth,
       tariff_plan_series_id,
       tariff_plan_name,
       tariff_class_code,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(gmv_amt) as gmv_amt,
       sum(net_inflow_amt) as net_inflow_amt,
       sum(gross_commission_revenue_amt) as gross_commission_revenue_amt,
       sum(incentives_amt) as incentives_amt,
       sum(b2b_decoupling_amt) as b2b_decoupling_amt
from t
where deliveries_cnt between 50 and 400
group by 1,2,3,4 order by 1;
