with cntr as (
    select distinct billing_client_id
    from snb_b2b.bmiklaz_corp_contracts
    where true
      and (service_ids::text like '%650%'
        or service_ids::text like '%718%')
)
, t as (
    select cc.id,
           cc.name,
           cc.description,
           services
    --        services -> 'cargo' ->> 'is_active' as services_cargo_is_active,
    --        services -> 'taxi' ->> 'is_active' as services_taxi_is_active
    from snb_b2b.bmiklaz_corp_clients cc
      left join cntr
        on cc.billing_id = cntr.billing_client_id
    where true
      and cntr.billing_client_id is null
      and (cc.description like '%ДЕМО%'
       or cc.description like '%DEMO%'
       or cc.description like '%ТЕСТ%')
      and (services -> 'cargo' ->> 'is_active') = '1'
)
select id,
       name,
       description,
       active_services
from t,
     lateral (
        select string_agg(service_name,',') as active_services
        from (
            select
               (json_each(services)).key as service_name,
               (json_each(services)).value ->> 'is_active' as service_is_active
            ) q
        where service_is_active = '1'
     ) qq
