select extract(hour from moscow_order_dttm) as order_hour,
       success_order_flg,
       status,
       taxi_status,
       count() as orders_cnt,
       sum(n_deliveries_total) as deliveries_total,
       sum(n_deliveries_visited) as deliveries_cnt
from snb_taxi.logdata_dm_order_v dmo
where utc_order_dt >= '2021-03-01'::date-1
  and moscow_order_dt between '2021-03-01' and '2021-03-31'
  and corp_client_id = 'd471ffcf960d4eb6b37a25c27cb36123'
group by 1,2,3,4;



select status_code,
       order_hour,
--        n_deliveries_total,
       count() as claims_cnt,
       sum(n_deliveries_total) as deliveries_total,
       sum(n_deliveries_visited) as deliveries_cnt
from (
    SELECT cl.claim_id,
           cl.status_code,
           extract(hour from cl.utc_created_dttm+interval '3 hours') as order_hour,
           count(*)                                                        AS n_deliveries_total,
           count(*) FILTER (WHERE cp.point_status::text = 'visited'::text) AS n_deliveries_visited
    FROM delivery_ods_cargo_claims.claim cl
      JOIN delivery_ods_cargo_claims.claim_segment cs ON cl.claim_id = cs.claim_id
      JOIN delivery_ods_cargo_claims.claim_segment_point cp ON cs.claim_segment_id = cp.claim_segment_id
    WHERE cp.point_type::text = 'destination'::text
      and corp_client_id = 'd471ffcf960d4eb6b37a25c27cb36123'
      and cl.utc_created_dttm between timestamp'2021-02-28 21:00:00' and timestamp'2021-03-31 20:59:59'
      and cs.utc_created_dttm >= '2021-02-28'
      and cp.utc_created_dttm >= '2021-02-28'
      and cl.yandex_login not in ('ozonmarcket')
    group by 1,2,3
) q
group by 1,2;


select *
FROM delivery_ods_cargo_claims.claim cl
where corp_client_id = 'd471ffcf960d4eb6b37a25c27cb36123'
  and cl.utc_created_dttm between timestamp'2021-02-28 21:00:00' and timestamp'2021-03-31 20:59:59'
limit 50;