select dmo.city,
       coalesce(a_comb.grouped_address, dmo.order_source_address) as order_source_address,
       date_trunc('week',dmo.moscow_order_dt)::date as calweek,
       sum(n_deliveries_visited) as deliveries_cnt
from snb_taxi.logdata_dm_order_v as dmo
  left join snb_taxi.niksm_b2b_a_points_combination as a_comb
    on a_comb.raw_address = dmo.order_source_address
    and a_comb.corp_client_id = dmo.corp_client_id
where true
  and dmo.utc_order_dt >= '2020-03-01'
  and moscow_order_dt between '2020-03-30' and (date_trunc('week',current_date) - interval '1 day')::date
  and logistic_tariff_flag
  and dmo.success_order_flg
  and not dmo.fake_order_flg
  and not dmo.mqc_order_flg
  and corp_contract_id = '951088/20'
  and success_order_flg
group by 1,2,3
order by calweek;