-- 1) temporary table clients
-- 2) main data by client
-- 3) daily data by day-client

drop table if exists clients;
create temporary table clients as
select lk.corp_client_id,
       lk.corp_contract_id,
       case when crm_cntr.contract_id is not null then crm_cntr.lead_id
            else crm_phnx.lead_id end as lead_id,
       case when crm_cntr.contract_id is not null then crm_cntr.pipeline_name
            else crm_phnx.pipeline_name end as pipeline_name,
       case when crm_cntr.contract_id is not null then crm_cntr.pipeline_status_name
            else crm_phnx.pipeline_status_name end as pipeline_status_name,
       case when crm_cntr.contract_id is not null then crm_cntr.price
            else crm_phnx.price end as potential,
       case when crm_cntr.contract_id is not null then crm_cntr.channel
            else crm_phnx.channel end as channel,
       case when crm_cntr.contract_id is not null then crm_cntr.lead_status
            else crm_phnx.lead_status end as lead_status,
       case when crm_cntr.contract_id is not null then crm_cntr.integration_status
            else crm_phnx.integration_status end as integration_status,
       case when crm_cntr.contract_id is not null then crm_cntr.tags
            else crm_phnx.tags end as tags,
       case when crm_cntr.contract_id is not null then crm_cntr.product
            else crm_phnx.product end as product,
       case when crm_cntr.contract_id is not null then crm_cntr.country
            else crm_phnx.country end as country,
       case when crm_cntr.contract_id is not null then crm_cntr.city
            else crm_phnx.city end as city,
       case when crm_cntr.contract_id is not null then crm_cntr.market_segment
            else crm_phnx.market_segment end as market_segment,
       case when crm_cntr.contract_id is not null then crm_cntr.tier
            else crm_phnx.tier end as tier,
       case when crm_cntr.contract_id is not null then crm_cntr.manager_login
            else crm_phnx.manager_login end as manager_login,
       case when crm_cntr.contract_id is not null then crm_cntr.manager_name
            else crm_phnx.manager_name end as manager_name,
       case when crm_cntr.contract_id is not null then crm_cntr.teamlead_name
            else crm_phnx.teamlead_name end as teamlead_name,
       case when crm_cntr.contract_id is not null then crm_cntr.manager_group
            else crm_phnx.manager_group end as manager_group,
       case when crm_cntr.contract_id is not null then crm_cntr.manager_metagroup
            else crm_phnx.manager_metagroup end as manager_metagroup,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_potential::bigint
            else crm_phnx.sdd_potential::bigint end as sdd_potential,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_connected_options
            else crm_phnx.sdd_connected_options end as sdd_connected_options,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_pipeline_stage
            else crm_phnx.sdd_pipeline_stage end as sdd_pipeline_stage,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_reason_loss
            else crm_phnx.sdd_reason_loss end as sdd_reason_loss,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_integration_status
            else crm_phnx.sdd_integration_status end as sdd_integration_status,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_dynamics
            else crm_phnx.sdd_dynamics end as sdd_dynamics,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_reason_churn
            else crm_phnx.sdd_reason_churn end as sdd_reason_churn,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_wishlist
            else crm_phnx.sdd_wishlist end as sdd_wishlist,
       case when crm_cntr.contract_id is not null then crm_cntr.sdd_ticket_logistariff
            else crm_phnx.sdd_ticket_logistariff end as sdd_ticket_logistariff,
       case when crm_cntr.contract_id is not null then crm_cntr.lead_name
            else crm_phnx.lead_name end as lead_name,
       case when crm_cntr.contract_id is not null then crm_cntr.company_name
            else crm_phnx.company_name end as company_name,
       case when crm_cntr.contract_id is not null then crm_cntr.holding_name
            else crm_phnx.holding_name end as holding_name
from snb_b2b.dbcorp_client_info lk
  left join snb_b2b.amo_contracts_info crm_cntr
    on crm_cntr.contract_id = lk.corp_contract_id
  left join snb_b2b.amo_clients_info crm_phnx
    on crm_phnx.corp_client_id = lk.corp_client_id
where crm_cntr.contract_id is not null
   or crm_phnx.corp_client_id is not null;

-- main
with points as (
    select claim_id,
           count(distinct point_id) as deliveries_cnt
    from delivery_ods_cargo_claims.claim_point
    where utc_created_dttm >= timestamp'2022-03-01'
      and point_type = 'destination'
      and visit_status = 'visited'
    group by claim_id
)
select clients.corp_client_id,
       clients.corp_contract_id, lead_id, pipeline_name, pipeline_status_name, potential,
       channel, lead_status, integration_status, tags, product, country, city, market_segment, tier,
       manager_login, manager_name, teamlead_name, manager_group, manager_metagroup,
       sdd_potential, sdd_connected_options, sdd_pipeline_stage, sdd_reason_loss, sdd_integration_status,
       sdd_dynamics, sdd_reason_churn, sdd_wishlist, sdd_ticket_logistariff,
       --
       coalesce(sum(case when fct_order.msk_order_created_dt between '2022-04-01' and '2022-04-30' then deliveries_cnt else 0 end),0) as deliveries_apr22,
       coalesce(sum(case when fct_order.msk_order_created_dt between '2022-05-01' and '2022-05-31' then deliveries_cnt else 0 end),0) as deliveries_may22,
       coalesce(sum(case when fct_order.msk_order_created_dt between '2022-06-01' and '2022-06-30' then deliveries_cnt else 0 end),0) as deliveries_jun22,
       min(fct_order.msk_order_created_dt) as msk_1st_sdd_delivery
from delivery_ods_cargo_claims.claim
  join points
    on points.claim_id = claim.claim_id
  join taxi_cdm_marketplace.fct_order
    on fct_order.order_id = claim.taxi_order_id
  join clients
    on claim.corp_client_id = clients.corp_client_id
where true
  and claim.utc_created_dttm >= timestamp'2022-03-01'
  and fct_order.utc_order_created_dttm >= timestamp'2022-03-01'
  and tariff_class_code = 'night'
group by clients.corp_client_id,
       clients.corp_contract_id, lead_id, pipeline_name, pipeline_status_name, potential,
       channel, lead_status, integration_status, tags, product, country, city, market_segment, tier,
       manager_login, manager_name, teamlead_name, manager_group, manager_metagroup,
       sdd_potential, sdd_connected_options, sdd_pipeline_stage, sdd_reason_loss, sdd_integration_status,
       sdd_dynamics, sdd_reason_churn, sdd_wishlist, sdd_ticket_logistariff;

-- daily
with points as (
    select claim_id,
           count(distinct point_id) as deliveries_cnt
    from delivery_ods_cargo_claims.claim_point
    where utc_created_dttm >= timestamp'2022-03-01'
      and point_type = 'destination'
      and visit_status = 'visited'
    group by claim_id
)
select clients.corp_client_id,
       clients.corp_contract_id,
       manager_login, manager_name, teamlead_name, manager_group, manager_metagroup,
       fct_order.msk_order_created_dt,
       sum(deliveries_cnt) as deliveries_cnt
from delivery_ods_cargo_claims.claim
  join points
    on points.claim_id = claim.claim_id
  join taxi_cdm_marketplace.fct_order
    on fct_order.order_id = claim.taxi_order_id
  join clients
    on claim.corp_client_id = clients.corp_client_id
where true
  and claim.utc_created_dttm >= timestamp'2022-03-01'
  and fct_order.utc_order_created_dttm >= timestamp'2022-03-01'
  and tariff_class_code = 'night'
group by clients.corp_client_id,
       clients.corp_contract_id,
       manager_login, manager_name, teamlead_name, manager_group, manager_metagroup,
       fct_order.msk_order_created_dt;
