select corp_contract_id,
       (corp_contract_id in ('554992/20', '1110617/20', '1376324/20', '941970/20', '1132754/20', '1660587/21', '394875/19')) as top7,
       corp_client_id,
       corp_client_name,
       city,
       date_trunc('week',moscow_order_dt)::date as calweek_msk,
       sum(plan_travel_distance_km) as plan_travel_distance_km,
       sum(travel_distance_km) as travel_distance_km,
       sum(order_cost * currency_rate) as gmv,
       sum(net_inflow * currency_rate) as net_inflow,
       sum(n_deliveries_visited) as deliveries_cnt
from snb_taxi.logdata_dm_order_v as dmo
  join snb_taxi.niksm_b2b_contracts_info
    on corp_contract_id = contract_id
where true
  and order_tariff = 'courier'
  and utc_order_dt >= '2021-04-01'
  and moscow_order_dt between '2021-04-05' and current_date-1
  and corp_order_flg
  and success_order_flg
  and which_crm = 6
  and manager_group in ('ГПП 1','ГПП 2')
group by corp_contract_id,
         corp_client_id,
         corp_client_name,
         city,
         date_trunc('week', moscow_order_dt)::date
order by calweek_msk;

select corp_contract_id,
       corp_client_id,
       corp_client_name,
       city,
       date_trunc('month',moscow_order_dt)::date as calmonth,
       sum(n_deliveries_visited) as deliveries_cnt
from snb_taxi.logdata_dm_order_v as dmo
where true
  and logistic_tariff_flag
  and utc_order_dt between '2020-04-01' and '2021-04-14'
  and corp_order_flg
  and success_order_flg
  and corp_contract_id in ('554992/20', '1110617/20', '1376324/20', '941970/20', '1132754/20', '1660587/21', '394875/19')
--   and which_crm = 6
--   and manager_group in ('ГМП','Тир 3')
group by corp_contract_id,
         corp_client_id,
         corp_client_name,
         city,
         date_trunc('month', moscow_order_dt)::date
order by deliveries_cnt desc;