drop table if exists niksm_temp_dash_robot_dlv_1st;
create temporary table niksm_temp_dash_robot_dlv_1st as
select corp_client_id,
       corp_contract_id,
       min(msk_order_created_dt) as first_delivery_dt
from taxi_cdm_marketplace.fct_order
  join snb_delivery.logdata_delivery_tariff lgst
    on lgst.order_tariff = fct_order.tariff_class_code
    and fct_order.utc_order_created_dttm between utc_datefrom and utc_dateto
where true
  and utc_order_created_dttm >= '2019-01-01'
  and msk_order_created_dt between '2019-01-01' and current_date-1
  and success_order_flg
  and corp_order_flg
  and delivery_point_cnt > 0
group by corp_client_id,
         corp_contract_id
distributed by (corp_client_id, corp_contract_id)
;
analyze niksm_temp_dash_robot_dlv_1st;
------------------------------------
drop table if exists ndd_deliveries;
CREATE TEMPORARY TABLE ndd_deliveries as
select corp_contract_id,
       'NDD'::varchar as tariff_class_code,
       count (distinct request_id) as deliveries_cnt
from
    (
        select distinct
            request_id,
            lk.corp_contract_id,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from snb_delivery.logdata_ndd_requests_datamart a
          left join core_cdm_geo.v_dim_fi_geo_hierarchy geo
            on a.delivery_region = geo.geobase_id
          left join snb_b2b.dbcorp_client_info lk
            on lk.corp_client_id = a.corp_client_id
        where true
          and mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
          and tech_event_instant_ddtm::date <= current_date-1
          and (delivery_country = 'Россия' or delivery_country is null)
    ) ndd
where first_day  between '2022-06-01' and '2022-06-30'
group by 1;

drop table if exists points;
CREATE TEMPORARY TABLE points as
select claim_id,
       count(distinct point_id) as deliveries_cnt
from delivery_ods_cargo_claims.claim_point
where utc_created_dttm >= current_date-65
  and point_type = 'destination'
  and visit_status = 'visited'
group by claim_id
distributed by (claim_id);

drop table if exists sdd_deliveries;
CREATE TEMPORARY TABLE sdd_deliveries as
select lk.corp_contract_id,
       'SDD'::varchar as tariff_class_code,
       sum(deliveries_cnt) as deliveries_cnt
from delivery_ods_cargo_claims.claim
  join points
    on points.claim_id = claim.claim_id
  join taxi_cdm_marketplace.fct_order
    on fct_order.order_id = claim.taxi_order_id
  join snb_b2b.dbcorp_client_info lk
    on claim.corp_client_id = lk.corp_client_id
where true
  and claim.utc_created_dttm >= current_date-65
  and fct_order.utc_order_created_dttm >= current_date-45
  and tariff_class_code = 'night'
  and msk_order_created_dt  between '2022-06-01' and '2022-06-30'
group by 1;

drop table if exists main_deliveries;
CREATE TEMPORARY TABLE main_deliveries as
select corp_contract_id,
       tariff_class_code,
       sum(delivery_point_cnt) as deliveries_cnt
from taxi_cdm_marketplace.fct_order
where true
  and delivery_point_cnt > 0
  ---- 30 days
  and utc_order_created_dttm >= current_date - 45
  and msk_order_created_dt between '2022-06-01' and '2022-06-30'
  and tariff_class_code <> 'night'
group by 1,2;

drop table if exists deliveries;
CREATE TEMPORARY TABLE deliveries as
with raw as (
    select corp_contract_id, tariff_class_code, deliveries_cnt from ndd_deliveries
    union all
    select corp_contract_id, tariff_class_code, deliveries_cnt from sdd_deliveries
    union all
    select corp_contract_id, tariff_class_code, deliveries_cnt from main_deliveries
)
select corp_contract_id,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(deliveries_cnt) filter ( where tariff_class_code in ('courier','express') ) as deliveries_express_cnt,
       sum(deliveries_cnt) filter ( where tariff_class_code in ('SDD') ) as deliveries_sdd_cnt,
       sum(deliveries_cnt) filter ( where tariff_class_code in ('NDD') ) as deliveries_ndd_cnt
from raw
group by corp_contract_id
distributed by (corp_contract_id);
------------------------------------
create temporary table temp_dlv as
select corp_client_id,
       corp_contract_id,
       sum(case when msk_order_created_dt between '2022-05-01' and '2022-05-31' then  delivery_point_cnt else 0 end) as deliveries_cnt_may
from taxi_cdm_marketplace.fct_order
where true
  and utc_order_created_dttm >= timestamp'2022-05-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and msk_order_created_dt between '2022-05-01' and '2022-05-31'
  and success_order_flg
  and corp_order_flg
group by corp_client_id,
         corp_contract_id
having sum(delivery_point_cnt) > 0
distributed by (corp_client_id, corp_contract_id)
;
;
with mng_l as (
  select distinct manager_login
from snb_b2b.amo_leads_info
where true
and manager_metagroup='Тир 2'
)
, ld_hst as (
select aml_h.*, max((mng_l is not null)::int) over (partition by lead_id) as rn
, lag(aml_h.manager_login) over(partition by lead_id order by msk_snapshot_dt) as mng_last,
  msk_snapshot_dt::date-1 as calday
from snb_b2b.amo_leads_info_hist aml_h
 left join mng_l
on mng_l.manager_login=aml_h.manager_login
where msk_snapshot_dt between '2022-06-01' and '2022-07-01'
 )
,ld_m as (select lead_id
               , array_agg(manager_login) as manager_login_hist
               , array_agg(user_group_name) as manager_group_hist
               , array_agg(mng_last)      as mng_last
               , array_agg(calday)        as calday_change
--     lead_id, count(*)
          from ld_hst
          where rn = 1
            and calday between '2022-06-01' and '2022-07-01'
            and manager_login <> mng_last
          group by lead_id)
, lead_list as
    (select ld_m.lead_id
, manager_login_hist
, manager_group_hist
, mng_last
, calday_change
, coalesce(aml.corp_client_id, lkc.lk_client_id) as corp_client_id
, aml.contract_id
, company_name
, lead_status                                    as status
, country
, city
, pipeline_name
, pipeline_status_name
, channel
, market_segment
, tags
, product
, integration_status
, price
, manager_group
, teamlead_name
, manager_login
, manager_name
from ld_m
left join snb_b2b.amo_leads_info aml on aml.lead_id = ld_m.lead_id
left join snb_b2b.niksm_b2b_lk_contract_info lkc on lkc.contract_external_id = aml.contract_id
)
select ll.*
, coalesce(dlv_1st.first_delivery_dt, dlv_1st_cl.first_delivery_dt) first_delivery_dt
, coalesce(temp_dlv.deliveries_cnt_may, temp_dlv_cl.deliveries_cnt_may) deliveries_cnt_may
,  deliveries_cnt
, deliveries_express_cnt
, deliveries_sdd_cnt
, deliveries_ndd_cnt
from lead_list ll
left join niksm_temp_dash_robot_dlv_1st dlv_1st on  dlv_1st.corp_contract_id=ll.contract_id
left join niksm_temp_dash_robot_dlv_1st dlv_1st_cl on dlv_1st_cl.corp_client_id=ll.corp_client_id and dlv_1st_cl.corp_contract_id is null
left join temp_dlv temp_dlv on  temp_dlv.corp_contract_id=ll.contract_id
left join temp_dlv temp_dlv_cl on temp_dlv_cl.corp_client_id=ll.corp_client_id and temp_dlv_cl.corp_contract_id is null
left join deliveries dlvr on dlvr.corp_contract_id=ll.contract_id
;
