-- Воронка + % от потенциала
with dlv as (
    select company_id,
           sum(case when msk_order_created_dt between
                    greatest(current_date-30,delivery_1st_dt)
                    and current_date-1
               then delivery_point_cnt else 0 end)*30.
            / greatest(7,least(30,current_date-min(delivery_1st_dt))) as deliveries_30d,
           sum(delivery_point_cnt) as delivery_point_cnt,
           min(delivery_1st_dt) as delivery_1st_dt
    from (
        select company_id,
               msk_order_created_dt,
               min(msk_order_created_dt) over (partition by company_id) as delivery_1st_dt,
               delivery_point_cnt
        from taxi_cdm_marketplace.fct_order
          join snb_b2b.amo_contracts_info
            on corp_contract_id = contract_id
        where utc_order_created_dttm >= '2022-01-01'
          and delivery_point_cnt>0
          and market_segment = 'Рестораны и кафе'
        ) q
    group by company_id
)
, hist as (
    select company_id,
           min(case when pipeline_name in ('ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ') then msk_snapshot_dt end)-1 as lead_init_dt,
           bool_or(pipeline_name in ('ЗАПУСК И РАЗВИТИЕ')) as launch_flg,
           min(case when pipeline_name in ('ЗАПУСК И РАЗВИТИЕ') then msk_snapshot_dt end)-1 as launch_dt,
           max(case when lead_status = 'open' and not pipeline_status_name in ('РАСТОРГНУТ ПО ИНИЦИАТИВЕ КЛИЕНТА','РАСТОРГНУТ ПО ИНИЦИАТИВЕ ЯНДЕКСА')
                    then msk_snapshot_dt end)-1 as last_open_dt
    from snb_b2b.amo_leads_info_hist
    where true
      and market_segment = 'Рестораны и кафе'
--       and msk_snapshot_dt >= '2022-05-01'
    group by 1
    having bool_or(pipeline_name in ('ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ'))
)
, ptnt as (
    select company_id,
           sum(price) as potential,
           bool_or(lead_status = 'open' and not pipeline_status_name in ('РАСТОРГНУТ ПО ИНИЦИАТИВЕ КЛИЕНТА','РАСТОРГНУТ ПО ИНИЦИАТИВЕ ЯНДЕКСА')) as open_flg
    from snb_b2b.amo_leads_info
    where true
      and market_segment = 'Рестораны и кафе'
    group by 1
)
select date_trunc('week',lead_init_dt)::date as lead_init_calweek,
       date_trunc('week',least(launch_dt,delivery_1st_dt))::date as launch_calweek,
       date_trunc('week',delivery_1st_dt)::date as delivery_1st_calweek,
       case when not open_flg then date_trunc('week',last_open_dt+1)::date end as lost_calweek,
       lead_init_dt >= '2022-05-02' and lead_init_dt < date_trunc('week',current_date)::date as actual_lead_flg,
       launch_flg or dlv.company_id is not null as launch_flg,
       dlv.company_id is not null as delivery_1st_flg,
       open_flg,
       count() as clients_cnt,
       sum(ptnt.potential) as potential,
       sum(deliveries_30d) as deliveries_30d
from ptnt
  join hist
    on hist.company_id = ptnt.company_id
  left join dlv
    on dlv.company_id = ptnt.company_id
where true
--   and lead_init_dt >= '2022-05-02'
--   and lead_init_dt < date_trunc('week',current_date)::date
--   and dlv.company_id is not null and not open_flg
group by 1,2,3,4,5,6,7,8
-- order by delivery_point_cnt desc nulls last
;