drop table analyst.gorbunov_yd_logdata267;
create table analyst.gorbunov_yd_logdata267 as
select dmo.city,
       coalesce(a_comb.grouped_address, dmo.order_source_address) as order_source_address,
       avg(extract(epoch from utc_start_waiting_dttm - utc_order_dttm)) as avg_arrival_time,
       sum(travel_distance_km) as travel_distance_km,
       sum(n_deliveries_visited) as deliveries_cnt
from snb_taxi.logdata_dm_order_v as dmo
  left join snb_taxi.niksm_b2b_a_points_combination as a_comb
    on a_comb.raw_address = dmo.order_source_address
    and a_comb.corp_client_id = dmo.corp_client_id
where true
  and dmo.utc_order_dt >= '2021-03-01'
  and logistic_tariff_flag
  and dmo.success_order_flg
  and not dmo.fake_order_flg
  and not dmo.mqc_order_flg
  and corp_contract_id = '1122918/20'
  and success_order_flg
group by 1,2;
