USE hahn;
PRAGMA yson.DisableStrict;
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;
$dttm_format = '%Y-%m-%d %H:%M:%S';
$str_to_dttm = ($dttm_str) -> {
    RETURN DateTime::MakeDatetime(DateTime::Parse($dttm_format)($dttm_str))
};
INSERT INTO `//home/taxi-delivery/analytics/production/b2b/ad-hoc/SDD/turkey_claim`
    WITH TRUNCATE
SELECT
    utc_claim_created_dt,
    corp_client_id,
    taxi_tariff_class_code,
    count(DISTINCT point_id) AS cnt_deliveries
    FROM range(`//home/delivery-dwh/cdm/delivery/fct_delivery`, `2022-07-01`)
    WHERE TRUE AND country_name_ru = 'Турция' AND corp_client_id IS NOT NULL AND status_code IN ('cancelled_with_payment', 'returned_finish', 'delivered_finish')
    GROUP BY
        DateTime::MakeDatetime(DateTime::StartOfDay($str_to_dttm(utc_claim_created_dttm))) AS utc_claim_created_dt,
        corp_client_id,
        taxi_tariff_class_code;
