select corp_contract_id,
       corp_client_id,
       corp_client_name,
       city,
       tariff_zone,
       date_trunc('month',moscow_order_dt)::date as calmonth,
       date_trunc('week',moscow_order_dt)::date as calweek,
       moscow_order_dt as calday,
       count() as orders_total,
       count() filter ( where success_order_flg ) as orders_success,
       sum(n_deliveries_visited) filter ( where success_order_flg ) as deliveries_cnt,
       sum(order_cost * currency_rate) filter ( where success_order_flg ) as gmv,
       sum(net_inflow * currency_rate) filter ( where success_order_flg ) as net_inflow,
       sum(travel_distance_km) filter ( where success_order_flg ) as travel_distance_km
from snb_taxi.logdata_dm_order_v as dmo
where true
  and corp_contract_id = '951088/20'
  and order_tariff in ('courier','express')
  and utc_order_dt >= '2021-02-28'
  and moscow_order_dt between '2021-03-01' and current_date-1
  and corp_order_flg
group by corp_contract_id,
         corp_client_id,
         corp_client_name,
         city,
         tariff_zone,
         moscow_order_dt
order by calday;