with dlv as (
    select corp_contract_id,
           sum(case when city = 'Москва' then n_deliveries_visited end) as deliveries_msk,
           sum(case when city = 'Санкт-Петербург' then n_deliveries_visited end) as deliveries_spb
    from snb_taxi.logdata_dm_order_v2
    where logistic_tariff_flag
      and success_order_flg
      and corp_order_flg
      and utc_order_dt >= current_date-90
    group by corp_contract_id
)
select deal_id,
       stage_name,
       market_segment,
       manager_name,
       contract_id,
       coalesce(deliveries_msk, 0) as deliveries_msk,
       coalesce(deliveries_spb, 0) as deliveries_spb
from snb_taxi.niksm_b2b_deals_info as dls
  left join dlv on corp_contract_id = contract_id
where which_crm = 6
  and lead_name = 'Алешина Татьяна'
  and website is not null
  and status = 'open'
  and market_segment in (
    'Детские товары',
    'Досуг и хобби',
    'Зоотовары',
    'Косметика и парфюмерия',
    'Электроника и бытовая техника',
    'Канцтовары',
    'Книги',
    'Одежда, обувь, сумки и чемоданы',
    'Спорт товары',
    'Товары широкого спектра',
    'Аптеки и фармацевтические компании'
    );