/*drop table if exists snb_taxi.niksm_b2b_a_points_combination;
create table snb_taxi.niksm_b2b_a_points_combination as*/
truncate table snb_taxi.niksm_b2b_a_points_combination;
insert into snb_taxi.niksm_b2b_a_points_combination
  (corp_client_id, raw_address, grouped_address)
with raw as (
    select order_id,
           utc_order_dt,
           corp_client_id,
           corp_client_name,
           order_source_address,
           order_source_lat,
           order_source_lon
    from summary.dm_order as dmo
    where true
      and dmo.utc_order_dt >= '2019-11-01'
      and dmo.order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
      and dmo.success_order_flg
      and not dmo.fake_order_flg
      and not dmo.fraud_order_flg
      and not dmo.mqc_order_flg
      and ((lower(dmo.corp_contract_id) not like '%тест%' and lower(dmo.corp_contract_id) not like '%без договора%')
        or dmo.corp_contract_id is null)
      and corp_order_flg
      and corp_client_id is not null
      and corp_client_id not in ('4decd14f25424e8b82b6d3e4f56d23b2','dc28c565829e48cca458b5feb161d5d6','d6bd052fe7f740a1be0183ae2eab60c1') -- Еда, Лавка и AVITO
)
, t0 as (
    /* сначала схлопываем по адресу */
    select corp_client_id,
           max(corp_client_name) as corp_client_name,
           order_source_address as address,
           avg(order_source_lat) as lat,
           avg(order_source_lon) as lon,
           count() as orders_cnt,
           row_number() over (partition by corp_client_id order by count() desc, order_source_address) as address_id
    from raw
    group by corp_client_id, order_source_address
)
, t2 as (
    /* метчим по парам */
    select ta.corp_client_id as corp_client_id,
           ta.address_id as a_address_id,
           ta.lat as a_lat,
           ta.lon as a_lon,
           tb.address_id as b_address_id,
           tb.lat as b_lat,
           tb.lon as b_lon
    from t0 as ta
      join t0 as tb
        on ta.corp_client_id = tb.corp_client_id
        and ta.address_id < tb.address_id    -- пары односторонние
        /* грубый фильтр для ускорения расчетов на следующем шаге; можно игнорировать */
        and abs(ta.lat - tb.lat)<0.001      -- 111 метров
        and abs(ta.lon - tb.lon)<0.002      -- мин (для 70й широты) = 76 метров
)
, pairs as (
    select corp_client_id,
           a_address_id,
           b_address_id
    from t2
    where 6371 * 2 * ASIN(SQRT(
              POWER(SIN((a_lat - b_lat) * PI()/180 / 2), 2) +
                COS(a_lat * PI()/180) *
                COS(b_lat * PI()/180) *
                POWER(SIN((a_lon - b_lon) * PI()/180 / 2), 2)
            )) < 0.050      -- пары до 50 метров
)
, distpairs as (
/* максимальная цепочка - 5 пар */
    select t1.corp_client_id,
           t1.b_address_id as b_address_id,
           min(coalesce(t5.a_address_id, t4.a_address_id, t3.a_address_id, t2.a_address_id, t1.a_address_id)) as a_address_id
    from pairs as t1
     left join pairs as t2 on t1.corp_client_id = t2.corp_client_id and t1.a_address_id = t2.b_address_id
     left join pairs as t3 on t1.corp_client_id = t3.corp_client_id and coalesce(t2.a_address_id, t1.a_address_id) = t3.b_address_id
     left join pairs as t4 on t1.corp_client_id = t4.corp_client_id and coalesce(t3.a_address_id, t2.a_address_id, t1.a_address_id) = t4.b_address_id
     left join pairs as t5 on t1.corp_client_id = t5.corp_client_id and coalesce(t4.a_address_id, t3.a_address_id, t2.a_address_id, t1.a_address_id) = t5.b_address_id
    group by t1.corp_client_id,
           t1.b_address_id
)
select d.corp_client_id,
	   tb.address as raw_address,
       ta.address as grouped_address
from distpairs as d
   join t0 as ta on ta.corp_client_id = d.corp_client_id and ta.address_id = d.a_address_id
   join t0 as tb on tb.corp_client_id = d.corp_client_id and tb.address_id = d.b_address_id;
-- DISTRIBUTED BY (corp_client_id)
;
--
/*comment on table snb_taxi.niksm_b2b_a_points_combination is
    'Группировка точек А в B2B заказах по расстоянию, не более 50 метров. Использовать так: select coalesce(a_comb.grouped_address, dmo.order_source_address) as order_source_address from summary.dm_order as dmo left join snb_taxi.niksm_b2b_a_points_combination as a_comb on a_comb.raw_address = dmo.order_source_address';*/
-- grant select on snb_taxi.niksm_b2b_a_points_combination to rawy, voytova, voytekh, niksm, "gorbunov-yd",  tsapenko, "robot-corploader", "robot-tableau-588";
-- grant all on snb_taxi.niksm_b2b_a_points_combination to "robot-sam-bridges";
