drop table if exists niksm_temp_dash_foodcourt_71_sales;
create temporary table niksm_temp_dash_foodcourt_71_sales as
with raw as (	-- dm_order + contract attributes + address grouped
    select dmo.order_id,
           dmo.tariff_class_code as order_tariff,
           dmo.country_name_ru as country,
           dmo.corp_contract_id as corp_contract_id,
           cntr_attr.which_crm,
           cntr_attr.manager_name,
           cntr_attr.lead_name,
           cntr_attr.manager_group,
           cntr_attr.market_segment,
           cntr_attr.channel,
           cntr_attr.city,
           cntr_attr.tags,
           blnc.contract_type,
           blnc.payment_type,
           dmo.corp_client_id || '_' || coalesce(a_comb.grouped_address, dmo.source_address) as order_source_address,
           --
           dmo.msk_order_created_dt                            as calday,
           --
           1                                              as orders,
           coalesce(n_deliveries_visited, 1)         as trips,
           order_cost * currency_rate                     as gmv
    from snb_taxi.logdata_fct_order as dmo
      left join snb_taxi.niksm_b2b_a_points_combination as a_comb
        on a_comb.raw_address = dmo.source_address
		and a_comb.corp_client_id = dmo.corp_client_id
      join snb_b2b.niksm_b2b_contracts_info cntr_attr
        on cntr_attr.contract_id = dmo.corp_contract_id
      left join snb_b2b.niksm_b2b_balance_contract_ext_info as blnc
        on blnc.contract_external_id = dmo.corp_contract_id
    where true
      and dmo.utc_order_created_dttm >= '2021-01-01' -- for partitioning
      and dmo.msk_order_created_dt between '2021-01-01' and current_date-1
      and logistic_tariff_flag
      and dmo.success_order_flg
      and not dmo.fake_order_flg
      and not dmo.mqc_order_flg
      and dmo.corp_order_flg
      and cntr_attr.which_crm = 6
)
, dl as (	-- group by calday etc
    select which_crm,
           manager_name,
           lead_name,
           manager_group,
           market_segment,
           channel,
           city,
           tags,
           contract_type,
           payment_type,
           corp_contract_id,
		   --
		   country,
		   order_tariff,
		   order_source_address,
		   calday,
           date_trunc('week', calday)::date  as calweek,
           (date_trunc('week', calday)::date - '1900-01-02'::date)/7 as calweek_id,
		   date_trunc('month', calday)::date as calmonth,
           extract(year from calday)*12 + extract(month from calday) as calmonth_id,
           --
           sum(orders)                          as orders,
           sum(trips)                           as trips,
           sum(gmv)                             as gmv
		from raw
		group by which_crm,
           manager_name,
           lead_name,
           manager_group,
           market_segment,
           channel,
           city,
           tags,
           contract_type,
           payment_type,
           corp_contract_id,
		   --
		   country,
		   order_tariff,
		   order_source_address,
		   calday
)
select which_crm,
       manager_name,
       lead_name,
       manager_group,
       market_segment,
       channel,
       city,
       tags,
       contract_type,
       payment_type,
	   corp_contract_id,
	   --
	   country,
	   order_tariff,
	   --
	   order_source_address,
	   calday,
-- 	   calweek,
-- 	   calweek_id,
-- 	   calmonth,
-- 	   calmonth_id,
	   --
	   orders,
	   trips,
	   gmv,
	   --
	   case when max(1) over (partition by order_source_address order by calday range between 1 preceding and 1 preceding) is not null then 1
		when max(1) over (partition by order_source_address order by calday range between unbounded preceding and 2 preceding) is not null then 2
		else 3 end as a_points_prev_cld_type_id,
	   case when max(1) over (partition by order_source_address order by calweek_id range between 1 preceding and 1 preceding) is not null then 1
		when max(1) over (partition by order_source_address order by calweek_id range between unbounded preceding and 2 preceding) is not null then 2
		else 3 end as a_points_prev_clw_type_id,
	   case when max(1) over (partition by order_source_address order by calmonth_id range between 1 preceding and 1 preceding) is not null then 1
		when max(1) over (partition by order_source_address order by calmonth_id range between unbounded preceding and 2 preceding) is not null then 2
		else 3 end as a_points_prev_clm_type_id,
	   --
	   case when max(1) over (partition by order_source_address order by calday range between 1 following and 1 following) is not null then 1
		else 2 end as a_points_next_cld_type_id,
	   case when max(1) over (partition by order_source_address order by calweek_id range between 1 following and 1 following) is not null then 1
		else 2 end as a_points_next_clw_type_id,
	   case when max(1) over (partition by order_source_address order by calmonth_id range between 1 following and 1 following) is not null then 1
		else 2 end as a_points_next_clm_type_id,
	   ----
	   ----
	   case when max(1) over (partition by corp_contract_id order by calday range between 1 preceding and 1 preceding) is not null then 1
		when max(1) over (partition by corp_contract_id order by calday range between unbounded preceding and 2 preceding) is not null then 2
		else 3 end as cntr_prev_cld_type_id,
	   case when max(1) over (partition by corp_contract_id order by calweek_id range between 1 preceding and 1 preceding) is not null then 1
		when max(1) over (partition by corp_contract_id order by calweek_id range between unbounded preceding and 2 preceding) is not null then 2
		else 3 end as cntr_prev_clw_type_id,
	   case when max(1) over (partition by corp_contract_id order by calmonth_id range between 1 preceding and 1 preceding) is not null then 1
		when max(1) over (partition by corp_contract_id order by calmonth_id range between unbounded preceding and 2 preceding) is not null then 2
		else 3 end as cntr_prev_clm_type_id,
	   --
	   case when max(1) over (partition by corp_contract_id order by calday range between 1 following and 1 following) is not null then 1
		else 2 end as cntr_next_cld_type_id,
	   case when max(1) over (partition by corp_contract_id order by calweek_id range between 1 following and 1 following) is not null then 1
		else 2 end as cntr_next_clw_type_id,
	   case when max(1) over (partition by corp_contract_id order by calmonth_id range between 1 following and 1 following) is not null then 1
		else 2 end as cntr_next_clm_type_id
from dl;
--
analyze niksm_temp_dash_foodcourt_71_sales;

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_temp_dash_foodcourt_71_pd;
create temporary table niksm_temp_dash_foodcourt_71_pd as
with dlv as (
    select corp_contract_id, min(calday) as init_dt
    from niksm_temp_dash_foodcourt_71_sales
    where trips>0
    group by corp_contract_id
)
, raw as (
    select crm.deal_id,
           crm.which_crm,
           dlh.record_date,
           crm.potential,
           ppls.pipeline_sort_id,
           ppln.pipeline_name,
           stgs.stage_sort_id,
           stgn.stage_name,
           crm.manager_name, crm.lead_name,
           crm.manager_group,
           crm.market_segment,
           crm.channel,
           crm.city,
           crm.tags,
           case when crm.status = 'lost' then 0 else 1 end as status_id,
           dlv.corp_contract_id is not null as delivery_flg,
           blnc.contract_type,
           blnc.payment_type
    from snb_b2b.voytekh_pd2_deal_history as dlh
      join snb_b2b.niksm_b2b_deals_info as crm
        on crm.which_crm = dlh.which_crm
        and crm.deal_id = dlh.id
      join snb_taxi.niksm_pd_pipeline_sort as ppls
        on ppls.pipeline_id = dlh.pipeline_id
      join snb_taxi.niksm_pd_pipeline_names as ppln
        on ppln.pipeline_sort_id = ppls.pipeline_sort_id
      join snb_taxi.niksm_pd_stage_sort as stgs
        on stgs.stage_id = dlh.stage_id
      join snb_taxi.niksm_pd_stage_names as stgn
        on stgn.stage_sort_id = stgs.stage_sort_id
      left join dlv
        on dlv.corp_contract_id = crm.contract_id
        and dlv.init_dt < dlh.record_date
      left join snb_b2b.niksm_b2b_balance_contract_ext_info as blnc
        on blnc.contract_external_id = crm.contract_id
    where dlh.which_crm = 6
      and dlh.record_date >= least(date_trunc('month',current_date-1) - interval '3 months',
          date_trunc('week',current_date-1) - interval '13 weeks')::date
)
select which_crm,
       record_date as calday,
       status_id,
       pipeline_sort_id, pipeline_name, stage_sort_id, stage_name,
       manager_name, lead_name, manager_group,
       market_segment,
       channel,
       city,
       tags,
       contract_type,
       payment_type,
       --
       count(deal_id) as deals_cnt,
       sum(case when status_id = 1 then 1 else 0 end) as deals_open_cnt,
       sum(case when status_id = 0 then 1 else 0 end) as deals_lost_cnt,
       sum(delivery_flg::int) as deals_w_delivery_cnt,
       sum(potential) as deals_potential,
       sum(case when status_id = 1 then potential else 0 end) as deals_open_potential,
       sum(case when status_id = 0 then potential else 0 end) as deals_lost_potential,
       sum(case when delivery_flg then potential else 0 end) as deals_w_delivery_potential
from raw
group by which_crm,
       record_date,
       status_id,
       pipeline_sort_id, pipeline_name, stage_sort_id, stage_name,
       manager_name, lead_name, manager_group,
       market_segment,
       channel,
       city,
       tags,
       contract_type,
       payment_type;
--
analyze niksm_temp_dash_foodcourt_71_pd;

--====================================================================================================================--

-- drop table if exists snb_b2b.niksm_dash_foodcourt_71;
-- create table snb_b2b.niksm_dash_foodcourt_71 as
truncate table snb_b2b.niksm_dash_foodcourt_71;
insert into snb_b2b.niksm_dash_foodcourt_71
    (which_crm,
       manager_name, lead_name, manager_group,
       market_segment, channel, city, tags,
       contract_type, payment_type,
       corp_contract_id,
       --
       country,
       order_tariff,
       --
       order_source_address,
       calday,
       orders, trips, gmv,
       a_points_prev_cld_type_id, a_points_prev_clw_type_id, a_points_prev_clm_type_id,
       a_points_next_cld_type_id, a_points_next_clw_type_id, a_points_next_clm_type_id,
       cntr_prev_cld_type_id, cntr_prev_clw_type_id, cntr_prev_clm_type_id,
       cntr_next_cld_type_id, cntr_next_clw_type_id, cntr_next_clm_type_id,
       status_id,
       pipeline_sort_id, pipeline_name, stage_sort_id, stage_name,
       deals_cnt, deals_open_cnt, deals_lost_cnt, deals_w_delivery_cnt,
       deals_potential, deals_open_potential, deals_lost_potential, deals_w_delivery_potential,
       first_full_date, last_full_date)
--
select which_crm,
       manager_name, lead_name, manager_group,
       market_segment, channel, city, tags,
       contract_type, payment_type,
       corp_contract_id,
       --
       country,
       order_tariff,
       --
       order_source_address,
       calday,
       orders, trips, gmv,
       a_points_prev_cld_type_id, a_points_prev_clw_type_id, a_points_prev_clm_type_id,
       a_points_next_cld_type_id, a_points_next_clw_type_id, a_points_next_clm_type_id,
       cntr_prev_cld_type_id, cntr_prev_clw_type_id, cntr_prev_clm_type_id,
       cntr_next_cld_type_id, cntr_next_clw_type_id, cntr_next_clm_type_id,
       NULL::int as status_id,
       NULL::int as pipeline_sort_id,
       NULL::text as pipeline_name,
       NULL::int as stage_sort_id,
       NULL::text as stage_name,
       NULL::bigint as deals_cnt,
       NULL::bigint as deals_open_cnt,
       NULL::bigint as deals_lost_cnt,
       NULL::bigint as deals_w_delivery_cnt,
       NULL::bigint as deals_potential,
       NULL::bigint as deals_open_potential,
       NULL::bigint as deals_lost_potential,
       NULL::bigint as deals_w_delivery_potential,
       NULL::date as first_full_date,
       NULL::date as last_full_date
from niksm_temp_dash_foodcourt_71_sales
where calday between
    least(date_trunc('month',current_date-1) - interval '3 months',
          date_trunc('week',current_date-1) - interval '13 weeks')::date
     and current_date - 1;

----------------------------------------------------

insert into snb_b2b.niksm_dash_foodcourt_71
    (which_crm,
       calday,
       status_id,
       pipeline_sort_id, pipeline_name, stage_sort_id, stage_name,
       manager_name, lead_name, manager_group,
       market_segment, channel, city, tags,
       contract_type, payment_type,
       deals_cnt, deals_open_cnt, deals_lost_cnt, deals_w_delivery_cnt,
       deals_potential, deals_open_potential, deals_lost_potential, deals_w_delivery_potential)
select which_crm,
       calday,
       status_id,
       pipeline_sort_id, pipeline_name, stage_sort_id, stage_name,
       manager_name, lead_name, manager_group,
       market_segment, channel, city, tags,
       contract_type, payment_type,
       --
       deals_cnt, deals_open_cnt, deals_lost_cnt, deals_w_delivery_cnt,
       deals_potential, deals_open_potential, deals_lost_potential, deals_w_delivery_potential
from niksm_temp_dash_foodcourt_71_pd;

----------------------------------------------------

update snb_b2b.niksm_dash_foodcourt_71
set first_full_date = least(date_trunc('month',current_date-1) - interval '3 months',
          date_trunc('week',current_date-1) - interval '13 weeks')::date,
    last_full_date = (
    select least(last_claims_date, last_fct_date, last_dls_date) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(moscow_order_dttm)::date - 1 as last_fct_date
        from summary.dm_order
        where utc_order_dt >= current_date - 7
        ) fct
    cross join (
        select max(record_date)::date as last_dls_date
        from snb_b2b.niksm_b2b_deals_info
        ) dls
    )
where true;

-- comment on table snb_b2b.niksm_dash_foodcourt_71 is 'Дашборд Ресторанный дворик. LOGDATA-71';
-- grant all on snb_b2b.niksm_dash_foodcourt_71 to "robot-sam-bridges";
