-- drop table snb_b2b.alextitov_logdata_722_datadesh;
-- create table snb_b2b.alextitov_logdata_722_datadesh as
 truncate table snb_b2b.alextitov_logdata_722_datadesh;
 insert into snb_b2b.alextitov_logdata_722_datadesh
with tt as (
    select deal_id, market_segment, contract_id
         ,start_dt,manager,potential
    , case when status='lost' then '2_���������'
           when contract_id is not null then '1_�������� ��������'
           else '3_����������' end as status
    from snb_b2b.niksm_b2b_deals_info dlf
    left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc  on contract_external_id = contract_id
    where which_crm = 6
)

  --and contract_id='2128126/21'

, tt2 as (
    select tt.deal_id                                            as deal_id
         , max(tt.status)                                        as status
         , max(tt.market_segment)                                as market_segment
         , max(case when delivery_point_cnt>0 then 1 else 0 end) as flag_del
         , COALESCE(sum(case
                            when utc_order_created_dttm between current_date - 30 and current_date and delivery_point_cnt>0
                                then delivery_point_cnt end), 0)                  as cnt_del_month
         , COALESCE(count(distinct agglomeration_name_ru), 0)    as cnt_city
         , COALESCE(sum(case
                            when utc_order_created_dttm between current_date - 7 and current_date and delivery_point_cnt>0
                                then delivery_point_cnt end), 0) as cnt_del_w_l1
         , COALESCE(sum(case
                            when utc_order_created_dttm between current_date - 14 and current_date - 7 and delivery_point_cnt>0
                                then delivery_point_cnt end), 0) as cnt_del_w_l2
         --corp_contract_id,
         --sum(delivery_point_cnt) as deliveries_cnt
--agglomeration_name_ru
--country_name_ru
         , max(max(case when utc_order_created_dttm<=current_date then utc_order_created_dttm::date end)) over() as date_report
    from taxi_cdm_marketplace.fct_order as del
             right join tt on tt.contract_id = del.corp_contract_id
    where utc_order_created_dttm >= current_date - 180
      and country_name_ru='������'
      --and corp_contract_id='2128126/21'
    group by 1
)

select max(cl_inf.id_client) as id_client,
        cl_inf.client as client
--        , max(cl_inf.market_segment) as market_segment
       , COALESCE(max(cl_inf.delivery_cnt_month),0) as capacity
       , substr(min(coalesce(tt2.status,'4_��� � CRM')),3) as status
       , COALESCE(max(tt2.flag_del),0) as flag_del
       , COALESCE(sum(tt2.cnt_del_w_l1),0) as cnt_del_week
       , COALESCE(sum(tt2.cnt_del_w_l1)/nullif(sum(tt2.cnt_del_w_l2),0),0) as wow_growth
       , COALESCE(max(cl_inf.delivery_cnt_month),0) as delivery_cnt_month_client
       --, COALESCE(max(cl_inf.city_cnt) ,0)as city_cnt_client
       --, COALESCE(sum(tt2.cnt_city),0) as cnt_city
       , COALESCE(sum(tt2.cnt_del_month)/nullif(max(cl_inf.delivery_cnt_month),0),0) as penetration_rate
       , dense_rank() over(order by COALESCE(max(cl_inf.delivery_cnt_month),0) desc) as rank_client
       , max(max(tt2.date_report))over() as date_report
from snb_b2b.alextitov_b2b_client_info as cl_inf
left join snb_b2b.alextitov_b2b_client_deal as cl_dl on cl_dl.client=cl_inf.client
left join tt2 on cl_dl.deal_id=tt2.deal_id
group by cl_inf.client
;

-- create table snb_b2b.alextitov_logdata_722_date as

 truncate table snb_b2b.alextitov_logdata_722_date;
 insert into snb_b2b.alextitov_logdata_722_date
with tt as (
    select deal_id, contract_id
    from snb_b2b.niksm_b2b_deals_info
    where which_crm = 6
)

, tt2 as (
    select tt.deal_id                                            as deal_id
        , date_trunc('week', utc_order_created_dttm)::date as date_week
         , COALESCE(sum(case
                            when utc_order_created_dttm between date_trunc('week',current_date-7*24)  and date_trunc('week',current_date)
                                then delivery_point_cnt end), 0)                  as cnt_delivery
    from taxi_cdm_marketplace.fct_order as del
             right join tt on tt.contract_id = del.corp_contract_id
    where utc_order_created_dttm >= current_date - 180
      and country_name_ru='������'
      and delivery_point_cnt>0
    group by 1,2
)

select max(cl_inf.id_client) as id_client,
        cl_inf.client as client,
        tt2.date_week,
       COALESCE(sum(tt2.cnt_delivery),0) as cnt_delivery
from snb_b2b.alextitov_b2b_client_info as cl_inf
left join snb_b2b.alextitov_b2b_client_deal as cl_dl on cl_dl.client=cl_inf.client
left join tt2 on cl_dl.deal_id=tt2.deal_id and tt2.cnt_delivery>0
group by 2,3;


-- grant select on snb_b2b.alextitov_logdata_722_datadesh to ro_snb_b2b;
-- grant select on snb_b2b.alextitov_logdata_722_date to ro_snb_b2b;



select
       --fct_delivery.corp_client_id,
       --city_name_ru,
       taxi_tariff_class_code,
       logistic_platform_source_type,
       claim.api_source_type
from taxi_cdm_logistic.fct_delivery
  left join delivery_ods_cargo_claims.claim
    on fct_delivery.claim_id = claim.claim_id
    and claim.utc_created_dttm >= '2022-01-11'
where fct_delivery.utc_created_dttm >= '2022-01-11'
group by 1,2,3


