-- Перевод на ЮЛ ЯД - статистика по менеджерам
select * from snb_delivery.niksm_b2b_logdata797
order by gr1,
         case when "Группа" = 'ГПП 1' then 1
              when "Группа" = 'ГПП 2' then 2
              when "Группа" = 'ГМП 1' then 3
              when "Группа" = 'ГМП 2' then 4
              when "Группа" = 'ГМП NDD' then 5
              when "Группа" = 'Тир 3' then 6 end,
         gr2,
         "Тимлид",
         gr3,
         deliveries_cnt_base desc;

select * from snb_delivery.niksm_b2b_logdata797_pmnt
order by gr1,
         case when "Группа" = 'ГПП 1' then 1
              when "Группа" = 'ГПП 2' then 2
              when "Группа" = 'ГМП 1' then 3
              when "Группа" = 'ГМП 2' then 4
              when "Группа" = 'ГМП NDD' then 5
              when "Группа" = 'Тир 3' then 6 end,
         gr2,
         "Тимлид",
         gr3,
         deliveries_cnt_base desc;

-- LOGDATA_797 taxi contracts
select * from snb_delivery.niksm_b2b_logdata797_contracts order by deliveries_cnt_30d desc;

--====================================================================================================================--
drop view if exists snb_delivery.niksm_b2b_logdata797;
create or replace view snb_delivery.niksm_b2b_logdata797 as
with -- LOGDATA-797
  dlv as (
    select corp_contract_id,
           sum(case when msk_order_created_dt between '2021-07-01' and '2021-09-30'
               then delivery_point_cnt else 0 end) as deliveries_cnt_base,
           sum(case when msk_order_created_dt between current_date-7 and current_date-1
               then delivery_point_cnt else 0 end) as deliveries_cnt_last
    from taxi_cdm_marketplace.fct_order
      join snb_delivery.logdata_delivery_tariff lgst
        on lgst.order_tariff = fct_order.tariff_class_code
        and utc_order_created_dttm between utc_datefrom and utc_dateto
    where true
      and utc_order_created_dttm >= timestamp'2021-07-01' at time zone 'Europe/Moscow' at time zone 'UTC'
      and country_name_ru = 'Россия'
      and success_order_flg
      and corp_order_flg
    group by 1
)
, crm as (
    select contract_id,
           manager_group,
           case when lead_name in ('Суворов Александр','Фарбер Ольга') then manager_name
            else lead_name
           end as lead_name,
           coalesce(manager_name,'No manager') as manager_name
    from snb_b2b.niksm_b2b_contracts_info
    where which_crm = 6
      and manager_group in  ('ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП 3','ГМП 4','Тир 3')    -- , 'СНГ'
      and country = 'РФ'
)
, raw as (
    select person_inn, person_kpp,
--            first_value(blnc.client) over (partition by person_inn, person_kpp
--                order by deliveries_cnt desc nulls last) as client_balance_name,
           contract_external_id,
           is_active,
           legal_contract_cargo,
           coalesce(deliveries_cnt_base,0) as deliveries_cnt_base,
           coalesce(deliveries_cnt_last,0) as deliveries_cnt_last,
           first_value(manager_group) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as manager_group,
           first_value(lead_name) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as lead_name,
           first_value(manager_name) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as manager_name
    from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
      join crm on crm.contract_id = blnc.contract_external_id
      left join dlv on dlv.corp_contract_id = blnc.contract_external_id
    where legal_contract_cargo = 1 or legal_contract_taxi = 1
)
, client_raw as (
    select person_inn, person_kpp,
           max(case when is_active = 1 then legal_contract_cargo end) as legal_active_contract_cargo,
           sum(deliveries_cnt_base) as deliveries_cnt_base,
           sum(deliveries_cnt_last) as deliveries_cnt_last,
           sum(case when legal_contract_cargo = 1 then deliveries_cnt_last else 0 end) as deliveries_cnt_cargo_last,
           --
           max(manager_group) as manager_group,
           max(lead_name) as lead_name,
           max(manager_name) as manager_name
    from raw
    group by person_inn, person_kpp
    having max(is_active) = 1
      and max(case when is_active = 1 then manager_group end) is not null
--         or max(case when is_active = 1 then legal_contract_cargo end) = 1)
)-- select * from client_raw;
select case when grouping(manager_group)=1 then 'TOTAL' else manager_group end as "Группа",
       case when grouping(lead_name)=1 then manager_group || ' TOTAL' else lead_name end as "Тимлид",
       case when grouping(manager_name)=1 then lead_name || ' TOTAL' else manager_name end as "Менеджер",
       --
       count() as "Клиентов всего",
       sum(case when legal_active_contract_cargo = 0 then 1 else 0 end) as "Кол-во клиентов БЕЗ договора ЯД",
       sum(case when legal_active_contract_cargo = 1 then 1. else 0. end)
           / count() as "Доля клиентов с договором ЯД",
       sum(case when legal_active_contract_cargo = 1 then deliveries_cnt_base else 0 end)
           / nullif(sum(deliveries_cnt_base),0) as "Доля доставок у клиентов с договором ЯД",
       sum(deliveries_cnt_cargo_last)
           / nullif(sum(deliveries_cnt_last),0) as "Доля доставок через ЯД за 7 дней по всем клиентам",
       sum(case when legal_active_contract_cargo = 1 then deliveries_cnt_cargo_last else 0 end)
           / nullif(sum(case when legal_active_contract_cargo = 1 then deliveries_cnt_last else 0 end),0)
            as "Доля доставок через ЯД за 7 дней только по клиентам ЯД",
       --
       sum(deliveries_cnt_base) as deliveries_cnt_base,
       grouping(manager_group) as gr1,
       grouping(lead_name) as gr2,
       grouping(manager_name) as gr3
from client_raw
group by rollup(manager_group, lead_name, manager_name)
having not (manager_group = 'Тир 3' and grouping(manager_name) = 1 and grouping(lead_name) = 0)
  and not (manager_group = 'ГПП 1' and grouping(manager_name) = 1 and grouping(lead_name) = 0)
  and not (manager_group = 'ГПП 2' and grouping(manager_name) = 1 and grouping(lead_name) = 0)
;

------------------------------------------------------------------------------------------------------------------------
drop view if exists snb_delivery.niksm_b2b_logdata797_pmnt;
create or replace view snb_delivery.niksm_b2b_logdata797_pmnt as
with -- LOGDATA-797
  dlv as (
    select corp_contract_id,
           sum(case when msk_order_created_dt between '2021-07-01' and '2021-09-30'
               then delivery_point_cnt else 0 end) as deliveries_cnt_base,
           sum(case when msk_order_created_dt between current_date-7 and current_date-1
               then delivery_point_cnt else 0 end) as deliveries_cnt_last
    from taxi_cdm_marketplace.fct_order
      join snb_delivery.logdata_delivery_tariff lgst
        on lgst.order_tariff = fct_order.tariff_class_code
        and utc_order_created_dttm between utc_datefrom and utc_dateto
    where true
      and utc_order_created_dttm >= timestamp'2021-07-01' at time zone 'Europe/Moscow' at time zone 'UTC'
      and country_name_ru = 'Россия'
      and success_order_flg
      and corp_order_flg
    group by 1
)
, crm as (
    select contract_id,
           manager_group,
           case when lead_name in ('Суворов Александр','Фарбер Ольга') then manager_name
            else lead_name
           end as lead_name,
           coalesce(manager_name,'No manager') as manager_name
    from snb_b2b.niksm_b2b_contracts_info
    where which_crm = 6
      and manager_group in ('ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП 3','ГМП 4')    -- , 'Тир 3', 'СНГ'
      and country = 'РФ'
)
, raw as (
    select person_inn, person_kpp,
--            first_value(blnc.client) over (partition by person_inn, person_kpp
--                order by deliveries_cnt desc nulls last) as client_balance_name,
           contract_external_id,
           is_active,
           payment_type,
           coalesce(deliveries_cnt_base,0) as deliveries_cnt_base,
           coalesce(deliveries_cnt_last,0) as deliveries_cnt_last,
           first_value(manager_group) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as manager_group,
           first_value(lead_name) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as lead_name,
           first_value(manager_name) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as manager_name
    from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
      join crm on crm.contract_id = blnc.contract_external_id
      left join dlv on dlv.corp_contract_id = blnc.contract_external_id
    where legal_contract_cargo = 1 or legal_contract_taxi = 1
)
, client_raw as (
    select person_inn, person_kpp,
           max(case when is_active = 1 then (payment_type='постоплата')::int end) as active_contract_postpaid,
           sum(deliveries_cnt_base) as deliveries_cnt_base,
           sum(deliveries_cnt_last) as deliveries_cnt_last,
           sum(case when payment_type='постоплата' then deliveries_cnt_last else 0 end) as deliveries_cnt_postpaid_last,
           --
           max(manager_group) as manager_group,
           max(lead_name) as lead_name,
           max(manager_name) as manager_name
    from raw
    group by person_inn, person_kpp
    having max(is_active) = 1
      and max(case when is_active = 1 then manager_group end) is not null
--         or max(case when is_active = 1 then legal_contract_cargo end) = 1)
) --select * from client_raw where manager_name = 'Ювкина Анна';
select case when grouping(manager_group)=1 then 'TOTAL' else manager_group end as "Группа",
       case when grouping(lead_name)=1 then manager_group || ' TOTAL' else lead_name end as "Тимлид",
       case when grouping(manager_name)=1 then lead_name || ' TOTAL' else manager_name end as "Менеджер",
       --
       count() as "Клиентов всего",
       sum(case when active_contract_postpaid = 0 then 1 else 0 end) as "Кол-во клиентов БЕЗ постоплатного договора",
       sum(case when active_contract_postpaid = 1 then 1. else 0. end)
           / count() as "Доля клиентов с постоплатным договором",
       sum(case when active_contract_postpaid = 1 then deliveries_cnt_base else 0 end)
           / nullif(sum(deliveries_cnt_base),0) as "Доля доставок у клиентов с постоплатным договором",
       sum(deliveries_cnt_postpaid_last)
           / nullif(sum(deliveries_cnt_last),0) as "Доля доставок через постоплату за 7 дней по всем клиентам",
       sum(case when active_contract_postpaid = 1 then deliveries_cnt_postpaid_last else 0 end)
           / nullif(sum(case when active_contract_postpaid = 1 then deliveries_cnt_last else 0 end),0)
            as "Доля доставок через постоплату за 7 дней только по клиентам с постоплатным договором",
       --
       sum(deliveries_cnt_base) as deliveries_cnt_base,
       grouping(manager_group) as gr1,
       grouping(lead_name) as gr2,
       grouping(manager_name) as gr3
from client_raw
group by rollup(manager_group, lead_name, manager_name)
having not (manager_group = 'Тир 3' and grouping(manager_name) = 1 and grouping(lead_name) = 0)
  and not (manager_group = 'ГПП 1' and grouping(manager_name) = 1 and grouping(lead_name) = 0)
  and not (manager_group = 'ГПП 2' and grouping(manager_name) = 1 and grouping(lead_name) = 0)
;

------------------------------------------------------------------------------------------------------------------------
drop view snb_delivery.niksm_b2b_logdata797_contracts;
create or replace view snb_delivery.niksm_b2b_logdata797_contracts as
with -- LOGDATA-797
  dlv as (
    select corp_contract_id,
           sum(case when msk_order_created_dt between '2021-07-01' and '2021-09-30'
               then delivery_point_cnt else 0 end) as deliveries_cnt_base,
           sum(case when msk_order_created_dt between current_date-30 and current_date-1
               then delivery_point_cnt else 0 end) as deliveries_cnt_30d,
           sum(case when msk_order_created_dt between current_date-30 and current_date-1
               then order_cost * currency_rate else 0 end) as gmv_rub_30d,
           sum(case when msk_order_created_dt between current_date-7 and current_date-1
               then delivery_point_cnt else 0 end) as deliveries_cnt_last
    from taxi_cdm_marketplace.fct_order
      join snb_taxi.logdata_logistic_tariffs lgst
        on lgst.order_tariff = fct_order.tariff_class_code
    where true
      and utc_order_created_dttm >= timestamp'2021-07-01' at time zone 'Europe/Moscow' at time zone 'UTC'
      and country_name_ru = 'Россия'
      and success_order_flg
      and corp_order_flg
    group by 1
)
, crm as (
    select contract_id,
           manager_group,
           case when lead_name = 'Пахарева Анастасия' then 'Букарева Анастасия'
            when lead_name = 'Гаман Владимир' then manager_name
            else lead_name
           end as lead_name,
           coalesce(manager_name,'No manager') as manager_name
    from snb_b2b.niksm_b2b_contracts_info
    where which_crm = 6
      and manager_group in ('ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП 3','ГМП 4', 'Тир 3')    -- , 'СНГ'
      and country = 'РФ'
)
, raw as (
    select person_inn, person_kpp,
--            first_value(blnc.client) over (partition by person_inn, person_kpp
--                order by deliveries_cnt desc nulls last) as client_balance_name,
           contract_external_id,
           blnc.person_name as balance_org_name,
           is_active,
           legal_contract_cargo,
           coalesce(deliveries_cnt_base,0) as deliveries_cnt_base,
           coalesce(deliveries_cnt_last,0) as deliveries_cnt_30d,
           coalesce(gmv_rub_30d,0) as gmv_rub_30d,
           coalesce(deliveries_cnt_last,0) as deliveries_cnt_last,
           first_value(manager_group) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as manager_group,
           first_value(lead_name) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as lead_name,
           first_value(manager_name) over (partition by person_inn, person_kpp
               order by crm.contract_id is not null desc,
                   is_active desc,
                   deliveries_cnt_base desc nulls last) as manager_name,
           max(case when is_active = 1 then legal_contract_cargo end)
               over (partition by person_inn, person_kpp) as legal_active_contract_cargo,
           max(is_active) over (partition by person_inn, person_kpp) as max_is_active,
           max(case when is_active = 1 then manager_group end)
               over (partition by person_inn, person_kpp) as max_manager_group
    from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
      join crm on crm.contract_id = blnc.contract_external_id
      left join dlv on dlv.corp_contract_id = blnc.contract_external_id
    where legal_contract_cargo = 1 or legal_contract_taxi = 1
)
select case when coalesce(legal_active_contract_cargo,0) = 0 then 'У клиента нет договора Яндекс.Доставки'
            when legal_contract_cargo = 0 and deliveries_cnt_last>0 then 'У клиента есть договор Яндекс.Доставки, но за 7 дней прошли доставки по Яндекс.Такси'
                end as reason,
       person_inn, person_kpp, contract_external_id, balance_org_name, is_active,
       case when legal_contract_cargo=1 then 'ООО Яндекс.Доставка' else 'ООО Яндекс.Такси' end as legal_entity,
       deliveries_cnt_base, deliveries_cnt_30d, gmv_rub_30d, deliveries_cnt_last,
       manager_group, lead_name, manager_name, legal_active_contract_cargo
from raw
where is_active = 1
  and max_manager_group is not null
  and (coalesce(legal_active_contract_cargo,0) = 0
    or (legal_contract_cargo = 0 and deliveries_cnt_last>0));
--
revoke select on snb_delivery.niksm_b2b_logdata797_contracts from rw_snb_delivery, ro_snb_delivery;
grant select on snb_delivery.niksm_b2b_logdata797_contracts to rw_snb_b2b, tsapenko;
------------------------------------------------------------------------------------------------------------------------

with dlv as (
    select corp_contract_id,
           sum(delivery_point_cnt) as deliveries_cnt
    from taxi_cdm_marketplace.fct_order
      join snb_taxi.logdata_logistic_tariffs lgst
        on lgst.order_tariff = fct_order.tariff_class_code
    where true
      and utc_order_created_dttm >= '2021-06-30'
      and msk_order_created_dt between current_date-30 and current_date-1
      and country_name_ru = 'Россия'
      and success_order_flg
      and corp_order_flg
    group by 1
)
select blnc.contract_external_id,
       person_inn, person_kpp,
       blnc.person_name,
       is_active,
       coalesce(deliveries_cnt,0) as deliveries_cnt
from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
  join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = blnc.contract_external_id
    and crm.which_crm = 6
  left join dlv
    on dlv.corp_contract_id = blnc.contract_external_id
where legal_contract_taxi = 1
order by deliveries_cnt desc;

select *
from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
  join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = blnc.contract_external_id
    and crm.which_crm = 6
where person_inn = '7814148471'

-- Договора ООО Доставки в Балансе, отсутствующие в CRM
select blnc.*
from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
  left join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = blnc.contract_external_id
    and crm.which_crm = 6
where legal_contract_cargo = 1
  and crm.which_crm is null;


select country_name_ru, corp_contract_id,
       count(distinct corp_contract_id) as contracts_cnt,
       sum(delivery_point_cnt) as deliveries_cnt
    from taxi_cdm_marketplace.fct_order fct
      join snb_taxi.logdata_logistic_tariffs lgst
        on lgst.order_tariff = fct.tariff_class_code
  left join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = fct.corp_contract_id
    and crm.which_crm = 6
where true
  and utc_order_created_dttm >= current_date - 30
--   and country_name_ru = 'Россия'
  and crm.contract_id is null
  and success_order_flg
  and corp_order_flg
group by 1,2;


WITH taxi_cntr as (
    select distinct "Contract_Num_Yandex_Taxi__c" as taxi_contract_id
    from snb_b2b.bmiklaz_ods_sf_b2b_contracts
    where "Contract_Num_Yandex_Taxi__c" is not null
      and "Contract_Num_Yandex_Taxi__c" <> ''
)
, dlv as (
    select date_trunc('month',msk_order_created_dt)::date as calmonth,
           corp_client_id,
           corp_contract_id,
           country_name_ru as country,
           sum(delivery_point_cnt) as deliveries_cnt,
           sum(order_cost * currency_rate) as gmv_rub
    from taxi_cdm_marketplace.fct_order
      join snb_taxi.logdata_logistic_tariffs lgst
        on lgst.order_tariff = fct_order.tariff_class_code
    where true
      and utc_order_created_dttm >= '2021-07-31'
      and msk_order_created_dt between '2021-08-01' and '2021-09-30'
      and success_order_flg
      and corp_order_flg
    group by 1,2,3,4
)
select *
--        calmonth, dlv.country,
--        case when legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
--            when legal_contract_taxi = 1 then 'ООО Яндекс.Такси'
--            else 'Прочие' end as legal_entity,
--        crm.contract_id is not null as crm_delivery_flg,
--        taxi_contract_id is not null as crm_taxi_flg,
--        --
--        count() as contracts_cnt,
--        sum(deliveries_cnt) as deliveries_cnt,
--        sum(gmv_rub) as gmv_rub
from dlv
  left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = dlv.corp_contract_id
  left join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = dlv.corp_contract_id
    and which_crm = 6
  left join taxi_cntr
    on taxi_cntr.taxi_contract_id = dlv.corp_contract_id
-- group by 1,2,3,4,5;
-- where crm.contract_id is null and taxi_contract_id is null
where crm.contract_id is null and legal_contract_cargo = 1
order by calmonth desc, gmv_rub desc;

select count()
from snb_b2b.niksm_b2b_balance_contract_ext_info
where legal_contract_cargo + legal_contract_taxi > 1
