-- 1) claim log
drop table if exists snb_delivery.niksm_temp_864_claim_statlog;
create table snb_delivery.niksm_temp_864_claim_statlog as
select claim_id,
       bool_or( new_claim_status = 'accepted' ) as accepted_flg,
       min(case when new_claim_status = 'accepted' then utc_created_dttm end) as utc_accepted_dttm,
       min(case when new_claim_status = 'performer_found' then utc_created_dttm end) as utc_found_dttm,
       min(case when new_claim_status = 'pickup_arrived' then utc_created_dttm end)  as utc_a_arrived_dttm,
       min(case when new_claim_status in ('cancelled', 'cancelled_with_items_on_hands', 'cancelled_with_payment')
            then utc_created_dttm end) as utc_cancelled_dttm
from delivery_ods_cargo_claims.claim_status_log
where true
  and utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
--   and utc_created_dttm >= '2021-10-17'
group by claim_id
distributed by (claim_id);
--
analyse snb_delivery.niksm_temp_864_claim_statlog;

-- 2) taxi log
drop table if exists snb_delivery.niksm_temp_864_taxi_log;
create table snb_delivery.niksm_temp_864_taxi_log as
select order_id,
       min(case when backend_event_code = 'create' then utc_status_created_dttm end) as utc_created_dttm_log,
       min(case when driver_status = 'waiting' then utc_status_created_dttm end)     as utc_a_arrived_dttm,
       min(case when backend_status = 'assigned' then utc_status_created_dttm end)   as utc_found_dttm,
       min(case when backend_status = 'cancelled' then utc_status_created_dttm end)  as utc_cancelled_dttm
from taxi_stg_dbprocessing.order_status_log
where true
  and utc_order_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
--   and utc_order_created_dttm >= '2021-10-17'
group by order_id
distributed by (order_id);
--
analyse snb_delivery.niksm_temp_864_taxi_log;

-- 3) claim_point_addr
drop table if exists snb_delivery.niksm_temp_864_claim_point_addr;
create table snb_delivery.niksm_temp_864_claim_point_addr as
select claim_id,
       max(case when claim_point.point_type = 'source' then point_full_address end) as source_address,
       string_agg(case when claim_point.point_type = 'destination'
           then point_full_address end, '; ' order by claim_point.visit_order_seq) as destination_address_list
from delivery_ods_cargo_claims.claim_point
  join delivery_ods_cargo_claims.point
    on claim_point.point_id = point.point_id
where claim_point.utc_created_dttm >=
        (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day')
                                              at time zone 'Europe/Moscow' at time zone 'UTC'
  and point.utc_created_dttm >=
       (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day')
                                        at time zone 'Europe/Moscow' at time zone 'UTC'
group by claim_id
DISTRIBUTED BY (claim_id);
--
analyse snb_delivery.niksm_temp_864_claim_point_addr;

------------------------------------------------------------------------------------------------------------------------
-- 4) raw claim_id-order_id
drop table if exists snb_delivery.niksm_temp_864_raw;
create table snb_delivery.niksm_temp_864_raw as
with cargo0 as (
    select max(claim.corp_client_id) as corp_client_id,
           claim.claim_id,
           max(claim.tariff_zone) as tariff_zone,
           max(claim.utc_created_dttm) as utc_created_dttm,
           (max(claim.utc_created_dttm) at time zone 'UTC' at time zone 'Europe/Moscow')::date as msk_created_dt,
           max(claim.status_code) as status_code,
           max(claim.taxi_order_id) as order_id,
           count(distinct case when spnt.point_type = 'source' then spnt.claim_point_id end) as source_points,
           count(distinct case when spnt.point_type = 'source' and spnt.point_status = 'visited' then spnt.claim_point_id end) as source_points_visited,
           count(distinct case when spnt.point_type = 'destination' then spnt.claim_point_id end) as destination_points,
           count(distinct case when spnt.point_type = 'destination' and spnt.point_status = 'visited' then spnt.claim_point_id end)as destination_points_visited,
           --
           bool_or(claim.utc_due_dttm is null or claim.utc_due_dttm <= (claim.utc_created_dttm + interval '30 minutes')) as cargo_soon_flg,
           bool_or(claim_statlog.claim_id is not null) as cargo_logging_flg,
           max(segm.utc_created_dttm) utc_created_dttm_log,
           max(claim_statlog.utc_found_dttm) utc_found_dttm,
           max(claim_statlog.utc_a_arrived_dttm) utc_a_arrived_dttm,
           max(claim_statlog.utc_cancelled_dttm) utc_cancelled_dttm
    from delivery_ods_cargo_claims.claim as claim
      join delivery_ods_cargo_claims.claim_segment as segm
        on segm.claim_id = claim.claim_id
      join delivery_ods_cargo_claims.claim_segment_point as spnt
        on spnt.claim_segment_id = segm.claim_segment_id
      left join snb_delivery.niksm_temp_864_claim_statlog claim_statlog
        on claim_statlog.claim_id = claim.claim_id
    where true
      and claim.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and claim.utc_created_dttm <  date_trunc('day', current_timestamp at time zone 'Europe/Moscow') at time zone 'Europe/Moscow' at time zone 'UTC'
      and segm.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and spnt.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and corp_client_id is not null
      and (accepted_flg or claim_statlog.claim_id is null)
    group by claim.claim_id
)
, cargo as (
    select cargo0.*,
           count() over (partition by corp_client_id, source_address, destination_address_list
               order by utc_created_dttm range between current row and interval '30 minute' following) > 1 as following_repeat_flg
    from cargo0
      left join snb_delivery.niksm_temp_864_claim_point_addr claim_point_addr
        on claim_point_addr.claim_id = cargo0.claim_id
)
, taxi as (
    select fct.corp_client_id,
           fct.order_id,
           order_source_code,
           tariff_geo_zone_code as tariff_zone,
           utc_order_created_dttm,
           msk_order_created_dt,
           driver_status,
           user_status,
           success_order_flg,
           destination_plan_geohash_cnt,
           order_type = 'soon' or fct.utc_order_due_dttm <= (fct.utc_order_created_dttm + interval '30 minutes') as taxi_soon_flg,
           taxi_log.order_id is not null as taxi_logging_flg,
           utc_created_dttm_log, utc_found_dttm, utc_a_arrived_dttm, utc_cancelled_dttm,
           count() over (partition by corp_client_id, source_address, destination_plan_address
               order by fct.utc_order_created_dttm range between current row and interval '30 minute' following) > 1 as following_repeat_flg
    from taxi_cdm_marketplace.fct_order fct
      join snb_taxi.logdata_logistic_tariffs lgst
        on lgst.order_tariff = fct.tariff_class_code
      left join snb_delivery.niksm_temp_864_taxi_log as taxi_log
        on taxi_log.order_id = fct.order_id
    where true
      and utc_order_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and corp_client_id is not null
)
select coalesce(cargo.corp_client_id, taxi.corp_client_id) as corp_client_id,
       coalesce(cargo.tariff_zone, taxi.tariff_zone) as tariff_zone,
       cargo.claim_id,
       coalesce(cargo.order_id, taxi.order_id) as order_id,
       cargo.claim_id is not null as cargo_flg,
       taxi.order_id is not null as taxi_flg,
       cargo.status_code,
       taxi.driver_status,
       taxi.user_status,
       taxi.success_order_flg,
       coalesce(cargo.msk_created_dt, taxi.msk_order_created_dt) as msk_created_dt,
       coalesce(cargo.following_repeat_flg, taxi.following_repeat_flg, false) as following_repeat_flg,
       --
       coalesce(cargo.source_points, 1::int) as source_points,
       coalesce(cargo.source_points_visited, success_order_flg::int) as source_points_visited,
       coalesce(cargo.destination_points, destination_plan_geohash_cnt, 1::int) as destination_points,
       coalesce(cargo.destination_points_visited, case when success_order_flg then destination_plan_geohash_cnt else 0::int end) as destination_points_visited,
       -- status
       case when cargo.claim_id is not null
           then cargo.status_code in ('cancelled','cancelled_with_items_on_hands','cancelled_with_payment')
           else taxi.user_status in ('cancelled')
           end as client_cancellation_flg,
       case when cargo.claim_id is not null then cargo.status_code = 'delivered_finish'
           else taxi.success_order_flg end as full_success_flg,
       case when cargo.claim_id is not null
           then cargo.status_code in ('performer_not_found')
           else taxi.user_status in ('expired')
           end as expired_flg,
       --
       coalesce(cargo_soon_flg,taxi_soon_flg) as soon_flg,
       coalesce(cargo_logging_flg,taxi_logging_flg) as logging_flg,
       case when cargo_logging_flg then cargo.utc_created_dttm_log
           when taxi_logging_flg then taxi.utc_created_dttm_log end as utc_created_dttm_log,
       --
       case when cargo_logging_flg then cargo.utc_found_dttm
           when taxi_logging_flg then taxi.utc_found_dttm end as utc_found_dttm,
       case when cargo_logging_flg then cargo.utc_found_dttm is not null
           when taxi_logging_flg then taxi.utc_found_dttm is not null end as courier_found_flg,
       --
       case when cargo_logging_flg then cargo.utc_a_arrived_dttm
           when taxi_logging_flg then taxi.utc_a_arrived_dttm end as utc_a_arrived_dttm,
       case when cargo_logging_flg then cargo.utc_a_arrived_dttm is not null
           when taxi_logging_flg then taxi.utc_a_arrived_dttm is not null end as courier_a_arrived_flg,
       --
       case when cargo_logging_flg then cargo.utc_cancelled_dttm
           when taxi_logging_flg then taxi.utc_cancelled_dttm end as utc_cancelled_dttm
from cargo
  full join taxi
    on cargo.order_id = taxi.order_id
where cargo.order_id is not null
   or ((taxi.order_source_code <> 'cargo' or taxi.order_source_code is null)
     and taxi.utc_order_created_dttm <  date_trunc('day', current_timestamp at time zone 'Europe/Moscow') at time zone 'Europe/Moscow' at time zone 'UTC')
;
analyse snb_delivery.niksm_temp_864_raw;
-- endof 4) raw claim_id-order_id
------------------------------------------------------------------------------------------------------------------------

-- percentile driving_to_a_time
with prcntl_raw as (
    select tariff_zone,
           market_segment,
           extract(epoch from utc_a_arrived_dttm - utc_found_dttm) as driving_to_a_time_sec,
           (count() over (partition by tariff_zone, market_segment
               order by extract(epoch from utc_a_arrived_dttm - utc_found_dttm) rows between unbounded preceding and current row) )::double precision
               / count() over (partition by tariff_zone, market_segment) as zone_segm_share,
           (count() over (partition by tariff_zone
               order by extract(epoch from utc_a_arrived_dttm - utc_found_dttm) rows between unbounded preceding and current row) )::double precision
               / count() over (partition by tariff_zone) as zone_share,
           (count() over (partition by market_segment
               order by extract(epoch from utc_a_arrived_dttm - utc_found_dttm) rows between unbounded preceding and current row) )::double precision
               / count() over (partition by market_segment) as segm_share,
           (count() over (
               order by extract(epoch from utc_a_arrived_dttm - utc_found_dttm) rows between unbounded preceding and current row) )::double precision
               / count() over () as total_share
    from snb_delivery.niksm_temp_864_raw raw
      join snb_b2b.niksm_b2b_lk_client_service_info lk
        on lk_service_name = 'cargo'
        and lk_client_id = raw.corp_client_id
      join snb_b2b.niksm_b2b_contracts_info crm
        on crm.contract_id = lk.contract_external_id
        and crm.which_crm = 6
    where courier_found_flg and courier_a_arrived_flg
      and utc_a_arrived_dttm > utc_found_dttm
      and manager_group in ('ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП 3','ГМП 4','Тир 3')
)
select tariff_zone,
       market_segment,
       avg(driving_to_a_time_sec)/60. as avg_driving_to_a_time_min,
       min(case when zone_segm_share >= .80 then driving_to_a_time_sec end)/60. as prc80_driving_to_a_time_min,
       min(case when zone_segm_share >= .90 then driving_to_a_time_sec end)/60. as prc90_driving_to_a_time_min,
       min(case when zone_segm_share >= .95 then driving_to_a_time_sec end)/60. as prc95_driving_to_a_time_min
from prcntl_raw
group by tariff_zone, market_segment
union all
select tariff_zone,
       'TOTAL' as market_segment,
       avg(driving_to_a_time_sec)/60. as avg_driving_to_a_time_min,
       min(case when zone_share >= .80 then driving_to_a_time_sec end)/60. as prc80_driving_to_a_time_min,
       min(case when zone_share >= .90 then driving_to_a_time_sec end)/60. as prc90_driving_to_a_time_min,
       min(case when zone_share >= .95 then driving_to_a_time_sec end)/60. as prc95_driving_to_a_time_min
from prcntl_raw
group by tariff_zone
union all
select 'TOTAL' as tariff_zone,
       market_segment,
       avg(driving_to_a_time_sec)/60. as avg_driving_to_a_time_min,
       min(case when segm_share >= .80 then driving_to_a_time_sec end)/60. as prc80_driving_to_a_time_min,
       min(case when segm_share >= .90 then driving_to_a_time_sec end)/60. as prc90_driving_to_a_time_min,
       min(case when segm_share >= .95 then driving_to_a_time_sec end)/60. as prc95_driving_to_a_time_min
from prcntl_raw
group by market_segment
union all
select 'TOTAL' as tariff_zone,
       'TOTAL' as market_segment,
       avg(driving_to_a_time_sec)/60. as avg_driving_to_a_time_min,
       min(case when total_share >= .80 then driving_to_a_time_sec end)/60. as prc80_driving_to_a_time_min,
       min(case when total_share >= .90 then driving_to_a_time_sec end)/60. as prc90_driving_to_a_time_min,
       min(case when total_share >= .95 then driving_to_a_time_sec end)/60. as prc95_driving_to_a_time_min
from prcntl_raw;
------------------------------------------------------------------------------------------------------------------------

-- MAIN
with gen(searching_time_min_group) as (
    select * from generate_series(1,9,1)
    union all
    select * from generate_series(10,30,5)
)
select tariff_zone,
       manager_group,
       market_segment,
       -- flags
       cargo_flg, taxi_flg,
       client_cancellation_flg,
       logging_flg,
       courier_found_flg,
       soon_flg,
       expired_flg,
--        full_success_flg,
       --
       searching_time_min_group,
       logging_flg and (
           not client_cancellation_flg
            or utc_cancelled_dttm > utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group)
            or (
               courier_found_flg
                and utc_found_dttm <= utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group)
               )
            ) as base_flg,
       logging_flg and courier_found_flg
           and utc_found_dttm <= utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group)
            as fast_search_flg,
       logging_flg and following_repeat_flg
           and utc_cancelled_dttm <= utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group)
            as fast_cancel_w_repeat_flg,
       --
       sum(source_points) as source_points,
       sum(source_points_visited) as source_points_visited,
       sum(destination_points) as destination_points,
       sum(destination_points_visited) as destination_points_visited,
       --
       sum(case when utc_cancelled_dttm is not null then extract(epoch from utc_cancelled_dttm - utc_created_dttm_log) end) as time_sec_before_cancel,
       sum(case when utc_cancelled_dttm is not null then source_points end) as source_points_utc_cancelled,
       --
       sum(case when courier_found_flg then source_points end) as pnt_for_searching_time,
       sum(case when courier_found_flg then extract(epoch from utc_found_dttm - utc_created_dttm_log) end) as searching_time_sec,
       --
       sum(case when courier_a_arrived_flg and utc_a_arrived_dttm > utc_found_dttm then source_points end) as pnt_for_driving_time,
       sum(case when courier_a_arrived_flg and utc_a_arrived_dttm > utc_found_dttm
           then extract(epoch from utc_a_arrived_dttm - utc_found_dttm) end) as driving_to_a_time_sec
from snb_delivery.niksm_temp_864_raw raw
  join snb_b2b.niksm_b2b_lk_client_service_info lk
    on lk_service_name = 'cargo'
    and lk_client_id = raw.corp_client_id
  join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = lk.contract_external_id
    and crm.which_crm = 6
  cross join gen
group by tariff_zone,
         manager_group,
         market_segment,
       -- flags
       cargo_flg, taxi_flg,
       client_cancellation_flg,
       logging_flg,
       courier_found_flg,
       soon_flg,
       expired_flg,
--        full_success_flg,
       --
       searching_time_min_group,
       logging_flg and (
           not client_cancellation_flg
            or utc_cancelled_dttm > utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group)
            or (
               courier_found_flg
                and utc_found_dttm <= utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group)
               )
            ),
       logging_flg and courier_found_flg
           and utc_found_dttm <= utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group),
       logging_flg and following_repeat_flg
           and utc_cancelled_dttm <= utc_created_dttm_log + make_interval(0,0,0,0,0,searching_time_min_group);

------------------------------------------------------------------------------------------------------------------------

-- до 2021-10-17
select utc_created_dttm::date,
       count()
from delivery_ods_cargo_claims.point
where utc_created_dttm >= '2021-08-01'
group by 1 order by 1;

with pnt as (
    select claim_id,
           max(case when claim_point.point_type = 'source' then point_full_address end) as source_address,
           string_agg(case when claim_point.point_type = 'destination'
               then point_full_address end, '; ' order by claim_point.visit_order_seq) as destination_address_list
    from delivery_ods_cargo_claims.claim_point
      join delivery_ods_cargo_claims.point
        on claim_point.point_id = point.point_id
    where claim_point.utc_created_dttm >= '2021-10-04'
--         (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day')
--                                               at time zone 'Europe/Moscow' at time zone 'UTC'
      and point.utc_created_dttm >= '2021-10-04'
--        (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day')
--                                         at time zone 'Europe/Moscow' at time zone 'UTC'
    group by claim_id
)
, claim_addr as (
    select claim.cargo_ref_id,
           corp_client_id,
           claim.utc_created_dttm,
           utc_accepted_dttm,
           status_code,
           utc_cancelled_dttm,
           source_address,
           destination_address_list,
           --
           utc_cancelled_dttm < utc_accepted_dttm + interval '10 minute' as fast_cancel_flg,
           count() over (partition by corp_client_id, source_address, destination_address_list
               order by utc_created_dttm range between current row and interval '30 minute' following) > 1 as following_repeat_flg,
           bool_or(utc_cancelled_dttm < utc_accepted_dttm + interval '10 minute')
               over (partition by corp_client_id, source_address, destination_address_list
                   order by utc_created_dttm range between interval '30 minute' preceding and interval '1 second' preceding) as prev_fast_cancel_flg
    from delivery_ods_cargo_claims.claim
      join pnt
        on pnt.claim_id = claim.claim_id
      left join snb_delivery.niksm_temp_864_claim_statlog statlog
        on statlog.claim_id = claim.claim_id
    where claim.utc_created_dttm >= '2021-10-04'
      and claim.utc_created_dttm <  '2021-10-18'
--           (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day')
--                                         at time zone 'Europe/Moscow' at time zone 'UTC'
)
, res as (
    select corp_client_id,
           lk_client_name as corp_client_name,
           lk.contract_external_id as contract_id,
           manager_group,
           manager_name,
           cargo_ref_id,
           utc_created_dttm,
           utc_accepted_dttm,
           status_code,
           utc_cancelled_dttm,
           source_address,
           destination_address_list,
           --
           fast_cancel_flg, following_repeat_flg, prev_fast_cancel_flg,
           count() over (partition by corp_client_id) as claims_cnt,
           sum((fast_cancel_flg and following_repeat_flg)::int) over (partition by corp_client_id) as fast_cancel_cnt
    from claim_addr
      join snb_b2b.niksm_b2b_lk_client_service_info lk
        on lk.lk_client_id = claim_addr.corp_client_id
        and lk.lk_service_name = 'cargo'
      join snb_b2b.niksm_b2b_contracts_info crm
        on crm.contract_id = lk.contract_external_id
    where manager_group in ('ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП 3','ГМП 4','СНГ РБ','СНГ РК','Тир 3')
)
select corp_client_id, corp_client_name, contract_id, manager_group, manager_name,
       cargo_ref_id,
       utc_created_dttm,
       utc_accepted_dttm,
       status_code,
       utc_cancelled_dttm,
       case when utc_cancelled_dttm is not null then extract(epoch from utc_cancelled_dttm - utc_accepted_dttm)/60. end as "Минут до отмены",
       source_address,
       destination_address_list,
       claims_cnt as "Заявок всего",
       fast_cancel_cnt as "Быстрые отмены",
       fast_cancel_cnt::double precision / claims_cnt as "Доля быстрых отмен у клиента"
from res
where fast_cancel_cnt >= 14
  and fast_cancel_cnt >= claims_cnt * 0.03
  and corp_client_id not in ('ed7c330f45fe4706a5e16e4efd7042b5')
  and ((fast_cancel_flg and following_repeat_flg)
    or prev_fast_cancel_flg)
order by "Быстрые отмены" desc, "Доля быстрых отмен у клиента" desc, corp_client_id, utc_created_dttm;


select corp_client_id,
       max(lk_client_name) as corp_client_name,
       max(lk.contract_external_id) as contract_id,
       count() claims_cnt,
       sum((repeat_flg and fast_cancel_flg)::int) as fast_cancel_cnt,
       max(manager_group) as manager_group,
       max(manager_name) as manager_name
from claim_addr
  join snb_b2b.niksm_b2b_lk_client_service_info lk
    on lk.lk_client_id = claim_addr.corp_client_id
    and lk.lk_service_name = 'cargo'
  join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = lk.contract_external_id
group by corp_client_id
order by claims_cnt desc
;

select node_type, count()
from taxi_cdm_geo.dim_geo_node geonode
where true
--   AND geonode.node_type = 'agglomeration'
  AND geonode.root_node_id = 'br_root'
group by 1;


select *
from taxi_cdm_geo.dim_geo_node geonode
--         on geonode.node_id = fct.agglomeration_node_id
where true
  AND geonode.node_type = 'agglomeration'
--   AND geonode.node_type = 'node'
  AND geonode.root_node_id = 'br_root';

select population_group, count()
from core_cdm_geo.v_dim_full_geo_hierarchy
where country_node_id = 'br_russia'
  and node_type = 'agglomeration'
group by 1
-- having count()>1
limit 50
