with lk as (
    select billing_id as billing_client_id,
           max(id)    as corp_client_id
    from snb_b2b.bmiklaz_corp_clients
    where billing_id in
          ('95618319', '95543673', '94738354', '95501772', '95265028', '89958803', '94242010', '89330305', '95146060',
           '94281694', '94636387', '95055901', '95055887', '95267114', '95253971', '95249463', '95041751', '95056867',
           '94826149', '94974632', '92144133', '95145318', '95133355', '95130082', '95068179', '95068134', '95055855',
           '95019741', '95019722', '94920677', '93952390', '94191659', '94787396', '94281677', '83479059', '93224224',
           '94738093', '92656022', '93532055', '94741266', '94032241', '94671514', '91659734', '94653161', '94635750',
           '91177858', '94638262', '94104252', '91097112', '94556000', '94511185', '94118097', '93859733', '90280946',
           '83478655', '91657194', '92749628', '93184709', '93992014', '94073858', '91108737', '93225337', '78306509',
           '92527274', '92828935', '94169930', '94169995', '90680604', '94178458', '92762411', '89776826', '93865213',
           '94355833', '91874372', '94381644', '93613896', '92764685', '91193040', '94032265', '93996323', '93991995',
           '93745356', '93948884', '93314409', '93915134', '93874429', '93834470', '93313464', '93598067', '93784044',
           '93774313', '93534341', '93015745', '93274354', '93383721', '93570891', '93604425', '93587365', '93570883',
           '93384697', '93519033', '93519057', '92914922', '93356973', '93355093')
    group by billing_id
)
select billing_client_id,
       corp_client_id,
       date_trunc('month',msk_order_created_dt)::date as "Месяц заказа (МСК)",
       count() as "Заказов всего (в т.ч. неуспешных)",
       sum(success_order_flg::int) as "Заказов успешных",
       sum(delivery_plan_point_cnt) as "Точек В плановых",
       sum(delivery_point_cnt) as "Успешных доставок",
       sum(order_cost * currency_rate) as "Gross Bookings, RUB"
from taxi_cdm_marketplace.fct_order
  join lk using (corp_client_id)
  join snb_taxi.logdata_logistic_tariffs lgst
    on fct_order.tariff_class_code = lgst.order_tariff
where utc_order_created_dttm >= timestamp'2021-07-01' at time zone 'Europe/Moscow' at time zone 'UTC'
group by 1,2,3
order by "Месяц заказа (МСК)";