with segm_car as (
    select distinct taxi_order_id
    from (
             select taxi_order_id,
                    json_array_elements(arr -> 'special_requirements') ->> 'id' as req_id
             from (
                      select claim_segment_id,
                             taxi_order_id,
                             json_array_elements(special_requirement_text::json -> 'virtual_tariffs') as arr
                      from delivery_ods_cargo_claims.claim_segment
                      where utc_created_dttm >= '2021-09-30'
                  ) q
             where (arr ->> 'class') = 'courier'
         ) qq
    where req_id = 'car_couriers'
)
select manager_group,
       corp_contract_id,
       corp_client_id,
       tariff_class_code,
       sum(delivery_point_cnt) as deliveries_cnt,
       sum(gmv_amt * currency_rate) as gmv_amt,
       sum(net_inflow_amt * currency_rate) as net_inflow_amt,
       sum(case when segm_car.taxi_order_id is not null then delivery_point_cnt else 0 end) as deliveries_cnt_car_couriers,
       sum(case when segm_car.taxi_order_id is not null then gmv_amt * currency_rate else 0 end) as gmv_amt_car_couriers,
       sum(case when segm_car.taxi_order_id is not null then net_inflow_amt * currency_rate else 0 end) as net_inflow_amt_car_couriers
from taxi_cdm_marketplace.fct_order_metric
  join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = fct_order_metric.corp_contract_id
  left join segm_car
    on segm_car.taxi_order_id = fct_order_metric.order_id
where fct_order_metric.utc_order_created_dttm >= '2021-09-30'
  and msk_order_created_dt between '2021-10-01' and '2021-10-31'
  and success_order_flg
  and corp_order_flg
  and manager_group in ('ГМП 1','ГМП 2','ГМП 3','ГМП 4','ГПП 1','Тир 3')
  and tariff_class_code = 'courier'
  and country_name_ru = 'Россия'
group by 1,2,3,4
