
-- 1) CLIENT_TARIFF_PLANS
drop table if exists snb_delivery.niksm_temp_client_tariff_plans;
create table snb_delivery.niksm_temp_client_tariff_plans as
select client_id,
       cast(date_from as timestamp) as dttm_from,
       coalesce(cast(date_to as timestamp),timestamp'2099-12-31 23:59:59') as dttm_to,
       tariff_plan_series_id
from snb_taxi.niksm_b2b_client_tariff_plans
where service = 'cargo'
  and coalesce(cast(date_to as timestamp),timestamp'2099-12-31 23:59:59') >= timestamp'2021-04-01'
distributed by (tariff_plan_series_id);
--
analyze snb_delivery.niksm_temp_client_tariff_plans;
--
select * from snb_delivery.niksm_temp_client_tariff_plans limit 10;

-- 2) TARIFF_PLANS
drop table if exists snb_delivery.niksm_temp_tariff_plans;
create table snb_delivery.niksm_temp_tariff_plans as
select tariff_plan_series_id, tariff_plan_series_name,
       tariff_zone,
       tariff_series_id,
       cast(date_from as timestamp) as dttm_from,
       coalesce(cast(date_to as timestamp),timestamp'2099-12-31 23:59:59') as dttm_to
from snb_taxi.niksm_b2b_tariff_plans
where coalesce(cast(date_to as timestamp),timestamp'2099-12-31 23:59:59') >= timestamp'2021-04-01';
--
analyze snb_delivery.niksm_temp_tariff_plans;
--
select * from snb_delivery.niksm_temp_tariff_plans limit 10;

-- 3) TARIFFS

select * from snb_taxi.niksm_b2b_tariffs as t limit 10;

drop table if exists snb_delivery.niksm_temp_tariffs;
create table snb_delivery.niksm_temp_tariffs as
select tariff_id, tariff_series_id, tariff_series_name,
       cast(tariff_series_date_from as timestamp) as tariff_series_dttm_from,
       coalesce(cast(tariff_series_date_to as timestamp),timestamp'2099-12-31 23:59:59') as tariff_series_dttm_to,
       class_name,
       interval_id, interval_category_type, interval_day_type, interval_time_from, interval_time_to,
       add_minimal_to_paid_cancel, minimal, paid_cancel_fix
from (
    select *,
           row_number() over (partition by tariff_id, class_name,
               tariff_series_date_from, tariff_series_date_to,
               interval_category_type, interval_day_type, interval_time_from, interval_time_to) as rn
    from snb_taxi.niksm_b2b_tariffs as t
    where true
      and interval_category_type = 'application'
      and interval_day_type = 2
      and interval_time_from = '00:00'
      and interval_time_to = '23:59'
) q
where rn = 1
  and coalesce(cast(tariff_series_date_to as timestamp),timestamp'2099-12-31 23:59:59') >= timestamp'2021-04-01'
distributed by (tariff_series_id);
--
analyze snb_delivery.niksm_temp_tariffs;

-- res = 500k
-- select count()
-- from snb_delivery.niksm_temp_client_tariff_plans as ctp
--   join snb_taxi.niksm_b2b_tariff_plans as tp
--     on tp.tariff_plan_series_id = ctp.tariff_plan_series_id
--   join snb_delivery.niksm_temp_tariffs as tariffs
--     on tariffs.tariff_series_id = tp.tariff_series_id;


drop table if exists snb_delivery.niksm_temp_tariffs_raw;
create table snb_delivery.niksm_temp_tariffs_raw as
select ctp.client_id,
       ctp.dttm_from as client_tariff_plans_dttm_from,
       ctp.dttm_to as client_tariff_plans_dttm_to,
       ctp.tariff_plan_series_id,
       tp.tariff_plan_series_name,
       tp.tariff_series_id,
       tp.tariff_zone,
       tp.dttm_from as tariff_plans_dttm_from,
       tp.dttm_to as tariff_plans_dttm_to,
       tariffs.tariff_series_name,
       tariffs.tariff_series_dttm_from,
       tariffs.tariff_series_dttm_to,
       tariffs.class_name,
       tariffs.interval_id,
--        tariffs.interval_category_type, interval_day_type, interval_time_from, interval_time_to,
       tariffs.add_minimal_to_paid_cancel,
       tariffs.minimal,
       tariffs.paid_cancel_fix
from snb_delivery.niksm_temp_client_tariff_plans as ctp
  join snb_delivery.niksm_temp_tariff_plans as tp
    on tp.tariff_plan_series_id = ctp.tariff_plan_series_id
  join snb_delivery.niksm_temp_tariffs as tariffs
    on tariffs.tariff_series_id = tp.tariff_series_id
;
--
analyze snb_delivery.niksm_temp_tariffs_raw;
select count() from snb_delivery.niksm_temp_tariffs_raw;

drop table if exists snb_delivery.niksm_temp_dmo;
create table snb_delivery.niksm_temp_dmo as
select utc_order_dt, order_id, tariff_zone, order_tariff,
       corp_client_id, corp_client_name,
       corp_contract_id,
       n_deliveries_visited, decoupling_driver_cost
from snb_taxi.logdata_dm_order_v
where utc_order_dt >= '2021-04-01'
  and logistic_tariff_flag;
--
analyze snb_delivery.niksm_temp_dmo;
select count() from snb_delivery.niksm_temp_dmo;


-- Final select
with interco as (
    select contract_id
    from snb_taxi.niksm_b2b_contracts_info
    where manager_group = 'INTERCO'
)
select cncl.*,
       tariffs_raw.*,
       dmo.corp_client_name,
       dmo.decoupling_driver_cost,
       dmo.n_deliveries_visited as dlv_cnt
from snb_taxi.niksm_b2b_paid_cancellation_raw as cncl
  join snb_delivery.niksm_temp_dmo as dmo
    on dmo.order_id = cncl.taxi_order_id
  join snb_delivery.niksm_temp_tariffs_raw as tariffs_raw
    on tariffs_raw.client_id = cncl.corp_client_id
    and to_timestamp(cncl.created_ts) >= tariffs_raw.client_tariff_plans_dttm_from
    and to_timestamp(cncl.created_ts) <  tariffs_raw.client_tariff_plans_dttm_to
    --
    and to_timestamp(cncl.created_ts) >= tariffs_raw.tariff_plans_dttm_from
    and to_timestamp(cncl.created_ts) <  tariffs_raw.tariff_plans_dttm_to
    --
    and to_timestamp(cncl.created_ts) >= tariffs_raw.tariff_series_dttm_from
    and to_timestamp(cncl.created_ts) <  tariffs_raw.tariff_series_dttm_to
    and tariffs_raw.tariff_zone = dmo.tariff_zone
    and tariffs_raw.class_name = dmo.order_tariff
  left join interco
    on interco.contract_id = dmo.corp_contract_id
where claim_created_dt between '2021-04-23' and '2021-05-22'
  and fin_pricing_case = 'paid_cancel'
--   and not cncl.corp_client_id in ('4decd14f25424e8b82b6d3e4f56d23b2','b2dc2b2e96f8482ba2d1582bd1445184','dc28c565829e48cca458b5feb161d5d6')
  and interco.contract_id is null
order by claim_created_dt
;



with trf as (
    select client_id,
           tariff_zone,
           class_name,
           add_minimal_to_paid_cancel,
           minimal,
           paid_cancel_fix
    from snb_delivery.niksm_temp_tariffs_raw
    where client_tariff_plans_dttm_to = timestamp'2099-12-31 23:59:59.000000'
      and tariff_plans_dttm_to = timestamp'2099-12-31 23:59:59.000000'
      and tariff_series_dttm_to = timestamp'2099-12-31 23:59:59.000000'
      and not client_id in ('4decd14f25424e8b82b6d3e4f56d23b2','b2dc2b2e96f8482ba2d1582bd1445184','dc28c565829e48cca458b5feb161d5d6')
)
, dmo as (
    select corp_client_id,
           corp_client_name,
           tariff_zone,
           order_tariff,
           count() as orders_cnt
    from snb_delivery.niksm_temp_dmo
    where utc_order_dt between '2021-04-23' and '2021-05-22'
    group by corp_client_id,
           corp_client_name,
           tariff_zone,
           order_tariff
)
select *
from trf
  left join dmo
    on trf.client_id = dmo.corp_client_id
    and trf.tariff_zone = dmo.tariff_zone
    and trf.class_name = dmo.order_tariff;


------------------------------------------------------------------------------------------------------------------------


select *
from snb_taxi.logdata_dm_order_v
where order_id = '9b6c4528767936438aaf6d9c5f3a99a0'
  and utc_order_dt >= '2021-05-01';


select *
from taxi_cdm_marketplace.fct_order
where order_id = '9b6c4528767936438aaf6d9c5f3a99a0'
  and utc_order_created_dttm >= '2021-05-01'

select sum(est_boarding_price)
from snb_taxi.niksm_b2b_paid_cancellation_raw
where claim_created_dt between '2021-04-01' and '2021-04-30'
  and fin_pricing_case = 'paid_cancel'
  and not corp_client_id in ('4decd14f25424e8b82b6d3e4f56d23b2','b2dc2b2e96f8482ba2d1582bd1445184','dc28c565829e48cca458b5feb161d5d6')
;

select --corp_client_id, corp_client_name, dmo.order_tariff, count()
       (dmo.order_id is not null),
       (tariffs_raw.client_id is not null),
       sum(est_boarding_price),
       sum(final_price)/1000000.
from snb_taxi.niksm_b2b_paid_cancellation_raw as cncl
  left join snb_delivery.niksm_temp_dmo as dmo
    on dmo.order_id = cncl.taxi_order_id
  left join snb_delivery.niksm_temp_tariffs_raw as tariffs_raw
    on tariffs_raw.client_id = cncl.corp_client_id
    and to_timestamp(cncl.created_ts) >= tariffs_raw.client_tariff_plans_dttm_from
    and to_timestamp(cncl.created_ts) <  tariffs_raw.client_tariff_plans_dttm_to
    --
    and to_timestamp(cncl.created_ts) >= tariffs_raw.tariff_plans_dttm_from
    and to_timestamp(cncl.created_ts) <  tariffs_raw.tariff_plans_dttm_to
    --
    and to_timestamp(cncl.created_ts) >= tariffs_raw.tariff_series_dttm_from
    and to_timestamp(cncl.created_ts) <  tariffs_raw.tariff_series_dttm_to
    and tariffs_raw.tariff_zone = dmo.tariff_zone
    and tariffs_raw.class_name = dmo.order_tariff
where claim_created_dt between '2021-04-23' and '2021-05-22'
  and fin_pricing_case = 'paid_cancel'
  and not cncl.corp_client_id in ('4decd14f25424e8b82b6d3e4f56d23b2','b2dc2b2e96f8482ba2d1582bd1445184','dc28c565829e48cca458b5feb161d5d6')
--   and dmo.order_id is null
--   and tariffs_raw.client_id is null
--   and corp_client_id = '7f7b5227ca614a8b9189366c2a4537f5'
group by 1,2
-- order by 4 desc
-- order by 1,2;
limit 10;

select *
from snb_taxi.niksm_b2b_tariffs
where tariff_series_id = 'abb60aaa08fb4dda8466d46526861e35'
limit 10;

select *
from snb_taxi.niksm_b2b_client_tariff_plans
where client_id = '7f7b5227ca614a8b9189366c2a4537f5';

select *
from snb_taxi.niksm_b2b_tariff_plans
  join snb_taxi.niksm_b2b_tariffs
    using (tariff_series_id)
where tariff_plan_series_id = '654bbb28383944eba0ee414d23533fb0'-- and tariff_zone = 'moscow';
  and date_to is null
--   and tariff_series_date_to is null

-- Checks
-- Res = 0
select client_id, dttm_from, count()
from niksm_client_tariff_plans
group by client_id, dttm_from
having count()>1;

-- Res = 0
select *
from niksm_client_tariff_plans as t1
  join niksm_client_tariff_plans as t2
    on t1.client_id = t2.client_id
where t2.dttm_from < t1.dttm_to
  and t2.dttm_to > t1.dttm_from
  and t2.dttm_from <> t1.dttm_from
limit 50;

analyze snb_taxi.niksm_b2b_tariffs;
select count() from snb_taxi.niksm_b2b_tariffs;
select * from snb_taxi.niksm_b2b_tariffs limit 10;

analyze snb_taxi.niksm_b2b_tariff_plans;
select count() from snb_taxi.niksm_b2b_tariff_plans;
select * from snb_taxi.niksm_b2b_tariff_plans limit 10;

analyze snb_taxi.niksm_b2b_client_tariff_plans;
select count() from snb_taxi.niksm_b2b_client_tariff_plans;
select * from snb_taxi.niksm_b2b_client_tariff_plans limit 10;

analyze snb_taxi.niksm_b2b_paid_cancellation_raw;
select count() from snb_taxi.niksm_b2b_paid_cancellation_raw;
select * from snb_taxi.niksm_b2b_paid_cancellation_raw limit 10;
select min(claim_created_dt), max(claim_created_dt) from snb_taxi.niksm_b2b_paid_cancellation_raw;

select * from (
    select *,
           count() over (partition by tariff_id, class_name, interval_category_type, interval_day_type, interval_time_from, interval_time_to) as cnt
    from snb_taxi.niksm_b2b_tariffs
) q
where cnt>1
order by tariff_id, class_name, interval_category_type, interval_day_type, interval_time_from, interval_time_to;

-- что-то есть, но мало
select count()
from snb_taxi.niksm_b2b_tariffs
where true
--   and not add_minimal_to_paid_cancel
--   and paid_cancel_fix = minimal * 0.5
  and minimal > 0
limit 10;


select *
from snb_taxi.niksm_b2b_paid_cancellation_raw
where claim_created_dt between '2021-04-01' and '2021-04-30'
  and fin_pricing_case = 'paid_cancel'
  and corp_client_id = '7f7b5227ca614a8b9189366c2a4537f5'
  and fin_boarding_price > est_boarding_price
limit 10;

select
       corp_client_id,
--        status,
       count() as claims_cnt,
       sum(est_boarding_price) as total_boarding_price,
       sum(fin_boarding_price) as total_boarding_price,
       sum(count()) over (partition by corp_client_id) as client_claims
from snb_taxi.niksm_b2b_paid_cancellation_raw
where claim_created_dt between '2021-04-01' and '2021-04-30'
  and fin_pricing_case = 'paid_cancel'
group by 1
order by client_claims desc, corp_client_id, claims_cnt desc;


-- client_name
select corp_client_id, corp_client_name
from snb_taxi.logdata_dm_order_v
where utc_order_dt between '2021-04-01' and '2021-04-30'
  and logistic_tariff_flag
  and corp_order_flg
group by 1,2
order by count() desc;