
drop table if exists snb_delivery.logdata_1573;
create table snb_delivery.logdata_1573 as
select
    date,
    corp_client_id,
    corp_contract_id,
    holding_name,
    country,
    tariff_geo_zone_code,
    tariff_class_code,
    case
        when tariff_class_code in ('ubernight','uberlux') then 'Uber'
        when tariff = 'K2' or client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
        when corp_client_id is not null then
            case
                when manager_metagroup = 'INTERCO' then 'INTERCO'
                when manager_metagroup = 'Тир 1' then 'Tier 1'
                when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
                when manager_metagroup = 'Тир 3' or phoenix then 'Tier 3'
                when manager_metagroup = 'Партнерские продажи' then 'Franchise'
                when manager_metagroup is null then 'B2B Platform'
            end
            else case
                when c2c_smb_b2b_flg = 'SMB' then 'Tier 4'
                when c2c_smb_b2b_flg = 'C2C' then 'C2C'
                else coalesce(manager_group,'Other')
            end
       end::text as tier,
    case
       when manager_group = 'B2B платформа' then 'B2B Platform'
       when order_source = 'API' then case
           when referral_source_code is not null then 'Modules'
           else 'API'
           end
       when order_source = 'Mobile App' then 'Go'
       else order_source
       end as channel,
    sum(orders::float) as orders,
    sum(deliveries::float) as deliveries
from
    snb_delivery.data_bizdev
where
    date >= '2021-01-01'
group by
    1,2,3,4,5,6,7,8,9;

grant select on snb_delivery.logdata_1573 to public;
