insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('dbcorp_client_contract_info', 'Client start', clock_timestamp());

---- corp_client_id datamart ----
drop table if exists temp_dbcorp_client_info;
create temporary table temp_dbcorp_client_info as
with cntr0 as (
    select *,
           row_number() over (partition by billing_client_id
               order by active_flg desc, utc_created_dttm desc) as rn
    from taxi_ods_dbcorp.contract
    where (position('718' in service_ids_text) > 0
        or position('650' in service_ids_text) > 0
        or position('135' in service_ids_text) > 0)
)
, cntr as (
    select billing_client_id,
           contract_code as corp_contract_id,
           contract_id as billing_contract_id,
           currency_code,
           active_flg as billing_contract_active_flg,
           cancelled_flg as billing_contract_cancelled_flg,
           offer_flg,
           offer_accepted_flg,
           payment_term_dur, payment_type,
           quasi_postpayment_type, quasi_threshold_ccy_value,
           service_ids_text,
           signed_flg as billing_contract_signed_flg,
           suspended_flg as billing_contract_suspended_flg,
           utc_contract_finish_dttm, utc_contract_start_dttm,
           utc_created_dttm as utc_contract_created_dttm,
           utc_updated_dttm as utc_contract_updated_dttm,
           edo_offer_accepted_flg,
           activate_flg,
           auto_activate_flg,
           contract_limit_ccy_value,
           contract_limit_threshold_ccy_value,
           low_balance_notification_flg,
           low_balance_threshold_ccy_value
    from cntr0
    where rn = 1
)
select corp_client_id,
       cl.billing_client_id,
       corp_client_name,
       service_active_flg_dict, service_test_flg_dict, service_visible_flg_dict, next_day_delivery_flg,
       trial_flg,
       cl.utc_created_dttm as utc_client_created_dttm,
       cl.utc_updated_dttm as utc_client_updated_dttm,
       cl.country_code,
       yandex_login,
       (service_active_flg_dict ->> 'cargo')::bool as cargo_service_active_flg,
       (service_active_flg_dict ->> 'taxi')::bool as taxi_service_active_flg,
       corp_contract_id,
       billing_contract_id, currency_code,
       billing_contract_active_flg,
       billing_contract_cancelled_flg,
       offer_flg, offer_accepted_flg,
       payment_term_dur, payment_type,
       quasi_postpayment_type, quasi_threshold_ccy_value,
       service_ids_text,
       billing_contract_signed_flg,
       billing_contract_suspended_flg,
       utc_contract_finish_dttm, utc_contract_start_dttm,
       utc_contract_created_dttm, utc_contract_updated_dttm,
       edo_offer_accepted_flg,
       activate_flg,
       auto_activate_flg,
       contract_limit_ccy_value,
       contract_limit_threshold_ccy_value,
       low_balance_notification_flg,
       low_balance_threshold_ccy_value
from taxi_ods_dbcorp.corp_client cl
  left join cntr
    on cntr.billing_client_id = cl.billing_client_id;

------------------------------------------------------------------------
-- drop table if exists snb_b2b.dbcorp_client_info;
-- create table snb_b2b.dbcorp_client_info as
truncate table snb_b2b.dbcorp_client_info;
insert into snb_b2b.dbcorp_client_info
    (corp_client_id, billing_client_id, corp_client_name,
       service_active_flg_dict, service_test_flg_dict, service_visible_flg_dict, next_day_delivery_flg, trial_flg,
       utc_client_created_dttm, utc_client_updated_dttm, country_code, yandex_login,
       cargo_service_active_flg, taxi_service_active_flg,
       corp_contract_id, billing_contract_id, currency_code, billing_contract_active_flg, billing_contract_cancelled_flg,
       offer_flg, offer_accepted_flg, payment_term_dur, payment_type, quasi_postpayment_type, quasi_threshold_ccy_value,
       service_ids_text, billing_contract_signed_flg, billing_contract_suspended_flg,
       utc_contract_finish_dttm, utc_contract_start_dttm, utc_contract_created_dttm, utc_contract_updated_dttm,
       edo_offer_accepted_flg,
       activate_flg, auto_activate_flg,
       contract_limit_ccy_value, contract_limit_threshold_ccy_value, low_balance_notification_flg, low_balance_threshold_ccy_value)
select corp_client_id, billing_client_id, corp_client_name,
       service_active_flg_dict, service_test_flg_dict, service_visible_flg_dict, next_day_delivery_flg, trial_flg,
       utc_client_created_dttm, utc_client_updated_dttm, country_code, yandex_login,
       cargo_service_active_flg, taxi_service_active_flg,
       corp_contract_id, billing_contract_id, currency_code, billing_contract_active_flg, billing_contract_cancelled_flg,
       offer_flg, offer_accepted_flg, payment_term_dur, payment_type, quasi_postpayment_type, quasi_threshold_ccy_value,
       service_ids_text, billing_contract_signed_flg, billing_contract_suspended_flg,
       utc_contract_finish_dttm, utc_contract_start_dttm, utc_contract_created_dttm, utc_contract_updated_dttm,
       edo_offer_accepted_flg,
       activate_flg, auto_activate_flg,
       contract_limit_ccy_value, contract_limit_threshold_ccy_value, low_balance_notification_flg, low_balance_threshold_ccy_value
from temp_dbcorp_client_info
-- distributed by (corp_client_id)
;

update snb_b2b.dbcorp_client_info
set _etl_processed_dttm = clock_timestamp()
where true;

-- alter table snb_b2b.dbcorp_client_info add constraint dbcorp_client_info_pk primary key (corp_client_id);
-- comment on table snb_b2b.dbcorp_client_info is 'Атрибуты клиента в админке Список клиентов. Ключ - corp_client_id';

---- endof corp_client_id datamart ----
--====================================================================================================================--
---- corp_contract_id datamart ----
insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('dbcorp_client_contract_info', 'Client success, contract start', clock_timestamp());

drop table if exists temp_dbcorp_contract_info;
create temporary table temp_dbcorp_contract_info as
with cntr0 as (
    select *,
           row_number() over (partition by contract_code
               order by active_flg desc, utc_created_dttm desc) as rn
    from taxi_ods_dbcorp.contract
    where true
      and (position('718' in service_ids_text) > 0
        or position('650' in service_ids_text) > 0
        or position('135' in service_ids_text) > 0)
      and contract_code is not null
)
, cntr as (
    select billing_client_id,
           contract_code as corp_contract_id,
           contract_id as billing_contract_id,
           currency_code,
           active_flg as billing_contract_active_flg,
           cancelled_flg as billing_contract_cancelled_flg,
           offer_flg,
           offer_accepted_flg,
           payment_term_dur, payment_type,
           quasi_postpayment_type, quasi_threshold_ccy_value,
           service_ids_text,
           signed_flg as billing_contract_signed_flg,
           suspended_flg as billing_contract_suspended_flg,
           utc_contract_finish_dttm, utc_contract_start_dttm,
           utc_created_dttm as utc_contract_created_dttm,
           utc_updated_dttm as utc_contract_updated_dttm,
           edo_offer_accepted_flg,
           activate_flg,
           auto_activate_flg,
           contract_limit_ccy_value,
           contract_limit_threshold_ccy_value,
           low_balance_notification_flg,
           low_balance_threshold_ccy_value
    from cntr0
    where rn = 1
)
, clnt0 as (
    select *,
           row_number() over (partition by billing_client_id
               order by utc_created_dttm desc) as rn
    from taxi_ods_dbcorp.corp_client
)
, clnt as (
    select corp_client_id,
           billing_client_id,
           corp_client_name,
           service_active_flg_dict, service_test_flg_dict, service_visible_flg_dict, next_day_delivery_flg,
           trial_flg,
           utc_created_dttm as utc_client_created_dttm,
           utc_updated_dttm as utc_client_updated_dttm,
           country_code,
           yandex_login
    from clnt0
    where rn = 1
)
select corp_client_id,
       clnt.billing_client_id,
       corp_client_name,
       service_active_flg_dict, service_test_flg_dict, service_visible_flg_dict, next_day_delivery_flg,
       trial_flg,
       utc_client_created_dttm,
       utc_client_updated_dttm,
       country_code,
       yandex_login,
       (service_active_flg_dict ->> 'cargo')::bool as cargo_service_active_flg,
       (service_active_flg_dict ->> 'taxi')::bool as taxi_service_active_flg,
       corp_contract_id,
       billing_contract_id, currency_code,
       billing_contract_active_flg,
       billing_contract_cancelled_flg,
       offer_flg, offer_accepted_flg,
       payment_term_dur, payment_type,
       quasi_postpayment_type, quasi_threshold_ccy_value,
       service_ids_text,
       billing_contract_signed_flg,
       billing_contract_suspended_flg,
       utc_contract_finish_dttm, utc_contract_start_dttm,
       utc_contract_created_dttm, utc_contract_updated_dttm,
       edo_offer_accepted_flg,
       activate_flg,
       auto_activate_flg,
       contract_limit_ccy_value,
       contract_limit_threshold_ccy_value,
       low_balance_notification_flg,
       low_balance_threshold_ccy_value
from cntr
  left join clnt
    on cntr.billing_client_id = clnt.billing_client_id;

------------------------------------------------------------------------
-- drop table if exists snb_b2b.dbcorp_contract_info;
-- create table snb_b2b.dbcorp_contract_info as
truncate table snb_b2b.dbcorp_contract_info;
insert into snb_b2b.dbcorp_contract_info
    (corp_client_id, billing_client_id, corp_client_name,
       service_active_flg_dict, service_test_flg_dict, service_visible_flg_dict, next_day_delivery_flg, trial_flg,
       utc_client_created_dttm, utc_client_updated_dttm, country_code, yandex_login,
       cargo_service_active_flg, taxi_service_active_flg,
       corp_contract_id, billing_contract_id, currency_code, billing_contract_active_flg, billing_contract_cancelled_flg,
       offer_flg, offer_accepted_flg, payment_term_dur, payment_type, quasi_postpayment_type, quasi_threshold_ccy_value,
       service_ids_text, billing_contract_signed_flg, billing_contract_suspended_flg,
       utc_contract_finish_dttm, utc_contract_start_dttm, utc_contract_created_dttm, utc_contract_updated_dttm,
       edo_offer_accepted_flg,
       activate_flg, auto_activate_flg,
       contract_limit_ccy_value, contract_limit_threshold_ccy_value, low_balance_notification_flg, low_balance_threshold_ccy_value)
select corp_client_id, billing_client_id, corp_client_name,
       service_active_flg_dict, service_test_flg_dict, service_visible_flg_dict, next_day_delivery_flg, trial_flg,
       utc_client_created_dttm, utc_client_updated_dttm, country_code, yandex_login,
       cargo_service_active_flg, taxi_service_active_flg,
       corp_contract_id, billing_contract_id, currency_code, billing_contract_active_flg, billing_contract_cancelled_flg,
       offer_flg, offer_accepted_flg, payment_term_dur, payment_type, quasi_postpayment_type, quasi_threshold_ccy_value,
       service_ids_text, billing_contract_signed_flg, billing_contract_suspended_flg,
       utc_contract_finish_dttm, utc_contract_start_dttm, utc_contract_created_dttm, utc_contract_updated_dttm,
       edo_offer_accepted_flg,
       activate_flg, auto_activate_flg,
       contract_limit_ccy_value, contract_limit_threshold_ccy_value, low_balance_notification_flg, low_balance_threshold_ccy_value
from temp_dbcorp_contract_info
-- distributed by (corp_contract_id)
;

update snb_b2b.dbcorp_contract_info
set _etl_processed_dttm = clock_timestamp() at time zone 'UTC'
where true;

-- alter table snb_b2b.dbcorp_contract_info add constraint dbcorp_contract_info_pk primary key (corp_contract_id);
-- comment on table snb_b2b.dbcorp_contract_info is 'Атрибуты контракта в админке Список клиентов. Ключ - corp_contract_id';
---- endof corp_contract_id datamart ----

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('dbcorp_client_contract_info', 'Finish', clock_timestamp());
