with src as (
    select (current_timestamp at time zone 'Europe/Moscow')::date as today_dt
)
, res as (
    select (max(_etl_processed_dttm) at time zone 'UTC' at time zone 'Europe/Moscow')::date as _etl_processed_dt
    from snb_b2b.dbcorp_contract_info
)
select case when src.today_dt > res._etl_processed_dt
                 or res._etl_processed_dt is null
            then 1::int else 0::int end as flg
from src cross join res;
