drop table if exists snb_b2b.niksm_b2b_corp_service_dict;
create table snb_b2b.niksm_b2b_corp_service_dict (
    service_id int,
    service_name text,
    service_id_comment text,
    constraint niksm_b2b_corp_services_pk primary key (service_id, service_name)
);
--
-- truncate table snb_b2b.niksm_b2b_corp_services_dict;
insert into snb_b2b.niksm_b2b_corp_service_dict (service_id, service_name, service_id_comment) values
        (135, 'taxi', 'OLD_TAXI'),
        (650, 'taxi', 'TAXI'),
        (650, 'cargo', 'TAXI'),
        (672, 'drive', 'DRIVE'),
        (668, 'eats2', 'EATS2'),
        (718, 'cargo', 'CARGO');

------------------------------------------------------------------------------------------------------------------------

drop table if exists snb_b2b.niksm_b2b_legal_contract_dict;
create table snb_b2b.niksm_b2b_legal_contract_dict (
    service_id int,
    legal_contract_taxi int,
    legal_contract_cargo int,
    constraint niksm_b2b_legal_contract_dict_pk primary key (service_id)
);
--
-- truncate table snb_b2b.niksm_b2b_legal_contract_dict;
insert into snb_b2b.niksm_b2b_legal_contract_dict (service_id, legal_contract_taxi, legal_contract_cargo) values
        (135, 1, 0),
        (650, 1, 0),
        (718, 0, 1);

------------------------------------------------------------------------------------------------------------------------
-- CORP_CONTRACTS --
drop table if exists snb_b2b.niksm_b2b_corp_contracts_hist;
create table snb_b2b.niksm_b2b_corp_contracts_hist
(
	id bigint not null,
	billing_client_id text,
	contract_external_id text,
	payment_type text,
	is_active bigint,
	is_offer bigint,
	offer_accepted double precision,
	service_ids json,
	currency text,
	balance json,
	settings json,
	created double precision,
	updated double precision,
	snapshot_date date not null,
	constraint niksm_b2b_corp_contracts_hist_pk
		primary key (snapshot_date, id)
)
distributed by (id)
PARTITION BY RANGE (snapshot_date)
    (
        START ('2020-01-01T00:00:00'::timestamp)
        END ('2025-01-01T00:00:00'::timestamp)
        EVERY ('1 month'::INTERVAL)
    );
comment on table snb_b2b.niksm_b2b_corp_contracts_hist is 'Историческая таблица corp_contracts. Источник - snb_b2b.bmiklaz_corp_contracts';
comment on column snb_b2b.niksm_b2b_corp_contracts_hist.snapshot_date is 'Дата записи';

------------------------------------------------------------------------------------------------------------------------
-- CORP_CLIENTS --
drop table if exists snb_b2b.niksm_b2b_corp_clients_hist;
create table snb_b2b.niksm_b2b_corp_clients_hist
(
	id text not null,
	contract_id text,
	yandex_id text,
	yandex_login text,
	email text,
	name text,
	billing_name text,
	billing_id text,
	is_active double precision,
	features json,
	created double precision,
	cabinet_only_role_id text,
	cost_centers json,
	contract_status text,
	payment json,
	manager_id text,
	country text,
	comment text,
	updated double precision,
	email_id text,
	yandex_login_id text,
	services json,
	is_trial double precision,
	description text,
	snapshot_date date not null,
	constraint niksm_b2b_corp_clients_hist_pk
		primary key (snapshot_date, id)
)
distributed by (id)
PARTITION BY RANGE (snapshot_date)
    (
        START ('2020-01-01T00:00:00'::timestamp)
        END ('2025-01-01T00:00:00'::timestamp)
        EVERY ('1 month'::INTERVAL)
    );
comment on table snb_b2b.niksm_b2b_corp_clients_hist is 'Историческая таблица corp_clients. Источник - snb_b2b.bmiklaz_corp_clients';
comment on column snb_b2b.niksm_b2b_corp_clients_hist.snapshot_date is 'Дата записи';

------------------------------------------------------------------------------------------------------------------------
-- CLIENT_SERVICE_INFO --
drop table if exists snb_b2b.niksm_b2b_lk_client_service_info_hist;
create table snb_b2b.niksm_b2b_lk_client_service_info_hist
(
	billing_contract_id bigint,
	contract_external_id text,
	billing_contract_payment_type text,
	billing_contract_is_active bigint,
	billing_contract_is_offer bigint,
	billing_contract_offer_accepted double precision,
	billing_contract_service_ids text,
	billing_contract_currency text,
	lk_contract_is_active integer,
	lk_contract_is_auto_activate integer,
	lk_contract_low_balance_notification_enabled integer,
	lk_contract_low_balance_threshold double precision,
	lk_contract_prepaid_deactivate_threshold double precision,
	lk_contract_prepaid_deactivate_threshold_type text,
	lk_contract_limit double precision,
	lk_contract_limit_threshold double precision,
	lk_service_name text not null,
	lk_service_is_active integer,
	lk_service_is_visible integer,
	lk_service_is_test integer,
	lk_service_deactivate_threshold_ride integer,
	lk_service_deactivate_threshold_moscow_dt date,
	lk_service_next_day_delivery integer,
	billing_client_id text,
	lk_client_id text not null,
	yandex_id text,
	yandex_login text,
	lk_client_email text,
	lk_client_name text,
	billing_client_name text,
	billing_client_manager_id text,
	lk_client_country text,
	lk_created_moscow_dt date,
	snapshot_date date not null,
	constraint niksm_b2b_lk_client_service_info_hist_pk
		primary key (snapshot_date, lk_client_id, lk_service_name)
)
distributed by (lk_client_id, lk_service_name)
PARTITION BY RANGE (snapshot_date)
    (
        START ('2020-01-01T00:00:00'::timestamp)
        END ('2025-01-01T00:00:00'::timestamp)
        EVERY ('1 month'::INTERVAL)
    );
comment on table snb_b2b.niksm_b2b_lk_client_service_info_hist is 'Историческая таблица lk_client_service_info. Источник - snb_b2b.niksm_b2b_lk_client_service_info';
comment on column snb_b2b.niksm_b2b_lk_client_service_info_hist.snapshot_date is 'Дата записи';


------------------------------------------------------------------------------------------------------------------------
-- DEALS_INFO --
drop table if exists snb_b2b.niksm_b2b_deals_info_hist;
create table snb_b2b.niksm_b2b_deals_info_hist
(
	which_crm integer not null,
	deal_id integer not null,
	org_id integer,
	org_name text,
	pipeline_id integer,
	pipeline_name text,
	stage_id integer,
	stage_name text,
	potential integer,
	status varchar(128),
	lost_reason text,
	add_date date,
	add_time timestamp,
	contract_id text,
	channel text,
	integration_status text,
	main_deal_link text,
	tags_key text,
	tags text,
	org_add_date date,
	org_add_time timestamp,
	company_id integer,
	owner_id integer,
	org_active_flag boolean,
	country text,
	market_segment text,
	tier text,
	holding_id integer,
	holding_name text,
	marketing_status text,
	website text,
	manager_login text,
	manager_name text,
	manager_name_first varchar(128),
	manager_name_last varchar(128),
	lead_name text,
	lead_name_first varchar(128),
	lead_name_last varchar(128),
	department_name varchar(128),
	permissions text,
	record_date date,
	manager_group text,
	client_id text,
	client_name text,
	wishlist_key text,
	wishlist text,
	inn text,
	product_key text,
	product text,
	yado_client_id text,
	yado_store_id text,
	city text,
	geography_key text,
	geography text,
	integration_module text,
	deal_title text,
	snapshot_date date,
	constraint niksm_b2b_deals_info_hist_pk
		primary key (snapshot_date, which_crm, deal_id)
)
distributed by (which_crm, deal_id)
PARTITION BY RANGE (snapshot_date)
    (
        START ('2020-01-01T00:00:00'::timestamp)
        END ('2025-01-01T00:00:00'::timestamp)
        EVERY ('1 month'::INTERVAL)
    );
comment on table snb_b2b.niksm_b2b_deals_info_hist is 'Историческая таблица niksm_b2b_deals_info. Источник - snb_b2b.niksm_b2b_deals_info';
comment on column snb_b2b.niksm_b2b_deals_info_hist.snapshot_date is 'Дата записи';
