-- drop table if exists snb_b2b.niksm_b2b_balance_contract_ext_info;
-- create table snb_b2b.niksm_b2b_balance_contract_ext_info as
truncate table snb_b2b.niksm_b2b_balance_contract_ext_info;
insert into snb_b2b.niksm_b2b_balance_contract_ext_info
    (billing_contract_id,
     contract_external_id, manager_code, manager, country, region, contract_type, payment_type,
     start_dt, finish_dt, signed_dt, faxed_dt, cancelled_dt, suspended_dt, is_deactivated, is_booked, booked_dt,
     client_id, client, person_id, person_name, person_inn, person_kpp, person_kz_bin, person_email, person_phone,
     invoice_id, invoice, act_sum, min_payment_date, currency, payment_term, invoice_payments_sum,
     min_payment_date_v2, no_acts, contract_services,
     debt00, debt130, debt3060, debt6090, debtover90, debt_sum, bad_debt, our_fault, overdue_debt, clean_debt, overdue_clean_debt,
     services_debt, service_ids, legal_contract_taxi, legal_contract_cargo, is_active)
--
with blnc_raw as (
    select *,
           row_number() over (partition by contract_external_id order by is_active desc, start_dt desc nulls last) as rn
    from snb_b2b.niksm_b2b_balance_contract_info as blnc
    where contract_external_id is not null
)
select billing_contract_id,
     contract_external_id, manager_code, manager, country, region, contract_type, payment_type,
     start_dt, finish_dt, signed_dt, faxed_dt, cancelled_dt, suspended_dt, is_deactivated, is_booked, booked_dt,
     client_id, client, person_id, person_name, person_inn, person_kpp, person_kz_bin, person_email, person_phone,
     invoice_id, invoice, act_sum, min_payment_date, currency, payment_term, invoice_payments_sum,
     min_payment_date_v2, no_acts, contract_services,
     debt00, debt130, debt3060, debt6090, debtover90, debt_sum, bad_debt, our_fault, overdue_debt, clean_debt, overdue_clean_debt,
     services_debt, service_ids, legal_contract_taxi, legal_contract_cargo, is_active
from blnc_raw
where rn = 1
-- DISTRIBUTED BY (contract_external_id)
;
-- alter table snb_b2b.niksm_b2b_balance_contract_ext_info add constraint niksm_b2b_balance_contract_ext_info_pk primary key (contract_external_id);   --!
-- comment on table snb_b2b.niksm_b2b_balance_contract_ext_info is 'Балансовые показатели. Ключ - contract_external_id';
-- grant all on snb_b2b.niksm_b2b_balance_contract_ext_info to "robot-sam-bridges", "robot-corploader";

----------------------------------------------------------------------------------------------------------------------
-- create or replace view snb_taxi.niksm_b2b_balance_contract_ext_info as
-- select * from snb_b2b.niksm_b2b_balance_contract_ext_info;
-- --
-- comment on view snb_taxi.niksm_b2b_balance_contract_ext_info is 'Копия snb_b2b. Балансовые показатели. Ключ - contract_external_id';
-- grant select on snb_taxi.niksm_b2b_balance_contract_ext_info to rw_snb_b2b, niksm, tsapenko;
