drop table if exists niksm_temp_b2b_balance_contract_info_res;
create temporary table niksm_temp_b2b_balance_contract_info_res as
with blnc_raw as (
    select contract_id::int               as billing_contract_id,
           max(contract)                  as contract_external_id,
           max(manager_code::int)         as manager_code,
           max(manager)                   as manager,
           max(country)                   as country,
           max(region)                    as region,
           max(contract_type)             as contract_type,
           max(payment_type)              as payment_type,
           max(start_dt::date)            as start_dt,
           max(finish_dt::date)           as finish_dt,
           max(signed_dt::date)           as signed_dt,
           max(faxed_dt::date)            as faxed_dt,
           max(cancelled_dt::date)        as cancelled_dt,
           max(suspended_dt::date)        as suspended_dt,
           max(is_deactivated)            as is_deactivated,
           max(is_booked)                 as is_booked,
           max(booked_dt::date)           as booked_dt,
           max(client_id::int)            as client_id,
           max(client)                    as client,
           max(person_id::int)            as person_id,
           max(person_name)               as person_name,
           max(person_inn)                as person_inn,
           max(person_kpp)                as person_kpp,
           max(person_kz_bin)             as person_kz_bin,
           max(person_email)              as person_email,
           max(person_phone)              as person_phone,
           max((invoice_id::float)::int)           as invoice_id,
           max(invoice)                   as invoice,
           max(act_sum)                   as act_sum,
           max(min_payment_date::date)    as min_payment_date,
           max(currency)                  as currency,
           max((payment_term::float)::int)         as payment_term,
           max(invoice_payments_sum)      as invoice_payments_sum,
           max(min_payment_date_v2::date) as min_payment_date_v2,
           max(no_acts::int)              as no_acts,
           max(contract_services)         as contract_services,
           --
           sum(debt00)                    as debt00,
           sum(debt130)                   as debt130,
           sum(debt3060)                  as debt3060,
           sum(debt6090)                  as debt6090,
           sum(debtover90)                as debtover90,
           sum(debt_sum)                  as debt_sum,
           sum(bad_debt)                  as bad_debt,
           sum(our_fault)                 as our_fault,
           sum(overdue_debt)              as overdue_debt,
           sum(clean_debt)                as clean_debt,
           sum(overdue_clean_debt)        as overdue_clean_debt,
           --
           case when count(debt_service_id) = 0
               then '{}'::json
               else json_object_agg(
                       coalesce(debt_service_id::text, ''), json_build_object(
                               'debt_service_name', debt_service,
                               'debt00', debt00,
                               'debt130', debt130,
                               'debt3060', debt3060,
                               'debt6090', debt6090,
                               'debtover90', debtover90,
                               'debt_sum', debt_sum,
                               'bad_debt', bad_debt,
                               'our_fault', our_fault,
                               'overdue_debt', overdue_debt,
                               'clean_debt', clean_debt,
                               'overdue_clean_debt', overdue_clean_debt))
               end as services_debt
    from snb_b2b.voytekh_corporate_contracts_and_debts
    group by contract_id::int
)

select blnc_raw.*,
       service_ids,
       legal_contract_taxi,
       legal_contract_cargo,
       case when start_dt <= current_date
               and (faxed_dt is not null or signed_dt is not null)
               and coalesce(finish_dt, '2099-12-31')::date >= current_date
               and coalesce(cancelled_dt, '2099-12-31')::date >= current_date
               and coalesce(suspended_dt, '2099-12-31')::date >= current_date
            then 1 else 0 end as is_active
from blnc_raw,
     lateral(
         select json_agg(qq.service_id) as service_ids,
             max(coalesce(lgl.legal_contract_taxi, 0)) as legal_contract_taxi,
             max(coalesce(lgl.legal_contract_cargo, 0)) as legal_contract_cargo
         from (
                select substring(serv_txt from '^.* \((\d+)\)$')::int as service_id
                from ( select unnest(string_to_array(contract_services, '; ')) as serv_txt ) q
              ) qq
           left join snb_b2b.niksm_b2b_legal_contract_dict as lgl
             on lgl.service_id = qq.service_id
         ) qqq;


-- drop table if exists snb_b2b.niksm_b2b_balance_contract_info;
-- create table snb_b2b.niksm_b2b_balance_contract_info as
truncate table snb_b2b.niksm_b2b_balance_contract_info;
insert into snb_b2b.niksm_b2b_balance_contract_info
    (billing_contract_id,
     contract_external_id, manager_code, manager, country, region, contract_type, payment_type,
     start_dt, finish_dt, signed_dt, faxed_dt, cancelled_dt, suspended_dt, is_deactivated, is_booked, booked_dt,
     client_id, client, person_id, person_name, person_inn, person_kpp, person_kz_bin, person_email, person_phone,
     invoice_id, invoice, act_sum, min_payment_date, currency, payment_term, invoice_payments_sum,
     min_payment_date_v2, no_acts, contract_services,
     debt00, debt130, debt3060, debt6090, debtover90, debt_sum, bad_debt, our_fault, overdue_debt, clean_debt, overdue_clean_debt,
     services_debt, service_ids, legal_contract_taxi, legal_contract_cargo, is_active)
select billing_contract_id,
       contract_external_id, manager_code, manager, country, region, contract_type, payment_type,
       start_dt, finish_dt, signed_dt, faxed_dt, cancelled_dt, suspended_dt, is_deactivated, is_booked, booked_dt,
       client_id, client, person_id, person_name, person_inn, person_kpp, person_kz_bin, person_email, person_phone,
       invoice_id, invoice, act_sum, min_payment_date, currency, payment_term, invoice_payments_sum,
       min_payment_date_v2, no_acts, contract_services,
       debt00, debt130, debt3060, debt6090, debtover90, debt_sum, bad_debt, our_fault, overdue_debt, clean_debt, overdue_clean_debt,
       services_debt, service_ids, legal_contract_taxi, legal_contract_cargo, is_active
from niksm_temp_b2b_balance_contract_info_res
-- DISTRIBUTED BY (billing_contract_id)
;

-- alter table snb_b2b.niksm_b2b_balance_contract_info add constraint niksm_b2b_balance_info_pk primary key (billing_contract_id);   --!
-- comment on table snb_b2b.niksm_b2b_balance_contract_info is 'Балансовые показатели. Ключ - billing_contract_id';
-- grant all on snb_b2b.niksm_b2b_balance_contract_info to "robot-sam-bridges", "robot-corploader";

------------------------------------------------------------------------------------------------------------------------
-- create or replace view snb_taxi.niksm_b2b_balance_contract_info as
-- select * from snb_b2b.niksm_b2b_balance_contract_info;
-- --
-- grant select on snb_taxi.niksm_b2b_balance_contract_info to niksm, ikhomyanin, griganton, "robot-corploader", voytekh, ankozik, tsapenko, "robot-tableau-588", "robot-sam-bridges";
-- comment on view snb_taxi.niksm_b2b_balance_contract_info is 'Копия snb_b2b. Балансовые показатели. Ключ - billing_contract_id';
