drop table if exists temp_niksm_b2b_lk_client_service_info;
create temporary table temp_niksm_b2b_lk_client_service_info as
select billing_contract_id::bigint as billing_contract_id,
       corp_contract_id::text as contract_external_id,
       payment_type::text as billing_contract_payment_type,
       billing_contract_active_flg::int as billing_contract_is_active,
       offer_flg::int as billing_contract_is_offer,
       offer_accepted_flg::int as billing_contract_offer_accepted,
       service_ids_text_agg as billing_contract_service_ids,
       currency_code::text as billing_contract_currency,
       activate_flg::int as lk_contract_is_active,
       auto_activate_flg::int as lk_contract_is_auto_activate,
       low_balance_notification_flg::int as lk_contract_low_balance_notification_enabled,
       low_balance_threshold_ccy_value::double precision as lk_contract_low_balance_threshold,
       quasi_threshold_ccy_value::double precision as lk_contract_prepaid_deactivate_threshold,
       quasi_postpayment_type::text as lk_contract_prepaid_deactivate_threshold_type,
       contract_limit_ccy_value::double precision as lk_contract_limit,
       contract_limit_threshold_ccy_value::double precision as lk_contract_limit_threshold,
       service_name as lk_service_name,
       ((service_active_flg_dict->>service_name)::bool)::int as lk_service_is_active,
       ((service_visible_flg_dict->>service_name)::bool)::int as lk_service_is_visible,
       ((service_test_flg_dict->>service_name)::bool)::int as lk_service_is_test,
       NULL::int as lk_service_deactivate_threshold_ride,
       NULL::date as lk_service_deactivate_threshold_moscow_dt,
       next_day_delivery_flg::int as lk_service_next_day_delivery,
       billing_client_id,
       corp_client_id as lk_client_id,
       NULL::text as yandex_id,
       yandex_login,
       NULL::text as lk_client_email,
       corp_client_name as lk_client_name,
       NULL::text as billing_client_name,
       NULL::text as billing_client_manager_id,
       country_code as lk_client_country,
       (utc_client_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as lk_created_moscow_dt
from snb_b2b.dbcorp_client_info,
     lateral (
         select json_agg(service_id)::text as service_ids_text_agg
         from (
             select unnest(
                string_to_array(service_ids_text,','))::int as service_id
             ) ids_agg0
         ) ids_agg,
     lateral (
         select distinct service_name
         from (
             select unnest(string_to_array(service_ids_text,','))::int as service_id) srv_name0
               join snb_b2b.niksm_b2b_corp_service_dict dict
                 on srv_name0.service_id = dict.service_id
         ) srv_name
where billing_contract_id is not null;


-- drop table if exists snb_b2b.niksm_b2b_lk_client_service_info;
-- create table snb_b2b.niksm_b2b_lk_client_service_info as
truncate table snb_b2b.niksm_b2b_lk_client_service_info;
insert into snb_b2b.niksm_b2b_lk_client_service_info
    (billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
     lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
     lk_service_name, lk_service_is_active, lk_service_is_visible, lk_service_is_test, lk_service_deactivate_threshold_ride, lk_service_deactivate_threshold_moscow_dt, lk_service_next_day_delivery,
     billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt)
--
---- ver 1 begin ----
-- with raw as (
--     select *,
--            row_number() over (partition by lk_client_id, lk_service_name
--                order by billing_contract_is_active desc nulls last, lk_service_is_active desc nulls last) as rn
--     from snb_b2b.niksm_b2b_lk_contract_service_info as cntr
-- )
-- select billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
--      lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
--      lk_service_name, lk_service_is_active, lk_service_is_visible, lk_service_is_test, lk_service_deactivate_threshold_ride, lk_service_deactivate_threshold_moscow_dt, lk_service_next_day_delivery,
--      billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt
-- from raw
-- where rn = 1
---- ver 1 end ----

---- ver 2 begin ----
select billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
     lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
     lk_service_name, lk_service_is_active, lk_service_is_visible, lk_service_is_test, lk_service_deactivate_threshold_ride, lk_service_deactivate_threshold_moscow_dt, lk_service_next_day_delivery,
     billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt
from temp_niksm_b2b_lk_client_service_info
---- ver 2 end ----

-- DISTRIBUTED BY (lk_client_id, lk_service_name)   --!
;
-- alter table snb_b2b.niksm_b2b_lk_client_service_info add constraint niksm_b2b_lk_client_service_info_pk primary key (lk_client_id, lk_service_name);   --!
-- comment on table snb_b2b.niksm_b2b_lk_client_service_info is 'Атрибуты пары: [Клиент - сервис] в админке (корп. кабинет)';
-- grant all on snb_b2b.niksm_b2b_lk_client_service_info to "robot-sam-bridges", "robot-corploader";

------------------------------------------------------------------------------------------------------------------------
-- create or replace view snb_taxi.niksm_b2b_lk_client_service_info as
-- select * from snb_b2b.niksm_b2b_lk_client_service_info;
-- --
-- grant select on snb_taxi.niksm_b2b_lk_client_service_info to niksm, ikhomyanin, griganton, "robot-corploader", voytekh, ankozik, tsapenko, "robot-tableau-588", "robot-sam-bridges";
-- comment on view snb_taxi.niksm_b2b_lk_client_service_info is 'Копия snb_b2b. Атрибуты пары: [Клиент - сервис] в админке (корп. кабинет)';
