drop table if exists temp_niksm_b2b_lk_contract_info;
create temporary table temp_niksm_b2b_lk_contract_info as
select billing_contract_id::bigint as billing_contract_id,
       corp_contract_id::text as contract_external_id,
       payment_type::text as billing_contract_payment_type,
       billing_contract_active_flg::int as billing_contract_is_active,
       offer_flg::int as billing_contract_is_offer,
       offer_accepted_flg::int as billing_contract_offer_accepted,
       service_ids_text_agg as billing_contract_service_ids,
       currency_code::text as billing_contract_currency,
       activate_flg::int as lk_contract_is_active,
       auto_activate_flg::int as lk_contract_is_auto_activate,
       low_balance_notification_flg::int as lk_contract_low_balance_notification_enabled,
       low_balance_threshold_ccy_value::double precision as lk_contract_low_balance_threshold,
       quasi_threshold_ccy_value::double precision as lk_contract_prepaid_deactivate_threshold,
       quasi_postpayment_type::text as lk_contract_prepaid_deactivate_threshold_type,
       contract_limit_ccy_value::double precision as lk_contract_limit,
       contract_limit_threshold_ccy_value::double precision as lk_contract_limit_threshold,
       ----
       ((service_active_flg_dict->>'cargo')::bool)::int as lk_cargo_is_active,
       ((service_visible_flg_dict->>'cargo')::bool)::int as lk_cargo_is_visible,
       ((service_test_flg_dict->>'cargo')::bool)::int as lk_cargo_is_test,
       NULL::int as lk_cargo_deactivate_threshold_ride,
       NULL::date as lk_cargo_deactivate_threshold_moscow_dt,
       next_day_delivery_flg::int as lk_cargo_next_day_delivery,
       --
       ((service_active_flg_dict->>'taxi')::bool)::int as lk_taxi_is_active,
       ((service_visible_flg_dict->>'taxi')::bool)::int as lk_taxi_is_visible,
       ((service_test_flg_dict->>'taxi')::bool)::int as lk_taxi_is_test,
       NULL::int as lk_taxi_deactivate_threshold_ride,
       NULL::date as lk_taxi_deactivate_threshold_moscow_dt,
       ----
       billing_client_id,
       corp_client_id as lk_client_id,
       NULL::text as yandex_id,
       yandex_login,
       NULL::text as lk_client_email,
       corp_client_name as lk_client_name,
       NULL::text as billing_client_name,
       NULL::text as billing_client_manager_id,
       country_code as lk_client_country,
       (utc_client_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as lk_created_moscow_dt
from snb_b2b.dbcorp_contract_info,
     lateral (
         select json_agg(service_id)::text as service_ids_text_agg
         from (
             select unnest(
                string_to_array(service_ids_text,','))::int as service_id
             ) ids_agg0
         ) ids_agg
where billing_contract_id is not null;



-- drop table if exists snb_b2b.niksm_b2b_lk_contract_info;
-- create table snb_b2b.niksm_b2b_lk_contract_info as
truncate table snb_b2b.niksm_b2b_lk_contract_info;
insert into snb_b2b.niksm_b2b_lk_contract_info
    (billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
     lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
     lk_cargo_is_active, lk_cargo_is_visible, lk_cargo_is_test, lk_cargo_deactivate_threshold_ride, lk_cargo_deactivate_threshold_moscow_dt, lk_cargo_next_day_delivery,
     lk_taxi_is_active, lk_taxi_is_visible, lk_taxi_is_test, lk_taxi_deactivate_threshold_ride, lk_taxi_deactivate_threshold_moscow_dt,
     billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt)
--
---- ver 1 begin ----
-- with cntr as (
--     select billing_contract_id,
--            max(contract_external_id)                          as contract_external_id,
--            max(billing_contract_payment_type)                 as billing_contract_payment_type,
--            max(billing_contract_is_active)                    as billing_contract_is_active,
--            max(billing_contract_is_offer)                     as billing_contract_is_offer,
--            max(billing_contract_offer_accepted)               as billing_contract_offer_accepted,
--            max(billing_contract_service_ids)                  as billing_contract_service_ids,
--            max(billing_contract_currency)                     as billing_contract_currency,
--            --
--            max(lk_contract_is_active)                         as lk_contract_is_active,
--            max(lk_contract_is_auto_activate)                  as lk_contract_is_auto_activate,
--            max(lk_contract_low_balance_notification_enabled)  as lk_contract_low_balance_notification_enabled,
--            max(lk_contract_low_balance_threshold)             as lk_contract_low_balance_threshold,
--            max(lk_contract_prepaid_deactivate_threshold)      as lk_contract_prepaid_deactivate_threshold,
--            max(lk_contract_prepaid_deactivate_threshold_type) as lk_contract_prepaid_deactivate_threshold_type,
--            max(lk_contract_limit)                             as lk_contract_limit,
--            max(lk_contract_limit_threshold)                   as lk_contract_limit_threshold,
--            --
--            max(case when lk_service_name = 'cargo' then lk_service_is_active end) as         lk_cargo_is_active,
--            max(case when lk_service_name = 'cargo' then lk_service_is_visible end) as        lk_cargo_is_visible,
--            max(case when lk_service_name = 'cargo' then lk_service_is_test end) as           lk_cargo_is_test,
--            max(case when lk_service_name = 'cargo'
--                        then lk_service_deactivate_threshold_ride end) as                     lk_cargo_deactivate_threshold_ride,
--            max(case when lk_service_name = 'cargo'
--                        then lk_service_deactivate_threshold_moscow_dt end) as                lk_cargo_deactivate_threshold_moscow_dt,
--            max(case when lk_service_name = 'cargo' then lk_service_next_day_delivery end) as lk_cargo_next_day_delivery,
--            --
--            max(case when lk_service_name = 'taxi' then lk_service_is_active end) as          lk_taxi_is_active,
--            max(case when lk_service_name = 'taxi' then lk_service_is_visible end) as         lk_taxi_is_visible,
--            max(case when lk_service_name = 'taxi' then lk_service_is_test end) as            lk_taxi_is_test,
--            max(case when lk_service_name = 'taxi'
--                        then lk_service_deactivate_threshold_ride end) as                     lk_taxi_deactivate_threshold_ride,
--            max(case when lk_service_name = 'taxi'
--                        then lk_service_deactivate_threshold_moscow_dt end) as                lk_taxi_deactivate_threshold_moscow_dt,
--            --
--            max(billing_client_id)                             as billing_client_id,
--            max(lk_client_id)                                  as lk_client_id,
--            max(yandex_id)                                     as yandex_id,
--            max(yandex_login)                                  as yandex_login,
--            max(lk_client_email)                               as lk_client_email,
--            max(lk_client_name)                                as lk_client_name,
--            max(billing_client_name)                           as billing_client_name,
--            max(billing_client_manager_id)                     as billing_client_manager_id,
--            max(lk_client_country)                             as lk_client_country,
--            max(lk_created_moscow_dt)                          as lk_created_moscow_dt,
--            --
--            row_number() over (partition by max(contract_external_id) order by max(billing_contract_is_active) desc) as rn
--     from snb_b2b.niksm_b2b_lk_contract_service_info
--     where contract_external_id is not null
--     group by billing_contract_id
-- )
-- select billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
--      lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
--      lk_cargo_is_active, lk_cargo_is_visible, lk_cargo_is_test, lk_cargo_deactivate_threshold_ride, lk_cargo_deactivate_threshold_moscow_dt, lk_cargo_next_day_delivery,
--      lk_taxi_is_active, lk_taxi_is_visible, lk_taxi_is_test, lk_taxi_deactivate_threshold_ride, lk_taxi_deactivate_threshold_moscow_dt,
--      billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt
-- from cntr
-- where rn = 1
---- ver 1 end ----

---- ver 2 begin ----
select billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
     lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
     lk_cargo_is_active, lk_cargo_is_visible, lk_cargo_is_test, lk_cargo_deactivate_threshold_ride, lk_cargo_deactivate_threshold_moscow_dt, lk_cargo_next_day_delivery,
     lk_taxi_is_active, lk_taxi_is_visible, lk_taxi_is_test, lk_taxi_deactivate_threshold_ride, lk_taxi_deactivate_threshold_moscow_dt,
     billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt
from temp_niksm_b2b_lk_contract_info
---- ver 2 end ----

-- DISTRIBUTED BY (contract_external_id)
;
-- alter table snb_b2b.niksm_b2b_lk_contract_info add constraint niksm_b2b_lk_contract_info_pk primary key (contract_external_id);   --!
-- comment on table snb_b2b.niksm_b2b_lk_contract_info is 'Атрибуты контракта типа 12345/67 в админке (корп. кабинет). Ключ - contract_external_id';
-- grant all on snb_b2b.niksm_b2b_lk_contract_info to "robot-sam-bridges", "robot-corploader";
--
-- ------------------------------------------------------------------------------------------------------------------------
-- create or replace view snb_taxi.niksm_b2b_lk_contract_info as
-- select * from snb_b2b.niksm_b2b_lk_contract_info;
-- --
-- grant select on snb_taxi.niksm_b2b_lk_contract_info to niksm, ikhomyanin, griganton, "robot-corploader", voytekh, ankozik, tsapenko, "robot-tableau-588", "robot-sam-bridges";
-- comment on view snb_taxi.niksm_b2b_lk_contract_info is 'Копия snb_b2b. Атрибуты контракта типа 12345/67 в админке (корп. кабинет). Ключ - contract_external_id';
