-- drop table if exists niksm_temp_b2b_lk_contract_service_info_res;
-- create temporary table niksm_temp_b2b_lk_contract_service_info_res as
-- with cntr_raw0 as (
--     select cntr,
--            row_number() over (partition by id order by updated desc) as rn1
--     from snb_b2b.bmiklaz_corp_contracts as cntr
-- )
-- , cntr_raw as ( -- contract billing_id as a key
--     select (cntr).*
--     from cntr_raw0
--     where rn1 = 1
-- )
-- , cntr_serv as (
--     select id as billing_contract_id,   -- = lk_contract_id
--            billing_client_id,
--            contract_external_id,
--            payment_type as billing_payment_type,
--            is_active as billing_contract_is_active,
--            is_offer as billing_contract_is_offer,
--            offer_accepted as billing_contract_offer_accepted,
--            service_ids::text as billing_contract_service_ids,
--            currency as billing_contract_currency,
--            (settings ->> 'is_active')::int                                  as lk_contract_is_active,
--            (settings ->> 'is_auto_activate')::int                           as lk_contract_is_auto_activate,
--            (settings ->> 'low_balance_notification_enabled')::int           as lk_contract_low_balance_notification_enabled,
--            (settings ->> 'low_balance_threshold')::double precision         as lk_contract_low_balance_threshold,
--            (settings ->> 'prepaid_deactivate_threshold')::double precision  as lk_contract_prepaid_deactivate_threshold,
--            (settings ->> 'prepaid_deactivate_threshold_type')               as lk_contract_prepaid_deactivate_threshold_type,
--            (settings -> 'contract_limit' ->> 'limit')::double precision     as lk_contract_limit,
--            (settings -> 'contract_limit' ->> 'threshold')::double precision as lk_contract_limit_threshold,
--            json_array_elements_text(service_ids)::int as service_id
--     from cntr_raw
-- )
-- , clnt_raw0 as (
--     select cl,
--            row_number() over (partition by id order by updated desc) as rn2
--     from snb_b2b.bmiklaz_corp_clients as cl
-- )
-- , clnt_raw as (
--     select (cl).*,
--            (json_each((cl).services)).key as service_name,
--            (json_each((cl).services)).value as service_attr
--     from clnt_raw0
--     where rn2 = 1
-- )
-- select cntr_serv.billing_contract_id,
--        -- contract attr
--        max(contract_external_id) as contract_external_id,
--        max(billing_payment_type) as billing_contract_payment_type,
--        max(billing_contract_is_active) as billing_contract_is_active,
--        max(billing_contract_is_offer) as billing_contract_is_offer,
--        max(billing_contract_offer_accepted) as billing_contract_offer_accepted,
--        max(billing_contract_service_ids) as billing_contract_service_ids,
--        max(cntr_serv.billing_contract_currency) as billing_contract_currency,
--        max(cntr_serv.lk_contract_is_active) as lk_contract_is_active,
--        max(cntr_serv.lk_contract_is_auto_activate) as lk_contract_is_auto_activate,
--        max(cntr_serv.lk_contract_low_balance_notification_enabled) as lk_contract_low_balance_notification_enabled,
--        max(cntr_serv.lk_contract_low_balance_threshold) as lk_contract_low_balance_threshold,
--        max(cntr_serv.lk_contract_prepaid_deactivate_threshold) as lk_contract_prepaid_deactivate_threshold,
--        max(cntr_serv.lk_contract_prepaid_deactivate_threshold_type) as lk_contract_prepaid_deactivate_threshold_type,
--        max(cntr_serv.lk_contract_limit) as lk_contract_limit,
--        max(cntr_serv.lk_contract_limit_threshold) as lk_contract_limit_threshold,
--        ----
--        corp_serv.service_name as lk_service_name,
--        -- service attr
--        max((clnt_raw.service_attr ->> 'is_active')::int) as lk_service_is_active,
--        max((clnt_raw.service_attr ->> 'is_visible')::int) as lk_service_is_visible,
--        max((clnt_raw.service_attr ->> 'is_test')::int) as lk_service_is_test,
--        max((clnt_raw.service_attr ->> 'deactivate_threshold_ride')::int) as lk_service_deactivate_threshold_ride,
--        (to_timestamp(
--                 max((clnt_raw.service_attr ->> 'deactivate_threshold_date')::double precision)
--             ) at time zone 'Europe/Moscow')::date
--            as lk_service_deactivate_threshold_moscow_dt,
--        max((clnt_raw.service_attr ->> 'next_day_delivery')::int) as lk_service_next_day_delivery,
--        -- client attr
--        max(cntr_serv.billing_client_id) as billing_client_id,
--        max(clnt_raw.id) as lk_client_id,
--        max(clnt_raw.yandex_id) as yandex_id,
--        max(clnt_raw.yandex_login) as yandex_login,
--        max(clnt_raw.email) as lk_client_email,
--        max(clnt_raw.name) as lk_client_name,
--        max(clnt_raw.billing_name) as billing_client_name,
--        max(clnt_raw.manager_id) as billing_client_manager_id,
--        max(clnt_raw.country) as lk_client_country,
--        (to_timestamp(max(clnt_raw.created)) at time zone 'Europe/Moscow')::date as lk_created_moscow_dt
-- from cntr_serv
--   join snb_b2b.niksm_b2b_corp_service_dict as corp_serv
--     on corp_serv.service_id = cntr_serv.service_id
--   join clnt_raw
--     on clnt_raw.service_name = corp_serv.service_name
--     and clnt_raw.billing_id = cntr_serv.billing_client_id
-- group by cntr_serv.billing_contract_id,
--          corp_serv.service_name;


-- drop table if exists snb_b2b.niksm_b2b_lk_contract_service_info;
-- create table snb_b2b.niksm_b2b_lk_contract_service_info as                  -- !DISTRIBUTED BY
-- truncate table snb_b2b.niksm_b2b_lk_contract_service_info;
-- insert into snb_b2b.niksm_b2b_lk_contract_service_info
--     (billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
--      lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
--      lk_service_name, lk_service_is_active, lk_service_is_visible, lk_service_is_test, lk_service_deactivate_threshold_ride, lk_service_deactivate_threshold_moscow_dt, lk_service_next_day_delivery,
--      billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt)
-- --
-- select billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency,
--        lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold,
--        lk_service_name, lk_service_is_active, lk_service_is_visible, lk_service_is_test, lk_service_deactivate_threshold_ride, lk_service_deactivate_threshold_moscow_dt, lk_service_next_day_delivery,
--        billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt
-- from niksm_temp_b2b_lk_contract_service_info_res
-- DISTRIBUTED BY (billing_contract_id, lk_service_name)   --!
;

-- alter table snb_b2b.niksm_b2b_lk_contract_service_info add constraint niksm_b2b_contract_services_pk primary key (billing_contract_id, lk_service_name);   --!
-- comment on table snb_b2b.niksm_b2b_lk_contract_service_info is 'Атрибуты пары: [биллинговый номер контракта - сервис] в админке (корп. кабинет)';
-- grant all on snb_b2b.niksm_b2b_lk_contract_service_info to "robot-sam-bridges", "robot-corploader";

------------------------------------------------------------------------------------------------------------------------
-- create or replace view snb_taxi.niksm_b2b_lk_contract_service_info as
-- select * from snb_b2b.niksm_b2b_lk_contract_service_info;
-- --
-- grant select on snb_taxi.niksm_b2b_lk_contract_service_info to rw_snb_b2b, niksm, tsapenko;
-- comment on view snb_taxi.niksm_b2b_lk_contract_service_info is 'Копия snb_b2b. Атрибуты пары: [биллинговый номер контракта - сервис] в админке (корп. кабинет)';
