-- CORP_CONTRACTS --
delete from snb_b2b.niksm_b2b_corp_contracts_hist
where snapshot_date = current_date;
insert into snb_b2b.niksm_b2b_corp_contracts_hist
    (id, billing_client_id, contract_external_id, payment_type, is_active, is_offer, offer_accepted, service_ids, currency, balance, settings, created, updated, snapshot_date)
--
with cntr_raw0 as (
    select *,
           row_number() over (partition by id order by updated desc) as rn
    from snb_b2b.bmiklaz_corp_contracts as cntr
)
select id, billing_client_id, contract_external_id, payment_type, is_active, is_offer, offer_accepted, service_ids, currency, balance, settings, created, updated,
       current_date as snapshot_date
from cntr_raw0
where rn = 1;

-- CORP_CLIENTS --
delete from snb_b2b.niksm_b2b_corp_clients_hist
where snapshot_date = current_date;
insert into snb_b2b.niksm_b2b_corp_clients_hist
    (id, contract_id, yandex_id, yandex_login, email, name, billing_name, billing_id, is_active, features, created, cabinet_only_role_id, cost_centers, contract_status, payment, manager_id, country, comment, updated, email_id, yandex_login_id, services, is_trial, description, snapshot_date)
with cntr_raw0 as (
    select *,
           row_number() over (partition by id order by updated desc) as rn
    from snb_b2b.bmiklaz_corp_clients as cntr
)
select id, contract_id, yandex_id, yandex_login, email, name, billing_name, billing_id, null as is_active, features, created, cabinet_only_role_id, cost_centers, contract_status, payment, manager_id, country, comment, updated, email_id, yandex_login_id, services, is_trial, description,
       current_date as snapshot_date
from cntr_raw0
where rn = 1;

-- CLIENT_SERVICE_INFO --
delete from snb_b2b.niksm_b2b_lk_client_service_info_hist
where snapshot_date = current_date;
insert into snb_b2b.niksm_b2b_lk_client_service_info_hist
      (billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency, lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold, lk_service_name, lk_service_is_active, lk_service_is_visible, lk_service_is_test, lk_service_deactivate_threshold_ride, lk_service_deactivate_threshold_moscow_dt, lk_service_next_day_delivery, billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt,
       snapshot_date)
select billing_contract_id, contract_external_id, billing_contract_payment_type, billing_contract_is_active, billing_contract_is_offer, billing_contract_offer_accepted, billing_contract_service_ids, billing_contract_currency, lk_contract_is_active, lk_contract_is_auto_activate, lk_contract_low_balance_notification_enabled, lk_contract_low_balance_threshold, lk_contract_prepaid_deactivate_threshold, lk_contract_prepaid_deactivate_threshold_type, lk_contract_limit, lk_contract_limit_threshold, lk_service_name, lk_service_is_active, lk_service_is_visible, lk_service_is_test, lk_service_deactivate_threshold_ride, lk_service_deactivate_threshold_moscow_dt, lk_service_next_day_delivery, billing_client_id, lk_client_id, yandex_id, yandex_login, lk_client_email, lk_client_name, billing_client_name, billing_client_manager_id, lk_client_country, lk_created_moscow_dt,
       current_date as snapshot_date
from snb_b2b.niksm_b2b_lk_client_service_info
;

-- DEALS_INFO --
delete from snb_b2b.niksm_b2b_deals_info_hist
where snapshot_date = current_date;
insert into snb_b2b.niksm_b2b_deals_info_hist
      (which_crm, deal_id, org_id, org_name, pipeline_id, pipeline_name, stage_id, stage_name, potential, status, lost_reason, add_date, add_time, contract_id, channel, integration_status, main_deal_link, tags_key, tags, org_add_date, org_add_time, company_id, owner_id, org_active_flag, country, market_segment, tier, holding_id, holding_name, marketing_status, website, manager_login, manager_name, manager_name_first, manager_name_last, lead_name, lead_name_first, lead_name_last, department_name, permissions, record_date, manager_group, client_id, client_name, wishlist_key, wishlist, inn, product_key, product, yado_client_id, yado_store_id, city, geography_key, geography, integration_module, deal_title,
       snapshot_date)
select which_crm, deal_id, org_id, org_name, pipeline_id, pipeline_name, stage_id, stage_name, potential, status, lost_reason, add_date, add_time, contract_id, channel, integration_status, main_deal_link, tags_key, tags, org_add_date, org_add_time, company_id, owner_id, org_active_flag, country, market_segment, tier, holding_id, holding_name, marketing_status, website, manager_login, manager_name, manager_name_first, manager_name_last, lead_name, lead_name_first, lead_name_last, department_name, permissions, record_date, manager_group, client_id, client_name, wishlist_key, wishlist, inn, product_key, product, yado_client_id, yado_store_id, city, geography_key, geography, integration_module, deal_title,
       current_date as snapshot_date
from snb_b2b.niksm_b2b_deals_info;

-- grant all on snb_b2b.niksm_b2b_corp_contracts_hist to "robot-sam-bridges";
-- grant all on snb_b2b.niksm_b2b_corp_clients_hist to "robot-sam-bridges";
-- grant all on snb_b2b.niksm_b2b_lk_client_service_info_hist to "robot-sam-bridges";
-- grant all on snb_b2b.niksm_b2b_deals_info_hist to "robot-sam-bridges";
