#!/usr/bin/env python
# -*- coding: utf-8 -*-
import pandas as pd
import datetime
import re
import requests
pd.options.display.max_columns = 500
pd.options.display.max_colwidth = 10000
from yql.api.v1.client import YqlClient

from business_models import hahn, greenplum
import datetime
import time
import logging
import json
import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format='%(asctime)s %(levelname)s: %(message)s')
logging.info(str(datetime.datetime.now()) + ' Start ' + __file__)


key_file = 'keys.json'
with open(key_file) as f:
    from_file = json.load(f)
token = from_file['corploader_hahn']
#con = f"postgresql://robot-corploader:{from_file['gp_token']}@gpdb-pgbouncer.taxi.yandex.net:5432/ritchie"

q = f"""
use hahn;
PRAGMA yson.DisableStrict;
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA AnsiOrderByLimitInUnionAll;

select *
FROM `//home/taxi/production/replica/postgres/cargo_corp/employees`
where name <> 'Robot for Yandex Balance' and name <> 'Robot for token for API'

"""

title = 'YQL employees'
with YqlClient(db='hahn', token=token) as yql_client:
    request = yql_client.query(q, title=title, syntax_version=1)
    request.run()
    time.sleep(5)
    df = request.full_dataframe

logging.info(f"df len {len(df)} download from hahn")

from business_models.greenplum import GreenplumManager
greenplum = GreenplumManager(user='robot-sam-bridges', token=from_file['sam_gp_token'])

df['snapshot_dttm'] = str(datetime.datetime.now())
greenplum.write(df,table_name='snb_b2b.niksm_cargo_corp_employees', if_exists='append')#, with_grant=True, operator='select', to='analyst')

logging.info("upload to GP")
