drop view if exists snb_b2b.niksm_dash_client_finance;
create or replace view snb_b2b.niksm_dash_client_finance as
SELECT fct.corp_client_id,
       lk.lk_client_name                                                     AS corp_client_name,
       fct.corp_contract_id,
       fct.tariff_geo_zone_code                                              AS tariff_zone,
       geonode.name_ru                                                       AS agglomeration_name,
       fct.country_name_ru,
       fct.tariff_class_code as tariff_class_code,
       ctp.tariff_plan_series_id,
       ctp.tariff_plan_name,
       fct.msk_order_created_dt                                              AS calday,
       fct.currency_code,
       sum(fct.delivery_point_cnt)                                           AS deliveries_cnt,
       sum(fct.gmv_amt)                                                      AS gmv_lcy,
       sum(fct.gmv_amt * COALESCE(fct.currency_rate, 1::numeric))            AS gmv_rub,
       sum(fct.gmv_amt/coalesce(vat.vat_rate,1.))                                               AS nmv_lcy,
       sum(fct.gmv_amt * COALESCE(fct.currency_rate, 1::numeric)/coalesce(vat.vat_rate,1.))     AS nmv_rub,
       sum(fct.net_inflow_amt)                                               AS net_inflow_lcy,
       sum(fct.net_inflow_amt * COALESCE(fct.currency_rate, 1::numeric))     AS net_inflow_rub,
       sum(fct.b2b_decoupling_amt)                                           AS b2b_decoupling_lcy,
       sum(fct.b2b_decoupling_amt * COALESCE(fct.currency_rate, 1::numeric)) AS b2b_decoupling_rub,
       sum(
               CASE
                   WHEN fct.decoupling_success_flg THEN fct.decoupling_driver_cost
                   ELSE 0::numeric
                   END)                                                      AS decoupling_driver_cost_lcy,
       sum(
               CASE
                   WHEN fct.decoupling_success_flg
                       THEN fct.decoupling_driver_cost * COALESCE(fct.currency_rate, 1::numeric)
                   ELSE 0::numeric
                   END)                                                      AS decoupling_driver_cost_rub,
       sum(fct.incentives_amt)                                               AS incentives_lcy,
       sum(fct.incentives_amt * COALESCE(fct.currency_rate, 1::numeric))     AS incentives_rub,
       sum(fct.transporting_distance_plan_km)                                AS distance,
       sum(
               CASE
                   WHEN fct.transporting_distance_plan_km > 0::numeric THEN fct.delivery_point_cnt
                   ELSE 0
                   END)                                                      AS dlv_for_distance,
       sum(
               CASE
                   WHEN fct.success_order_flg THEN fct.order_before_surge_cost
                   ELSE 0::numeric
                   END)                                                      AS order_before_surge_cost_lcy,
       sum(
               CASE
                   WHEN fct.success_order_flg THEN fct.order_before_surge_cost * COALESCE(fct.currency_rate, 1::numeric)
                   ELSE 0::numeric
                   END)                                                      AS order_before_surge_cost_rub,
       sum(
               CASE
                   WHEN fct.success_order_flg THEN fct.order_cost
                   ELSE 0::numeric
                   END)                                                      AS order_cost_lcy,
       sum(
               CASE
                   WHEN fct.success_order_flg THEN fct.order_cost * COALESCE(fct.currency_rate, 1::numeric)
                   ELSE 0::numeric
                   END)                                                      AS order_cost_rub
FROM taxi_cdm_marketplace.fct_order_metric fct
          left join snb_b2b.niksm_country_vat_rate vat
             on vat.country_name_ru = fct.country_name_ru
         JOIN snb_delivery.logdata_delivery_tariff lgst
              ON lgst.order_tariff = fct.tariff_class_code::text AND fct.utc_order_created_dttm >= lgst.utc_datefrom AND
                 fct.utc_order_created_dttm <= lgst.utc_dateto
         JOIN snb_b2b.niksm_b2b_lk_client_service_info lk
              ON lk.lk_client_id = fct.corp_client_id::text AND lk.lk_service_name = 'cargo'::text
         JOIN snb_b2b.dbcorp_client_tariff_plan_current ctp ON ctp.corp_client_id::text = fct.corp_client_id::text and ctp.service_name = 'cargo'::text
         LEFT JOIN taxi_cdm_geo.dim_geo_node geonode
                   ON geonode.agglomeration_node_id::text = fct.agglomeration_node_id::text AND
                      geonode.node_type::text = 'agglomeration'::text AND geonode.root_node_id::text = 'br_root'::text
WHERE true
  AND fct.utc_order_created_dttm >= timezone('UTC'::text, timezone('Europe/Moscow'::text,
                                                                   date_trunc('week'::text, timezone(
                                                                           'Europe/Moscow'::text,
                                                                           'now'::text::date::timestamp with time zone)) -
                                                                   '28 days'::interval))
  AND fct.msk_order_created_dt >= ('now'::text::date - 28)
  AND fct.msk_order_created_dt <= ('now'::text::date - 1)
GROUP BY fct.corp_client_id, lk.lk_client_name, fct.corp_contract_id, fct.tariff_geo_zone_code, fct.country_name_ru,geonode.name_ru,fct.tariff_class_code,
         ctp.tariff_plan_series_id, ctp.tariff_plan_name, fct.msk_order_created_dt, fct.currency_code;

comment on view snb_b2b.niksm_dash_client_finance is 'Витрина для мониторинга экономики клиента. LOGDATA-1216. Автор niksm@';
