insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_dz_635_debt', 'Start', clock_timestamp());

drop table if exists niksm_temp_dash_dz_debt_res;
create temporary table niksm_temp_dash_dz_debt_res as
with debt_types (debt_srt, debt_type, debt_flg, overdue_flg) as (
values ( -2, 'No Debt', false, false),
       ( -1, 'Debt wo overdue', true, false),
       (  0, 'Overdue 0-30', true, true),
       ( 30, 'Overdue 30-60', true, true),
       ( 60, 'Overdue 60-90', true, true),
       ( 90, 'Overdue 90-180', true, true),
       (180, 'Overdue 180-360', true, true),
       (360, 'Overdue 360+', true, true)
)
, lk_hist as (
    select snapshot_date, contract_external_id,
           max(billing_contract_is_active) as billing_contract_is_active,
           max(lk_service_is_active) as lk_service_is_active
    from snb_b2b.niksm_b2b_lk_client_service_info_hist
    where snapshot_date >= '2021-08-01'
      and lk_service_name = 'cargo'
    group by 1,2
)
, dlv_1st as (
    select corp_contract_id,
           min(msk_order_created_dt) as first_dlv_dt
    from taxi_cdm_marketplace.fct_order fct
      join snb_taxi.logdata_logistic_tariffs lgst
        on fct.tariff_class_code = lgst.order_tariff
    where utc_order_created_dttm >= '2020-01-01'
    group by corp_contract_id
)
, pmnt as (
    select corp_contract_id,
           first_payment_dt::date as first_payment_dt
    from snb_b2b.niksm_b2b_contract_last_payment
)
, dlv_monthly as (
    select date_trunc('month',msk_order_created_dt)::date as calmonth,
           corp_contract_id,
           sum(delivery_point_cnt) as deliveries_cnt
    from taxi_cdm_marketplace.fct_order fct
      join snb_taxi.logdata_logistic_tariffs lgst
        on fct.tariff_class_code = lgst.order_tariff
    where utc_order_created_dttm >= '2020-12-31'
    group by 1,2
)
, contracts as (
    select calday::date as calday,
           manager_group,
           lead_name,
           manager_name,
           case when debt_by_act_0_30 + debt_by_act_30_60 + debt_by_act_60_90 + debt_by_act_90_180 +
                     debt_by_act_180_360 + debt_by_act_360_plus > 100 then
                case
                    when overdue_debt_by_act_360_plus > 0 then 360
                    when overdue_debt_by_act_180_360 > 0 then 180
                    when overdue_debt_by_act_90_180 > 0 then 90
                    when overdue_debt_by_act_60_90 > 0 then 60
                    when overdue_debt_by_act_30_60 > 0 then 30
                    when overdue_debt_by_act_0_30 > 0 then 0
                    else -1 end
               else -2
               end as contract_debt_srt,
           coalesce(lk_hist.billing_contract_is_active = 1, False) as billing_contract_is_active_hist,
           coalesce(lk_hist.lk_service_is_active = 1, False) as lk_service_is_active_hist,
           case
               when calday::date >= first_dlv_dt then
                   case
                       when calday::date >= first_payment_dt then
                           case
                               when debt_by_act_0_30 + debt_by_act_30_60 + debt_by_act_60_90 + debt_by_act_90_180 +
                                    debt_by_act_180_360 + debt_by_act_360_plus > 100 then 'Должник'
                               else 'Порядочный' end
                       else
                           case
                               when debt_by_act_0_30 + debt_by_act_30_60 + debt_by_act_60_90 + debt_by_act_90_180 +
                                    debt_by_act_180_360 + debt_by_act_360_plus > 100 then 'Фродер'
                               else 'Новичок' end
                       end
               else 'Не поехал' end as contract_kind,
           dlv_monthly.deliveries_cnt as deliveries_cnt_prev_month,
           --
           (debt_by_act_0_30 + debt_by_act_30_60 + debt_by_act_60_90 + debt_by_act_90_180 +
                debt_by_act_180_360 + debt_by_act_360_plus)
            - (overdue_debt_by_act_0_30 + overdue_debt_by_act_30_60 + overdue_debt_by_act_60_90 +
               overdue_debt_by_act_90_180 + overdue_debt_by_act_180_360 + overdue_debt_by_act_360_plus) as debt_00,
           overdue_debt_by_act_0_30, overdue_debt_by_act_30_60, overdue_debt_by_act_60_90, overdue_debt_by_act_90_180, overdue_debt_by_act_180_360, overdue_debt_by_act_360_plus
    from snb_b2b.niksm_b2b_contract_debt_daily dbt
      join snb_b2b.niksm_b2b_contracts_info crm
        on crm.contract_id = dbt.corp_contract_id
      join snb_b2b.niksm_b2b_lk_contract_info lk
        on lk.contract_external_id = dbt.corp_contract_id
        and lk_cargo_is_active = 1                                  -- только с активным сервисом доставки в ЛК
--       join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
--         on blnc.contract_external_id = dbt.corp_contract_id
      left join lk_hist
        on lk_hist.snapshot_date = calday::date
        and lk_hist.contract_external_id = dbt.corp_contract_id
      left join dlv_1st
        on dlv_1st.corp_contract_id = dbt.corp_contract_id
      left join pmnt
        on pmnt.corp_contract_id = dbt.corp_contract_id
      left join dlv_monthly
        on dlv_monthly.corp_contract_id = dbt.corp_contract_id
        and dlv_monthly.calmonth = (date_trunc('month',calday::date) - interval '1 month')
    where crm.which_crm = 6
)
select debt_srt, debt_type, debt_flg, overdue_flg,
       calday,
       manager_group, lead_name, manager_name,
       billing_contract_is_active_hist,
       lk_service_is_active_hist,
       contract_kind,
       --
       sum(case when debt_srt = contract_debt_srt then deliveries_cnt_prev_month else 0 end) as deliveries_cnt_prev_month,
       sum((debt_srt = contract_debt_srt)::int) as contracts_cnt,
       sum(case debt_srt
           when -2 then 0
           when -1 then debt_00
           when 0 then overdue_debt_by_act_0_30
           when 30 then overdue_debt_by_act_30_60
           when 60 then overdue_debt_by_act_60_90
           when 90 then overdue_debt_by_act_90_180
           when 180 then overdue_debt_by_act_180_360
           when 360 then overdue_debt_by_act_360_plus
           end) as debt_rub
from contracts
  cross join debt_types
group by debt_srt, debt_type, debt_flg, overdue_flg,
         calday,
         manager_group, lead_name, manager_name,
         billing_contract_is_active_hist,
         lk_service_is_active_hist,
         contract_kind;
--
analyse niksm_temp_dash_dz_debt_res;


-- drop table if exists snb_b2b.niksm_dash_dz_635_debt;
-- create table snb_b2b.niksm_dash_dz_635_debt as
truncate table snb_b2b.niksm_dash_dz_635_debt;
insert into snb_b2b.niksm_dash_dz_635_debt
    (debt_srt, debt_type, debt_flg, overdue_flg, calday,
     manager_group, lead_name, manager_name,
     billing_contract_is_active_hist, lk_service_is_active_hist,
     contract_kind, deliveries_cnt_prev_month, contracts_cnt, debt_rub,
     last_full_date)
select debt_srt, debt_type, debt_flg, overdue_flg, calday,
       manager_group, lead_name, manager_name,
       billing_contract_is_active_hist, lk_service_is_active_hist,
       contract_kind, deliveries_cnt_prev_month, contracts_cnt, debt_rub,
       NULL::date as last_full_date
from niksm_temp_dash_dz_debt_res;

update snb_b2b.niksm_dash_dz_635_debt
set last_full_date = (
    select least(last_claims_date, last_fct_date) as last_full_date
    from (
        select max(calday)::date as last_claims_date
        from snb_b2b.niksm_b2b_contract_debt_daily
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
)
where true;

-- comment on table snb_b2b.niksm_dash_dz_635_debt is 'Таблица для дашборда по дебиторской задолженности. LOGDATA-635';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_dz_635_debt', 'Finish', clock_timestamp());
