insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata113_funnel', 'Start', clock_timestamp());

drop table if exists niksm_temp_113_dlv;
create temporary table niksm_temp_113_dlv as
--
select corp_contract_id, min(msk_order_created_dt) as first_dlv_dt
from taxi_cdm_marketplace.fct_order as fct
  join snb_delivery.logdata_delivery_tariff as trf
    on trf.order_tariff = fct.tariff_class_code
    and fct.utc_order_created_dttm between utc_datefrom and utc_dateto
where true
  and utc_order_created_dttm >= '2020-01-01'
  and corp_order_flg
  and success_order_flg
group by corp_contract_id
distributed by (corp_contract_id);
--
analyze niksm_temp_113_dlv;

drop table if exists niksm_temp_113_dlh;
create temporary table niksm_temp_113_dlh as
select 6 as which_crm,
       lead_id as deal_id,
       min(msk_snapshot_dt) as first_crm_dt
from snb_b2b.amo_leads_info_hist as dlh
where true
  and pipeline_id = 5208574   -- ПОДКЛЮЧЕНИЕ
group by
         lead_id
distributed by (which_crm, deal_id);
--
analyse niksm_temp_113_dlh;

drop table if exists niksm_temp_113_res;
create temporary table niksm_temp_113_res as
with cntr_init as (
    select contract_external_id,
           least(start_dt,faxed_dt,signed_dt) as contract_created_dt
    from snb_b2b.niksm_b2b_balance_contract_ext_info
)
select dls.which_crm,
       dls.deal_id, client_name,
       potential, status, lost_reason,
       wishlist_sorted as wishlist,
       contract_id, channel,
       country, city, market_segment,
       manager_login, manager_name, lead_name, manager_group,
       permissions, tags, product, integration_module,
       (pipeline_id = 5208574)::int as in_connection_pipeline_now,
       case when pipeline_id = 5208574 then stgn.stage_sort_id end as stage_sort_id,
       case when pipeline_id = 5208574 then stgn.stage_name end as stage_name,
       --
       deal_init.first_crm_dt,
       least(cntr_init.contract_created_dt, dlv.first_dlv_dt) as contract_created_dt,
       dlv.first_dlv_dt,
       ndd_pipeline_stage is not null as ndd_flag
from (select dls.*,ali.pd_deal_id
      from snb_b2b.niksm_b2b_deals_info dls
    join snb_b2b.amo_leads_info  ali on dls.deal_id=ali.lead_id::int
     )as dls
  cross join lateral (
    select '[' || string_agg(wishlist_unit, ',' order by wishlist_unit) || ']' as wishlist_sorted
    from (
      select unnest(
               string_to_array(
                 substring(dls.wishlist from '\[(.*)\]'),
                ',')
                ) as wishlist_unit
    ) q
  ) qq
  left join snb_b2b.niksm_pd_stage_sort as stgs
    on stgs.stage_id = dls.stage_id
  left join snb_b2b.niksm_pd_stage_names as stgn
    on stgn.stage_sort_id = stgs.stage_sort_id
  join niksm_temp_113_dlh as deal_init
    on deal_init.which_crm = dls.which_crm
    and deal_init.deal_id = dls.deal_id
  left join cntr_init
    on cntr_init.contract_external_id = dls.contract_id
  left join niksm_temp_113_dlv as dlv
    on dlv.corp_contract_id = dls.contract_id
where true
  and dls.which_crm in (6,8);

-- drop table if exists snb_b2b.niksm_b2b_logdata113_funnel;
-- create table snb_b2b.niksm_b2b_logdata113_funnel as
truncate table snb_b2b.niksm_b2b_logdata113_funnel;
insert into snb_b2b.niksm_b2b_logdata113_funnel
    (which_crm, deal_id, client_name, potential, status, lost_reason, wishlist, contract_id, channel, country, city,
     market_segment, manager_login, manager_name, lead_name, manager_group, permissions, tags, product, integration_module,
     in_connection_pipeline_now, stage_sort_id, stage_name,
    first_crm_dt, contract_created_dt, first_dlv_dt, ndd_flag, last_full_date)
select  which_crm, deal_id, client_name, potential, status, lost_reason, wishlist, contract_id, channel, country, city,
       market_segment, manager_login, manager_name, lead_name, manager_group, permissions, tags, product, integration_module,
       in_connection_pipeline_now, stage_sort_id, stage_name, first_crm_dt, contract_created_dt, first_dlv_dt, ndd_flag,
       NULL::date as last_full_date
from niksm_temp_113_res;

update snb_b2b.niksm_b2b_logdata113_funnel
set last_full_date = (
    select least(last_fct_date, last_dls_date) as last_full_date
    from (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
    cross join (
        select max(record_date)::date as last_dls_date
        from snb_b2b.niksm_b2b_deals_info
        ) dls
    )
where true;

-- comment on table snb_b2b.niksm_b2b_logdata113_funnel is 'Данные для дэша по воронкам. LOGDATA-113';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata113_funnel', 'Finish', clock_timestamp());
