drop view if exists snb_b2b.niksm_dash_hygfilters;
create or replace view snb_b2b.niksm_dash_hygfilters as
with hist as (
    select dt, login, alias, sum(1) as n
    from snb_b2b.hygfilter_hist
    group by dt, login, alias
)
select hist.alias,
       hist.login,
       array_to_json(array(select json_array_elements_text(m.hierarchy))
        || (select array_agg(user_login)
           from snb_b2b.niksm_b2b_user_permission
            where user_group in ('Full base','International','Telemarketing','CRM'))
           ) as hierarchy,
       hist.dt,
       coalesce(m.name_last_ru || ' ' || m.name_first_ru,hist.login) as man,
       m.lead_name_last || ' ' || m.lead_name_first          as lead,
       hist.n                                                as gig_cnt
from hist
  left join snb_b2b.voytekh_manager_v2 as m
    on hist.login = m.login;

comment on view snb_b2b.niksm_dash_hygfilters is 'Витрина для дашборда Hygienic Filters';
