drop table if exists akorchagina24_temp_calendar;
create temporary table  akorchagina24_temp_calendar
as
        select
            distinct
            calday,
            case when calday = last_full_date then true else false end as yesterday_flg,
            case when calday = last_full_date - interval '7 day' then true else false end as yesterday_prev_flg,

            case when calday between date_trunc('week', last_full_date) and last_full_date then true else false end as wtd_flg,
            case when calday between date_trunc('week', last_full_date) - interval '7 day' and last_full_date - interval '7 day' then true else false end as wtd_prev_flg,

            case when calday between date_trunc('week', last_full_date + interval '1 day') - interval '1 week' and date_trunc('week', last_full_date + interval '1 day') - interval '1 day' then true else false end as lfw_flg,
            case when calday between date_trunc('week', last_full_date + interval '1 day') - interval '2 week' and date_trunc('week', last_full_date + interval '1 day') - interval '8 day' then true else false end as lfw_prev_flg,

            case when calday between date_trunc('month', last_full_date) and last_full_date then true else false end as mtd_flg,
            case when calday between date_trunc('month', last_full_date) - interval '1 month' and last_full_date - interval '1 month' then true else false end as mtd_prev_flg,

            case when calday between date_trunc('month', last_full_date + interval '1 day') - interval '1 month' and date_trunc('month', last_full_date + interval '1 day') - interval '1 day' then true else false end as lfm_flg,
            case when calday between date_trunc('month', last_full_date + interval '1 day') - interval '2 month' and date_trunc('month', last_full_date + interval '1 day') - interval '1 month 1 day' then true else false end as lfm_prev_flg,


            case when calday between last_full_date - interval '6 day' and last_full_date then true else false end as l7d_flg,
            case when calday between last_full_date - interval '13 day' and last_full_date - interval '7 day' then true else false end as l7d_prev_flg,

            case when calday between last_full_date - interval '29 day' and last_full_date then true else false end as l30d_flg,
            case when calday between last_full_date - interval '59 day' and last_full_date - interval '30 day' then true else false end as l30d_prev_flg

        from snb_b2b.niksm_dash_logdata111
;

drop table if exists akorchagina24_temp_addition_calc;
create temporary table  akorchagina24_temp_addition_calc
as
    select
        contract_id,
        max(activated_dt) as max_activated_dt,
        max(last_full_date) as last_full_date,

        -------------For churn, no deliveries, dlv falling-------------------------
        sum(deliveries_cnt) filter (where yesterday_flg) as deliveries_y,
        sum(deliveries_cnt) filter (where yesterday_prev_flg) as deliveries_y_prev,
        sum(deliveries_cnt) filter (where wtd_flg) as deliveries_wtd,
        sum(deliveries_cnt) filter (where wtd_prev_flg) as deliveries_wtd_prev,
        sum(deliveries_cnt) filter (where lfw_flg) as deliveries_lfw,
        sum(deliveries_cnt) filter (where lfw_prev_flg) as deliveries_lfw_prev,
        sum(deliveries_cnt) filter (where mtd_flg) as deliveries_mtd,
        sum(deliveries_cnt) filter (where mtd_prev_flg) as deliveries_mtd_prev,
        sum(deliveries_cnt) filter (where lfm_flg) as deliveries_lfm,
        sum(deliveries_cnt) filter (where lfm_prev_flg) as deliveries_lfm_prev,
        sum(deliveries_cnt) filter (where l7d_flg) as deliveries_7d,
        sum(deliveries_cnt) filter (where l7d_prev_flg) as deliveries_7d_prev,
        sum(deliveries_cnt) filter (where l30d_flg) as deliveries_30d,
        sum(deliveries_cnt) filter (where l30d_prev_flg) as deliveries_30d_prev,
        -----------------------------------------------------
        -------------For low balance-------------------------
        max(balance) - coalesce(max(deactivate_threshold), 0) as threshold_balance,
        sum(case when l7d_flg then gmv else 0 end)/7 as gmv_daily,
        max(payment_type) as payment_type,
        -----------------------------------------------------
        -------------For CR------------------------------
        sum(deliveries_total) filter (where yesterday_flg) as applications_y,
        sum(deliveries_total) filter (where wtd_flg) as applications_wtd,
        sum(deliveries_total) filter (where lfw_flg) as applications_lfw,
        sum(deliveries_total) filter (where mtd_flg) as applications_mtd,
        sum(deliveries_total) filter (where lfm_flg) as applications_lfm,
        sum(deliveries_total) filter (where l7d_flg) as applications_7d,
        sum(deliveries_total) filter (where l30d_flg) as applications_30d

    from snb_b2b.niksm_dash_logdata111 as tbl
    left join akorchagina24_temp_calendar as cld
        on tbl.calday = cld.calday
    group by
        contract_id
;

drop table if exists akorchagina24_temp_extended_table;
create temporary table  akorchagina24_temp_extended_table
as
    select
        contract_id,
        case when max_activated_dt is not null then true else false end as active_flg,
        --------------------churn--------------------
        case when deliveries_y_prev > 0 and coalesce(deliveries_y,0) = 0 and max_activated_dt is not null then true else false end as churn_y_flg,
        case when deliveries_wtd_prev > 0 and coalesce(deliveries_wtd,0) = 0 and max_activated_dt is not null then true else false end as churn_wtd_flg,
        case when deliveries_lfw_prev > 0 and coalesce(deliveries_lfw,0) = 0 and max_activated_dt is not null  then true else false end as churn_lfw_flg,
        case when deliveries_mtd_prev > 0 and coalesce(deliveries_mtd,0) = 0 and max_activated_dt is not null  then true else false end as churn_mtd_flg,
        case when deliveries_lfm_prev > 0 and coalesce(deliveries_lfm,0) = 0 and max_activated_dt is not null  then true else false end as churn_lfm_flg,
        case when deliveries_7d_prev > 0 and coalesce(deliveries_7d,0) = 0 and max_activated_dt is not null  then true else false end as churn_7d_flg,
        case when deliveries_30d_prev > 0 and coalesce(deliveries_30d,0) = 0 and max_activated_dt is not null  then true else false end as churn_30d_flg,
        ---------------------------------------------
        -----------low balance-----------------------
        case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end as low_balance_flg,
        -----------------------------------------------
        -----------no deliveries-----------------------
        case when max_activated_dt is not null and coalesce(deliveries_y,0) = 0
                    and --low_balance_flg--
                    not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
                    then true else false end as no_deliveries_y_flg,
        case when max_activated_dt is not null and coalesce(deliveries_wtd,0) = 0
                    and --low_balance_flg--
                    not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
                    then true else false end as no_deliveries_wtd_flg,
        case when max_activated_dt is not null and coalesce(deliveries_lfw,0) = 0
                    and --low_balance_flg--
                    not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
                    then true else false end as no_deliveries_lfw_flg,
        case when max_activated_dt is not null and coalesce(deliveries_mtd,0) = 0
                    and --low_balance_flg--
                    not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
                    then true else false end as no_deliveries_mtd_flg,
        case when max_activated_dt is not null and coalesce(deliveries_lfm,0) = 0
                    and --low_balance_flg--
                    not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
                    then true else false end as no_deliveries_lfm_flg,
        case when max_activated_dt is not null and coalesce(deliveries_7d,0) = 0
                    and --low_balance_flg--
                    not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
                    then true else false end as no_deliveries_7d_flg,
        case when max_activated_dt is not null and coalesce(deliveries_30d,0) = 0
                    and --low_balance_flg--
                    not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
                    then true else false end as no_deliveries_30d_flg,
        ---------------------------------------------
        -----------dlv falling-----------------------
        case when max_activated_dt is not null and coalesce(deliveries_y,0) - coalesce(deliveries_y_prev,0) <= 0 then true else false end as dlv_falling_y_flg,
        case when max_activated_dt is not null and coalesce(deliveries_wtd,0) - coalesce(deliveries_wtd_prev,0) <= 0 then true else false end as dlv_falling_wtd_flg,
        case when max_activated_dt is not null and coalesce(deliveries_lfw,0) - coalesce(deliveries_lfw_prev,0) <= 0 then true else false end as dlv_falling_lfw_flg,
        case when max_activated_dt is not null and coalesce(deliveries_mtd,0) - coalesce(deliveries_mtd_prev,0) <= 0 then true else false end as dlv_falling_mtd_flg,
        case when max_activated_dt is not null and coalesce(deliveries_lfm,0) - coalesce(deliveries_lfm_prev,0) <= 0 then true else false end as dlv_falling_lfm_flg,
        case when max_activated_dt is not null and coalesce(deliveries_7d,0) - coalesce(deliveries_7d_prev,0) <= 0 then true else false end as dlv_falling_7d_flg,
        case when max_activated_dt is not null and coalesce(deliveries_30d,0) - coalesce(deliveries_30d_prev,0) <= 0 then true else false end as dlv_falling_30d_flg,
        ---------------------------------------------
        -----------dlv growing-----------------------
        case when max_activated_dt is not null and coalesce(deliveries_y,0) - coalesce(deliveries_y_prev,0) > 0 then true else false end as dlv_growing_y_flg,
        case when max_activated_dt is not null and coalesce(deliveries_wtd,0) - coalesce(deliveries_wtd_prev,0) > 0 then true else false end as dlv_growing_wtd_flg,
        case when max_activated_dt is not null and coalesce(deliveries_lfw,0) - coalesce(deliveries_lfw_prev,0) > 0 then true else false end as dlv_growing_lfw_flg,
        case when max_activated_dt is not null and coalesce(deliveries_mtd,0) - coalesce(deliveries_mtd_prev,0) > 0 then true else false end as dlv_growing_mtd_flg,
        case when max_activated_dt is not null and coalesce(deliveries_lfm,0) - coalesce(deliveries_lfm_prev,0) > 0 then true else false end as dlv_growing_lfm_flg,
        case when max_activated_dt is not null and coalesce(deliveries_7d,0) - coalesce(deliveries_7d_prev,0) > 0 then true else false end as dlv_growing_7d_flg,
        case when max_activated_dt is not null and coalesce(deliveries_30d,0) - coalesce(deliveries_30d_prev,0) > 0 then true else false end as dlv_growing_30d_flg,
        ---------------------------------------------
        -----------CR--------------------------------
        case when coalesce(applications_y,0) >0 then coalesce(deliveries_y,0)/applications_y else 0 end as cr_y,
        case when coalesce(applications_wtd,0) >0 then coalesce(deliveries_wtd,0)/applications_wtd else 0 end as cr_wtd,
        case when coalesce(applications_lfw,0) >0 then coalesce(deliveries_lfw,0)/applications_lfw else 0 end as cr_lfw,
        case when coalesce(applications_mtd,0) >0 then coalesce(deliveries_mtd,0)/applications_mtd else 0 end as cr_mtd,
        case when coalesce(applications_lfm,0) >0 then coalesce(deliveries_lfm,0)/applications_lfm else 0 end as cr_lfm,
        case when coalesce(applications_7d,0) >0 then coalesce(deliveries_7d,0)/applications_7d else 0 end as cr_7d,
        case when coalesce(applications_30d,0) >0 then coalesce(deliveries_30d,0)/applications_30d else 0 end as cr_30d,
        ----------------------------------------
        -----------Newbie-----------------------
        case when max_activated_dt is not null and last_full_date - max_activated_dt <=35 then true else false end as newbie_flg
        ----------------------------------------
    from akorchagina24_temp_addition_calc
;


truncate table snb_b2b.akorchagina24_logdata111_report_tables;
insert into snb_b2b.akorchagina24_logdata111_report_tables
(
    contract_id, lk_client_id, lk_client_name, which_crm, deal_id, add_contract_flg, contract_terminated_flg, crm_link,
    client_name, holding_name, deal_title, potential, country, market_segment,
    tier, manager_name, lead_name, department_name, permissions, manager_group,
    payment_type, last_activity_date, next_activity_date, quasi_flg, deactivate_threshold,
    balance, debt, debt00, overdue_clean_debt, activated_dt, last_payment_dt,
    tariff_plan_series_name,
    calday, product, tariff_zone, city, city_en, soon_order,
    deliveries_total, deliveries_cnt, deliveries_expired, deliveries_failed, deliveries_cancelled_by_courier,
    deliveries_cancelled_by_client,
    deliveries_total_w_distance, distance,
    gmv, net_inflow,
    deliveries_found, deliveries_a_arrived, deliveries_a_visited, deliveries_cancelled,
    dlv_for_searching_time, searching_time_sec,
    dlv_for_driving_to_a_time, driving_to_a_time_sec,
    dlv_for_arrival_time, arrival_time_sec,
    dlv_for_waiting_a_time, waiting_a_time_sec,
    dlv_for_transporting_time, transporting_time_sec,
    dlv_for_total_time, total_time_sec,
    dlv_for_cancellation_time, cancellation_time_sec,
    dlv_for_cancellation_before_found_time, cancellation_before_found_time_sec,
    cntr_prev_cld_type_id, cntr_prev_clw_type_id, cntr_prev_clm_type_id, first_delivery_dt,
    category, theme_1, theme_2, theme_3, theme_4, tickets_cnt,
    last_full_date,
    y_flg, wtd_flg, lfw_flg, mtd_flg, lfm_flg, l7d_flg, l30d_flg,
    y_prev_flg, wtd_prev_flg, lfw_prev_flg, mtd_prev_flg, lfm_prev_flg, l7d_prev_flg, l30d_prev_flg,
    active_flg,
    churn_y_flg, churn_wtd_flg, churn_lfw_flg, churn_mtd_flg, churn_lfm_flg, churn_7d_flg, churn_30d_flg,
    low_balance_flg,
    no_deliveries_y_flg, no_deliveries_wtd_flg, no_deliveries_lfw_flg, no_deliveries_mtd_flg, no_deliveries_lfm_flg,
    no_deliveries_7d_flg, no_deliveries_30d_flg,
    dlv_falling_y_flg, dlv_falling_wtd_flg, dlv_falling_lfw_flg, dlv_falling_mtd_flg, dlv_falling_lfm_flg,
    dlv_falling_7d_flg, dlv_falling_30d_flg,
    dlv_growing_y_flg, dlv_growing_wtd_flg, dlv_growing_lfw_flg, dlv_growing_mtd_flg, dlv_growing_lfm_flg,
    dlv_growing_7d_flg, dlv_growing_30d_flg,
    cr_y, cr_wtd, cr_lfw, cr_mtd, cr_lfm, cr_7d, cr_30d,
    newbie_flg)
    
        select
            tbl.contract_id, tbl.lk_client_id, tbl.lk_client_name, tbl.which_crm, tbl.deal_id, tbl.add_contract_flg, tbl.contract_terminated_flg, tbl.crm_link,
            tbl.client_name, tbl.holding_name, tbl.deal_title, tbl.potential, tbl.country, tbl.market_segment,
            tbl.tier, tbl.manager_name, tbl.lead_name, tbl.department_name, tbl.permissions, tbl.manager_group,
            tbl.payment_type, tbl.last_activity_date, tbl.next_activity_date, tbl.quasi_flg, tbl.deactivate_threshold,
            tbl.balance, tbl.debt, tbl.debt00, tbl.overdue_clean_debt, tbl.activated_dt, tbl.last_payment_dt,
            tbl.tariff_plan_series_name,
            tbl.calday, tbl.product, tbl.tariff_zone, tbl.city, tbl.city_en, tbl.soon_order,
            tbl.deliveries_total, tbl.deliveries_cnt, tbl.deliveries_expired, tbl.deliveries_failed, tbl.deliveries_cancelled_by_courier,
            tbl.deliveries_cancelled_by_client,
            tbl.deliveries_total_w_distance, tbl.distance,
            tbl.gmv, tbl.net_inflow,
            tbl.deliveries_found, tbl.deliveries_a_arrived, tbl.deliveries_a_visited, tbl.deliveries_cancelled,
            tbl.dlv_for_searching_time, tbl.searching_time_sec,
            tbl.dlv_for_driving_to_a_time, tbl.driving_to_a_time_sec,
            tbl.dlv_for_arrival_time, tbl.arrival_time_sec,
            tbl.dlv_for_waiting_a_time, tbl.waiting_a_time_sec,
            tbl.dlv_for_transporting_time, tbl.transporting_time_sec,
            tbl.dlv_for_total_time, tbl.total_time_sec,
            tbl.dlv_for_cancellation_time, tbl.cancellation_time_sec,
            tbl.dlv_for_cancellation_before_found_time, tbl.cancellation_before_found_time_sec,
            tbl.cntr_prev_cld_type_id, tbl.cntr_prev_clw_type_id, tbl.cntr_prev_clm_type_id, tbl.first_delivery_dt,
            tbl.category, tbl.theme_1, tbl.theme_2, tbl.theme_3, tbl.theme_4, tbl.tickets_cnt,
            tbl.last_full_date,
            cld.yesterday_flg as y_flg, cld.wtd_flg, cld.lfw_flg, cld.mtd_flg, cld.lfm_flg, cld.l7d_flg, cld.l30d_flg,
            cld.yesterday_prev_flg as y_prev_flg, cld.wtd_prev_flg, cld.lfw_prev_flg, cld.mtd_prev_flg, cld.lfm_prev_flg, cld.l7d_prev_flg, cld.l30d_prev_flg,
            ext.active_flg,
            ext.churn_y_flg, ext.churn_wtd_flg, ext.churn_lfw_flg, ext.churn_mtd_flg, ext.churn_lfm_flg, ext.churn_7d_flg, ext.churn_30d_flg,
            ext.low_balance_flg,
            ext.no_deliveries_y_flg, ext.no_deliveries_wtd_flg, ext.no_deliveries_lfw_flg, ext.no_deliveries_mtd_flg, ext.no_deliveries_lfm_flg, ext.no_deliveries_7d_flg, ext.no_deliveries_30d_flg,
            ext.dlv_falling_y_flg, ext.dlv_falling_wtd_flg, ext.dlv_falling_lfw_flg, ext.dlv_falling_mtd_flg, ext.dlv_falling_lfm_flg, ext.dlv_falling_7d_flg, ext.dlv_falling_30d_flg,
            ext.dlv_growing_y_flg, ext.dlv_growing_wtd_flg, ext.dlv_growing_lfw_flg, ext.dlv_growing_mtd_flg, ext.dlv_growing_lfm_flg, ext.dlv_growing_7d_flg, ext.dlv_growing_30d_flg,
            ext.cr_y, ext.cr_wtd, ext.cr_lfw, ext.cr_mtd, ext.cr_lfm, ext.cr_7d, ext.cr_30d,
            ext.newbie_flg

        from snb_b2b.niksm_dash_logdata111 as tbl
        left join akorchagina24_temp_calendar as cld
            on tbl.calday = cld.calday
        left join akorchagina24_temp_extended_table ext
            on ext.contract_id = tbl.contract_id

