insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_logdata111', 'Start', clock_timestamp());

drop table if exists last_pmnt;
create temporary table last_pmnt as
select contract_eid as corp_contract_id,
       max(doc_date) as last_payment_dt
from snb_b2b.balance_oebs_cash_payment_fact payment
         join snb_b2b.balance_invoice invoice
              on invoice.external_id = payment.invoice_eid
         join snb_b2b.balance_contracts contracts
              on contracts.contract_id = invoice.contract_id
where payment.amt > 0
group by 1
    distributed by (corp_contract_id);
analyse last_pmnt;

--== cntr_enrich ==--
drop table if exists niksm_temp_111_cntr_enrich;
create temporary table niksm_temp_111_cntr_enrich as
with cntr0 as (
    select contract_id,
           --
           lead_id as deal_id,
           case when crm_source = 'yandexdelivery'
                    then 'https://yandexdelivery.amocrm.ru/leads/detail/' || lead_id::text end as crm_link,
           add_contract_flg,
           contract_terminated_flg,
           lead_status as status,
           price/30. as potential,
           6::int as which_crm,
           coalesce(holding_name,company_name) as client_name,
           -- attr
           holding_name,
           lead_name as deal_title,
           country,
           market_segment,
           tier,
           coalesce(manager_name, manager_login) as manager_name,
           teamlead_name as lead_name,
           department_name,
           permissions,
           manager_group
    from snb_b2b.amo_contracts_info as d
    where true
      and crm_source = 'yandexdelivery'
      --
    union all
    select contract_id,
           --
           NULL::int as deal_id,
           NULL::text as crm_link,
           false as add_contract_flg,
           false as contract_terminated_flg,
           status,
           potential/30. as potential,
           which_crm,
           client_name,
           -- attr
           holding_name,
           deal_title,
           country,
           market_segment,
           tier,
           coalesce(manager_name, manager_login) as manager_name,
           lead_name,
           department_name,
           permissions,
           manager_group
    from snb_b2b.niksm_b2b_contracts_info_sf
)
   , blnc as (
    select contract as corp_contract_id,
           coalesce(max(invoice_payments_sum),0.) - coalesce(max(act_sum),0.) as balance,
           max(invoice_payments_sum) as invoice_payments_sum,
           sum(debt_sum) as debt,
           sum(debt00) as debt00,
           sum(overdue_clean_debt) as overdue_clean_debt
    from snb_b2b.voytekh_corporate_contracts_and_debts
    group by contract
)
   , act_dt as (
    select contract_external_id as corp_contract_id,
           contract_type,
           payment_type,
           case
               when contract_type = 'Договор-оферта' then min_payment_date_v2
               when payment_type = 'предоплата' then start_dt
               else least(signed_dt, faxed_dt, booked_dt)
               end as activated_dt
    from snb_b2b.niksm_b2b_balance_contract_ext_info
)
   , lk as (
    select contract_external_id,
           lk_client_id,
           lk_client_name,
           lk_contract_prepaid_deactivate_threshold as deactivate_threshold,
           coalesce((lk_contract_prepaid_deactivate_threshold <= -100)::int, 0) as quasi_flg,
           lk_client_country,
           lk_created_moscow_dt
    from snb_b2b.niksm_b2b_lk_contract_info
)
select contract_id,
       --
       lk.lk_client_id,
       lk.lk_client_name,
       cntr0.which_crm,
       cntr0.deal_id,
       add_contract_flg,
       contract_terminated_flg,
       crm_link,
       client_name,
       holding_name,
       deal_title,
       potential,
       country,
       market_segment,
       tier,
       manager_name,
       lead_name,
       department_name,
       permissions,
       manager_group,
       payment_type,
       --
       NULL::date as last_activity_date,
       NULL::date as next_activity_date,
       coalesce(quasi_flg,0) as quasi_flg,
       coalesce(deactivate_threshold,0) as deactivate_threshold,
       coalesce(balance,0) as balance,
       coalesce(invoice_payments_sum, 0) as invoice_payments_sum,
       coalesce(debt,0) as debt,
       coalesce(debt00,0) as debt00,
       coalesce(overdue_clean_debt,0) as overdue_clean_debt,
       case when lk_client_country = 'isr' and contract_type = 'Договор-оферта' then lk_created_moscow_dt
            else act_dt.activated_dt end as activated_dt,
       last_payment_dt
from cntr0
         left join blnc on blnc.corp_contract_id = cntr0.contract_id
         left join act_dt on act_dt.corp_contract_id = cntr0.contract_id
         left join last_pmnt on last_pmnt.corp_contract_id = cntr0.contract_id
         left join lk on lk.contract_external_id = cntr0.contract_id;
--
analyze niksm_temp_111_cntr_enrich;

------------------------------------------------------------------------------------------------------------------------
drop table if exists niksm_temp_111_phoenix_client_enrich;
create temporary table niksm_temp_111_phoenix_client_enrich as
select corp_client_id,
       --
       lead_id as deal_id,
       case when crm_source = 'yandexdelivery'
                then 'https://yandexdelivery.amocrm.ru/leads/detail/' || lead_id::text end as crm_link,
       add_contract_flg,
       contract_terminated_flg,
       lead_status as status,
       price/30. as potential,
       6::int as which_crm,
       coalesce(holding_name,company_name) as client_name,
       -- attr
       holding_name,
       lead_name as deal_title,
       country,
       market_segment,
       tier,
       coalesce(manager_name, manager_login) as manager_name,
       teamlead_name as lead_name,
       department_name,
       permissions,
       manager_group,
       --
       NULL::date as last_activity_date,
       NULL::date as next_activity_date,
       'Феникс' as payment_type
from snb_b2b.amo_clients_info clnt0
    DISTRIBUTED BY (corp_client_id)
;
--
analyse niksm_temp_111_phoenix_client_enrich;

------------------------------------------------------------------------------------------------------------------------
drop table if exists niksm_temp_dash_robot_phoenix_claim;
create temporary table niksm_temp_dash_robot_phoenix_claim as
select taxi_order_id,
       max(claim.corp_client_id) as corp_client_id
from delivery_ods_cargo_claims.claim
         join snb_b2b.niksm_b2b_clients_info crm
              on claim.corp_client_id = crm.corp_client_id
where true
  and utc_created_dttm >= timestamp'2021-11-01'
group by taxi_order_id
    distributed by (taxi_order_id)
;
analyse niksm_temp_dash_robot_phoenix_claim;

------------------------------------------------------------------------------------------------------------------------
--== cl_type ==--
drop table if exists niksm_temp_111_cl_type;
create temporary table niksm_temp_111_cl_type as
with raw0 as (
    select coalesce(fct.corp_client_id, ph.corp_client_id) as corp_client_id,
           corp_contract_id,
           greatest(msk_order_created_dt,current_date - 92 - 32) as calday,
           min(min(msk_order_created_dt)) over (partition by corp_contract_id) as first_delivery_dt
    from taxi_cdm_marketplace.fct_order as fct
             join snb_delivery.logdata_delivery_tariff lgst
                  on lgst.order_tariff = fct.tariff_class_code
                      and fct.utc_order_created_dttm between utc_datefrom and utc_dateto
             left join niksm_temp_dash_robot_phoenix_claim ph
                       on ph.taxi_order_id = fct.order_id
    where true
      and fct.utc_order_created_dttm >= '2020-01-01' -- for partitioning
      and fct.success_order_flg
      and not fct.mqc_order_flg
      and (fct.corp_order_flg or ph.taxi_order_id is not null)
    group by 1,2,3
    having sum(delivery_point_cnt) > 0
)
   , raw as (
    select corp_client_id,
           corp_contract_id,
           calday,
           (date_trunc('week', calday)::date - '1900-01-02'::date) / 7 as calweek_id,
           extract(year from calday) * 12 + extract(month from calday) as calmonth_id,
           first_delivery_dt
    from raw0
)
select corp_client_id,
       corp_contract_id,
       calday,
       first_delivery_dt,
       case when count() over (partition by corp_client_id, corp_contract_id order by calday range between 1 preceding and 1 preceding) > 0 then 1
            when count() over (partition by corp_client_id, corp_contract_id order by calday range between unbounded preceding and 2 preceding) > 0 then 2
            else 3 end as cntr_prev_cld_type_id,
       case when count() over (partition by corp_client_id, corp_contract_id order by calweek_id range between 1 preceding and 1 preceding) > 0 then 1
            when count() over (partition by corp_client_id, corp_contract_id order by calweek_id range between unbounded preceding and 2 preceding) > 0 then 2
            else 3 end as cntr_prev_clw_type_id,
       case when count() over (partition by corp_client_id, corp_contract_id order by calmonth_id range between 1 preceding and 1 preceding) > 0 then 1
            when count() over (partition by corp_client_id, corp_contract_id order by calmonth_id range between unbounded preceding and 2 preceding) > 0 then 2
            else 3 end as cntr_prev_clm_type_id
from raw;
--
analyze niksm_temp_111_cl_type;

------------------------------------------------------------------------------------------------------------------------
--== cargo_log ==--
drop table if exists niksm_temp_111_cargo_log;
create temporary table niksm_temp_111_cargo_log as
--
with claim_statlog as (
    select claim_id,
           bool_or(new_claim_status = 'accepted') as accepted_flg,
           min(case when new_claim_status = 'accepted' then utc_created_dttm end) as utc_accepted_dttm,
           min(case when new_claim_status = 'performer_found' then utc_created_dttm end) as utc_found_dttm,
           min(case when new_claim_status = 'pickup_arrived' then utc_created_dttm end)  as utc_a_arrived_dttm,
           min(case when new_claim_status = 'pickuped' then utc_created_dttm end)        as utc_a_visited_dttm,
           max(case when new_claim_status = 'delivered' then utc_created_dttm end)       as utc_b_visited_last_dttm
    from delivery_ods_cargo_claims.claim_status_log
    where true
      and utc_created_dttm >= current_date - 93
    group by claim_id
    having bool_or(new_claim_status = 'accepted')
)
   , spnt as (
    select claim_segment_id,
           count() as deliveries_total,
           count(case when point_status = 'visited' then 1 end) as deliveries_cnt
    from delivery_ods_cargo_claims.claim_segment_point
    where true
      and utc_created_dttm >= current_date - 93
      and point_type = 'destination'
    group by claim_segment_id
)
select segm.claim_segment_id,
       segm.claim_id,
       segm.taxi_order_id as order_id,
       claim.corp_client_id,
       segment_status,
--        claim.utc_created_dttm,
       claim.utc_due_dttm,
       utc_resolved_at_dttm,
       --
       claim_statlog.claim_id is not null as cargo_logging_flg,
       coalesce(utc_accepted_dttm,segm.utc_created_dttm) as utc_created_dttm,                       --!!!
       utc_found_dttm,
       utc_a_arrived_dttm,
       utc_a_visited_dttm,
       utc_b_visited_last_dttm,
       --
       coalesce(deliveries_total,0) as deliveries_total,
       coalesce(deliveries_cnt,0) as deliveries_cnt,
       sum(case when deliveries_cnt>0 then 1 else 0 end)
       over (partition by segm.taxi_order_id) as segments_success_per_order
from delivery_ods_cargo_claims.claim as claim
         join delivery_ods_cargo_claims.claim_segment segm
              on claim.claim_id = segm.claim_id
         join spnt on spnt.claim_segment_id = segm.claim_segment_id
         left join claim_statlog on claim_statlog.claim_id = claim.claim_id
where true
  and segm.utc_created_dttm >= current_date - 93
    distributed by (order_id)
;
--
analyze niksm_temp_111_cargo_log;

------------------------------------------------------------------------------------------------------------------------
--== taxi_log ==--
drop table if exists niksm_temp_111_taxi_log;
create temporary table niksm_temp_111_taxi_log as
with raw as (
    select order_id,
           min(case when backend_status = 'assigned' then utc_status_created_dttm end) as utc_found_dttm,
           min(case when driver_status = 'waiting' then utc_status_created_dttm end)      as utc_a_arrived_dttm,
           min(case when driver_status = 'transporting' then utc_status_created_dttm end) as utc_a_visited_dttm,
           max(case when driver_status = 'complete' then utc_status_created_dttm end)     as utc_b_visited_last_dttm
    from taxi_stg_dbprocessing.order_status_log
    where utc_order_created_dttm >= current_date - 93
      and utc_order_created_dttm <  current_date - 62
    group by order_id
)
select order_id,
       true as taxi_logging_flg,
--        least(utc_created_dttm_log, utc_found_dttm, utc_a_arrived_dttm, utc_a_visited_dttm, utc_b_visited_last_dttm) as utc_created_dttm,
       utc_found_dttm,
       utc_a_arrived_dttm,
       utc_a_visited_dttm,
       utc_b_visited_last_dttm
from raw
         distributed by (order_id);
--
insert into niksm_temp_111_taxi_log (order_id, taxi_logging_flg, utc_found_dttm, utc_a_arrived_dttm, utc_a_visited_dttm, utc_b_visited_last_dttm)
with raw as (
    select order_id,
           min(case when backend_status = 'assigned' then utc_status_created_dttm end) as utc_found_dttm,
           min(case when driver_status = 'waiting' then utc_status_created_dttm end)      as utc_a_arrived_dttm,
           min(case when driver_status = 'transporting' then utc_status_created_dttm end) as utc_a_visited_dttm,
           max(case when driver_status = 'complete' then utc_status_created_dttm end)     as utc_b_visited_last_dttm
    from taxi_stg_dbprocessing.order_status_log
    where utc_order_created_dttm >= current_date - 62
      and utc_order_created_dttm <  current_date - 31
    group by order_id
)
select order_id,
       true as taxi_logging_flg,
--        least(utc_created_dttm_log, utc_found_dttm, utc_a_arrived_dttm, utc_a_visited_dttm, utc_b_visited_last_dttm) as utc_created_dttm,
       utc_found_dttm,
       utc_a_arrived_dttm,
       utc_a_visited_dttm,
       utc_b_visited_last_dttm
from raw;
--
insert into niksm_temp_111_taxi_log (order_id, taxi_logging_flg, utc_found_dttm, utc_a_arrived_dttm, utc_a_visited_dttm, utc_b_visited_last_dttm)
with raw as (
    select order_id,
           min(case when backend_status = 'assigned' then utc_status_created_dttm end) as utc_found_dttm,
           min(case when driver_status = 'waiting' then utc_status_created_dttm end)      as utc_a_arrived_dttm,
           min(case when driver_status = 'transporting' then utc_status_created_dttm end) as utc_a_visited_dttm,
           max(case when driver_status = 'complete' then utc_status_created_dttm end)     as utc_b_visited_last_dttm
    from taxi_stg_dbprocessing.order_status_log
    where utc_order_created_dttm >= current_date - 31
    group by order_id
)
select order_id,
       true as taxi_logging_flg,
--        least(utc_created_dttm_log, utc_found_dttm, utc_a_arrived_dttm, utc_a_visited_dttm, utc_b_visited_last_dttm) as utc_created_dttm,
       utc_found_dttm,
       utc_a_arrived_dttm,
       utc_a_visited_dttm,
       utc_b_visited_last_dttm
from raw;
--
analyze niksm_temp_111_taxi_log;


------------------------------------------------------------------------------------------------------------------------
--== sales ==--
drop table if exists niksm_temp_111_sales;
create temporary table niksm_temp_111_sales as
--
with raw as (
    select fct.order_id,
           fct.corp_contract_id,
           coalesce(fct.corp_client_id, ph.corp_client_id) as corp_client_id,

--        когда-нибудь поменять на claims.utc_created_dttm или claims.utc_due_dttm;
--        пока оставляем для сопоставимости
           fct.msk_order_created_dt as calday,
           --
           case when (ndd.claim_id is not null) then 'NDD'
                when fct.tariff_class_code in ('courier') then 'Курьер'
                when fct.tariff_class_code in ('express') then 'Доставка'
                when fct.tariff_class_code in ('cargo','cargocorp') then 'Грузовой'
                when fct.tariff_class_code in ('night') then 'SDD'
               end as product,
           fct.tariff_geo_zone_code as tariff_zone,
           geonode.name_ru as city,
           geonode.name_en as city_en,
           --
           coalesce(cargo_log.deliveries_total, fct.delivery_plan_point_cnt) as deliveries_total,
           coalesce(cargo_log.deliveries_cnt, fct.delivery_point_cnt) as deliveries_cnt,
           --
           case when cargo_log.order_id is not null and cargo_log.deliveries_cnt > 0
                    then fct.transporting_distance_plan_km / segments_success_per_order
                when fct.success_order_flg then fct.transporting_distance_plan_km
                else 0 end as distance,
           case when cargo_log.order_id is not null and cargo_log.deliveries_cnt > 0
                    then fct.gmv_amt * fct.currency_rate / segments_success_per_order
                when fct.success_order_flg then fct.gmv_amt * fct.currency_rate
                else 0 end as gmv,
           case when cargo_log.order_id is not null and cargo_log.deliveries_cnt > 0
                    then fct.net_inflow_amt * fct.currency_rate / segments_success_per_order
                when fct.success_order_flg then fct.net_inflow_amt * fct.currency_rate
                else 0 end as net_inflow,
           ----
           segment_status,
           --
           coalesce( cargo_logging_flg or taxi_logging_flg, false) as logging_flg,
           case when cargo_logging_flg then cargo_log.utc_created_dttm
                else fct.utc_order_created_dttm
               end as utc_created_dttm,
           case when cargo_logging_flg then cargo_log.utc_found_dttm
                when taxi_logging_flg then taxi_log.utc_found_dttm
               end as utc_found_dttm,
           case when cargo_logging_flg then cargo_log.utc_a_arrived_dttm
                when taxi_logging_flg then taxi_log.utc_a_arrived_dttm
               end as utc_a_arrived_dttm,
           case when cargo_logging_flg then cargo_log.utc_a_visited_dttm
                when taxi_logging_flg then taxi_log.utc_a_visited_dttm
               end as utc_a_visited_dttm,
           case when cargo_logging_flg then cargo_log.utc_b_visited_last_dttm
                when taxi_logging_flg then taxi_log.utc_b_visited_last_dttm
               end as utc_b_visited_last_dttm,
           --
           case when cargo_log.order_id is not null
                    then
                    case when segment_status in ('performer_not_found') then 'expired'
                         when segment_status in ('failed') then 'failed'
                         when segment_status in ('cancelled_by_taxi') then 'cancelled_by_courier'
                         when segment_status in ('cancelled','cancelled_with_items_on_hands','cancelled_with_payment') then 'cancelled_by_client'
                        end
                else
                    case when fct.driver_status in ('expired') then 'expired'
                         when fct.driver_status in ('failed') then 'failed'
                         when fct.driver_status in ('cancelled') then 'cancelled_by_courier'
                         when fct.user_status in ('cancelled') then 'cancelled_by_client'
                        end
               end as final_status,
           --
           segment_status in ('cancelled','cancelled_by_taxi','cancelled_with_items_on_hands','cancelled_with_payment','failed','performer_not_found')
               or fct.driver_status in ('failed','expired','cancelled')
               or fct.user_status in ('cancelled')
               as cancelled_flg,
           case when
                            segment_status in ('cancelled','cancelled_by_taxi','cancelled_with_items_on_hands','cancelled_with_payment','failed','performer_not_found')
                        or fct.driver_status in ('failed','expired','cancelled')
                        or fct.user_status in ('cancelled')
                    then utc_resolved_at_dttm end as utc_cancelled_dttm,

           case when cargo_log.order_id is not null
                    then cargo_log.utc_due_dttm is null or cargo_log.utc_due_dttm <= (cargo_log.utc_created_dttm + interval '30 minutes')
                else fct.order_type = 'soon' or fct.utc_order_due_dttm <= (fct.utc_order_created_dttm + interval '30 minutes')
               end as soon_order
    from taxi_cdm_marketplace.fct_order_metric as fct
             join snb_delivery.logdata_delivery_tariff as trf
                  on trf.order_tariff = fct.tariff_class_code
                      and fct.utc_order_created_dttm between utc_datefrom and utc_dateto
             left join niksm_temp_dash_robot_phoenix_claim ph
                       on ph.taxi_order_id = fct.order_id
        -- status log --
             left join niksm_temp_111_cargo_log as cargo_log         -- тут может быть 2 строки с order_id, см segments_success_per_order
                       on cargo_log.order_id = fct.order_id
             left join niksm_temp_111_taxi_log as taxi_log
                       on taxi_log.order_id = fct.order_id
        -- NDD --
             left join snb_b2b.niksm_k2_lavka_claims as ndd
                       on ndd.claim_id = cargo_log.claim_id
        -- city name --
             left join taxi_cdm_geo.dim_geo_node geonode
                       on geonode.node_id = fct.agglomeration_node_id
                           AND geonode.node_type = 'agglomeration'
                           AND geonode.root_node_id = 'br_root'
    where true
      and fct.utc_order_created_dttm >= current_date - 93 -- for partitioning
      and fct.msk_order_created_dt between current_date - 92 and current_date - 1
--       and dmo.logistic_tariff_flag
--       and dmo.success_order_flg  -- исключаем для расчета CR
      and not fct.fake_order_flg
      and not fct.mqc_order_flg
      and (fct.corp_order_flg or ph.taxi_order_id is not null)
)
   , sls_daily as (
    select corp_client_id,
           corp_contract_id,
           calday,
           product,
           tariff_zone,
           city,
           city_en,
           soon_order,
           ------
           sum(deliveries_total) as deliveries_total,
           sum(deliveries_cnt) as deliveries_cnt,
           sum(case when final_status = 'expired' then deliveries_total end) as deliveries_expired,
           sum(case when final_status = 'failed' then deliveries_total end) as deliveries_failed,
           sum(case when final_status = 'cancelled_by_courier' then deliveries_total end) as deliveries_cancelled_by_courier,
           sum(case when final_status = 'cancelled_by_client' then deliveries_total end) as deliveries_cancelled_by_client,
           --
           sum(case when distance > 0 then deliveries_total end) as deliveries_total_w_distance,
           sum(distance) as distance,
           --
           sum(gmv) as gmv,
           sum(net_inflow) as net_inflow,
           --
           sum(case when coalesce(utc_found_dttm,utc_a_arrived_dttm,utc_a_visited_dttm) is not null or deliveries_cnt>0 then deliveries_total else 0 end) as deliveries_found,
           sum(case when coalesce(utc_a_arrived_dttm,utc_a_visited_dttm) is not null or deliveries_cnt>0 then deliveries_total else 0 end) as deliveries_a_arrived,
           sum(case when utc_a_visited_dttm is not null or deliveries_cnt>0 then deliveries_total else 0 end) as deliveries_a_visited,
           sum(case when cancelled_flg then deliveries_total else 0 end) as deliveries_cancelled,
           ----
           sum(case when utc_found_dttm > utc_created_dttm
                        then deliveries_total end) as dlv_for_searching_time,
           sum(case when utc_found_dttm > utc_created_dttm
                        then extract(epoch from utc_found_dttm - utc_created_dttm) * deliveries_total end) as searching_time_sec,
           --
           sum(case when utc_a_arrived_dttm > utc_found_dttm
                        then deliveries_total end) as dlv_for_driving_to_a_time,
           sum(case when utc_a_arrived_dttm > utc_found_dttm
                        then extract(epoch from utc_a_arrived_dttm - utc_found_dttm) * deliveries_total end) as driving_to_a_time_sec,
           --
           sum(case when utc_a_arrived_dttm > utc_created_dttm
                        then deliveries_total end) as dlv_for_arrival_time,
           sum(case when utc_a_arrived_dttm > utc_created_dttm
                        then extract(epoch from utc_a_arrived_dttm - utc_created_dttm) * deliveries_total end) as arrival_time_sec,
           --
           sum(case when utc_a_visited_dttm > utc_a_arrived_dttm
                        then deliveries_total end) as dlv_for_waiting_a_time,
           sum(case when utc_a_visited_dttm > utc_a_arrived_dttm
                        then extract(epoch from utc_a_visited_dttm - utc_a_arrived_dttm) * deliveries_total end) as waiting_a_time_sec,
           --
           sum(case when utc_b_visited_last_dttm > utc_a_visited_dttm
                        then deliveries_total end) as dlv_for_transporting_time,
           sum(case when utc_b_visited_last_dttm > utc_a_visited_dttm
                        then extract(epoch from utc_b_visited_last_dttm - utc_a_visited_dttm) * deliveries_total end) as transporting_time_sec,
           --
           sum(case when utc_b_visited_last_dttm > utc_created_dttm
                        then deliveries_total end) as dlv_for_total_time,
           sum(case when utc_b_visited_last_dttm > utc_created_dttm
                        then extract(epoch from utc_b_visited_last_dttm - utc_created_dttm) * deliveries_total end) as total_time_sec,
           --
           sum(case when utc_cancelled_dttm > utc_created_dttm
                        then deliveries_total end) as dlv_for_cancellation_time,
           sum(case when utc_cancelled_dttm > utc_created_dttm
                        then extract(epoch from utc_cancelled_dttm - utc_created_dttm) * deliveries_total end) as cancellation_time_sec,
           --
           sum(case when final_status = 'cancelled_by_client' and logging_flg and utc_found_dttm is null and utc_cancelled_dttm > utc_created_dttm
                        then deliveries_total end) as dlv_for_cancellation_before_found_time,
           sum(case when final_status = 'cancelled_by_client' and logging_flg and utc_found_dttm is null and utc_cancelled_dttm > utc_created_dttm
                        then extract(epoch from utc_cancelled_dttm - utc_created_dttm) * deliveries_total end) as cancellation_before_found_time_sec
    from raw
    group by corp_client_id,
             corp_contract_id,
             calday,
             product,
             tariff_zone,
             city,
             city_en,
             soon_order
)
select sls_daily.*,
       --
       cl_type.cntr_prev_cld_type_id,
       cl_type.cntr_prev_clw_type_id,
       cl_type.cntr_prev_clm_type_id,
       cl_type.first_delivery_dt
from sls_daily
         left join niksm_temp_111_cl_type as cl_type
                   on cl_type.corp_contract_id = sls_daily.corp_contract_id
                       and cl_type.corp_client_id = sls_daily.corp_client_id
                       and cl_type.calday = sls_daily.calday
    distributed by (corp_contract_id);
--
analyze niksm_temp_111_sales;
--======================================================================================================================
drop table if exists niksm_dash_logdata111_fin;
create temporary table  niksm_dash_logdata111_fin as
--
select contract_id,
       --
       lk_client_id,
       lk_client_name,
       which_crm,
       deal_id,
       add_contract_flg,
       contract_terminated_flg,
       crm_link,
       client_name,
       holding_name,
       deal_title,
       potential,
       country,
       market_segment,
       tier,
       manager_name,
       lead_name,
       department_name,
       permissions,
       manager_group,
       payment_type,
       last_activity_date, next_activity_date,
       quasi_flg,
       deactivate_threshold,
       balance,
       invoice_payments_sum,
       debt,
       debt00,
       overdue_clean_debt,
       activated_dt,
       last_payment_dt,
       --
       tariffs.tariff_plan_name as tariff_plan_series_name,
       --
       NULL::date             as calday,
       NULL::text             as product,
       NULL::text             as tariff_zone,
       NULL::text             as city,
       NULL::text             as city_en,
       NULL::bool             as soon_order,
       --
       NULL::bigint           as deliveries_total,
       NULL::bigint           as deliveries_cnt,
       NULL::bigint           as deliveries_expired,
       NULL::bigint           as deliveries_failed,
       NULL::bigint           as deliveries_cancelled_by_courier,
       NULL::bigint           as deliveries_cancelled_by_client,
       NULL::bigint           as deliveries_total_w_distance,
       NULL::double precision as distance,
       NULL::double precision as gmv,
       NULL::double precision as net_inflow,
       NULL::bigint           as deliveries_found,
       NULL::bigint           as deliveries_a_arrived,
       NULL::bigint           as deliveries_a_visited,
       NULL::bigint           as deliveries_cancelled,
       NULL::bigint           as dlv_for_searching_time,
       NULL::double precision as searching_time_sec,
       NULL::bigint           as dlv_for_driving_to_a_time,
       NULL::double precision as driving_to_a_time_sec,
       NULL::bigint           as dlv_for_arrival_time,
       NULL::double precision as arrival_time_sec,
       NULL::bigint           as dlv_for_waiting_a_time,
       NULL::double precision as waiting_a_time_sec,
       NULL::bigint           as dlv_for_transporting_time,
       NULL::double precision as transporting_time_sec,
       NULL::bigint           as dlv_for_total_time,
       NULL::double precision as total_time_sec,
       NULL::bigint           as dlv_for_cancellation_time,
       NULL::double precision as cancellation_time_sec,
       NULL::bigint           as dlv_for_cancellation_before_found_time,
       NULL::double precision as cancellation_before_found_time_sec,
       NULL::int              as cntr_prev_cld_type_id,
       NULL::int              as cntr_prev_clw_type_id,
       NULL::int              as cntr_prev_clm_type_id,
       NULL::date             as first_delivery_dt,
       NULL::text             as category,
       NULL::text             as theme_1,
       NULL::text             as theme_2,
       NULL::text             as theme_3,
       NULL::text             as theme_4,
       NULL::int              as tickets_cnt,
       NULL::date             as last_full_date
from niksm_temp_111_cntr_enrich cntr_enrich
         left join snb_b2b.dbcorp_client_tariff_plan_current tariffs
                   on tariffs.corp_client_id = cntr_enrich.lk_client_id and tariffs.service_name = 'cargo'::text;

------------------------------------------------------------------
insert into niksm_dash_logdata111_fin
(contract_id,
 lk_client_id, lk_client_name, which_crm, deal_id, add_contract_flg, contract_terminated_flg, crm_link, client_name, holding_name, deal_title,
 country, market_segment, tier, manager_name, lead_name, department_name, permissions, manager_group,
 payment_type, quasi_flg,
 calday, product, tariff_zone, city, city_en, soon_order,
 deliveries_total, deliveries_cnt, deliveries_expired, deliveries_failed, deliveries_cancelled_by_courier, deliveries_cancelled_by_client,
 deliveries_total_w_distance, distance,
 gmv, net_inflow,
 deliveries_found, deliveries_a_arrived, deliveries_a_visited, deliveries_cancelled,
 dlv_for_searching_time, searching_time_sec,
 dlv_for_driving_to_a_time, driving_to_a_time_sec,
 dlv_for_arrival_time, arrival_time_sec,
 dlv_for_waiting_a_time, waiting_a_time_sec,
 dlv_for_transporting_time, transporting_time_sec,
 dlv_for_total_time, total_time_sec,
 dlv_for_cancellation_time, cancellation_time_sec,
 dlv_for_cancellation_before_found_time, cancellation_before_found_time_sec,
 cntr_prev_cld_type_id, cntr_prev_clw_type_id, cntr_prev_clm_type_id, first_delivery_dt)
--
select contract_id,
       --
       lk_client_id,
       lk_client_name,
       which_crm,
       deal_id,
       add_contract_flg,
       contract_terminated_flg,
       crm_link,
       client_name,
       holding_name,
       deal_title,
       country,
       market_segment,
       tier,
       manager_name,
       lead_name,
       department_name,
       permissions,
       manager_group,
       payment_type,
       quasi_flg,
       --
       calday,
       product,
       tariff_zone,
       city,
       city_en,
       soon_order,
       --
       deliveries_total, deliveries_cnt, deliveries_expired, deliveries_failed, deliveries_cancelled_by_courier, deliveries_cancelled_by_client,
       deliveries_total_w_distance, distance,
       gmv, net_inflow,
       deliveries_found, deliveries_a_arrived, deliveries_a_visited, deliveries_cancelled,
       dlv_for_searching_time, searching_time_sec,
       dlv_for_driving_to_a_time, driving_to_a_time_sec,
       dlv_for_arrival_time, arrival_time_sec,
       dlv_for_waiting_a_time, waiting_a_time_sec,
       dlv_for_transporting_time, transporting_time_sec,
       dlv_for_total_time, total_time_sec,
       dlv_for_cancellation_time, cancellation_time_sec,
       dlv_for_cancellation_before_found_time, cancellation_before_found_time_sec,
       --
       cntr_prev_cld_type_id,
       cntr_prev_clw_type_id,
       cntr_prev_clm_type_id,
       first_delivery_dt
from niksm_temp_111_cntr_enrich cntr_enrich
         left join niksm_temp_111_sales sales
                   on cntr_enrich.contract_id = sales.corp_contract_id;

------------------------------------------------------------------
insert into niksm_dash_logdata111_fin
(contract_id,
 which_crm, deal_id, add_contract_flg, contract_terminated_flg, crm_link, client_name, holding_name, deal_title,
 country, market_segment, tier, manager_name, lead_name, department_name, permissions, manager_group,
 calday, product, tariff_zone, city, city_en, soon_order,
 deliveries_total, deliveries_cnt, deliveries_expired, deliveries_failed, deliveries_cancelled_by_courier, deliveries_cancelled_by_client,
 deliveries_total_w_distance, distance,
 gmv, net_inflow,
 deliveries_found, deliveries_a_arrived, deliveries_a_visited, deliveries_cancelled,
 dlv_for_searching_time, searching_time_sec,
 dlv_for_driving_to_a_time, driving_to_a_time_sec,
 dlv_for_arrival_time, arrival_time_sec,
 dlv_for_waiting_a_time, waiting_a_time_sec,
 dlv_for_transporting_time, transporting_time_sec,
 dlv_for_total_time, total_time_sec,
 dlv_for_cancellation_time, cancellation_time_sec,
 dlv_for_cancellation_before_found_time, cancellation_before_found_time_sec,
 cntr_prev_cld_type_id, cntr_prev_clw_type_id, cntr_prev_clm_type_id, first_delivery_dt,
 payment_type)
--
select clnt_enrich.corp_client_id as contract_id,
       --
       which_crm,
       deal_id,
       add_contract_flg,
       contract_terminated_flg,
       crm_link,
       client_name,
       holding_name,
       deal_title,
       country,
       market_segment,
       tier,
       manager_name,
       lead_name,
       department_name,
       permissions,
       manager_group,
       --
       calday,
       product,
       tariff_zone,
       city,
       city_en,
       soon_order,
       --
       deliveries_total, deliveries_cnt, deliveries_expired, deliveries_failed, deliveries_cancelled_by_courier, deliveries_cancelled_by_client,
       deliveries_total_w_distance, distance,
       gmv, net_inflow,
       deliveries_found, deliveries_a_arrived, deliveries_a_visited, deliveries_cancelled,
       dlv_for_searching_time, searching_time_sec,
       dlv_for_driving_to_a_time, driving_to_a_time_sec,
       dlv_for_arrival_time, arrival_time_sec,
       dlv_for_waiting_a_time, waiting_a_time_sec,
       dlv_for_transporting_time, transporting_time_sec,
       dlv_for_total_time, total_time_sec,
       dlv_for_cancellation_time, cancellation_time_sec,
       dlv_for_cancellation_before_found_time, cancellation_before_found_time_sec,
       --
       cntr_prev_cld_type_id,
       cntr_prev_clw_type_id,
       cntr_prev_clm_type_id,
       first_delivery_dt,
       payment_type
from niksm_temp_111_phoenix_client_enrich clnt_enrich
         left join niksm_temp_111_sales sales
                   on clnt_enrich.corp_client_id = sales.corp_client_id;

------------------------------------------------------------------
insert into niksm_dash_logdata111_fin
(contract_id, calday,
 lk_client_id, lk_client_name, which_crm, deal_id, add_contract_flg, contract_terminated_flg, crm_link, client_name, holding_name, deal_title,
 country, market_segment, tier, manager_name, lead_name, department_name, permissions, manager_group,
 payment_type, quasi_flg,
 category, theme_1, theme_2, theme_3, theme_4, tickets_cnt)
--
with tickets as (
    select contract_id,
           creation_dt::date as calday,
           category, theme_1, theme_2, theme_3, theme_4,
           count() as tickets_cnt
    from snb_b2b.ankozik_ticket_contract as tkt
    where contract_id is not null
      and creation_dt between (current_date - 92)::text and (current_date - 1)::text
    group by contract_id,
             creation_dt::date,
             category, theme_1, theme_2, theme_3, theme_4
)
select cntr_enrich.contract_id,
       calday,
       lk_client_id, lk_client_name, which_crm, deal_id, add_contract_flg, contract_terminated_flg, crm_link, client_name, holding_name, deal_title,
       country, market_segment, tier, manager_name, lead_name, department_name, permissions, manager_group,
       payment_type, quasi_flg,
       category, theme_1, theme_2, theme_3, theme_4,
       tickets_cnt
from niksm_temp_111_cntr_enrich cntr_enrich
         join tickets
              on cntr_enrich.contract_id = tickets.contract_id;

------------------------------------------------------------------
update niksm_dash_logdata111_fin
set last_full_date = (
    select least(last_claims_date, last_fct_date
               , last_dls_date
               ) as last_full_date
    from (
             select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
             from delivery_ods_cargo_claims.claim
             where utc_created_dttm >= current_date - 7
         ) cc
             cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
    ) fct
             cross join (
        select (max(_etl_processed_dttm) at time zone 'UTC' at time zone 'Europe/Moscow')::date as last_dls_date
        from snb_b2b.amo_contracts_info
    ) dls
)
where true;
analyze niksm_dash_logdata111_fin;
--======================================================================================================================
drop table if exists akorchagina24_temp_calendar;
create temporary table  akorchagina24_temp_calendar
as
select
    distinct
    calday,
    case when calday = last_full_date then true else false end as yesterday_flg,
    case when calday = last_full_date - interval '7 day' then true else false end as yesterday_prev_flg,

    case when calday between date_trunc('week', last_full_date) and last_full_date then true else false end as wtd_flg,
    case when calday between date_trunc('week', last_full_date) - interval '7 day' and last_full_date - interval '7 day' then true else false end as wtd_prev_flg,

    case when calday between date_trunc('week', last_full_date + interval '1 day') - interval '1 week' and date_trunc('week', last_full_date + interval '1 day') - interval '1 day' then true else false end as lfw_flg,
    case when calday between date_trunc('week', last_full_date + interval '1 day') - interval '2 week' and date_trunc('week', last_full_date + interval '1 day') - interval '8 day' then true else false end as lfw_prev_flg,

    case when calday between date_trunc('month', last_full_date) and last_full_date then true else false end as mtd_flg,
    case when calday between date_trunc('month', last_full_date) - interval '1 month' and last_full_date - interval '1 month' then true else false end as mtd_prev_flg,

    case when calday between date_trunc('month', last_full_date + interval '1 day') - interval '1 month' and date_trunc('month', last_full_date + interval '1 day') - interval '1 day' then true else false end as lfm_flg,
    case when calday between date_trunc('month', last_full_date + interval '1 day') - interval '2 month' and date_trunc('month', last_full_date + interval '1 day') - interval '1 month 1 day' then true else false end as lfm_prev_flg,


    case when calday between last_full_date - interval '6 day' and last_full_date then true else false end as l7d_flg,
    case when calday between last_full_date - interval '13 day' and last_full_date - interval '7 day' then true else false end as l7d_prev_flg,

    case when calday between last_full_date - interval '29 day' and last_full_date then true else false end as l30d_flg,
    case when calday between last_full_date - interval '59 day' and last_full_date - interval '30 day' then true else false end as l30d_prev_flg

from niksm_dash_logdata111_fin
;

drop table if exists akorchagina24_temp_addition_calc;
create temporary table  akorchagina24_temp_addition_calc
as
select
    contract_id,
    max(activated_dt) as max_activated_dt,
    max(last_full_date) as last_full_date,

    -------------For churn, no deliveries, dlv falling-------------------------
    sum(deliveries_cnt) filter (where yesterday_flg) as deliveries_y,
    sum(deliveries_cnt) filter (where yesterday_prev_flg) as deliveries_y_prev,
    sum(deliveries_cnt) filter (where wtd_flg) as deliveries_wtd,
    sum(deliveries_cnt) filter (where wtd_prev_flg) as deliveries_wtd_prev,
    sum(deliveries_cnt) filter (where lfw_flg) as deliveries_lfw,
    sum(deliveries_cnt) filter (where lfw_prev_flg) as deliveries_lfw_prev,
    sum(deliveries_cnt) filter (where mtd_flg) as deliveries_mtd,
    sum(deliveries_cnt) filter (where mtd_prev_flg) as deliveries_mtd_prev,
    sum(deliveries_cnt) filter (where lfm_flg) as deliveries_lfm,
    sum(deliveries_cnt) filter (where lfm_prev_flg) as deliveries_lfm_prev,
    sum(deliveries_cnt) filter (where l7d_flg) as deliveries_7d,
    sum(deliveries_cnt) filter (where l7d_prev_flg) as deliveries_7d_prev,
    sum(deliveries_cnt) filter (where l30d_flg) as deliveries_30d,
    sum(deliveries_cnt) filter (where l30d_prev_flg) as deliveries_30d_prev,
    -----------------------------------------------------
    -------------For low balance-------------------------
    max(balance) - coalesce(max(deactivate_threshold), 0) as threshold_balance,
    sum(case when l7d_flg then gmv else 0 end)/7 as gmv_daily,
    max(payment_type) as payment_type,
    -----------------------------------------------------
    -------------For CR------------------------------
    sum(deliveries_total) filter (where yesterday_flg) as applications_y,
    sum(deliveries_total) filter (where wtd_flg) as applications_wtd,
    sum(deliveries_total) filter (where lfw_flg) as applications_lfw,
    sum(deliveries_total) filter (where mtd_flg) as applications_mtd,
    sum(deliveries_total) filter (where lfm_flg) as applications_lfm,
    sum(deliveries_total) filter (where l7d_flg) as applications_7d,
    sum(deliveries_total) filter (where l30d_flg) as applications_30d

from niksm_dash_logdata111_fin as tbl
         left join akorchagina24_temp_calendar as cld
                   on tbl.calday = cld.calday
group by
    contract_id
;

drop table if exists akorchagina24_temp_extended_table;
create temporary table  akorchagina24_temp_extended_table
as
select
    contract_id,
    case when max_activated_dt is not null then true else false end as active_flg,
    --------------------churn--------------------
    case when deliveries_y_prev > 0 and coalesce(deliveries_y,0) = 0 and max_activated_dt is not null then true else false end as churn_y_flg,
    case when deliveries_wtd_prev > 0 and coalesce(deliveries_wtd,0) = 0 and max_activated_dt is not null then true else false end as churn_wtd_flg,
    case when deliveries_lfw_prev > 0 and coalesce(deliveries_lfw,0) = 0 and max_activated_dt is not null  then true else false end as churn_lfw_flg,
    case when deliveries_mtd_prev > 0 and coalesce(deliveries_mtd,0) = 0 and max_activated_dt is not null  then true else false end as churn_mtd_flg,
    case when deliveries_lfm_prev > 0 and coalesce(deliveries_lfm,0) = 0 and max_activated_dt is not null  then true else false end as churn_lfm_flg,
    case when deliveries_7d_prev > 0 and coalesce(deliveries_7d,0) = 0 and max_activated_dt is not null  then true else false end as churn_7d_flg,
    case when deliveries_30d_prev > 0 and coalesce(deliveries_30d,0) = 0 and max_activated_dt is not null  then true else false end as churn_30d_flg,
    ---------------------------------------------
    -----------low balance-----------------------
    case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end as low_balance_flg,
    -----------------------------------------------
    -----------no deliveries-----------------------
    case when max_activated_dt is not null and coalesce(deliveries_y,0) = 0
        and --low_balance_flg--
              not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
             then true else false end as no_deliveries_y_flg,
    case when max_activated_dt is not null and coalesce(deliveries_wtd,0) = 0
        and --low_balance_flg--
              not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
             then true else false end as no_deliveries_wtd_flg,
    case when max_activated_dt is not null and coalesce(deliveries_lfw,0) = 0
        and --low_balance_flg--
              not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
             then true else false end as no_deliveries_lfw_flg,
    case when max_activated_dt is not null and coalesce(deliveries_mtd,0) = 0
        and --low_balance_flg--
              not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
             then true else false end as no_deliveries_mtd_flg,
    case when max_activated_dt is not null and coalesce(deliveries_lfm,0) = 0
        and --low_balance_flg--
              not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
             then true else false end as no_deliveries_lfm_flg,
    case when max_activated_dt is not null and coalesce(deliveries_7d,0) = 0
        and --low_balance_flg--
              not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
             then true else false end as no_deliveries_7d_flg,
    case when max_activated_dt is not null and coalesce(deliveries_30d,0) = 0
        and --low_balance_flg--
              not (case when max_activated_dt is not null and (threshold_balance < gmv_daily * 4 or threshold_balance = 0) and payment_type = 'предоплата' then true else false end)
             then true else false end as no_deliveries_30d_flg,
    ---------------------------------------------
    -----------dlv falling-----------------------
    case when max_activated_dt is not null and coalesce(deliveries_y,0) - coalesce(deliveries_y_prev,0) <= 0 then true else false end as dlv_falling_y_flg,
    case when max_activated_dt is not null and coalesce(deliveries_wtd,0) - coalesce(deliveries_wtd_prev,0) <= 0 then true else false end as dlv_falling_wtd_flg,
    case when max_activated_dt is not null and coalesce(deliveries_lfw,0) - coalesce(deliveries_lfw_prev,0) <= 0 then true else false end as dlv_falling_lfw_flg,
    case when max_activated_dt is not null and coalesce(deliveries_mtd,0) - coalesce(deliveries_mtd_prev,0) <= 0 then true else false end as dlv_falling_mtd_flg,
    case when max_activated_dt is not null and coalesce(deliveries_lfm,0) - coalesce(deliveries_lfm_prev,0) <= 0 then true else false end as dlv_falling_lfm_flg,
    case when max_activated_dt is not null and coalesce(deliveries_7d,0) - coalesce(deliveries_7d_prev,0) <= 0 then true else false end as dlv_falling_7d_flg,
    case when max_activated_dt is not null and coalesce(deliveries_30d,0) - coalesce(deliveries_30d_prev,0) <= 0 then true else false end as dlv_falling_30d_flg,
    ---------------------------------------------
    -----------dlv growing-----------------------
    case when max_activated_dt is not null and coalesce(deliveries_y,0) - coalesce(deliveries_y_prev,0) > 0 then true else false end as dlv_growing_y_flg,
    case when max_activated_dt is not null and coalesce(deliveries_wtd,0) - coalesce(deliveries_wtd_prev,0) > 0 then true else false end as dlv_growing_wtd_flg,
    case when max_activated_dt is not null and coalesce(deliveries_lfw,0) - coalesce(deliveries_lfw_prev,0) > 0 then true else false end as dlv_growing_lfw_flg,
    case when max_activated_dt is not null and coalesce(deliveries_mtd,0) - coalesce(deliveries_mtd_prev,0) > 0 then true else false end as dlv_growing_mtd_flg,
    case when max_activated_dt is not null and coalesce(deliveries_lfm,0) - coalesce(deliveries_lfm_prev,0) > 0 then true else false end as dlv_growing_lfm_flg,
    case when max_activated_dt is not null and coalesce(deliveries_7d,0) - coalesce(deliveries_7d_prev,0) > 0 then true else false end as dlv_growing_7d_flg,
    case when max_activated_dt is not null and coalesce(deliveries_30d,0) - coalesce(deliveries_30d_prev,0) > 0 then true else false end as dlv_growing_30d_flg,
    ---------------------------------------------
    -----------CR--------------------------------
    case when coalesce(applications_y,0) >0 then coalesce(deliveries_y,0)/applications_y else 0 end as cr_y,
    case when coalesce(applications_wtd,0) >0 then coalesce(deliveries_wtd,0)/applications_wtd else 0 end as cr_wtd,
    case when coalesce(applications_lfw,0) >0 then coalesce(deliveries_lfw,0)/applications_lfw else 0 end as cr_lfw,
    case when coalesce(applications_mtd,0) >0 then coalesce(deliveries_mtd,0)/applications_mtd else 0 end as cr_mtd,
    case when coalesce(applications_lfm,0) >0 then coalesce(deliveries_lfm,0)/applications_lfm else 0 end as cr_lfm,
    case when coalesce(applications_7d,0) >0 then coalesce(deliveries_7d,0)/applications_7d else 0 end as cr_7d,
    case when coalesce(applications_30d,0) >0 then coalesce(deliveries_30d,0)/applications_30d else 0 end as cr_30d,
    ----------------------------------------
    -----------Newbie-----------------------
    case when max_activated_dt is not null and last_full_date - max_activated_dt <=35 then true else false end as newbie_flg
    ----------------------------------------
from akorchagina24_temp_addition_calc
;

drop table if exists akorchagina24_logdata111_report_tables;
create temporary table  akorchagina24_logdata111_report_tables as

select
    tbl.contract_id, tbl.lk_client_id, tbl.lk_client_name, tbl.which_crm, tbl.deal_id, tbl.add_contract_flg, tbl.contract_terminated_flg, tbl.crm_link,
    tbl.client_name, tbl.holding_name, tbl.deal_title, tbl.potential, tbl.country, tbl.market_segment,
    tbl.tier, tbl.manager_name, tbl.lead_name, tbl.department_name, tbl.permissions, tbl.manager_group,
    tbl.payment_type, tbl.last_activity_date, tbl.next_activity_date, tbl.quasi_flg, tbl.deactivate_threshold,
    tbl.balance, tbl.invoice_payments_sum,tbl.debt, tbl.debt00, tbl.overdue_clean_debt, tbl.activated_dt, tbl.last_payment_dt,
    tbl.tariff_plan_series_name,
    tbl.calday, tbl.product, tbl.tariff_zone, tbl.city, tbl.city_en, tbl.soon_order,
    tbl.deliveries_total, tbl.deliveries_cnt, tbl.deliveries_expired, tbl.deliveries_failed, tbl.deliveries_cancelled_by_courier,
    tbl.deliveries_cancelled_by_client,
    tbl.deliveries_total_w_distance, tbl.distance,
    tbl.gmv, tbl.net_inflow,
    tbl.deliveries_found, tbl.deliveries_a_arrived, tbl.deliveries_a_visited, tbl.deliveries_cancelled,
    tbl.dlv_for_searching_time, tbl.searching_time_sec,
    tbl.dlv_for_driving_to_a_time, tbl.driving_to_a_time_sec,
    tbl.dlv_for_arrival_time, tbl.arrival_time_sec,
    tbl.dlv_for_waiting_a_time, tbl.waiting_a_time_sec,
    tbl.dlv_for_transporting_time, tbl.transporting_time_sec,
    tbl.dlv_for_total_time, tbl.total_time_sec,
    tbl.dlv_for_cancellation_time, tbl.cancellation_time_sec,
    tbl.dlv_for_cancellation_before_found_time, tbl.cancellation_before_found_time_sec,
    tbl.cntr_prev_cld_type_id, tbl.cntr_prev_clw_type_id, tbl.cntr_prev_clm_type_id, tbl.first_delivery_dt,
    tbl.category, tbl.theme_1, tbl.theme_2, tbl.theme_3, tbl.theme_4, tbl.tickets_cnt,
    tbl.last_full_date,
    cld.yesterday_flg as y_flg, cld.wtd_flg, cld.lfw_flg, cld.mtd_flg, cld.lfm_flg, cld.l7d_flg, cld.l30d_flg,
    cld.yesterday_prev_flg as y_prev_flg, cld.wtd_prev_flg, cld.lfw_prev_flg, cld.mtd_prev_flg, cld.lfm_prev_flg, cld.l7d_prev_flg, cld.l30d_prev_flg,
    ext.active_flg,
    ext.churn_y_flg, ext.churn_wtd_flg, ext.churn_lfw_flg, ext.churn_mtd_flg, ext.churn_lfm_flg, ext.churn_7d_flg, ext.churn_30d_flg,
    ext.low_balance_flg,
    ext.no_deliveries_y_flg, ext.no_deliveries_wtd_flg, ext.no_deliveries_lfw_flg, ext.no_deliveries_mtd_flg, ext.no_deliveries_lfm_flg, ext.no_deliveries_7d_flg, ext.no_deliveries_30d_flg,
    ext.dlv_falling_y_flg, ext.dlv_falling_wtd_flg, ext.dlv_falling_lfw_flg, ext.dlv_falling_mtd_flg, ext.dlv_falling_lfm_flg, ext.dlv_falling_7d_flg, ext.dlv_falling_30d_flg,
    ext.dlv_growing_y_flg, ext.dlv_growing_wtd_flg, ext.dlv_growing_lfw_flg, ext.dlv_growing_mtd_flg, ext.dlv_growing_lfm_flg, ext.dlv_growing_7d_flg, ext.dlv_growing_30d_flg,
    ext.cr_y, ext.cr_wtd, ext.cr_lfw, ext.cr_mtd, ext.cr_lfm, ext.cr_7d, ext.cr_30d,
    ext.newbie_flg,
    case
        when credit_rating in ('A', 'B', 'B+', 'B-')
         then 7
         when invoice_payments_sum = 0 then 1
        when  quasi_flg=1
        then 7
        when (tbl.invoice_payments_sum/case when (tbl.invoice_payments_sum+tbl.debt) = 0
                                                 then 1.0
                                             else (tbl.invoice_payments_sum+tbl.debt)
        end)::float4 < 0.5 then 3
         when (tbl.invoice_payments_sum/case when (tbl.invoice_payments_sum+tbl.debt) = 0
                                                 then 1.0
                                             else (tbl.invoice_payments_sum+tbl.debt)
             end)::float4 < 0.8 then 5
         when (tbl.invoice_payments_sum/case when (tbl.invoice_payments_sum+tbl.debt) = 0
                                                 then 1.0
                                             else (tbl.invoice_payments_sum+tbl.debt)
             end)::float4 <= 1  then 7
    end as date1

from niksm_dash_logdata111_fin as tbl
         left join akorchagina24_temp_calendar as cld
                   on tbl.calday = cld.calday
         left join akorchagina24_temp_extended_table ext
                   on ext.contract_id = tbl.contract_id
         left join snb_b2b.amo_contracts_info ci
                   on ci.lead_id = tbl.deal_id;

analyze akorchagina24_logdata111_report_tables;

--===============================================
drop table if exists temp_tables;
create temporary table  temp_tables as
select *,
       (date_trunc('month', current_date) + interval '14 days' + make_interval(days:=date1))::date as deactivation_date

from akorchagina24_logdata111_report_tables;
--====================================================================================================================--

-- drop table if exists snb_b2b.niksm_dash_logdata111;
-- create table snb_b2b.niksm_dash_logdata111 as
truncate table snb_b2b.niksm_dash_logdata111;
insert into snb_b2b.niksm_dash_logdata111
(
    contract_id, lk_client_id, lk_client_name, which_crm, deal_id, add_contract_flg, contract_terminated_flg, crm_link,
    client_name, holding_name, deal_title, potential, country, market_segment, tier, manager_name, lead_name,
    department_name, permissions, manager_group, payment_type, last_activity_date, next_activity_date, quasi_flg,
    deactivate_threshold, balance, invoice_payments_sum, debt, debt00, overdue_clean_debt, activated_dt, last_payment_dt, tariff_plan_series_name,
    calday, product, tariff_zone, city, city_en, soon_order, deliveries_total, deliveries_cnt, deliveries_expired,
    deliveries_failed, deliveries_cancelled_by_courier, deliveries_cancelled_by_client, deliveries_total_w_distance,
    distance, gmv, net_inflow, deliveries_found, deliveries_a_arrived, deliveries_a_visited, deliveries_cancelled,
    dlv_for_searching_time, searching_time_sec, dlv_for_driving_to_a_time, driving_to_a_time_sec, dlv_for_arrival_time,
    arrival_time_sec, dlv_for_waiting_a_time, waiting_a_time_sec, dlv_for_transporting_time, transporting_time_sec,
    dlv_for_total_time, total_time_sec, dlv_for_cancellation_time, cancellation_time_sec, dlv_for_cancellation_before_found_time,
    cancellation_before_found_time_sec, cntr_prev_cld_type_id, cntr_prev_clw_type_id, cntr_prev_clm_type_id,
    first_delivery_dt, category, theme_1, theme_2, theme_3, theme_4, tickets_cnt, last_full_date, y_flg, wtd_flg,
    lfw_flg, mtd_flg, lfm_flg, l7d_flg, l30d_flg, y_prev_flg, wtd_prev_flg, lfw_prev_flg, mtd_prev_flg, lfm_prev_flg,
    l7d_prev_flg, l30d_prev_flg, active_flg, churn_y_flg, churn_wtd_flg, churn_lfw_flg, churn_mtd_flg, churn_lfm_flg,
    churn_7d_flg, churn_30d_flg, low_balance_flg, no_deliveries_y_flg, no_deliveries_wtd_flg, no_deliveries_lfw_flg,
    no_deliveries_mtd_flg, no_deliveries_lfm_flg, no_deliveries_7d_flg, no_deliveries_30d_flg, dlv_falling_y_flg,
    dlv_falling_wtd_flg, dlv_falling_lfw_flg, dlv_falling_mtd_flg, dlv_falling_lfm_flg, dlv_falling_7d_flg, dlv_falling_30d_flg,
    dlv_growing_y_flg, dlv_growing_wtd_flg, dlv_growing_lfw_flg, dlv_growing_mtd_flg, dlv_growing_lfm_flg, dlv_growing_7d_flg,
    dlv_growing_30d_flg, cr_y, cr_wtd, cr_lfw, cr_mtd, cr_lfm, cr_7d, cr_30d, newbie_flg, deactivation_date
)


select
    contract_id, lk_client_id, lk_client_name, which_crm, deal_id, add_contract_flg, contract_terminated_flg, crm_link,
    client_name, holding_name, deal_title, potential, country, market_segment, tier, manager_name, lead_name,
    department_name, permissions, manager_group, payment_type, last_activity_date, next_activity_date, quasi_flg,
    deactivate_threshold, balance, invoice_payments_sum, debt, debt00, overdue_clean_debt, activated_dt, last_payment_dt, tariff_plan_series_name,
    calday, product, tariff_zone, city, city_en, soon_order, deliveries_total, deliveries_cnt, deliveries_expired,
    deliveries_failed, deliveries_cancelled_by_courier, deliveries_cancelled_by_client, deliveries_total_w_distance,
    distance, gmv, net_inflow, deliveries_found, deliveries_a_arrived, deliveries_a_visited, deliveries_cancelled,
    dlv_for_searching_time, searching_time_sec, dlv_for_driving_to_a_time, driving_to_a_time_sec, dlv_for_arrival_time,
    arrival_time_sec, dlv_for_waiting_a_time, waiting_a_time_sec, dlv_for_transporting_time, transporting_time_sec,
    dlv_for_total_time, total_time_sec, dlv_for_cancellation_time, cancellation_time_sec, dlv_for_cancellation_before_found_time,
    cancellation_before_found_time_sec, cntr_prev_cld_type_id, cntr_prev_clw_type_id, cntr_prev_clm_type_id,
    first_delivery_dt, category, theme_1, theme_2, theme_3, theme_4, tickets_cnt, last_full_date, y_flg, wtd_flg,
    lfw_flg, mtd_flg, lfm_flg, l7d_flg, l30d_flg, y_prev_flg, wtd_prev_flg, lfw_prev_flg, mtd_prev_flg, lfm_prev_flg,
    l7d_prev_flg, l30d_prev_flg, active_flg, churn_y_flg, churn_wtd_flg, churn_lfw_flg, churn_mtd_flg, churn_lfm_flg,
    churn_7d_flg, churn_30d_flg, low_balance_flg, no_deliveries_y_flg, no_deliveries_wtd_flg, no_deliveries_lfw_flg,
    no_deliveries_mtd_flg, no_deliveries_lfm_flg, no_deliveries_7d_flg, no_deliveries_30d_flg, dlv_falling_y_flg,
    dlv_falling_wtd_flg, dlv_falling_lfw_flg, dlv_falling_mtd_flg, dlv_falling_lfm_flg, dlv_falling_7d_flg, dlv_falling_30d_flg,
    dlv_growing_y_flg, dlv_growing_wtd_flg, dlv_growing_lfw_flg, dlv_growing_mtd_flg, dlv_growing_lfm_flg, dlv_growing_7d_flg,
    dlv_growing_30d_flg, cr_y, cr_wtd, cr_lfw, cr_mtd, cr_lfm, cr_7d, cr_30d, newbie_flg, deactivation_date
from temp_tables;

-- comment on table snb_b2b.niksm_dash_logdata111 is 'Витрина для дашборда B2B Manager Workspace. LOGDATA-111';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_logdata111', 'Finish', clock_timestamp());



