insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata359', 'Start', clock_timestamp());

drop table if exists niksm_b2b_logdata359_dlv;
create temporary table niksm_b2b_logdata359_dlv as
select fct.order_id,
       fct.utc_order_created_dttm,
       fct.msk_order_created_dt,
       fct.corp_client_id,
       fct.corp_contract_id,
       lk.lk_client_name as corp_client_name,
       fct.tariff_class_code,
       fct.tariff_geo_zone_code,
       fct.country_name_ru,
       fct.currency_code,
       --
       fct.decoupling_success_flg,
       coalesce(sign(fct.b2b_decoupling_amt),0) as decoupling_sign,
       --
       delivery_point_cnt as deliveries_cnt,
       ----
       fct.gmv_amt as gmv_lcy,
       fct.gross_commission_revenue_amt as gross_commission_revenue_lcy,
       fct.incentives_amt as incentives_lcy,
       fct.b2b_decoupling_amt as decoupling_fee_lcy,
       case when fct.decoupling_success_flg then fct.decoupling_user_cost end as decoupling_user_cost_lcy,
       case when fct.decoupling_success_flg then fct.decoupling_driver_cost end as decoupling_driver_cost_lcy,
       fct.net_inflow_amt as net_inflow_lcy,
       --
       fct.gmv_amt * fct.currency_rate as gmv_rub,
       fct.gross_commission_revenue_amt * fct.currency_rate as gross_commission_revenue_rub,
       fct.incentives_amt * fct.currency_rate as incentives_rub,
       fct.b2b_decoupling_amt * fct.currency_rate as decoupling_fee_rub,
       case when fct.decoupling_success_flg
           then fct.decoupling_user_cost * fct.currency_rate end as decoupling_user_cost_rub,
       case when fct.decoupling_success_flg
           then fct.decoupling_driver_cost * fct.currency_rate end as decoupling_driver_cost_rub,
       fct.net_inflow_amt * fct.currency_rate as net_inflow_rub
from taxi_cdm_marketplace.fct_order_metric as fct
  join snb_delivery.logdata_delivery_tariff lgst
    on lgst.order_tariff = fct.tariff_class_code
    and fct.utc_order_created_dttm between lgst.utc_datefrom and lgst.utc_dateto
  left join snb_b2b.niksm_b2b_lk_client_service_info lk
    on lk.lk_service_name = 'cargo'
    and lk.lk_client_id = fct.corp_client_id
where fct.success_order_flg
  and fct.corp_order_flg
  and fct.utc_order_created_dttm >= timestamp'2021-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
distributed by (corp_client_id)
;
analyse niksm_b2b_logdata359_dlv;

drop table if exists niksm_b2b_logdata359_dlv_trf;
create temporary table niksm_b2b_logdata359_dlv_trf as
select dlv.*,
       tp.tariff_plan_name as tariff_plan_series_name,
       t.tariff_name_en as tariff_series_name,
       tp_cur.tariff_plan_name as tariff_plan_series_name_current,
       t_cur.tariff_name_en as tariff_series_name_current,
       --
       ctp.utc_updated_dttm as ctp_updated_dttm,
       tp.utc_updated_dttm as tp_updated_dttm,
       tps.utc_updated_dttm as tps_updated_dttm,
       t.utc_updated_dttm as t_updated_dttm,
       ctp_cur.utc_updated_dttm as ctp_cur_updated_dttm,
       tp_cur.utc_updated_dttm as tp_cur_updated_dttm,
       tps_cur.utc_updated_dttm as tps_cur_updated_dttm,
       t_cur.utc_updated_dttm as t_cur_updated_dttm
from niksm_b2b_logdata359_dlv dlv
  left join taxi_ods_dbcorp.client_tariff_plan as ctp
    on ctp.corp_client_id = dlv.corp_client_id
    and dlv.utc_order_created_dttm >= ctp.tariff_plan_valid_from_dttm
    and (dlv.utc_order_created_dttm < ctp.tariff_plan_valid_to_dttm or ctp.tariff_plan_valid_to_dttm is null)
    and ctp.service_name = 'cargo'
  left join taxi_ods_dbcorp.tariff_plan as tp
    on tp.tariff_plan_series_id = ctp.tariff_plan_series_id
    and dlv.utc_order_created_dttm >= tp.date_from_dttm
    and (dlv.utc_order_created_dttm < tp.date_to_dttm or tp.date_to_dttm is null)
  left join taxi_ods_dbcorp.tariff_plan_series as tps
    on tps.tariff_plan_id = tp.tariff_plan_id
    and tps.tariff_geo_zone_code = dlv.tariff_geo_zone_code
  left join taxi_ods_dbcorp.tariff as t
    on t.tariff_series_id = tps.tariff_series_id
    and dlv.utc_order_created_dttm >= t.tariff_valid_from_dttm
    and (dlv.utc_order_created_dttm < t.tariff_valid_to_dttm or t.tariff_valid_to_dttm is null)
    and t.corp_tariff_class_name_en = dlv.tariff_class_code
    and t.day_code = 2
    and t.interval_name_key = 'interval.always'
    and t.category_type = 'application'
  --
  left join taxi_ods_dbcorp.client_tariff_plan as ctp_cur
    on ctp_cur.corp_client_id = dlv.corp_client_id
    and current_timestamp >= ctp_cur.tariff_plan_valid_from_dttm
    and (current_timestamp < ctp_cur.tariff_plan_valid_to_dttm or ctp_cur.tariff_plan_valid_to_dttm is null)
    and ctp_cur.service_name = 'cargo'
  left join taxi_ods_dbcorp.tariff_plan as tp_cur
    on tp_cur.tariff_plan_series_id = ctp_cur.tariff_plan_series_id
    and current_timestamp >= tp_cur.date_from_dttm
    and (current_timestamp < tp_cur.date_to_dttm or tp_cur.date_to_dttm is null)
  left join taxi_ods_dbcorp.tariff_plan_series as tps_cur
    on tps_cur.tariff_plan_id = tp_cur.tariff_plan_id
    and tps_cur.tariff_geo_zone_code = dlv.tariff_geo_zone_code
  left join taxi_ods_dbcorp.tariff as t_cur
    on t_cur.tariff_series_id = tps_cur.tariff_series_id
    and current_timestamp >= t_cur.tariff_valid_from_dttm
    and (current_timestamp < t_cur.tariff_valid_to_dttm or t_cur.tariff_valid_to_dttm is null)
    and t_cur.corp_tariff_class_name_en = dlv.tariff_class_code
    and t_cur.day_code = 2
    and t_cur.interval_name_key = 'interval.always'
    and t_cur.category_type = 'application'
distributed by (order_id);
--
analyse niksm_b2b_logdata359_dlv_trf;

drop table if exists niksm_b2b_logdata359_fullbase;
create temporary table niksm_b2b_logdata359_fullbase as
with dlv_trf0 as (
    select *,
       row_number() over (partition by order_id
           order by ctp_updated_dttm desc nulls last,
               tp_updated_dttm desc nulls last,
               tps_updated_dttm desc nulls last,
               t_updated_dttm desc nulls last,
               ctp_cur_updated_dttm desc nulls last,
               tp_cur_updated_dttm desc nulls last,
               tps_cur_updated_dttm desc nulls last,
               t_cur_updated_dttm desc nulls last
               ) as rn
    from niksm_b2b_logdata359_dlv_trf
)
, dlv_trf as (
    select *
    from dlv_trf0
    where rn = 1
)
select msk_order_created_dt as calday,
       dlv_trf.corp_client_id,
       corp_contract_id,
       corp_client_name,
       tariff_class_code as order_tariff,
       tariff_geo_zone_code as tariff_zone,
       dlv_trf.country_name_ru as country,
       currency_code,
       --
       decoupling_success_flg,
       decoupling_sign,
       sum(deliveries_cnt) as deliveries_cnt,
       ----
       sum(gmv_lcy) as gmv_lcy,
       sum(gmv_lcy / coalesce(vat.vat_rate,1.)) as gmv_lcy_wo_vat,
       sum(gross_commission_revenue_lcy) as gross_commission_revenue_lcy,
       sum(incentives_lcy) as incentives_lcy,
       sum(decoupling_fee_lcy) as decoupling_fee_lcy,
       sum(decoupling_user_cost_lcy) as decoupling_user_cost_lcy,
       sum(decoupling_driver_cost_lcy) as decoupling_driver_cost_lcy,
       sum(net_inflow_lcy) as net_inflow_lcy,
       --
       sum(gmv_rub) as gmv_rub,
       sum(gmv_rub / coalesce(vat.vat_rate,1.)) as gmv_rub_wo_vat,
       sum(gross_commission_revenue_rub) as gross_commission_revenue_rub,
       sum(incentives_rub) as incentives_rub,
       sum(decoupling_fee_rub) as decoupling_fee_rub,
       sum(decoupling_user_cost_rub) as decoupling_user_cost_rub,
       sum(decoupling_driver_cost_rub) as decoupling_driver_cost_rub,
       sum(net_inflow_rub) as net_inflow_rub,
       --
       tariff_plan_series_name,
       tariff_series_name,
       tariff_plan_series_name_current,
       tariff_series_name_current,
       coalesce(crm.manager_group,crm_sf.manager_group) as manager_group,
       coalesce(crm.lead_name,crm_sf.lead_name) as lead_name,
       coalesce(crm.manager_login,crm_sf.manager_login) as manager_login,
       coalesce(crm.manager_name,crm_sf.manager_name) as manager_name
from dlv_trf
  left join snb_b2b.niksm_country_vat_rate vat
    on vat.country_name_ru = dlv_trf.country_name_ru
  left join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = dlv_trf.corp_contract_id
    and which_crm = 6
    and manager_group <> 'B2B платформа'
  left join snb_b2b.niksm_b2b_contracts_info_sf crm_sf
    on crm_sf.contract_id = dlv_trf.corp_contract_id
where (crm.contract_id is not null
    or crm_sf.contract_id is not null)
group by msk_order_created_dt,
         dlv_trf.corp_client_id,
         corp_contract_id,
         corp_client_name,
         tariff_class_code,
         tariff_geo_zone_code,
         dlv_trf.country_name_ru,
         currency_code,
         decoupling_success_flg,
         decoupling_sign,
         tariff_plan_series_name,
         tariff_series_name,
         tariff_plan_series_name_current,
         tariff_series_name_current,
         coalesce(crm.manager_group, crm_sf.manager_group),
         coalesce(crm.lead_name, crm_sf.lead_name),
         coalesce(crm.manager_login, crm_sf.manager_login),
         coalesce(crm.manager_name, crm_sf.manager_name);
--
analyse niksm_b2b_logdata359_fullbase;

------------------------------------------------------------------------------------------------------------------------
-- drop table if exists snb_b2b.niksm_b2b_logdata359;
-- create table snb_b2b.niksm_b2b_logdata359 as
truncate table snb_b2b.niksm_b2b_logdata359;
insert into snb_b2b.niksm_b2b_logdata359
    (calday, corp_client_id, corp_contract_id, corp_client_name, order_tariff, tariff_zone, country, currency_code,
     decoupling_success_flg, decoupling_sign, deliveries_cnt,
     gmv_lcy, gmv_lcy_wo_vat, gross_commission_revenue_lcy,
     incentives_lcy, decoupling_fee_lcy, decoupling_user_cost_lcy, decoupling_driver_cost_lcy, net_inflow_lcy,
     gmv_rub, gmv_rub_wo_vat, gross_commission_revenue_rub,
     incentives_rub, decoupling_fee_rub, decoupling_user_cost_rub, decoupling_driver_cost_rub, net_inflow_rub,
     tariff_plan_series_name, tariff_series_name, tariff_plan_series_name_current, tariff_series_name_current,
     manager_group, lead_name, manager_login, manager_name,
     last_full_date)
--
select calday, corp_client_id, corp_contract_id, corp_client_name, order_tariff, tariff_zone, country, currency_code,
       decoupling_success_flg, decoupling_sign,
       deliveries_cnt,
       gmv_lcy, gmv_lcy_wo_vat, gross_commission_revenue_lcy,
       NULL as incentives_lcy,
       NULL as decoupling_fee_lcy,
       decoupling_user_cost_lcy, decoupling_driver_cost_lcy, net_inflow_lcy,
       gmv_rub, gmv_rub_wo_vat, gross_commission_revenue_rub,
       NULL as incentives_rub,
       NULL as decoupling_fee_rub,
       decoupling_user_cost_rub, decoupling_driver_cost_rub, net_inflow_rub,
       tariff_plan_series_name, tariff_series_name, tariff_plan_series_name_current, tariff_series_name_current,
       manager_group, lead_name, manager_login, manager_name,
       NULL::date as last_full_date
from niksm_b2b_logdata359_fullbase
union all
select calday, corp_client_id, corp_contract_id, corp_client_name, order_tariff, tariff_zone, country, currency_code,
       decoupling_success_flg, decoupling_sign,
       NULL as deliveries_cnt,
       NULL as gmv_lcy, NULL as gmv_lcy_wo_vat, NULL as gross_commission_revenue_lcy,
       incentives_lcy,
       NULL as decoupling_fee_lcy,
       NULL as decoupling_user_cost_lcy, NULL as decoupling_driver_cost_lcy, NULL as net_inflow_lcy,
       NULL as gmv_rub, NULL as gmv_rub_wo_vat, NULL as gross_commission_revenue_rub,
       incentives_rub,
       NULL as decoupling_fee_rub,
       NULL as decoupling_user_cost_rub, NULL as decoupling_driver_cost_rub, NULL as net_inflow_rub,
       tariff_plan_series_name, tariff_series_name, tariff_plan_series_name_current, tariff_series_name_current,
       manager_group, lead_name, manager_login, manager_name,
       NULL::date as last_full_date
from niksm_b2b_logdata359_fullbase
union all
select calday, corp_client_id, corp_contract_id, corp_client_name, order_tariff, tariff_zone, country, currency_code,
       decoupling_success_flg, decoupling_sign,
       NULL as deliveries_cnt,
       NULL as gmv_lcy, NULL as gmv_lcy_wo_vat, NULL as gross_commission_revenue_lcy,
       NULL as incentives_lcy,
       decoupling_fee_lcy,
       NULL as decoupling_user_cost_lcy, NULL as decoupling_driver_cost_lcy, NULL as net_inflow_lcy,
       NULL as gmv_rub, NULL as gmv_rub_wo_vat, NULL as gross_commission_revenue_rub,
       NULL as incentives_rub,
       decoupling_fee_rub,
       NULL as decoupling_user_cost_rub, NULL as decoupling_driver_cost_rub, NULL as net_inflow_rub,
       tariff_plan_series_name, tariff_series_name, tariff_plan_series_name_current, tariff_series_name_current,
       manager_group, lead_name, manager_login, manager_name,
       NULL::date as last_full_date
from niksm_b2b_logdata359_fullbase;

update snb_b2b.niksm_b2b_logdata359
set last_full_date = (
    select least(last_claims_date, last_fct_date) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
)
where true;

-- comment on table snb_b2b.niksm_b2b_logdata359 is 'Таблица для дашборда по корп. тарифам. LOGDATA-359';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata359', 'Finish', clock_timestamp());
