drop view if exists snb_b2b.niksm_b2b_logdata502_robot_by_client;
create or replace view snb_b2b.niksm_b2b_logdata502_robot_by_client as
select corp_client_id, contract_external_id,
       lk_service_is_active, lk_client_country, lk_created_moscow_dt, contract_type, payment_type, lk_contract_prepaid_deactivate_threshold,
       start_dt, finish_dt, is_active,
       case when legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
            when legal_contract_taxi = 1 then 'ООО Яндекс.Такси' end as legal_entity,
       service_ids,
       deal_id,
       'https://yandexdelivery.amocrm.ru/leads/detail/' || deal_id::text as pipedrive_link, -- xlsxwriter limitations of 65,530 URLS per worksheet
       status, crm_country, crm_city, pipeline_name, stage_name,
       channel, market_segment, tags, product, integration_status, potential,
       tier, manager_group, lead_name, manager_login, manager_name,
       first_delivery_dt,
       last_full_date,
       sum(case when calday
                 between date_trunc('month', last_full_date)::date - interval '1 month'
                 and date_trunc('month', last_full_date)::date - interval '1 day'
               then deliveries_cnt
               else 0 end) as deliveries_cnt_lm,
       sum(case when calday between date_trunc('month',last_full_date)::date and last_full_date then deliveries_cnt else 0 end) as deliveries_cnt_cm,
       permissions as hierarchy
from snb_b2b.niksm_b2b_logdata502_robot
where which_crm = 6
group by corp_client_id, contract_external_id,
       lk_service_is_active, lk_client_country, lk_created_moscow_dt, contract_type, payment_type, lk_contract_prepaid_deactivate_threshold,
       start_dt, finish_dt, is_active,
       case when legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
            when legal_contract_taxi = 1 then 'ООО Яндекс.Такси' end,
       service_ids,
       deal_id,
       status, crm_country, crm_city, pipeline_name, stage_name,
       channel, market_segment, tags, product, integration_status, potential,
       tier, manager_group, lead_name, manager_login, manager_name,
       first_delivery_dt,
       last_full_date,
         permissions;

comment on view snb_b2b.niksm_b2b_logdata502_robot_by_client is 'Группировка snb_b2b.niksm_b2b_logdata502_robot до клиента для рассылки';

------------------------------------------------------------------------------------------------------------------------

drop view if exists snb_b2b.niksm_b2b_logdata502_robot_daily;
create or replace view snb_b2b.niksm_b2b_logdata502_robot_daily as
select corp_client_id, contract_external_id,
--        lk_service_is_active, lk_client_country, lk_created_moscow_dt, contract_type, payment_type, lk_contract_prepaid_deactivate_threshold,
--        start_dt, finish_dt, is_active,
--        case when legal_contract_cargo = 1 then 'ООО Яндекс.Логистика'
--             when legal_contract_taxi = 1 then 'ООО Яндекс.Такси' end as legal_entity,
--        service_ids,
--        deal_id,
--        status, crm_country, crm_city, pipeline_name, stage_name,
--        channel, market_segment, tags, product, integration_status, potential,
--        tier, manager_group, lead_name, manager_login, manager_name,
--        first_delivery_dt,
--        last_full_date,
       --
       tariff_class_code,
       calday, deliveries_cnt,
       permissions as hierarchy
from snb_b2b.niksm_b2b_logdata502_robot
where which_crm = 6
  and calday between last_full_date-60 and last_full_date;

comment on view snb_b2b.niksm_b2b_logdata502_robot_daily is 'Фильтр snb_b2b.niksm_b2b_logdata502_robot за последние 60 дней для рассылки';
