insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata502_robot', 'Start', clock_timestamp());

drop table if exists niksm_temp_dash_robot_phoenix_claim;
create temporary table niksm_temp_dash_robot_phoenix_claim as
select taxi_order_id,
       max(claim.corp_client_id) as corp_client_id
from delivery_ods_cargo_claims.claim
  join snb_b2b.niksm_b2b_clients_info crm
    on claim.corp_client_id = crm.corp_client_id
where true
  and utc_created_dttm >= timestamp'2021-11-01'
group by taxi_order_id
distributed by (taxi_order_id)
;
analyse niksm_temp_dash_robot_phoenix_claim;

drop table if exists niksm_temp_dash_robot_dlv;
create temporary table niksm_temp_dash_robot_dlv as
select coalesce(fct_order.corp_client_id, claim.corp_client_id) as corp_client_id,
       corp_contract_id,
       msk_order_created_dt as calday,
       fct_order.tariff_class_code,
       sum(delivery_point_cnt) as deliveries_cnt
from taxi_cdm_marketplace.fct_order
  join snb_delivery.logdata_delivery_tariff lgst
    on lgst.order_tariff = fct_order.tariff_class_code
    and fct_order.utc_order_created_dttm between utc_datefrom and utc_dateto
  left join niksm_temp_dash_robot_phoenix_claim claim
    on claim.taxi_order_id = fct_order.order_id
where true
  and utc_order_created_dttm >= timestamp'2021-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and msk_order_created_dt between '2021-01-01' and current_date-1
  and success_order_flg
  and (corp_order_flg or claim.taxi_order_id is not null)
group by coalesce(fct_order.corp_client_id, claim.corp_client_id),
         corp_contract_id,
         msk_order_created_dt,
         fct_order.tariff_class_code
having sum(delivery_point_cnt) > 0
distributed by (corp_client_id, corp_contract_id)
;
analyze niksm_temp_dash_robot_dlv;
-----------------------------------------------------


drop table if exists niksm_temp_dash_robot_dlv_1st;
create temporary table niksm_temp_dash_robot_dlv_1st as
select corp_client_id,
       corp_contract_id,
       min(msk_order_created_dt) as first_delivery_dt
from taxi_cdm_marketplace.fct_order
  join snb_delivery.logdata_delivery_tariff lgst
    on lgst.order_tariff = fct_order.tariff_class_code
    and fct_order.utc_order_created_dttm between utc_datefrom and utc_dateto
where true
  and utc_order_created_dttm >= '2019-01-01'
  and msk_order_created_dt between '2019-01-01' and current_date-1
  and success_order_flg
  and corp_order_flg
  and delivery_point_cnt > 0
group by corp_client_id,
         corp_contract_id
distributed by (corp_client_id, corp_contract_id)
;
analyze niksm_temp_dash_robot_dlv_1st;

drop table if exists niksm_temp_dash_robot_client;
create temporary table niksm_temp_dash_robot_client as
with crm as (
    select contract_id,
           6::int as which_crm,
           lead_id as deal_id,
           pipeline_name,
           pipeline_status_name as stage_name,
           price as potential,
           channel,
           lead_status as status,
           integration_status,
           tags,
           product,
           country,
           city,
           market_segment,
           tier,
           manager_login,
           manager_name,
           teamlead_name as lead_name,
           manager_group,
           permissions
    from snb_b2b.amo_contracts_info
    where true
       and crm_source = 'yandexdelivery'
    union all
    select contract_id,
           which_crm,
           NULL::int as deal_id,
           NULL::text as pipeline_name,
           NULL::text as stage_name,
           potential,
           NULL::text as channel,
           status,
           NULL::text as integration_status,
           NULL::text as tags,
           NULL::text as product,
           country,
           NULL::text as crm_city,
           market_segment,
           tier,
           manager_login,
           manager_name,
           lead_name,
           manager_group,
           permissions
    from snb_b2b.niksm_b2b_contracts_info_sf
)
select lk.lk_client_id as corp_client_id,
       lk.contract_external_id,
       lk.lk_service_is_active,
       lk.lk_contract_prepaid_deactivate_threshold,
       lk.lk_client_country,
       lk.lk_created_moscow_dt,
       blnc.contract_type,
       blnc.payment_type,
       blnc.start_dt,
       blnc.finish_dt,
       blnc.is_active,
       blnc.service_ids::text as service_ids,
       blnc.legal_contract_taxi,
       blnc.legal_contract_cargo,
       --
       crm.which_crm,
       crm.deal_id,
       crm.pipeline_name,
       crm.stage_name,
       crm.potential,
       crm.channel,
       crm.status,
       crm.integration_status,
       crm.tags,
       crm.product,
       crm.country as crm_country,
       crm.city as crm_city,
       crm.market_segment,
       crm.tier,
       crm.manager_login,
       crm.manager_name,
       crm.lead_name,
       crm.manager_group,
       crm.permissions,
       dlv_1st.first_delivery_dt
from snb_b2b.niksm_b2b_lk_client_service_info as lk
  left join snb_b2b.niksm_b2b_balance_contract_ext_info as blnc
    on lk.contract_external_id = blnc.contract_external_id
  left join crm
    on crm.contract_id = lk.contract_external_id
  left join niksm_temp_dash_robot_dlv_1st as dlv_1st
    on dlv_1st.corp_contract_id = lk.contract_external_id
where lk.lk_service_name = 'cargo'
distributed by (contract_external_id)
;
--
analyze niksm_temp_dash_robot_client;

drop table if exists niksm_temp_dash_robot_phoenix_client;
create temporary table niksm_temp_dash_robot_phoenix_client as
select crm.corp_client_id,
       6::int as which_crm,
       lead_id as deal_id,
       pipeline_name,
       pipeline_status_name as stage_name,
       price as potential,
       channel,
       lead_status as status,
       integration_status,
       tags,
       product,
       country as crm_country,
       city as crm_city,
       market_segment,
       tier,
       manager_login,
       manager_name,
       teamlead_name as lead_name,
       manager_group,
       permissions,
       dlv_1st.first_delivery_dt,
       'Феникс' as contract_type
from snb_b2b.amo_clients_info crm
  left join niksm_temp_dash_robot_dlv_1st as dlv_1st
    on dlv_1st.corp_client_id = crm.corp_client_id
distributed by (corp_client_id);
--
analyse niksm_temp_dash_robot_phoenix_client;

------------------------------------------------------------------------------------------------------------------------

-- drop table if exists snb_b2b.niksm_b2b_logdata502_robot;
-- create table snb_b2b.niksm_b2b_logdata502_robot as           -- ! distributed by !
truncate table snb_b2b.niksm_b2b_logdata502_robot;
insert into snb_b2b.niksm_b2b_logdata502_robot
    (corp_client_id, contract_external_id, lk_service_is_active, lk_contract_prepaid_deactivate_threshold, lk_client_country, lk_created_moscow_dt,
     contract_type, payment_type, start_dt, finish_dt, is_active, service_ids, legal_contract_taxi, legal_contract_cargo,
     which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product, crm_country, crm_city, market_segment, tier,
     manager_login, manager_name, lead_name, manager_group, permissions, first_delivery_dt,
     tariff_class_code,
     calday, deliveries_cnt,
     first_full_date, last_full_date)
select corp_client_id, contract_external_id, lk_service_is_active, lk_contract_prepaid_deactivate_threshold, lk_client_country, lk_created_moscow_dt,
       contract_type, payment_type, start_dt, finish_dt, is_active, service_ids, legal_contract_taxi, legal_contract_cargo,
       which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product, crm_country, crm_city, market_segment, tier,
       manager_login, manager_name, lead_name, manager_group, permissions, first_delivery_dt,
       NULL::text as tariff_class_code,
       NULL::date as calday,
       NULL::bigint as deliveries_cnt,
       NULL::date as first_full_date,
       NULL::date as last_full_date
from niksm_temp_dash_robot_client
-- distributed by (corp_client_id)
;

insert into snb_b2b.niksm_b2b_logdata502_robot
    (corp_client_id, contract_external_id, lk_service_is_active, lk_contract_prepaid_deactivate_threshold, lk_client_country, lk_created_moscow_dt,
     contract_type, payment_type, start_dt, finish_dt, is_active, service_ids, legal_contract_taxi, legal_contract_cargo,
     which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product, crm_country, crm_city, market_segment, tier,
     manager_login, manager_name, lead_name, manager_group, permissions, first_delivery_dt,
     tariff_class_code,
     calday, deliveries_cnt)
select cl.corp_client_id, contract_external_id, lk_service_is_active, lk_contract_prepaid_deactivate_threshold, lk_client_country, lk_created_moscow_dt,
       contract_type, payment_type, start_dt, finish_dt, is_active, service_ids, legal_contract_taxi, legal_contract_cargo,
       which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product, crm_country, crm_city, market_segment, tier,
       manager_login, manager_name, lead_name, manager_group, permissions, first_delivery_dt,
       --
       dlv.tariff_class_code,
       dlv.calday,
       dlv.deliveries_cnt
from niksm_temp_dash_robot_client as cl
  join niksm_temp_dash_robot_dlv as dlv
    on dlv.corp_contract_id = cl.contract_external_id;

insert into snb_b2b.niksm_b2b_logdata502_robot
    (corp_client_id,
     which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product,
     crm_country, crm_city, market_segment,
     tier, manager_login, manager_name, lead_name, manager_group, permissions,
     first_delivery_dt,
     contract_type)
select corp_client_id,
     which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product,
     crm_country, crm_city, market_segment,
     tier, manager_login, manager_name, lead_name, manager_group, permissions,
     first_delivery_dt,
       contract_type
from niksm_temp_dash_robot_phoenix_client;

insert into snb_b2b.niksm_b2b_logdata502_robot
    (corp_client_id,
     which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product,
     crm_country, crm_city, market_segment,
     tier, manager_login, manager_name, lead_name, manager_group, permissions,
     first_delivery_dt,
     contract_type,
     tariff_class_code, calday, deliveries_cnt)
select crm.corp_client_id,
       which_crm, deal_id, pipeline_name, stage_name, potential, channel, status, integration_status, tags, product,
       crm_country, crm_city, market_segment,
       tier, manager_login, manager_name, lead_name, manager_group, permissions,
       first_delivery_dt,
       contract_type,
       --
       dlv.tariff_class_code,
       dlv.calday,
       dlv.deliveries_cnt
from niksm_temp_dash_robot_phoenix_client crm
  join niksm_temp_dash_robot_dlv as dlv
    on dlv.corp_client_id = crm.corp_client_id;

update snb_b2b.niksm_b2b_logdata502_robot
set first_full_date = '2021-01-01'::date,
    last_full_date = (
    select least(last_claims_date, last_fct_date
        , last_dls_date
        ) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
    cross join (
        select (max(_etl_processed_dttm) at time zone 'UTC' at time zone 'Europe/Moscow')::date as last_dls_date
        from snb_b2b.amo_contracts_info
        ) dls
    )
where true;

-- comment on table snb_b2b.niksm_b2b_logdata502_robot is 'LOGDATA-502. Атрибуты клиента из админки, баланса и CRM с доставками';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata502_robot', 'Finish', clock_timestamp());

-- Depended views
-- snb_delivery.niksm_client_overview_crm6
-- snb_b2b.niksm_b2b_logdata502_robot_by_client
-- snb_b2b.niksm_b2b_logdata502_robot_daily
