use hahn;
PRAGMA yt.Pool='taxi-delivery';
PRAGMA yt.InferSchema = '10';
pragma yt.UseNativeYtTypes;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$tmp = '//home/taxi-delivery/analytics/production/b2b/dash/temp/temp_niksm_b2b_logdata502_robot';
$target = '//home/taxi-delivery/analytics/production/b2b/dash/niksm_b2b_logdata502_robot';

$perm_1 = '//home/taxi-delivery/analytics/production/b2b/dict/amo_contract_permission';
$perm_2 = '//home/taxi-delivery/analytics/production/b2b/dict/amo_client_permission';


$perm =
(
    select
        contract_id,
        user_login,
        staff_uid
    from $perm_1

    union all

    select
        corp_client_id as contract_id,
        user_login,
        staff_uid
    from $perm_2
);

$add_calc =
(
    select COALESCE(a.contract_external_id, a.corp_client_id) as contract_id, a.*
    from $tmp as a
    where permissions is not null
);



insert into $target with truncate
SELECT *
from $add_calc as a
left join $perm as b
on a.contract_id = b.contract_id
order by calday desc;
;
commit;
