insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_logdata102', 'Start', clock_timestamp());

drop table if exists niksm_temp_logdata102_contracts_info;
create temporary table niksm_temp_logdata102_contracts_info as
select * from snb_b2b.niksm_b2b_contracts_info;
--
analyse niksm_temp_logdata102_contracts_info;

drop table if exists niksm_logdata102_cntr_enrich;
create temporary table niksm_logdata102_cntr_enrich as
with cntr0 as (
     select contract_id,
            -- temp
            deal_id,
            status,
            record_date,
            case when status = 'open' then potential/30. else 0 end as potential,
            -- key for attr
            which_crm,
            coalesce(holding_name, org_name) as holding_name,
            -- attr
            case when holding_name in ('Еда & Лавка') then holding_name else 'Прочие' end as client_top,
            country,
            market_segment,
            tier,
            coalesce(manager_name, manager_login) as manager_name,
            lead_name,
            department_name,
            manager_group
     from niksm_temp_logdata102_contracts_info as d
)
, cntr1 as (
    select cntr0.*,
           sum(potential)
               over (partition by which_crm, holding_name) as potential_client,
           max(record_date) over () as last_record_date,
           --
           row_number() over (partition by which_crm, holding_name
               order by record_date desc,
                   case when status = 'lost' then 0 else 1 end desc,
                   deal_id desc) as rn_client
    from cntr0
)
select cntr0.contract_id,
       -- key for attr
       cntr0.which_crm,
       cntr0.holding_name,
       cntr0.potential,
       -- attr
       cntr1.client_top,
       cntr1.country,
       cntr1.market_segment,
       cntr1.tier,
       cntr1.manager_name,
       cntr1.lead_name,
       cntr1.department_name,
       cntr1.manager_group,
       cntr1.potential_client,
       cntr1.last_record_date
from cntr0
  join cntr1
    on cntr0.which_crm = cntr1.which_crm
    and cntr0.holding_name = cntr1.holding_name
    and cntr1.rn_client = 1
DISTRIBUTED BY (contract_id);
--
ANALYSE niksm_logdata102_cntr_enrich;

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_logdata102_potential_grouping;
create temporary table niksm_logdata102_potential_grouping as
with potential_grouping0 as (
    select which_crm,
           client_top,
           country, market_segment, tier,
           manager_name, lead_name, department_name, manager_group,
           last_record_date,
           sum(potential) as potential_grp_daily
    from niksm_logdata102_cntr_enrich
    group by which_crm,
             client_top,
             country, market_segment, tier,
             manager_name, lead_name, department_name, manager_group,
             last_record_date
)
, calend as (
    select gs::date as calday
    from generate_series(current_date-90, current_date, interval '1 day') as gs
)
select calday,
       potential_grouping0.*
from calend
  cross join potential_grouping0
where calday between (date_trunc('month',last_record_date) - interval '1 month')::date and last_record_date;
--
ANALYSE niksm_logdata102_potential_grouping;

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_logdata102_ndd_orders;
create temporary table niksm_logdata102_ndd_orders as
select distinct claim.taxi_order_id as ndd_order_id
from ritchie.delivery_ods_cargo_claims.claim
  join snb_delivery.dash_k2 as lvk
    on claim.claim_id = lvk.claim_id
where claim.utc_created_dttm >= '2020-01-01'
  and lvk.pickup_or_lavka = 'lavka'
DISTRIBUTED BY (ndd_order_id);
--
analyse niksm_logdata102_ndd_orders;

drop table if exists niksm_logdata102_raw0;
create temporary table niksm_logdata102_raw0 as
select fct.corp_contract_id,
       msk_order_created_dt as calday,
       (date_trunc('week', msk_order_created_dt)::date - '1900-01-02'::date)/7 as calweek_id,
       extract(year from msk_order_created_dt)*12 + extract(month from msk_order_created_dt) as calmonth_id,
       --
       case when (ndd.ndd_order_id is not null) then 'NDD'
           when fct.tariff_class_code in ('express','courier') then 'Экспресс'
           when fct.tariff_class_code in ('cargo','cargocorp') then 'Грузовой'
        end as product,
       --
       sum(case when fct.success_order_flg then delivery_point_cnt end) as trips_cnt,
       --
       count() as orders_total_cnt,
       sum(fct.success_order_flg::int) as orders_cnt,
       sum(fct.expired_order_flg::int) as orders_expired_cnt,
       --
       sum(case when fct.success_order_flg then gmv_amt * currency_rate end) as gmv,
       sum(case when fct.success_order_flg then net_inflow_amt * currency_rate end) as net_inflow
from taxi_cdm_marketplace.fct_order_metric as fct
  join snb_delivery.logdata_delivery_tariff lgst
    on lgst.order_tariff = fct.tariff_class_code
    and fct.utc_order_created_dttm between utc_datefrom and utc_dateto
  left join niksm_logdata102_ndd_orders ndd on fct.order_id = ndd.ndd_order_id
where true
  and fct.utc_order_created_dttm >= timestamp'2020-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and fct.msk_order_created_dt >= '2020-01-01'
--       and fct.success_order_flg  -- исключаем для расчета CR
  and not fct.fake_order_flg
  and not fct.mqc_order_flg
  and fct.corp_order_flg
group by msk_order_created_dt,
       --
         case when (ndd.ndd_order_id is not null) then 'NDD'
              when fct.tariff_class_code in ('express', 'courier') then 'Экспресс'
              when fct.tariff_class_code in ('cargo', 'cargocorp') then 'Грузовой'
             end,
         fct.corp_contract_id
DISTRIBUTED BY (corp_contract_id)
;
analyse niksm_logdata102_raw0;


drop table if exists niksm_logdata102_raw;
create temporary table niksm_logdata102_raw as
select calday,
       calweek_id,
       calmonth_id,
       --
       product,
       --
       cntr_enrich.which_crm,
       cntr_enrich.holding_name,
       -- attr
       cntr_enrich.client_top,
       cntr_enrich.country,
       cntr_enrich.market_segment,
       cntr_enrich.tier,
       cntr_enrich.manager_name,
       cntr_enrich.lead_name,
       cntr_enrich.department_name,
       cntr_enrich.manager_group,
       cntr_enrich.potential_client,
       cntr_enrich.last_record_date,
       --
       sum(trips_cnt) as trips_cnt,
       sum(orders_total_cnt) as orders_total_cnt,
       sum(orders_cnt) as orders_cnt,
       sum(orders_expired_cnt) as orders_expired_cnt,
       sum(gmv) as gmv,
       sum(net_inflow) as net_inflow
from niksm_logdata102_raw0 as fct
  left join niksm_logdata102_cntr_enrich as cntr_enrich
    on cntr_enrich.contract_id = fct.corp_contract_id
group by calday,
       calweek_id,
       calmonth_id,
       --
       product,
       --
       cntr_enrich.which_crm,
       cntr_enrich.holding_name,
       -- attr
       cntr_enrich.client_top,
       cntr_enrich.country,
       cntr_enrich.market_segment,
       cntr_enrich.tier,
       cntr_enrich.manager_name,
       cntr_enrich.lead_name,
       cntr_enrich.department_name,
       cntr_enrich.manager_group,
       cntr_enrich.potential_client,
       cntr_enrich.last_record_date;
--
analyze niksm_logdata102_raw;
--=========================================================================================---
drop table if exists akorchagina24_temp_calendar;
create temporary table  akorchagina24_temp_calendar
as
        select
            distinct
            calday,
            case when calday between date_trunc('week', last_full_date) and last_full_date then true else false end as wtd_flg,
            case when calday between date_trunc('week', last_full_date) - interval '7 day' and last_full_date - interval '7 day' then true else false end as wtd_prev_flg,

            case when calday between date_trunc('week', last_full_date + interval '1 day') - interval '1 week' and date_trunc('week', last_full_date + interval '1 day') - interval '1 day' then true else false end as lfw_flg,
            case when calday between date_trunc('week', last_full_date + interval '1 day') - interval '2 week' and date_trunc('week', last_full_date + interval '1 day') - interval '8 day' then true else false end as lfw_prev_flg,

            case when calday between date_trunc('month', last_full_date) and last_full_date then true else false end as mtd_flg,
            case when calday between date_trunc('month', last_full_date) - interval '1 month' and last_full_date - interval '1 month' then true else false end as mtd_prev_flg,

            case when calday between date_trunc('month', last_full_date + interval '1 day') - interval '1 month' and date_trunc('month', last_full_date + interval '1 day') - interval '1 day' then true else false end as lfm_flg,
            case when calday between date_trunc('month', last_full_date + interval '1 day') - interval '2 month' and date_trunc('month', last_full_date + interval '1 day') - interval '1 month 1 day' then true else false end as lfm_prev_flg,


            case when calday between last_full_date - interval '6 day' and last_full_date then true else false end as l7d_flg,
            case when calday between last_full_date - interval '13 day' and last_full_date - interval '7 day' then true else false end as l7d_prev_flg,

            case when calday between last_full_date - interval '29 day' and last_full_date then true else false end as l30d_flg,
            case when calday between last_full_date - interval '59 day' and last_full_date - interval '30 day' then true else false end as l30d_prev_flg

        from snb_b2b.niksm_dash_logdata102
;
--====================================================================================================================--

-- drop table if exists snb_b2b.niksm_dash_logdata102;
-- create table snb_b2b.niksm_dash_logdata102 as
truncate table snb_b2b.niksm_dash_logdata102;
insert into snb_b2b.niksm_dash_logdata102
    (calday, product, which_crm, holding_name, client_top, country, market_segment,
     tier, manager_name, lead_name, department_name, manager_group,
     potential_client, last_record_date,
     orders_total_cnt, trips_cnt, orders_cnt, orders_expired_cnt, gmv, net_inflow,
     org_prev_cld_type_id, org_prev_clw_type_id, org_prev_clm_type_id, plan_trips_cnt, potential_grp_daily,
     last_full_date,
     wtd_flg, lfw_flg, mtd_flg, lfm_flg, l7d_flg, l30d_flg,
     wtd_prev_flg,lfw_prev_flg, mtd_prev_flg, lfm_prev_flg, l7d_prev_flg, l30d_prev_flg)
--
select tbl.calday,
       --
       product,
       --
       which_crm,
       holding_name,
       -- attr
       client_top,
       country,
       market_segment,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       potential_client,
       last_record_date,
       --
       orders_total_cnt, trips_cnt, orders_cnt, orders_expired_cnt,
       gmv, net_inflow,
       --
       case when max(trips_cnt) over (partition by which_crm, holding_name order by tbl.calday range between 1 preceding and 1 preceding) is not null then 1
        when max(trips_cnt) over (partition by which_crm, holding_name order by tbl.calday range between unbounded preceding and 2 preceding) is not null then 2
        else 3 end as org_prev_cld_type_id,
       case when max(trips_cnt) over (partition by which_crm, holding_name order by calweek_id range between 1 preceding and 1 preceding) is not null then 1
        when max(trips_cnt) over (partition by which_crm, holding_name order by calweek_id range between unbounded preceding and 2 preceding) is not null then 2
        else 3 end as org_prev_clw_type_id,
       case when max(trips_cnt) over (partition by which_crm, holding_name order by calmonth_id range between 1 preceding and 1 preceding) is not null then 1
        when max(trips_cnt) over (partition by which_crm, holding_name order by calmonth_id range between unbounded preceding and 2 preceding) is not null then 2
        else 3 end as org_prev_clm_type_id,
       NULL::double precision as plan_trips_cnt,
       NULL::double precision as potential_grp_daily,
       NULL::date as last_full_date,
       cld.wtd_flg, cld.lfw_flg, cld.mtd_flg, cld.lfm_flg, cld.l7d_flg, cld.l30d_flg,
            cld.wtd_prev_flg, cld.lfw_prev_flg, cld.mtd_prev_flg, cld.lfm_prev_flg, cld.l7d_prev_flg, cld.l30d_prev_flg
from niksm_logdata102_raw as tbl
left join akorchagina24_temp_calendar as cld
        on tbl.calday = cld.calday;

------------------------------------------------------------------------------------------------------------------------

insert into snb_b2b.niksm_dash_logdata102
    (calday, which_crm,
     client_top, country, market_segment,
     tier, manager_name, lead_name, department_name, manager_group,
     last_record_date,
     potential_grp_daily
     , wtd_flg, lfw_flg, mtd_flg, lfm_flg, l7d_flg, l30d_flg,
            wtd_prev_flg,lfw_prev_flg, mtd_prev_flg, lfm_prev_flg, l7d_prev_flg, l30d_prev_flg)
select tbl.calday,
       which_crm,
       -- attr
       client_top,
       country,
       market_segment,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       --
       last_record_date,
       --
       potential_grp_daily,
        cld.wtd_flg, cld.lfw_flg, cld.mtd_flg, cld.lfm_flg, cld.l7d_flg, cld.l30d_flg,
            cld.wtd_prev_flg, cld.lfw_prev_flg, cld.mtd_prev_flg, cld.lfm_prev_flg, cld.l7d_prev_flg, cld.l30d_prev_flg
from niksm_logdata102_potential_grouping as tbl
left join akorchagina24_temp_calendar as cld
        on tbl.calday = cld.calday;

------------------------------------------------------------------------------------------------------------------------

insert into snb_b2b.niksm_dash_logdata102
    (calday, product, which_crm, client_top, manager_group, plan_trips_cnt
      , wtd_flg, lfw_flg, mtd_flg, lfm_flg, l7d_flg, l30d_flg,
            wtd_prev_flg,lfw_prev_flg, mtd_prev_flg, lfm_prev_flg, l7d_prev_flg, l30d_prev_flg )
select day::date as calday,
       --
       product,
       --
       case when manager_group = 'B2B такси' then 0 else 6 end as which_crm,
       -- attr
       client_top,
       case when manager_group = 'Без группы' then 'Тир 3'
           when manager_group = 'Без группы' then 'B2B платформа'
           else manager_group end as manager_group,
       --
       plan_trips_cnt,
         cld.wtd_flg, cld.lfw_flg, cld.mtd_flg, cld.lfm_flg, cld.l7d_flg, cld.l30d_flg,
            cld.wtd_prev_flg, cld.lfw_prev_flg, cld.mtd_prev_flg, cld.lfm_prev_flg, cld.l7d_prev_flg, cld.l30d_prev_flg
from snb_taxi.niksm_b2b_plan_daily
as tbl
left join akorchagina24_temp_calendar as cld
        on tbl.day::date = cld.calday
where manager_group in ('INTERCO','ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП 3','ГМП 4','ГМП NDD','СНГ РБ','СНГ РК','Без группы','B2B такси','Партнерские продажи');

------------------------------------------------------------------------------------------------------------------------

update snb_b2b.niksm_dash_logdata102
set last_full_date = (
    select least(last_claims_date, last_fct_date
        , last_dls_date
        ) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
    cross join (
        select max(record_date)::date as last_dls_date
        from snb_b2b.niksm_b2b_deals_info
        ) dls
    )
where true;

-- comment on table snb_b2b.niksm_dash_logdata102 is 'Витрина для дэша Sales Metrics. LOGDATA-102';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_logdata102', 'Finish', clock_timestamp());

