with src as (
    select least(last_claims_date, last_fct_date
--         , last_dls_date
        ) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
--     cross join (
--         select max(record_date)::date as last_dls_date
--         from snb_b2b.niksm_b2b_deals_info
--         ) dls
)
, res as (
    select max(last_full_date) as last_full_date
    from snb_b2b.niksm_dash_logdata102
)
select case when src.last_full_date > res.last_full_date
                 or res.last_full_date is null
            then 1::int else 0::int end as flg
from src cross join res;
