insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_corpwelcome_utm', 'Start', clock_timestamp());

drop table if exists niksm_temp_b2b_dlv;
create temporary table niksm_temp_b2b_dlv as
select corp_contract_id,
       msk_order_created_dt as moscow_order_dt,
       delivery_point_cnt as deliveries_cnt,
       min(msk_order_created_dt) over (partition by corp_contract_id) as first_dlv_dt
from taxi_cdm_marketplace.fct_order
  join snb_taxi.logdata_logistic_tariffs lgst
    on lgst.order_tariff = fct_order.tariff_class_code
where utc_order_created_dttm between date_trunc('week',current_date-7*52) and current_date
  and success_order_flg
  and corp_order_flg
  and corp_contract_id not in ('','unknown')
  and corp_contract_id is not null
DISTRIBUTED BY (corp_contract_id);
--
analyze niksm_temp_b2b_dlv;


drop table if exists niksm_temp_b2b_res;
create temporary table niksm_temp_b2b_res as
with corpwlc0 as (
    select case substring(deal from 'https://(yandexdelivery|globalexpansion2021).pipedrive.com/deal/(\d+)(([^\d]+.*)|)$')
               when 'yandexdelivery' then 6
               when 'globalexpansion2021' then 8
            end as which_crm,
           substring(deal from 'https://(?:yandexdelivery|globalexpansion2021).pipedrive.com/deal/(\d+)(([^\d]+.*)|)$')::int as deal_id,
    -- для запуска не питоном убрать \ перед yandexdelivery в предыдущей строчке
           utmmedium,
           utmsource,
           utmcampaign,
           created,
           substr(created,1,10)::date as created_dt
    from snb_b2b.voytekh_corpwelcome
    where true
      and type = 'task'
      and resolution in ('fixed', 'escalated')
      and deal ~ 'https://(yandexdelivery|globalexpansion2021).pipedrive.com/deal/(\d+)'
      and substr(created,1,10)::date between date_trunc('week',current_date-7*52) and current_date-1
)
, corpwlc as (
    select which_crm, deal_id,
           utmmedium, utmsource, utmcampaign,
           created_dt,
           row_number() over (partition by which_crm, deal_id order by created) as rn
    from corpwlc0
)
, dlv as (
    select corp_contract_id,
           1::int as with_delivery,
           sum(case when moscow_order_dt between first_dlv_dt and first_dlv_dt+29 then deliveries_cnt end) as dlv_cnt_1st_month
    from niksm_temp_b2b_dlv
    group by corp_contract_id
)
, tm_utm as (
    select (tm).* from (
        select tm,
               row_number() over (partition by organization_external_id) as rn
        from snb_b2b.niksm_b2b_utm_telemarketing as tm
        where campaign_type = 'Acquisition'
    ) q
    where rn = 1
)
select corpwlc.which_crm,
       corpwlc.deal_id,
       coalesce(case when tm_utm.organization_external_id is not null then NULL else corpwlc.utmmedium end) as utmmedium,
       coalesce(case when tm_utm.organization_external_id is not null then tm_utm.source else corpwlc.utmsource end) as utmsource,
       coalesce(case when tm_utm.organization_external_id is not null then tm_utm.campaign else corpwlc.utmcampaign end) as utmcampaign,
       case when tm_utm.organization_external_id is not null then 'Telemarketing'
           when corpwlc.utmsource is not null and corpwlc.utmsource<>'' then 'Marketing'
           else 'Organic' end as utmchannel,
       corpwlc.created_dt,
       coalesce(lk.lk_cargo_is_active,0) as lk_cargo_is_active,
       coalesce(dlv.with_delivery,0::int) as with_delivery,
       coalesce(dlv.dlv_cnt_1st_month,0) as dlv_cnt_1st_month,
       dls.manager_group,
       dls.country,
       dls.market_segment,
       NULL::date as last_full_date
from corpwlc
  left join snb_b2b.niksm_b2b_deals_info as dls
    on dls.which_crm = corpwlc.which_crm
    and dls.deal_id = corpwlc.deal_id
  left join snb_b2b.niksm_b2b_lk_contract_info as lk
    on lk.contract_external_id = dls.contract_id
    and dls.contract_id <> ''
  left join dlv
    on dlv.corp_contract_id = dls.contract_id
    and dls.contract_id <> ''
  left join tm_utm
    on tm_utm.organization_external_id = corpwlc.deal_id
    and corpwlc.which_crm = 6
where corpwlc.rn = 1;
--
analyze niksm_temp_b2b_res;

------------------------------------------------------------------------------------------------------------------------
-- drop table if exists snb_b2b.niksm_b2b_corpwelcome_utm;
-- create table snb_b2b.niksm_b2b_corpwelcome_utm as                       -- ! DISTRIBUTED BY
truncate table snb_b2b.niksm_b2b_corpwelcome_utm;
insert into snb_b2b.niksm_b2b_corpwelcome_utm
    (which_crm, deal_id, utmmedium, utmsource, utmcampaign, utmchannel,
     created_dt, lk_cargo_is_active,
     with_delivery, dlv_cnt_1st_month,
     manager_group, country, market_segment, last_full_date)
--
select which_crm, deal_id, utmmedium, utmsource, utmcampaign, utmchannel,
     created_dt, lk_cargo_is_active,
     with_delivery, dlv_cnt_1st_month,
     manager_group, country, market_segment, last_full_date
from niksm_temp_b2b_res
-- DISTRIBUTED BY (which_crm, deal_id)
;

update snb_b2b.niksm_b2b_corpwelcome_utm
set last_full_date = (
    select least(last_claims_date, last_fct_date, last_crpwlc_date) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
    cross join (
        select (max(created)::timestamp AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_crpwlc_date
        from snb_b2b.voytekh_corpwelcome
        ) crpwlc
    )
where true;

-- alter table snb_b2b.niksm_b2b_corpwelcome_utm add constraint niksm_b2b_corpwelcome_utm_pk primary key (which_crm, deal_id);   --!
-- comment on table snb_b2b.niksm_b2b_corpwelcome_utm is 'Связка сделки с UTM-меткой. LOGDATA-316';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_corpwelcome_utm', 'Finish', clock_timestamp());
