insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_logdata190', 'Start', clock_timestamp());

-- 1) niksm_dash_logdata190_cntr_enrich
-- 2) niksm_dash_logdata190_raw
-- 3) niksm_dash_logdata190_raw_cl
-- 4) niksm_dash_logdata190_prev_res

drop table if exists niksm_dash_logdata190_cntr_enrich;
create temporary table niksm_dash_logdata190_cntr_enrich as
with cntr0 as (
     select contract_id,
            -- temp
            deal_id,
            status,
            record_date,
            case when status <> 'lost' then potential else 0 end as potential,
            -- key for attr
            which_crm,
            client_id,
            -- attr
            client_name,
            case when client_name in ('Еда & Лавка','ВкусВилл') then client_name else 'Прочие' end as client_top,
            country,
            market_segment,
            channel,
            tier,
            coalesce(manager_name, manager_login) as manager_name,
            lead_name,
            department_name,
            manager_group
     from snb_b2b.niksm_b2b_contracts_info as d
)
, cntr1 as (
    select cntr0.*,
           sum(potential)
               over (partition by which_crm, client_id) as potential_client,
           max(record_date) over () as last_record_date,
           --
           row_number() over (partition by which_crm, client_id
               order by record_date desc,
                   case when status = 'lost' then 0 else 1 end desc,
                   deal_id desc) as rn_client
    from cntr0
)
-- , cntr_enrich as (
    select cntr0.contract_id,
           -- key for attr
           cntr0.client_id,
           -- attr of contract
           cntr0.potential,
           -- attr of client
           cntr1.which_crm,
           cntr1.client_name,
           cntr1.client_top,
           cntr1.country,
           cntr1.market_segment,
           cntr1.channel,
           cntr1.tier,
           cntr1.manager_name,
           cntr1.lead_name,
           cntr1.department_name,
           cntr1.manager_group,
           cntr1.potential_client,
           cntr1.last_record_date
    from cntr0
      join cntr1
        on cntr0.client_id = cntr1.client_id
        and cntr1.rn_client = 1
;

analyze niksm_dash_logdata190_cntr_enrich;

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_dash_logdata190_cntr_dlv;
create temporary table niksm_dash_logdata190_cntr_dlv as
select corp_order_flg,
       corp_contract_id,
       user_phone_pd_id,
       msk_order_created_dt,
       country_name_ru,
       app_platform_name,
       sum(delivery_point_cnt) as trips_cnt,
       --
       sum(gmv_amt * currency_rate) as gmv,
       sum(net_inflow_amt * currency_rate) as net_inflow
from taxi_cdm_marketplace.fct_order_metric as fct
  join snb_delivery.logdata_delivery_tariff lgst
    on lgst.order_tariff = fct.tariff_class_code
    and fct.utc_order_created_dttm between utc_datefrom and utc_dateto
where true
  and utc_order_created_dttm >= timestamp'2020-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and success_order_flg
  and not fake_order_flg
  and not mqc_order_flg
group by corp_order_flg,
         corp_contract_id,
         user_phone_pd_id,
         msk_order_created_dt,
         country_name_ru,
         app_platform_name
DISTRIBUTED BY (user_phone_pd_id);
--
analyse niksm_dash_logdata190_cntr_dlv;

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_dash_logdata190_raw_cl;
create temporary table niksm_dash_logdata190_raw_cl as
with raw_cl0 as (
    select fct.corp_order_flg,
           case when corp_order_flg then '1_' || coalesce(cntr_enrich.client_id,corp_contract_id)
               else '0_' || fct.user_phone_pd_id end as client_id,
           greatest( (date_trunc('week',msk_order_created_dt)::date - '1969-12-29'::date)/7,
               (date_trunc('week',current_date)::date - '1969-12-29'::date)/7 - (13+4+1) ) as calweek_id,
           -- attr
           max(cntr_enrich.which_crm) as which_crm,
           coalesce(max(cntr_enrich.client_top),'Прочие') as client_top,
           max(case when fct.corp_order_flg
               then cntr_enrich.country
               else -- приводим к CRM
                   case when fct.country_name_ru = 'Россия' then 'РФ'
                       when fct.country_name_ru = 'Белоруссия' then 'Беларусь'
                       else fct.country_name_ru end
               end) as country,
           max(cntr_enrich.market_segment) as market_segment,
           max(cntr_enrich.channel) as channel,
           max(cntr_enrich.tier) as tier,
           max(cntr_enrich.manager_name) as manager_name,
           max(cntr_enrich.lead_name) as lead_name,
           max(cntr_enrich.department_name) as department_name,
           max(case when fct.corp_order_flg then cntr_enrich.manager_group
               when fct.msk_order_created_dt >= t4.datefrom then 'Тир 4' end ) as manager_group
    from niksm_dash_logdata190_cntr_dlv as fct
      left join niksm_dash_logdata190_cntr_enrich as cntr_enrich
        on cntr_enrich.contract_id = fct.corp_contract_id
      left join snb_delivery.niksm_b2b_tier4_user_datefrom as t4
        on t4.user_phone_pd_id = fct.user_phone_pd_id
    where true
      and (fct.corp_order_flg
          or fct.msk_order_created_dt >= t4.datefrom)
    group by 1,2,3
)
select client_id,
       calweek_id,
       -- attr
       corp_order_flg,
       which_crm,
       client_top,
       country,
       market_segment,
       channel,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       --
       case when count() over (partition by client_id order by calweek_id range between 4 preceding and 1 preceding) > 0 then 1             -- были доставки за последние 4 недели
            when count() over (partition by client_id order by calweek_id range between unbounded preceding and 5 preceding) > 0 then 2     -- были доставки когда-то в прошлом
            else 3 end as client_prev_clw_type_id,
       case when count() over (partition by client_id order by calweek_id range between 1 following and unbounded following) = 0 then -2    -- нет доставок на последующих неделях
            when count() over (partition by client_id order by calweek_id range between 1 following and 4 following) = 0 then -1            -- нет доставок след 4 недели
            end as client_fllw_clw_type_id
from raw_cl0;

analyze niksm_dash_logdata190_raw_cl;

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_dash_logdata190_prev_res;
create temporary table niksm_dash_logdata190_prev_res as
with churn_moment as (
    select -- attr
           corp_order_flg,
           which_crm,
           client_top,
           country,
           market_segment,
           channel,
           tier,
           manager_name,
           lead_name,
           department_name,
           manager_group,
           --
           calweek_id + 4 as calweek_id,
           client_fllw_clw_type_id as client_prev_clw_type_id,
           count() as clients_cnt
    from niksm_dash_logdata190_raw_cl
    where client_fllw_clw_type_id is not null
    group by -- attr
             corp_order_flg,
             which_crm,
             client_top,
             country,
             market_segment,
             channel,
             tier,
             manager_name,
             lead_name,
             department_name,
             manager_group,
             --
             calweek_id + 4,
             client_fllw_clw_type_id
)
select -- attr
   corp_order_flg,
   which_crm,
   client_top,
   country,
   market_segment,
   channel,
   tier,
   manager_name,
   lead_name,
   department_name,
   manager_group,
   --
   calweek_id,
   client_prev_clw_type_id,
   count() as clients_cnt
from niksm_dash_logdata190_raw_cl
where calweek_id
    between (date_trunc('week',current_date  )::date - '1969-12-29'::date)/7 - 13
        and (date_trunc('week',current_date-1)::date - '1969-12-29'::date)/7
group by -- attr
         corp_order_flg,
         which_crm,
         client_top,
         country,
         market_segment,
         channel,
         tier,
         manager_name,
         lead_name,
         department_name,
         manager_group,
         --
         calweek_id,
         client_prev_clw_type_id
--
union all
select corp_order_flg,
       which_crm,
       client_top,
       country,
       market_segment,
       channel,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       --
       calweek_id,
       client_prev_clw_type_id,
       clients_cnt
from churn_moment
where calweek_id
    between (date_trunc('week',current_date  )::date - '1969-12-29'::date)/7 - 13
        and (date_trunc('week',current_date-1)::date - '1969-12-29'::date)/7;

analyze niksm_dash_logdata190_prev_res;

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_dash_logdata190_raw;
create temporary table niksm_dash_logdata190_raw as
--
select msk_order_created_dt as calday,
       (date_trunc('week', msk_order_created_dt)::date - '1969-12-29'::date)/7 as calweek_id,
       extract(year from msk_order_created_dt)*12 + extract(month from msk_order_created_dt) as calmonth_id,
       --
       coalesce(app.application_platform_group,'others') as application_platform_group,
       --
       dlv.corp_order_flg,
       case when corp_order_flg then '1_' || coalesce(cntr_enrich.client_id,corp_contract_id)
           else '0_' || dlv.user_phone_pd_id end as client_id,
       -- attr
       max(cntr_enrich.which_crm) as which_crm,
       max(cntr_enrich.client_name) as client_name,
       coalesce(max(cntr_enrich.client_top),'Прочие') as client_top,
       max(case when dlv.corp_order_flg
           then cntr_enrich.country
           else -- приводим к CRM
               case when dlv.country_name_ru = 'Россия' then 'РФ'
                   when dlv.country_name_ru = 'Белоруссия' then 'Беларусь'
                   else dlv.country_name_ru end
           end) as country,
       max(cntr_enrich.market_segment) as market_segment,
       max(cntr_enrich.channel) as channel,
       max(cntr_enrich.tier) as tier,
       max(cntr_enrich.manager_name) as manager_name,
       max(cntr_enrich.lead_name) as lead_name,
       max(cntr_enrich.department_name) as department_name,
       max(case when dlv.corp_order_flg then cntr_enrich.manager_group
           when dlv.msk_order_created_dt >= t4.datefrom then 'Тир 4' end ) as manager_group,
       max(cntr_enrich.potential_client) as potential_client,
       max(cntr_enrich.last_record_date) as last_record_date,
       --
       sum(trips_cnt) as trips_cnt,
       --
       sum(gmv) as gmv,
       sum(net_inflow) as net_inflow
from niksm_dash_logdata190_cntr_dlv as dlv
  left join niksm_dash_logdata190_cntr_enrich as cntr_enrich
    on cntr_enrich.contract_id = dlv.corp_contract_id
  left join snb_delivery.niksm_b2b_tier4_user_datefrom as t4
    on t4.user_phone_pd_id = dlv.user_phone_pd_id
  left join snb_delivery.niksm_b2b_application_platform_grouping as app
    on app.application_platform = dlv.app_platform_name
where true
  and (dlv.corp_order_flg
      or dlv.msk_order_created_dt >= t4.datefrom)
group by msk_order_created_dt,
         --
         coalesce(app.application_platform_group, 'others'),
         --
         dlv.corp_order_flg,
         case when corp_order_flg then '1_' || coalesce(cntr_enrich.client_id,corp_contract_id)
           else '0_' || dlv.user_phone_pd_id end
;

analyze niksm_dash_logdata190_raw;

--====================================================================================================================--

-- drop table if exists snb_b2b.niksm_dash_logdata190;
-- create table snb_b2b.niksm_dash_logdata190 as
truncate table snb_b2b.niksm_dash_logdata190;
insert into snb_b2b.niksm_dash_logdata190
    (calday, product, application_platform_group, corp_order_flg,
     client_id, which_crm, client_name, client_top, country, market_segment, channel, tier, manager_name, lead_name, department_name, manager_group, potential_client,
     orders_total_cnt, trips_cnt, orders_cnt, orders_expired_cnt, gmv, net_inflow,
     org_prev_cld_type_id, org_prev_clw_type_id, org_prev_clm_type_id, client_prev_clw_type_id,
     plan_trips_cnt, potential_grp_daily, clients_cnt, t34_plan_trips_cnt, t34_plan_clients_cnt, clients_cnt_cm, last_full_date)
-- factual deliveries --
select calday,
       --
       NULL::text as product,
       application_platform_group,
       --
       corp_order_flg,
       case when corp_order_flg then client_id end as client_id,
       -- attr
       which_crm,
       client_name,
       client_top,
       country,
       market_segment,
       channel,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       potential_client,
       --
       NULL::double precision as orders_total_cnt,
       sum(trips_cnt) as trips_cnt,
       NULL::double precision as orders_cnt,
       NULL::double precision as orders_expired_cnt,
       sum(gmv) as gmv,
       sum(net_inflow) as net_inflow,
       --
       NULL::int as org_prev_cld_type_id,
       NULL::int as org_prev_clw_type_id,
       NULL::int as org_prev_clm_type_id,
       --
       client_prev_clw_type_id,
       NULL::double precision as plan_trips_cnt,
       NULL::numeric as potential_grp_daily,
       NULL::bigint as clients_cnt,
       NULL::double precision as t34_plan_trips_cnt,
       NULL::double precision as t34_plan_clients_cnt,
       NULL::bigint as clients_cnt_cm,
       NULL::date as last_full_date
from niksm_dash_logdata190_raw as raw
  left join (
      select client_id, calweek_id, client_prev_clw_type_id from niksm_dash_logdata190_raw_cl) as cl
    using(client_id, calweek_id)
where calday >= (date_trunc('week',current_date)::date - 13*7)::date
group by calday,
       --
       product,
       application_platform_group,
       --
       corp_order_flg,
       case when corp_order_flg then client_id end,
       -- attr
       which_crm,
       client_name,
       client_top,
       country,
       market_segment,
       channel,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       potential_client,
       client_prev_clw_type_id;


insert into snb_b2b.niksm_dash_logdata190
    (calday, corp_order_flg,
     which_crm, client_top, country, market_segment, channel, tier, manager_name, lead_name, department_name, manager_group,
     potential_grp_daily)
with potential_grouping0 as (
    select which_crm,
           client_top,
           country, market_segment, channel, tier,
           manager_name, lead_name, department_name, manager_group,
           last_record_date,
           sum(potential)/30. as potential_grp_daily
    from niksm_dash_logdata190_cntr_enrich as cntr_enrich
    group by which_crm,
             client_top,
             country, market_segment, channel, tier,
             manager_name, lead_name, department_name, manager_group,
             last_record_date
)
, calend as (
    select gs::date as calday
    from generate_series(current_date-90, current_date, interval '1 day') as gs
)
, potential_grouping as (
    select calday,
           potential_grouping0.*
    from calend
      cross join potential_grouping0
    where calday between (date_trunc('month',last_record_date) - interval '1 month')::date and last_record_date
)
-- potential_grp_daily --
select calday,
       --
       True as corp_order_flg,
       --
       -- attr
       which_crm,
       client_top,
       country,
       market_segment,
       channel,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       potential_grp_daily
from potential_grouping
where calday >= (date_trunc('week',current_date)::date - 13*7)::date;


insert into snb_b2b.niksm_dash_logdata190
    (calday, product, corp_order_flg,
     which_crm, client_top, manager_group,
     plan_trips_cnt)
-- plan_trips_cnt --
select day::date as calday,
       --
       product,
       (manager_group <> 'Тир 4') as corp_order_flg,
       -- attr
       case when manager_group = 'B2B платформа' then 0 else 6 end as which_crm,
       client_top,
       manager_group,
       plan_trips_cnt
from snb_taxi.niksm_b2b_plan_daily
where manager_group in ('INTERCO','ГМП 1','ГМП 2','ГМП 3','ГМП 4','ГПП 1','Партнерские продажи','Тир 3')
 and day::date >= (date_trunc('week',current_date)::date - 13*7)::date;


insert into snb_b2b.niksm_dash_logdata190
    (calday, corp_order_flg,
     which_crm, client_top, country, market_segment, channel, tier, manager_name, lead_name, department_name, manager_group,
     client_prev_clw_type_id, clients_cnt)
-- clients_cnt --
select (date'1969-12-29' + calweek_id*7) as calday,
       --
       corp_order_flg,
       -- attr
       which_crm,
       client_top,
       country,
       market_segment,
       channel,
       tier,
       manager_name,
       lead_name,
       department_name,
       manager_group,
       --
       client_prev_clw_type_id,
       clients_cnt
from niksm_dash_logdata190_prev_res
where (date'1969-12-29' + calweek_id*7) >= (date_trunc('week',current_date)::date - 13*7)::date;


insert into snb_b2b.niksm_dash_logdata190
    (calday, corp_order_flg, which_crm,
     country, manager_group, t34_plan_trips_cnt)
-- plans Tier 3-4 --
select calday,
       --
       (manager_group <> 'Тир 4') as corp_order_flg,
       -- attr
       6 as which_crm,
       case
           when country = 'Россия' then 'РФ'
           when country = 'Белоруссия' then 'Беларусь'
        else country end as country,
       manager_group,
       plan_trips_cnt as t34_plan_trips_cnt
from snb_b2b.niksm_b2b_t34_plan_daily
where manager_group in ('Тир 3','Тир 4')
  and calday >= (date_trunc('week',current_date)::date - 13*7)::date;


insert into snb_b2b.niksm_dash_logdata190
    (calday, country, manager_group, clients_cnt_cm)
select date_trunc('month',current_date-1)::date as calday,
       country,
       manager_group,
       count(distinct client_id) as clients_cnt_cm
from niksm_dash_logdata190_raw
where calday between date_trunc('month',current_date-1)::date and current_date-1
GROUP BY 1,2,3
;


update snb_b2b.niksm_dash_logdata190
set last_full_date = (
    select least(last_claims_date, last_fct_date
--         , last_dls_date
        ) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
--     cross join (
--         select max(record_date)::date as last_dls_date
--         from snb_b2b.niksm_b2b_deals_info
--         ) dls
    )
where true;

-- comment on table snb_b2b.niksm_dash_logdata190 is 'Таблица для дашборда по СМБ. LOGDATA-190';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_logdata190', 'Finish', clock_timestamp());

