#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
import requests
import psycopg2
import datetime
import csv
import codecs
import sys
import argparse
import smtplib
import time
import imaplib
import email
import email.header
import uuid
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication
from b2b_mailer import main, main2, gp2df
import logging
import yaml
import pandas as pd
import re
import time
from yql.api.v1.client import YqlClient
import sys

from business_models import greenplum
from business_models.greenplum import GreenplumManager


with open("keys.json") as f:
    from_file = json.load(f)
token = from_file['sam_yt_token']

gp_user = 'robot-sam-bridges'
gp_token = from_file['sam_gp_token']
greenplum = GreenplumManager(user=gp_user, token = gp_token)

hf_query = "select * from `//home/taxi-delivery/analytics/production/b2b/ad_hoc/hf`"

title = 'YQL hf'
with YqlClient(db='hahn', token=token) as yql_client:
    request = yql_client.query(hf_query, title=title, syntax_version=1)
    request.run()
    time.sleep(5)
    base = request.full_dataframe

#base = pd.read_excel('hf.xlsx')

def mainx():
    #cities = pd.read_excel('cities.xlsx')
    cities_query = "select * from `//home/taxi-delivery/analytics/production/b2b/ad_hoc/cities`"

    title = 'YQL cities'
    with YqlClient(db='hahn', token=token) as yql_client:
        request = yql_client.query(cities_query, title=title, syntax_version=1)
        request.run()
        time.sleep(5)
        cities = request.full_dataframe


    # --- CUT HERE ---

    # In[4]:

    sql = """select key, name, options from snb_b2b.voytekh_pd2_deal_field
    where which_crm = 6"""
    cfields = greenplum(sql)
    cnames = {}
    rpl = {}
    for k in cfields.reset_index().to_dict('records'):
        cnames[k['key']] = k['name']
        if k['options']:
            rpl[k['key']] = k['options']

    mop = [
        '68026643cf481989c50033590b961b8a7b340b03',
        '38d25dc4ddeb9fcac154ba3a51fbc6b58fd42964',
        'a6b106d5204058a098b981bac7fce54506345b90',
        'bf0acb98470f7456b3fb7f5fce04b7044f74a1c6',
        '337a6c18a796bb71765a6d51467511b75a6fefa1'
    ]
    rpl2 = {x: rpl.get(x, None) for x in mop}
    for x in mop:
        rpl.pop(x)

    # Выкидываем воронку ДОГОВОРЫ ЯНДЕКС ТАКСИ
    sql = """select custom_fields from snb_b2b.voytekh_pd2_deal where which_crm = 6 and pipeline_id <> 16"""
    df_deal = greenplum(sql)['custom_fields'].apply(pd.Series).replace(rpl)
    for k, v in rpl2.items():
        df_deal[k] = (df_deal[k].fillna('').str.split(',')
                      .explode()
                      .replace(v)
                      .groupby(level=0).agg(';'.join))
    df_deal = df_deal.rename(columns=cnames)
    df_deal['org_id'] = df_deal['Организация'].apply(lambda x: str(x['value']) if x else None)
    df_deal['person_id'] = df_deal['Контактное лицо'].apply(lambda x: str(x['value']) if x else None)
    df_deal['login'] = df_deal['Владелец'].apply(lambda x: x['email'].split('@')[0])

    sql = """select s.name as stage, s.pd_id as stage_id, p.name as pipeline
    from snb_b2b.voytekh_pd_stage as s
    left join snb_b2b.voytekh_pd_pipeline as p
    on s.pipeline = p.pd_id and
    s.which_crm = p.which_crm
    where s.which_crm = 6
    """
    df_stage = greenplum(sql)
    df_stage = df_stage.set_index('stage_id')
    df_deal = df_deal.join(df_stage, on='Этап')
    df_deal['Идентификатор'] = df_deal['Идентификатор'].astype(str)

    # In[5]:

    sql = """select key, name, options from snb_b2b.voytekh_pd2_org_field where which_crm = 6"""
    cfields = greenplum(sql)
    cnames = {}
    rpl = {}
    for k in cfields.reset_index().to_dict('records'):
        cnames[k['key']] = k['name']
        if k['options']:
            rpl[k['key']] = k['options']
    cnames['address_country'] = 'address_country'
    mop = [
        'e7480ce35afd1074394d66643d39937cd806187d'
    ]
    rpl.pop('label')
    rpl2 = {x: rpl.get(x, None) for x in mop}
    for x in mop:
        rpl.pop(x)

    sql = """select custom_fields from snb_b2b.voytekh_pd2_org where which_crm = 6"""
    df_org = greenplum(sql)['custom_fields'].apply(pd.Series).replace(rpl)
    for k, v in rpl2.items():
        df_org[k] = (df_org[k].fillna('').str.split(',')
                     .explode()
                     .replace(v)
                     .groupby(level=0).agg(';'.join))
    df_org = df_org.rename(columns=cnames)
    df_org['login'] = df_org['Владелец'].apply(lambda x: x['email'].split('@')[0])
    df_org['Идентификатор'] = df_org['Идентификатор'].astype(str)

    # In[6]:

    sql = """select key, name, options from snb_b2b.voytekh_pd2_person_field where which_crm = 6"""
    cfields = greenplum(sql)
    cnames = {}
    rpl = {}
    for k in cfields.reset_index().to_dict('records'):
        cnames[k['key']] = k['name']
        if k['options']:
            rpl[k['key']] = k['options']
    cnames['first_name'] = 'first_name'
    mop = [
        '9c58d6d2593cf6b0305de5b91b5d269204b6380e'
    ]
    rpl.pop('label')
    rpl2 = {x: rpl.get(x, None) for x in mop}
    for x in mop:
        rpl.pop(x)

    sql = """select custom_fields from snb_b2b.voytekh_pd2_person where which_crm = 6"""
    df_person = greenplum(sql)['custom_fields'].apply(pd.Series).replace(rpl)
    for k, v in rpl2.items():
        df_person[k] = (df_person[k].fillna('').str.split(',')
                        .explode()
                        .replace(v)
                        .groupby(level=0).agg(';'.join))
    df_person = df_person.rename(columns=cnames)
    df_person['org_id'] = df_person['Организация'].apply(lambda x: x['value'] if x else None)
    df_person['login'] = df_person['Владелец'].apply(lambda x: x['email'].split('@')[0])

    # In[7]:

    sql = """select * from snb_b2b.voytekh_pd2_activity as a
    left join snb_b2b.voytekh_pd_user as u
    on a.user_id = u.pd_id and a.which_crm = u.which_crm
    where a.which_crm = 6"""
    df_activity = greenplum(sql)
    df_activity['login'] = df_activity['email'].apply(lambda x: x.split('@')[0])
    df_activity = df_activity.rename(columns={'deal_id': 'Идентификатор'})
    df_activity['Идентификатор'] = df_activity['Идентификатор'].fillna(0).astype(int).astype(str)

    # In[8]:

    sql = """select * from snb_b2b.voytekh_manager_v2"""
    df_man = greenplum(sql).drop_duplicates('login')

    # In[9]:

    sql = """
    select contract_id, contract, contract_type, payment_type,
    start_dt, finish_dt, client_id, person_inn, person_kz_bin, person_kpp,
    faxed_dt, signed_dt, is_booked, booked_dt
    from (
        select contract_id, contract, contract_type, payment_type,
        start_dt, finish_dt, client_id, person_inn, person_kz_bin, person_kpp,
        faxed_dt, signed_dt, is_booked, booked_dt,
        row_number() over (partition by contract order by start_dt desc) as rn
        from snb_b2b.voytekh_corporate_contracts_and_debts
    ) as cc where rn = 1
    """
    df_cc = greenplum(sql)

    # In[10]:

    df_cc['inn/bin'] = df_cc.apply(
        lambda x: x['person_inn'] if not pd.isnull(x['person_inn']) else x['person_kz_bin'], axis=1)

    # In[11]:

    sql = """
    select
    (custom_fields ->> '5b46472f62d243f28c789cfa00dc4859a06973a8') as contract,
    record_date,
    id,
    split_part((custom_fields -> 'user_id' ->> 'email'), '@', 1) as login
    from snb_b2b.voytekh_pd2_deal_history
    where which_crm = 6 and record_date >= now() - INTERVAL '2 days'
    order by id, record_date desc
    """
    df_custom_1 = greenplum(sql)

    # In[12]:

    sql = """
    select
    next_activity_date,
    next_activity_id,
    record_date,
    id,
    split_part((custom_fields -> 'user_id' ->> 'email'), '@', 1) as login
    from snb_b2b.voytekh_pd2_deal_history
    where which_crm = 6 and record_date >= now() - INTERVAL '2 days'
    order by id, record_date desc
    """
    df_custom_2 = greenplum(sql)

    # !!!TEMPORARY STUFF ASKVOYTEKH !!!
    #df_deal = df_deal[~(
    #    (pd.to_datetime(df_deal['Сделка создана']) >= '2021-05-09')
    #    & (pd.to_datetime(df_deal['Сделка создана']) < '2021-05-10'))
    #]
    #df_org = df_org[~(
    #    (pd.to_datetime(df_org['Организация создана']) >= '2021-05-09')
    #    & (pd.to_datetime(df_org['Организация создана']) < '2021-05-10'))
    #]
    #df_person = df_person[~(
    #    (pd.to_datetime(df_person['Контакт создан']) >= '2021-05-09')
    #    & (pd.to_datetime(df_person['Контакт создан']) < '2021-05-10'))
    #]


    #t = yaml.safe_load(open("t.yml", 'r'))
    #df_deal = df_deal[~df_deal['Идентификатор'].isin([str(x) for x in t['d']])]
    #df_org = df_org[~df_org['Идентификатор'].isin([str(x) for x in t['o']])]
    #df_person = df_person[~df_person['Идентификатор'].isin([str(x) for x in t['p']])]

    # # rules

    # In[17]:

    r = df_deal[df_deal['Канал привлечения'].isna()][['login', 'Идентификатор']]
    r['alias'] = 'no_channel'
    r['type'] = 'deal'
    r['data'] = ''

    # In[13]:

    r2 = df_org[
        (df_org.duplicated(keep=False, subset=['ИНН/БИН', 'КПП']))
        & (~df_org['ИНН/БИН'].isna())
        & (df_org['ИНН/БИН'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'double_inn'
    r2['type'] = 'organization'
    r = pd.concat([r, r2])

    # In[14]:

    r2 = df_deal[
        (df_deal['next_activity_id'].isna())
        & (
                (df_deal['pipeline'].isin(['ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ']))
                | (df_deal['stage'].isin(['НАЙТИ КОНТАКТЫ', 'СВЯЗАТЬСЯ И НАПРАВИТЬ ПРЕДЛОЖЕНИЕ']))
        )
        & (df_deal['Состояние'] != 'Проигранa')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'no_next_activity'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[15]:

    r2 = df_activity[
        (df_activity['type'].isin(['chek_poezdok', ]))
        & (df_activity['marked_as_done_time'] >= datetime.datetime(2021, 1, 25))
        ]
    r2 = r2.join(df_deal[['Идентификатор', '№ договора', 'pipeline', 'Состояние']].set_index('Идентификатор'),
                 on='Идентификатор')
    r2 = r2[
        ((r2['№ договора'] == '') | (r2['№ договора'].isna()))
        & (~r2['pipeline'].isin(['САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ', 'ХОЛОД']))
        & (~r2['Состояние'].isna())
        ]
    r2 = r2[['login', 'Идентификатор']].drop_duplicates()
    r2['alias'] = 'wrong_task'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[16]:

    r2 = df_org[df_org['КПП'].str.contains('[^0-9]+', na=False)][['login', 'Идентификатор']]
    r2['alias'] = 'kpp_has_letter'
    r2['type'] = 'organization'
    r = pd.concat([r, r2])

    # In[17]:

    r2 = df_activity[
        (df_activity['type'].isin(['call', ]))
        & (df_activity['note'].isna())
        & (
                (df_activity['done'] == False)
                | (df_activity['marked_as_done_time'] >= datetime.datetime(2021, 1, 25))
        )
        ]
    r2 = r2.join(df_deal[['Идентификатор', 'deleted']].set_index('Идентификатор'))
    r2 = r2[~r2['deleted'].isnull()]
    r2 = r2[['login', 'Идентификатор']]
    r2['alias'] = 'call_no_note'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[18]:

    vc = df_deal[[
        'Идентификатор',
        'org_id',
        '№ договора',
        'login'
    ]].join(
        df_org[['Идентификатор', 'Кредитный рейтинг']].set_index('Идентификатор'),
        on='org_id'
    )
    r2 = vc[
        (pd.isnull(vc['Кредитный рейтинг']))
        & (
                (~pd.isnull(vc['№ договора']))
                & (vc['№ договора'] != '')
        )
        ]
    r2 = r2[['login', 'Идентификатор']]
    r2['alias'] = 'no_rating'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[23]:

    r2 = df_deal[df_deal['pipeline'] == 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ'][[
        'Идентификатор', 'login', 'org_id'
    ]]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Тип группы компаний',
            'Группа компаний'
        ]].set_index('Идентификатор'),
        on='org_id'
    )
    r2 = r2[
        (pd.isnull(r2['Тип группы компаний']))
    ][['Идентификатор', 'login']]
    r2['alias'] = 'additionl_agr_no_gk'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[24]:

    r2 = df_deal[df_deal['pipeline'] == 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ'][[
        'Идентификатор', 'login', 'org_id'
    ]]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Тип группы компаний',
            'Группа компаний'
        ]].set_index('Идентификатор'),
        on='org_id'
    )
    r2 = r2[
        (pd.isnull(r2['Группа компаний']))
    ][['Идентификатор', 'login']]
    r2['alias'] = 'additionl_agr_no_gk_name'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[20]:

    vc = df_deal[~df_deal['Ссылка на основную сделку (для дополнительных договоров)'].isna()][
        'Ссылка на основную сделку (для дополнительных договоров)'].str.extract(r'.*/(?P<tdeal_id>\d+)[^0-9]*')[
        'tdeal_id'].to_list()
    r2 = df_deal[df_deal['Идентификатор'].isin(vc)][['login', 'Идентификатор', 'org_id']]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Тип группы компаний',
            'Группа компаний'
        ]].set_index('Идентификатор'),
        on='org_id'
    )
    r2 = r2[
        (pd.isnull(r2['Тип группы компаний']))
        | (pd.isnull(r2['Группа компаний']))
        ][['Идентификатор', 'login']]

    vc = df_deal[~df_deal['Ссылка на основную сделку (для дополнительных договоров)'].isna()]
    vc = vc[[
        'Идентификатор',
        'Ссылка на основную сделку (для дополнительных договоров)'
    ]]
    vc['main'] = vc['Ссылка на основную сделку (для дополнительных договоров)'].str.extract(
        r'.*/(?P<tdeal_id>\d+)[^0-9]*')
    vc = vc.groupby('main')['Идентификатор'].apply(list).reset_index('main')
    vc = vc.rename(columns={'Идентификатор': 'data'}).set_index('main')
    r2 = r2.join(vc, on='Идентификатор')
    r2['alias'] = 'main_deal_no_gk'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[21]:

    r2 = df_deal.join(df_man[['login', 'is_dismissed', 'lead_login']].set_index('login'), on='login')
    r2['login'] = r2['lead_login']
    r2 = r2[
        (r2['is_dismissed'] == True)
        & (r2['Состояние'] != 'Проиграна')
        ][['Идентификатор', 'login']]

    r2['alias'] = 'deal_owner_is_ex'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[22]:

    r2 = df_deal.join(df_man[['login', 'is_dismissed', 'lead_login']].set_index('login'), on='login')
    r2['login'] = r2['lead_login']
    r2 = r2[
        (r2['is_dismissed'] == True)
        & (r2['Состояние'] == 'Проигранa')
        ][['Идентификатор', 'login']]

    r2['alias'] = 'deal_ex_owner_is_ex'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[23]:

    r2 = df_deal[
        (pd.isnull(df_deal['Ссылка на основную сделку (для дополнительных договоров)']))
        & (df_deal['pipeline'] == 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ')
        ][['Идентификатор', 'login']]

    r2['alias'] = 'deal_no_main_link'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[24]:

    vc = df_deal[~df_deal['Ссылка на основную сделку (для дополнительных договоров)'].isna()][
        'Ссылка на основную сделку (для дополнительных договоров)'].str.extract(r'.*/(?P<tdeal_id>\d+)[^0-9]*')[
        'tdeal_id'].to_list()
    r2 = df_deal[df_deal['Идентификатор'].isin(vc)][['login', 'Идентификатор', 'pipeline','stage']]
    r2 = r2[~((r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ', 'САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ',
                                  'DEBT-BRUT','DEBT-LONGIN']))
            |(r2['stage'].isin(['Отключена доставка дог. Яндекс.Такси']))
              )
        ][['Идентификатор','login']]

    r2['alias'] = 'main_deal_wrong_place'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[25]:

    r2 = df_deal[~df_deal['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ',
                                         'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ',
                                         'ПРОВЕСТИ ПРЕЗЕНТАЦИЮ',
                                         'Контактные данные получены'])][[
        'Идентификатор', 'login', 'org_id'
    ]]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Страна'
        ]].set_index('Идентификатор'),
        on='org_id'
    )
    r2 = r2[pd.isnull(r2['Страна'])][['Идентификатор', 'login']]
    r2['alias'] = 'no_country'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[26]:

    r2 = df_deal[
        (~df_deal['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ',
                                         'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ',
                                         'ПРОВЕСТИ ПРЕЗЕНТАЦИЮ',
                                         'ИДЕЯ (БАЗА ДЛЯ ПРОРАБОТКИ)',
                                         'НАЙТИ КОНТАКТЫ', 'БАЗА']))
        & (~df_deal['pipeline'].isin(['ФЕНИКС']))
    ][['Идентификатор', 'login', 'org_id']]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Город'
        ]].set_index('Идентификатор'),
        on='org_id'
    )
    r2 = r2[pd.isnull(r2['Город'])][['Идентификатор', 'login']]
    r2['alias'] = 'no_city'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[30]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', 'Заголовок', 'stage', 'pipeline',
        'Тип договора', '№ договора'
    ]]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Имя'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )
    r2 = r2[
        (
                (~pd.isnull(r2['№ договора']))
                & (r2['№ договора'] != '')
        )
        | (r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ', 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',
                                'РАСТОРГНУТЫЕ ДОГОВОРЫ', 'DEBT-BRUT',
                                'DEBT-LONGIN']))
        | (r2['stage'].isin(['ЖДЕМ ДОГОВОР']))

        ]
    r2 = r2[~(
            (r2['stage'] == 'СТАРТ')
            & (r2['Тип договора'] == 'ОФЕРТА')
            & (
                    (pd.isnull(r2['№ договора']))
                    | (r2['№ договора'] == '')
            )
    )
    ]

    r2 = r2[
        (r2['Имя'].fillna('').str.lower().str.contains('xxx'))
        | (r2['Имя'].fillna('').str.lower().str.contains('ххх'))
        | (r2['Заголовок'].fillna('').str.lower().str.contains('xxx'))
        | (r2['Заголовок'].fillna('').str.lower().str.contains('ххх'))
        ][['Идентификатор', 'login']]

    r2['alias'] = 'xxx'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[31]:

    r2 = df_deal[
        (
                (~pd.isnull(df_deal['№ договора']))
                & (df_deal['№ договора'] != '')
        )
    ][['Тип оплаты', 'Идентификатор', 'login', 'org_id']]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'ИНН/БИН'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )

    r2 = r2[
        (
                (r2['Тип оплаты'].isna())
                | (r2['ИНН/БИН'].isna())
                | (r2['ИНН/БИН'] == '')
        )
    ][['Идентификатор', 'login']]

    r2['alias'] = 'no_contract_data'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[32]:

    r2 = df_deal[
        (pd.isnull(df_deal['№ договора']))
        | (df_deal['№ договора'] == '')
        ][[
        'Идентификатор', 'login', 'stage', 'pipeline',
        'Тип договора', '№ договора'
    ]]

    r2 = r2[
        (r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ', 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',
                              'РАСТОРГНУТЫЕ ДОГОВОРЫ', 'DEBT-BRUT',
                              'DEBT-LONGIN']))
        | (r2['stage'].isin(['ЖДЕМ ДОГОВОР']))

        ]
    r2 = r2[~(
            (r2['stage'] == 'СТАРТ')
            & (r2['Тип договора'] == 'ОФЕРТА')
    )][['Идентификатор', 'login']]
    r2['alias'] = 'no_contract'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[33]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', 'stage', 'pipeline',
        'Тип договора', '№ договора'
    ]]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Сегмент рынка'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )
    r2 = r2[(r2['Сегмент рынка'].isna())
            | (r2['Сегмент рынка'] == '')
            ]
    r2 = r2[
        (r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ', 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',
                              'РАСТОРГНУТЫЕ ДОГОВОРЫ', 'DEBT-BRUT',
                              'DEBT-LONGIN']))
        | (r2['stage'].isin(['ЖДЕМ ДОГОВОР', 'ПРИНЯТО РЕШЕНИЕ', 'ПЕРЕГОВОРЫ']))

        ]
    r2 = r2[~(
            (r2['stage'] == 'СТАРТ')
            & (r2['Тип договора'] == 'ОФЕРТА')
    )
    ][['Идентификатор', 'login']]

    r2['alias'] = 'no_segment'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[34]:

    r2 = df_deal[
        (df_deal['Состояние'] == 'Проиграна')
        & (df_deal['pipeline'] != 'ПОДКЛЮЧЕНИЕ')
        ][[
        'Идентификатор', 'login'
    ]]
    r2['alias'] = 'lost_not_in_sales'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[35]:

    r2 = df_deal[
        (df_deal.duplicated(keep=False, subset=['№ договора']))
        & (~df_deal['№ договора'].isna())
        & (df_deal['№ договора'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'double_contract'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[36]:

    cities = cities.to_dict(orient='records')
    cities = dict(map(lambda x: [x['cities'], x['country']], cities))
    r2 = df_org[['Город', 'Страна', 'login', 'Идентификатор']]

    def vc(x):
        c = cities.get(x['Город'], '').split(',')
        if x['Страна'] in c:
            return True
        return False

    r2['ok'] = r2.apply(vc, axis=1)
    r2 = r2[(r2['ok'] == False)
            & (~r2['Город'].isna())][['login', 'Идентификатор']]

    r2['alias'] = 'wrong_country'
    r2['type'] = 'organization'
    r = pd.concat([r, r2])

    # In[37]:

    r2 = df_deal[
        (df_deal[[
            'Менеджер интеграции',
            # 'Статус интеграции',
            'Тикет на интеграцию']].any(axis='columns'))
        #     & (~df_deal[[
        #         'Менеджер интеграции',
        #         'Статус интеграции',
        #         'Тикет на интеграцию']].replace({None: False}).all(axis='columns'))
        & (df_deal['Статус интеграции Экспресс'].isna())
        ][['login', 'Идентификатор']]
    r2['alias'] = 'integration_fkup'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[38]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', '№ договора', 'Продукт'
    ]]
    r2 = r2[
        (~r2['№ договора'].isna())
        & (r2['№ договора'] != '')
        & (r2['Продукт'] != 'Старая Яндекс Доставка')
        ]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'ИНН/БИН',
            'КПП',
            'Страна'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )
    #r2 = r2[
    #      (~r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ']))
    #]
    r2 = r2[
        (r2['Страна'] == 'РФ')
    ]
    r2 = r2.join(
        df_cc[['contract', 'inn/bin', 'person_kpp']].set_index('contract'),
        on='№ договора'
    )
    r2 = r2.fillna('')
    r2 = r2[
        (r2['ИНН/БИН'] != r2['inn/bin'])
        | (
                (r2['КПП'] != r2['person_kpp'])
                & (~r2['person_kpp'].isna())
                #& (~r2['client'].fillna('').str.contains('Индивидуальный предприниматель'))
        )
        ]
    r2['alias'] = 'wrong_inn'
    r2['type'] = 'deal'
    r2['data'] = r2.apply(
        lambda x: f"""inn: crm: {x['ИНН/БИН']} type {type(x['ИНН/БИН'])} / bal: {x['inn/bin']} type {type(x['inn/bin'])}
kpp: crm: {x['КПП']} type {type(x['КПП'])} / bal: {x['person_kpp']} type {type(x['person_kpp'])}""",
        axis=1)
    r2 = r2[['login', 'Идентификатор', 'alias', 'type', 'data']]
    r = pd.concat([r, r2])

    # In[39]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', 'stage', 'pipeline', 'Состояние'
    ]]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Кредитный рейтинг',
            'Открытые сделки'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )
    vc = r2[
        (r2['pipeline'].isin(['ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ', 'ЗАПУСК И РАЗВИТИЕ',
                              'DEBT-BRUT', 'DEBT-LONGIN',
                              'РАСТОРГНУТЫЕ ДОГОВОРЫ',
                              'САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ']))
    ]['org_id'].to_list()
    r2 = r2[
        (~r2['Кредитный рейтинг'].isna())
        & (
                (r2['pipeline'].isin(['ХОЛОД']))
                | (r2['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ',
                                     'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ',
                                     'ПРОВЕСТИ ПРЕЗЕНТАЦИЮ',
                                     'ПЕРЕГОВОРЫ']))
        )
        & (~r2['org_id'].isin(vc))
        & ((r2['Открытые сделки'] == 0) | (r2['Состояние'] != 'Проигранa'))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'remove_rating'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[22]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', 'stage', 'pipeline',
        'Тип договора', 'Стоимость'
    ]]
    r2 = r2[
        (
                (r2['Стоимость'] == 0)
                | (r2['Стоимость'] == '')
                | (r2['Стоимость'].isna())
        )
        & (
                (
                        (r2['Тип договора'] != 'ОФЕРТА')
                        & (r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ']))
                )
                | (
                        (r2['Тип договора'] == 'ОФЕРТА')
                        & (
                                (r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ']))
                                & (r2['stage'] != 'СТАРТ')
                        )
                )
        )
        ][['login', 'Идентификатор']]
    r2['alias'] = 'missing_value_acc'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[19]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', 'stage', 'pipeline',
        'Тип договора', 'Стоимость'
    ]]
    r2 = r2[
        (
                (r2['Стоимость'] == 0)
                | (r2['Стоимость'] == '')
                | (r2['Стоимость'].isna())
        )
        & (
            (
                r2['stage'].isin(['ПЕРЕГОВОРЫ',
                                  'ПРИНЯТО РЕШЕНИЕ',
                                  'ЖДЕМ ДОГОВОР',
                                  'ВАЛИДАЦИЯ']

                                 )
            )
        )
        ][['login', 'Идентификатор']]
    r2['alias'] = 'missing_value_sale'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[41]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', 'stage', 'pipeline',
        'Тип договора', 'Стоимость'
    ]]
    r2 = r2[
        (r2['Стоимость'] != 0)
        & (r2['pipeline'].isin(['ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ']))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'remove_value'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[42]:

    r2 = df_org[['login', 'Идентификатор']].join(
        df_deal[['org_id', 'Идентификатор']].set_index('org_id'),
        on='Идентификатор', rsuffix='_deal')
    r2 = r2[
        r2['Идентификатор_deal'].isna()
    ][['login', 'Идентификатор']]
    r2['alias'] = 'no_deal'
    r2['type'] = 'organization'
    r = pd.concat([r, r2])

    # In[43]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'stage', 'Стоимость'
    ]]
    r2 = r2[
        (r2['Стоимость'] > 100)
        & (r2['stage'].isin(['ВАЛИДАЦИЯ']))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'big_in_free'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[44]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'Работа с долгом', 'pipeline'
    ]]
    r2 = r2[
        (r2['Работа с долгом'].isna())
        & (r2['pipeline'].isin(['DEBT-BRUT', 'DEBT-LONGIN']))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'debt_unknown'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[45]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'Работа с долгом', 'pipeline'
    ]]
    r2 = r2[
        (r2['Работа с долгом'] == 'На дебиторщиках')
        & (~r2['pipeline'].isin(['DEBT-BRUT', 'DEBT-LONGIN']))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'debt_untaken'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[46]:

    r2 = df_activity[
        (df_activity['done'] == False)
        & (
                pd.to_datetime(df_activity['due_date']) <= pd.to_datetime(
            datetime.datetime.now() - datetime.timedelta(days=7))
        )

        ][['login', 'Идентификатор']]
    r2['alias'] = 'abandoned_activity'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[47]:

    r2 = df_activity.join(
        df_deal[[
            'Идентификатор',
            'pipeline',
            'Состояние',
            'org_id']].set_index('Идентификатор'),
        on='Идентификатор', rsuffix=' (deal)'
    ).join(
        df_org[['Идентификатор', 'Tier']].set_index('Идентификатор'),
        on='org_id (deal)'
    )
    r2 = r2[
        (r2['pipeline'] == 'ПОДКЛЮЧЕНИЕ')
        & (r2['Состояние'] == 'Открыто')
        # & (r2['Tier'] == 'Tier 2') ждем согласования
        ]
    r2 = r2[['Идентификатор', 'done', 'marked_as_done_time', 'due_date']]
    i = r2[r2['done'] == True][[
        'Идентификатор', 'marked_as_done_time']].groupby('Идентификатор').max()
    k = r2[r2['done'] == False][[
        'Идентификатор', 'due_date']].groupby('Идентификатор').min()
    i = i.join(k)
    i = i.reset_index()
    i.marked_as_done_time = i.marked_as_done_time.dt.date

    def o(x):
        if not pd.isnull(x['due_date']) and not pd.isnull(x['marked_as_done_time']):
            return (x['due_date'] - x['marked_as_done_time']).days
        return None

    i['delta'] = i.apply(o, axis=1)
    i = i[i['delta'] > 14]
    r2 = df_deal[df_deal['Идентификатор'].isin(i['Идентификатор'].to_list())]
    r2 = r2[['login', 'Идентификатор']]
    r2['alias'] = 'abandoned_deal'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[48]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'stage', 'Последнее изменение этапа'
    ]]
    r2 = r2[
        (r2['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ']))
        & (pd.to_datetime(r2['Последнее изменение этапа'])
           < pd.to_datetime((datetime.datetime.now() - datetime.timedelta(days=1)).date()))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'stuck_at_study'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[49]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'stage', 'Последнее изменение этапа', 'Состояние'
    ]]
    r2 = r2[
        (
                r2['Состояние'] != 'Проигранa')
        & (r2['stage'].isin(['ПРИНЯТО РЕШЕНИЕ']))
        & (pd.to_datetime(r2['Последнее изменение этапа'])
           < pd.to_datetime((datetime.datetime.now() - datetime.timedelta(days=2)).date())
           )
        ][['login', 'Идентификатор']]
    r2['alias'] = 'stuck_at_justdoit'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[50]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'stage', 'Последнее изменение этапа'
    ]]
    r2 = r2[
        (r2['stage'].isin(['СТАРТ']))
        & (pd.to_datetime(r2['Последнее изменение этапа'])
           < pd.to_datetime((datetime.datetime.now() - datetime.timedelta(days=4)).date()))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'stuck_at_start'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[51]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'stage', 'Последнее изменение этапа'
    ]]
    r2 = r2[
        (r2['stage'].isin(['КАНДИДАТЫ НА ВЫХОД']))
        & (pd.to_datetime(r2['Последнее изменение этапа'])
           < pd.to_datetime((datetime.datetime.now() - datetime.timedelta(days=5)).date()))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'stuck_at_resurrection'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[20]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'person_id', 'stage', 'pipeline',
        'Тип договора', '№ договора', 'Состояние', 'Время проигрыша'
    ]]
    r2['person_id'] = r2['person_id'].fillna(0).astype(int)
    r2 = r2.join(
        df_person[[
            'Идентификатор',
            'Cущность КЛ',
            'Должность',
            'Имя'
        ]].set_index('Идентификатор'),
        on='person_id', rsuffix=' (org)'
    )
    r2 = r2[((r2['Cущность КЛ'].isna())
             | (r2['Должность'].isna()))
            & (~r2['Имя'].isna())
            ]
    r2 = r2[
        r2['stage'].isin(['ЖДЕМ ДОГОВОР', 'ПРИНЯТО РЕШЕНИЕ', 'ПЕРЕГОВОРЫ'])

    ]
    r2 = r2[
        (r2['Состояние'] == 'Открыто')
        | (pd.to_datetime(r2['Время проигрыша']) > pd.to_datetime('2021-02-04'))
        ]
    r2 = r2[~(
            (r2['stage'] == 'СТАРТ')
            & (r2['Тип договора'] == 'ОФЕРТА')
    )
    ][['Идентификатор', 'login']]

    r2['alias'] = 'no_person_info_sale'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[21]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'person_id', 'stage', 'pipeline',
        'Тип договора', '№ договора', 'Состояние', 'Время проигрыша'
    ]]
    r2['person_id'] = r2['person_id'].fillna(0).astype(int)
    r2 = r2.join(
        df_person[[
            'Идентификатор',
            'Cущность КЛ',
            'Должность',
            'Имя'
        ]].set_index('Идентификатор'),
        on='person_id', rsuffix=' (org)'
    )
    r2 = r2[((r2['Cущность КЛ'].isna())
             | (r2['Должность'].isna()))
            & (~r2['Имя'].isna())
            ]
    r2 = r2[
        r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ', 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ'])

    ]
    r2 = r2[
        (r2['Состояние'] == 'Открыто')
        | (pd.to_datetime(r2['Время проигрыша']) > pd.to_datetime('2021-02-04'))
        ]
    r2 = r2[~(
            (r2['stage'] == 'СТАРТ')
            & (r2['Тип договора'] == 'ОФЕРТА')
    )
    ][['Идентификатор', 'login']]

    r2['alias'] = 'no_person_info_acc'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[53]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'Причина проигрыша', 'Состояние', 'Wishlist'
    ]]
    r2 = r2[
        (r2['Причина проигрыша'] == 'ТРЕБУЕТСЯ КАСТОМИЗАЦИЯ')
        & (r2['Wishlist'] == '')
        ][['Идентификатор', 'login']]

    r2['alias'] = 'no_wishlist'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[54]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'Причина проигрыша', 'Дата следующей задачи'
    ]]
    r2 = r2[
        (r2['Причина проигрыша'] == 'ОТЛОЖИТЬ')
        & (r2['Дата следующей задачи'].isna())
        ][['Идентификатор', 'login']]

    r2['alias'] = 'postpone_no_activity'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[55]:

    # r2 = df_deal[[
    #     'Идентификатор', 'login', 'Причина проигрыша', 'Канал привлечения'
    # ]]
    # r2 = r2[
    #     (r2['Причина проигрыша'] == 'НЕ ЗАПУЩЕНА ДОСТАВКА')
    #     & (r2['Канал привлечения'] != 'ХОЛОДНЫЙ КОНТАКТ')
    # ][['Идентификатор', 'login']]

    # r2['alias'] = 'delivery_but_no_delivery'
    # r2['type'] = 'deal'
    # r = pd.concat([r, r2])

    # In[56]:

    r2 = df_deal[[
        'Идентификатор', 'login', '№ договора', 'pipeline'
    ]]
    r2 = r2[(
                    (r2['№ договора'] != '')
                    & (~r2['№ договора'].isna())
            )
            & (r2['pipeline'] == 'ХОЛОД')
            ][['Идентификатор', 'login']]

    r2['alias'] = 'cold_contract'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[57]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'Работа с долгом', 'Причина bad debt', 'pipeline'
    ]]
    r2 = r2[(
                    (~r2['Работа с долгом'].isna())
                    | (~r2['Причина bad debt'].isna())
            )
            & (r2['pipeline'] == 'ПОДКЛЮЧЕНИЕ')
            ][['Идентификатор', 'login']]

    r2['alias'] = 'fake_debt'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[58]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'org_id', 'Wishlist', 'Стоимость'
    ]]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Город'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )
    r2 = r2[
        (r2['Wishlist'].str.contains('Доставка на следующий день'))
        & (r2['Город'].isin(['Москва', 'Санкт-Петербург']))
        & (r2['Стоимость'] >= 1500)
        ][['Идентификатор', 'login']]

    r2['alias'] = 'we_have_ndd'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[59]:

    # r2 = df_deal[[
    #     'Идентификатор', 'login', 'org_id', 'Wishlist'
    # ]]
    # r2=r2[
    #     (r2['Wishlist'].str.contains('Термосумки'))
    # ][['Идентификатор', 'login']]

    # r2['alias'] = 'we_have_thermo'
    # r2['type'] = 'deal'
    # r = pd.concat([r, r2])

    # In[60]:

    r2 = df_activity.join(df_man[['login', 'is_dismissed', 'lead_login']].set_index('login'), on='login')
    r2['login'] = r2['lead_login']
    r2 = r2[
        (r2['is_dismissed'] == True)
        & (r2['done'] == False)
        ][['Идентификатор', 'login']]

    r2['alias'] = 'activity_owner_is_ex'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[61]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'Стоимость'
    ]]
    r2 = r2[
        r2['Стоимость'] % 10 != 0
        ][['Идентификатор', 'login']]

    r2['alias'] = 'terrific_precision'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[62]:

    r2 = df_org[[
        'Идентификатор', 'login', 'Сайт'
    ]]
    r2['what'] = r2['Сайт'].str.extract(r'(?P<website>.+\..+)')
    r2 = r2[(r2['what'].isna()) & (~r2['Сайт'].isna()) & (r2['Сайт'] != '')][['Идентификатор', 'login']]

    r2['alias'] = 'darkweb'
    r2['type'] = 'organization'
    r = pd.concat([r, r2])

    # In[63]:

    r2 = df_deal[
        (~df_deal['Ссылка на основную сделку (для дополнительных договоров)'].isna())
        & (df_deal['pipeline'] == 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ')
        ]
    r2['main'] = r2['Ссылка на основную сделку (для дополнительных договоров)'].str.extract(
        r'.*/(?P<tdeal_id>\d+)[^0-9]*')
    vc = df_deal[df_deal['Идентификатор'].isin(r2['main'].to_list())][['login', 'Идентификатор']]
    r2 = r2.join(vc.set_index('Идентификатор'), on='main', rsuffix=' (main)')
    r2 = r2[r2['login'] != r2['login (main)']][['Идентификатор', 'login']]

    r2['alias'] = 'two_nuns_have_the_kid'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[64]:

    r2 = df_deal[
        (~df_deal['Ссылка на основную сделку (для дополнительных договоров)'].isna())
        & (df_deal['pipeline'] == 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ')
        ]
    r2['main'] = r2['Ссылка на основную сделку (для дополнительных договоров)'].str.extract(
        r'.*/(?P<tdeal_id>\d+)[^0-9]*')
    vc = df_deal[df_deal['Идентификатор'].isin(r2['main'].to_list())][['login', 'Идентификатор']]
    r2 = r2.join(vc.set_index('Идентификатор'), on='main', rsuffix=' (main)')
    r2 = r2[
        (r2['login'].isin(['wubbo_ockels', 'toyohiro']))
        & (r2['login (main)'].isin(['wubbo_ockels', 'toyohiro']))
        & (r2['login'] != r2['login (main)'])

        ][['Идентификатор', 'login']]

    r2['alias'] = 'two_robots_have_the_kid'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[65]:

    r2 = df_deal[~df_deal['Состояние'].isin(['Открыто', 'Проигранa'])][['Идентификатор', 'login']]

    r2['alias'] = 'winner_r_we'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[66]:

    r2 = df_deal[
        (~df_deal['Ссылка на основную сделку (для дополнительных договоров)'].isna())
        & (df_deal['Ссылка на основную сделку (для дополнительных договоров)'] != '')
        ]
    r2['main'] = r2['Ссылка на основную сделку (для дополнительных договоров)'
    ].str.extract(r'.*/(?P<tdeal_id>\d+)[^0-9]*')
    vc = df_deal[df_deal['Идентификатор'].isin(r2['main'].to_list())
    ][['login', 'Идентификатор', 'org_id']]
    r2 = r2.join(
        df_org[[
            'Идентификатор',
            'Сегмент рынка',
            'Тип группы компаний'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )[['login', 'Идентификатор', 'main', 'Сегмент рынка', 'Тип группы компаний']]
    vc = vc.join(
        df_org[[
            'Идентификатор',
            'Сегмент рынка',
            'Тип группы компаний'
        ]].set_index('Идентификатор'),
        on='org_id', rsuffix=' (org)'
    )[['login', 'Идентификатор', 'Сегмент рынка', 'Тип группы компаний']]

    r2 = r2.join(vc.set_index('Идентификатор'), on='main', rsuffix=' (main)')
    r2 = r2[r2['Сегмент рынка'] != r2['Сегмент рынка (main)']]
    r2 = r2[
        (r2['Тип группы компаний'] != 'Без четкой связи')
        & (r2['Тип группы компаний (main)'] != 'Без четкой связи')
        ][['Идентификатор', 'login']]

    r2['alias'] = 'different_segments'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[67]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'person_id', 'stage', 'pipeline'
    ]]
    r2['person_id'] = r2['person_id'].fillna(0).astype(int)
    r2 = r2.join(
        df_person[[
            'Идентификатор',
            'Имя'
        ]].set_index('Идентификатор'),
        on='person_id', rsuffix=' (person)'
    )
    r2 = r2[
        (
                (r2['Имя'].fillna('').str.lower().str.contains('ххх'))
                | (r2['Имя'].fillna('').str.lower().str.contains('xxx'))
        )
        & (
                (r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ']))
                | (r2['stage'].isin(['ПЕРЕГОВОРЫ',
                                     'ПРИНЯТО РЕШЕНИЕ',
                                     'ЖДЕМ ДОГОВОР',
                                     'ВАЛИДАЦИЯ']))
        )
        ][['Идентификатор', 'login']]

    r2['alias'] = 'xxx_contact'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[68]:

    r2 = df_deal[
        (
                (~df_deal['Ссылка на основную сделку (для дополнительных договоров)'].isna())
                & (df_deal['Ссылка на основную сделку (для дополнительных договоров)'] != '')
        )
        & (~df_deal['pipeline'].isin(['ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ', 'DEBT-BRUT', 'DEBT-LONGIN']))
        ][['Идентификатор', 'login']]

    r2['alias'] = 'remove_main_link'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[69]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'stage', 'pipeline', '№ договора', 'Тип оплаты',
        'Продукт'
    ]]
    r2 = r2[
        (~r2['№ договора'].isna())
        & (r2['№ договора'] != '')
        & (r2['pipeline'].isin(['ЗАПУСК И РАЗВИТИЕ',
                                'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',
                                'САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ']))
        & (r2['Тип оплаты'] == 'ПОСТОПЛАТА')
        & (~r2['Продукт'].str.contains('Старая Яндекс Доставка'))
        ]
    r2 = r2.join(
        df_cc[['contract', 'faxed_dt', 'signed_dt', 'is_booked']].set_index('contract'),
        on='№ договора'
    )
    r2 = r2[
        (r2['signed_dt'].isna())
        & (
                (r2['faxed_dt'].isna())
                | (r2['is_booked'] == 'yes')
        )
        ][['login', 'Идентификатор']]
    r2['alias'] = 'no_scan'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[13]:

    r2 = df_deal[
        (df_deal['Состояние'] == 'Проигранa')
        & (
            (
                    (df_deal['Причина проигрыша'] == 'НЕ УСТРАИВАЕТ ПРЕДОПЛАТА')
                    & (df_deal['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ',
                                              'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ',
                                              'ПРОВЕСТИ ПРЕЗЕНТАЦИЮ', 'ПЕРЕГОВОРЫ']))
            )
        )
        ][[
        'Идентификатор', 'login'
    ]]
    r2['alias'] = 'lost_wrongly'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[14]:

    r2 = df_deal[
        (df_deal['Состояние'] == 'Проигранa')
        & (
            (
                    (df_deal['Причина проигрыша'] == 'НЕ УСТАНОВЛЕН КОНТАКТ (НИКОГДА)')
                    & (~df_deal['stage'].isin(['ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ']))
            )
        )
        & (~df_deal['pipeline'].isin(['ФЕНИКС']))
        ][[
        'Идентификатор', 'login'
    ]]
    r2['alias'] = 'lost_wrongly_no_contact'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[15]:

    r2 = df_deal[
        (df_deal['Состояние'] == 'Проигранa')
        & (
            (
                (df_deal['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ']))
            )
        )
        ][[
        'Идентификатор', 'login'
    ]]
    r2['alias'] = 'lost_wrongly_sale1'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[16]:

    r2 = df_deal[
        (df_deal['Состояние'] == 'Проигранa')
        & (
            (
                    (df_deal['Причина проигрыша'] == 'НЕ ЗАПУЩЕНА ДОСТАВКА')
                    & (df_deal['Дата следующей задачи'].isna())
            )
        )
        ][[
        'Идентификатор', 'login'
    ]]
    r2['alias'] = 'lost_wrongly_no_task'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[71]:

    r2 = df_custom_1.groupby('id')['contract'].apply(list).reset_index('id')
    r2['check'] = r2['contract'].apply(lambda x: len(set(x)))
    r2['last'] = r2['contract'].apply(lambda x: x[-1]).fillna('')
    r2 = r2[(r2['check'] > 2) | ((r2['check'] == 2) & (r2['last'] != ''))]
    r2['id'] = r2['id'].astype(str)
    r2 = r2[['id']].join(
        df_deal[['Идентификатор', 'login']].set_index('Идентификатор'),
        on='id'
    ).rename(columns={'id': 'Идентификатор'})
    r2['alias'] = 'mangled_contract'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[72]:

    df_custom_2['next_activity_id'] = df_custom_2['next_activity_id'].fillna('')
    df_custom_2['next_activity_date'] = df_custom_2['next_activity_date'].fillna(datetime.date(9999, 1, 1))
    r2 = df_custom_2.groupby('id')['next_activity_id'].apply(list).reset_index('id')
    r2 = r2.join(
        df_custom_2.groupby('id')['next_activity_date'].apply(list),
        on='id'
    )
    r2['activities'] = r2['next_activity_id'].apply(lambda x: len(set(x)))
    r2['activity_dts'] = r2['next_activity_date'].apply(lambda x: x[0] > x[1] if len(x) > 1 else False)
    r2 = r2[(r2['activities'] == 1)
            & (r2['activity_dts'] == True)]
    r2['id'] = r2['id'].astype(str)
    r2 = r2[['id']].join(
        df_deal[['Идентификатор', 'login']].set_index('Идентификатор'),
        on='id'
    ).rename(columns={'id': 'Идентификатор'})
    r2['alias'] = 'aint_cheating'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[73]:

    r2 = df_deal[[
        'Идентификатор', 'login', 'stage', 'Последнее изменение этапа', 'Состояние'
    ]]
    r2 = r2[
        (r2['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ', 'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ',
                           'СТАРТ']))
        & (r2['Состояние'] != 'Проигранa')
        & (pd.to_datetime(r2['Последнее изменение этапа'])
           < pd.to_datetime((datetime.datetime.now() - datetime.timedelta(days=14)).date()))
        ][['login', 'Идентификатор']]
    r2['alias'] = 'stuck_at_very_start'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[74]:

    vc = df_cc['contract'].to_list()
    r2 = df_deal[
        (~df_deal['№ договора'].isin(vc))
        & (~df_deal['№ договора'].isna())
        & (df_deal['№ договора'] != '')
        & (df_deal['Продукт'] != 'Старая Яндекс Доставка')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'contract_ufo'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[75]:

    r2 = df_deal[
        (~df_deal['Тикет LOGISTARIFF'].str.contains(
            '^https://st.yandex-team.ru/(?:FP|NDDPROD|CMTARIFF)-\d+$',
            regex=True,
            na=False)
         )
        & (~df_deal['Тикет LOGISTARIFF'].isna())
        & (df_deal['Тикет LOGISTARIFF'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'ticket_fp'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[76]:

    r2 = df_deal[
        (~df_deal['Тикет LegalTaxi'].str.contains(
            '^https://st.yandex-team.ru/(LEGALTAXI|INTERCO)-\d+$',
            regex=True,
            na=False)
         )
        & (~df_deal['Тикет LegalTaxi'].isna())
        & (df_deal['Тикет LegalTaxi'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'ticket_lt'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[77]:

    r2 = df_deal[
        (~df_deal['Тикет ManCalcs (MancDelivery)'].str.contains(
            '^https://st.yandex-team.ru/((MANCALCS)|(MANCDELIVERY))-\d+$',
            regex=True,
            na=False)
         )
        & (~df_deal['Тикет ManCalcs (MancDelivery)'].isna())
        & (df_deal['Тикет ManCalcs (MancDelivery)'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'ticket_mc'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[78]:

    r2 = df_deal[
        (~df_deal['Тикет на интеграцию'].str.contains(
            '^https://st.yandex-team.ru/CORPINT-\d+$',
            regex=True,
            na=False)
         )
        & (~df_deal['Тикет на интеграцию'].isna())
        & (df_deal['Тикет на интеграцию'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'ticket_corpint'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[79]:

    r2 = df_deal[
        (~df_deal['Тикет на тестовый кабинет'].str.contains(
            '^https://st.yandex-team.ru/TESTCLIENT(LOGIS)?-\d+$',
            regex=True,
            na=False)
         )
        & (~df_deal['Тикет на тестовый кабинет'].isna())
        & (df_deal['Тикет на тестовый кабинет'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'ticket_tst'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    # In[80]:

    r2 = df_org[
        (~df_org['Тикет PR & Marketing'].str.contains(
            '^https://st.yandex-team.ru/GB?-\d+$',
            regex=True,
            na=False)
         )
        & (~df_org['Тикет PR & Marketing'].isna())
        & (df_org['Тикет PR & Marketing'] != '')
        ][['login', 'Идентификатор']]
    r2['alias'] = 'ticket_gb'
    r2['type'] = 'org'
    r = pd.concat([r, r2])

    # In[81]:

    r2 = df_deal[
        (
                (df_deal['Продукт'].isna())
                | (df_deal['Продукт'] == '')
        )
        & (
                ~(df_deal['pipeline'].isin(['ХОЛОД', 'САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ',
                                            'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ']))
                & ~(df_deal['stage'].isin(['ИЗУЧИТЬ И ЗАБРАТЬ',
                                           'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ',
                                           'ПРОВЕСТИ ПРЕЗЕНТАЦИЮ', 'ПЕРЕГОВОРЫ',
                                           'БАЗА']))
        )
        & (
                (pd.to_datetime(df_deal['Время проигрыша']) > pd.to_datetime('2021-01-01'))
                | (df_deal['Время проигрыша'].isna())
        )
        ]
    r2 = r2[~(
            (r2['stage'] == 'СТАРТ')
            & (r2['Тип договора'] == 'ОФЕРТА')
    )
    ][['login', 'Идентификатор']]
    r2['alias'] = 'no_product'
    r2['type'] = 'deal'
    r = pd.concat([r, r2])

    return r


def main_(bkp=False):
    logging.info('go start')

    r = mainx()
    logging.info(f'mainx done, len = {len(r)}')

    sql = """delete
    from snb_b2b.hygfilter_hist as i
    where i.dt::date = now()::date;
    select now()::date
    """
    _ = greenplum(sql)
    # conn = get_cursor()
    # cursor = conn.cursor()
    # cursor.execute(sql)
    # conn.commit()
    # conn.close()

    logging.info('deleted from hygfilter_hist')
    r['Идентификатор'] = r['Идентификатор'].fillna(0).astype(int).astype(str)
    r['dt'] = datetime.datetime.now().date()
    print(r['alias'].value_counts())
    r = r[['alias', 'data', 'dt', 'login', 'type', 'Идентификатор']]
    logging.info('ready to insert')
    greenplum.write_table('snb_b2b.hygfilter_hist', r, if_exists='append')
    logging.info('go success')

def tst():
    r = pd.read_csv('tmp', sep='\t')
    r['Идентификатор'] = r['Идентификатор'].fillna(0).astype(int).astype(str)
    greenplum.write_table('snb_b2b.hygfilter_hist', r, if_exists='append')


def mailit():
    logging.info('mail start')
    query = """
select i."Идентификатор",
       i.alias,
       i.type,
       i.login,
       m.hierarchy,
       i.data,
       m.lead_name_last || ' ' || m.lead_name_first       as lead,
       case when y.alias is null then 'no' else 'yes' end as existed_yesterday
from snb_b2b.hygfilter_hist as i
  left join snb_b2b.voytekh_manager_v2 as m
    on i.login = m.login
  left join (
    select distinct i."Идентификатор", i.alias, i.type
    from snb_b2b.hygfilter_hist as i
    where i.dt::date = (now() - INTERVAL '1 DAY')::date
  ) as y
    on i."Идентификатор" = y."Идентификатор"
    and i.alias = y.alias
    and i.type = y.type
where i.dt::date = now()::date
    """

    key_file = 'keys.json'
    key_key = 'gp_token'
    df = greenplum(query)
    df['link'] = df.apply(lambda x: f'https://yandexdelivery.pipedrive.com/{x["type"]}/{x["Идентификатор"]}', axis=1)
    df = df[['alias', 'hierarchy', 'link', 'login', 'lead', 'data', 'existed_yesterday']].join(base.set_index('alias'), on='alias')
    df = df.rename(columns={'login': 'manager'})

    main2(
        # define who receivers are. can use all attributes at once. value should be a list of strings or None
        receivers_url=['yandex_rkub_taxi_dev_corp_dep13862', 'outstaff_2289_8095_dep36242',
                       'outstaff_2289_6747_dep94284_dep80684_dep95183', 'yandex_rkub_taxi_dev_corp_dep31858',
                       'yandex_rkub_taxi_dep80055_dep49675',
                       'outstaff_2289_dep60996_dep82934', 'yandex_rkub_taxi_dep80055_dep49675_dep81903'
                       ],  # add to receivers all people from specific groups at staff
        receivers_ancestors=['outstaff_2289_6747_dep94284_dep80684_dep95183', 'outstaff_2289_6747_dep94284_dep80684',
                             'yandex_rkub_taxi_dev_corp_dep13862', 'yandex_rkub_taxi_dep80055_dep49675_dep81903'],
        receivers_logins=['ferenec', 'lyadovayuliya'],  # add to receivers people by logins
        exclude_logins=['sinelnikov', ],  # do not send to these people, if they are selected in 3 parameters above
        flat=None,  # list of logins to send all rows to
        mail_name='Инквизитор СРМ логистики.',  # name of letter
        mail_text=f'Инквизитор СРМ логистики \n{note}',  # body of letter
        mail_cc=['voytekh@yandex-team.ru','ferenec@yandex_team.ru'],  # send a copy to listed emails  'bmiklaz@yandex-team.ru' #'voytekh@yandex-team.ru',
        hierarchy=True,
        # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
        emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
        key_file=key_file,  # where the keys are
        key_key=key_key,  # key of gp token in file
        user='robot-corploader',  # user for gp. defaults to user='robot-corploader'
        host='gpdb-master.taxi.yandex.net',
        sheets=[
            {'query': None,
             'df': df,
             'exclude_columns': None,
             'col_names': None,
             'sheet_name': 'data'}
        ]
    )
    logging.info('mail success')


def mailflat():
    logging.info('flat start')
    query = """
select i."Идентификатор",
       i.alias,
       i.type,
       i.login,
       m.hierarchy,
       i.data,
       m.lead_name_last || ' ' || m.lead_name_first       as lead,
       case when y.alias is null then 'no' else 'yes' end as existed_yesterday
from snb_b2b.hygfilter_hist as i
  left join snb_b2b.voytekh_manager_v2 as m
    on i.login = m.login
  left join (
    select distinct i."Идентификатор", i.alias, i.type
    from snb_b2b.hygfilter_hist as i
    where i.dt::date = (now() - INTERVAL '1 DAY')::date
  ) as y
    on i."Идентификатор" = y."Идентификатор"
    and i.alias = y.alias
    and i.type = y.type
where i.dt::date = now()::date
    """

    key_file = 'keys.json'
    key_key = 'gp_token'
    df = greenplum(query)
    df['link'] = df.apply(lambda x: f'https://yandexdelivery.pipedrive.com/{x["type"]}/{x["Идентификатор"]}', axis=1)
    df = df[['alias', 'hierarchy', 'link', 'login', 'lead', 'data', 'existed_yesterday']].join(base.set_index('alias'), on='alias')
    df = df.rename(columns={'login': 'manager'})

    main2(
        # define who receivers are. can use all attributes at once. value should be a list of strings or None
        receivers_url=None,  # add to receivers all people from specific groups at staff
        receivers_ancestors=None,
        receivers_logins=[],  # add to receivers people by logins
        exclude_logins=['sinelnikov', ],  # do not send to these people, if they are selected in 3 parameters above
        flat= ['niksm', 'alextitov', 'voytekh', 'gaman', 'suvorov-a-v', 'churkin-es', 'klipovka', 'ozotina',
              'sysolyatina-d', 'dariadushkina', 'anashche', 'fedorivashkin', 'lengardn', 'ferenec', 'imchigrin', 'natpetrova'],  # list of logins to send all rows to
        mail_name='Инквизитор СРМ логистики.',  # name of letter
        mail_text=f'Инквизитор СРМ логистики \n{note}\n\nПолезные ссылки:\nhttps://tableau.taxi.yandex-team.ru/#/views/rebuild2/Dashboard2 Отчет в Tableau\nhttps://wiki.yandex-team.ru/logistics/gigfiltry-crm-dostavki/ Вики',  # body of letter
        mail_cc=None,#['voytekh@yandex-team.ru'],  # send a copy to listed emails
        hierarchy=True,
        # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
        emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
        key_file=key_file,  # where the keys are
        key_key=key_key,  # key of gp token in file
        user='robot-corploader',  # user for gp. defaults to user='robot-corploader'
        host='gpdb-master.taxi.yandex.net',
        sheets=[
            {'query': None,
             'df': df,
             'exclude_columns': None,
             'col_names': None,
             'sheet_name': 'data'}
        ]
    )
    logging.info('flat success')

    main2(
        # define who receivers are. can use all attributes at once. value should be a list of strings or None
        receivers_url=None,  # add to receivers all people from specific groups at staff
        receivers_ancestors=None,
        receivers_logins=[],  # add to receivers people by logins
        exclude_logins=['sinelnikov', ],  # do not send to these people, if they are selected in 3 parameters above
        flat=['niksm', 'ozotina', 'ferenec', 'natpetrova'],  # list of logins to send all rows to
        mail_name='Инквизитор СРМ логистики.',  # name of letter
        mail_text=f'Инквизитор СРМ логистики, Магистраль \n{note}\n\nПолезные ссылки:\nhttps://tableau.taxi.yandex-team.ru/#/views/rebuild2/Dashboard2 Отчет в Tableau\nhttps://wiki.yandex-team.ru/logistics/gigfiltry-crm-dostavki/ Вики',  # body of letter
        mail_cc=['voytekh@yandex-team.ru','savelyevtimur@yandex-team.ru', 'ferenec@yandex-team.ru'],  # send a copy to listed emails #
        hierarchy=True,
        # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
        emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
        key_file=key_file,  # where the keys are
        key_key=key_key,  # key of gp token in file
        user='robot-corploader',  # user for gp. defaults to user='robot-corploader'
        host='gpdb-master.taxi.yandex.net',
        sheets=[
            {'query': None,
             'df': df[df.manager.isin(['s.savatich', 'a.chertykovcev', 'a.semenov', 'karpovsergey', 'ay-druzhinin',
                                      'anadorov', 'kucherjulia', 'i.kovtun', 'mdadilov', 'antonov-i', 'savelyevtimur',
                                      'sggladkov', 'vrusan', 'a.arbatckaya', 'peterenko-i', 'y.vyunova', 'olgaivantsova',
                                      'd.shacev', 'i.salmin', 'korytko', 'd.zamyatin', 'm.sokolova', 'korobkovlada'])],
             'exclude_columns': None,
             'col_names': None,
             'sheet_name': 'data'}
        ]
    )
    logging.info('flat magistral success')

import logging

if __name__ == '__main__':
    # locale.setlocale(locale.LC_ALL, 'en_US.UTF-8')

    logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                        format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
    logging.info('START')

    note = []
    main_()
    mailit()
    mailflat()

    logging.info('SUCCESS')
