insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_client_rebirth_637', 'Start', clock_timestamp());

drop table if exists niksm_temp_dash_client_rebirth_637_res;
create temporary table niksm_temp_dash_client_rebirth_637_res as
with raw as (
    select person_inn, person_kpp,
           blnc.client_id as billing_client_id,
           lk_client_id as corp_client_id,
           blnc.contract_external_id as corp_contract_id,
           start_dt,
           finish_dt,
           ctp.tariff_plan_series_id,
           ctp.tariff_plan_name as tariff_plan_series_name,
           lk_service_is_active,
           case when legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
                when legal_contract_taxi  = 1 then 'ООО Яндекс.Такси' end as legal_entity,
           which_crm,
           manager_group,
           lead_name,
           manager_name,
           1 - row_number() over (partition by person_inn, person_kpp order by start_dt desc) as rn
    from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
      join snb_b2b.niksm_b2b_lk_client_service_info lk
        on lk_service_name = 'cargo'
        and blnc.client_id = lk.billing_client_id::integer
      left join snb_b2b.dbcorp_client_tariff_plan_current ctp
        on ctp.corp_client_id = lk.lk_client_id
        and service_name = 'cargo'
      left join snb_b2b.niksm_b2b_contracts_info as crm
        on crm.contract_id = blnc.contract_external_id
    where (legal_contract_cargo = 1 or legal_contract_taxi = 1)
)
select person_inn, person_kpp,
       --
       max(case when rn = -1 then billing_client_id end) as old_billing_client_id,
       max(case when rn = -1 then corp_client_id end) as old_corp_client_id,
       max(case when rn = -1 then corp_contract_id end) as old_corp_contract_id,
       max(case when rn = -1 then legal_entity end) as old_legal_entity,
       max(case when rn = -1 then start_dt end) as old_start_dt,
       max(case when rn = -1 then finish_dt end) as old_finish_dt,
       max(case when rn = -1 then tariff_plan_series_id end) as old_tariff_plan_series_id,
       max(case when rn = -1 then tariff_plan_series_name end) as old_tariff_plan_series_name,
       --
       max(case when rn = 0 then billing_client_id end) as new_billing_client_id,
       max(case when rn = 0 then corp_client_id end) as new_corp_client_id,
       max(case when rn = 0 then corp_contract_id end) as new_corp_contract_id,
       max(case when rn = 0 then legal_entity end) as new_legal_entity,
       max(case when rn = 0 then start_dt end) as new_start_dt,
       max(case when rn = 0 then finish_dt end) as new_finish_dt,
       max(case when rn = 0 then tariff_plan_series_id end) as new_tariff_plan_series_id,
       max(case when rn = 0 then tariff_plan_series_name end) as new_tariff_plan_series_name,
       max(case when rn = 0 then lk_service_is_active end) as new_lk_service_is_active,
       max(case when rn = 0 then which_crm end) as which_crm,
       max(case when rn = 0 then manager_group end) as manager_group,
       max(case when rn = 0 then lead_name end) as lead_name,
       max(case when rn = 0 then manager_name end) as manager_name
from raw
where rn in (-1,0)
group by person_inn, person_kpp
having count(case when rn = -1 then 1 end) > 0
  and max(case when rn = 0 then start_dt end) > '2021-07-01'
  and max(case when rn = 0 then which_crm end) = 6;


-- drop table if exists snb_b2b.niksm_dash_client_rebirth_637;
-- create table snb_b2b.niksm_dash_client_rebirth_637 as
truncate table snb_b2b.niksm_dash_client_rebirth_637;
insert into snb_b2b.niksm_dash_client_rebirth_637
    (person_inn, person_kpp,
       old_billing_client_id, old_corp_client_id, old_corp_contract_id, old_legal_entity, old_start_dt, old_finish_dt, old_tariff_plan_series_id, old_tariff_plan_series_name,
       new_billing_client_id, new_corp_client_id, new_corp_contract_id, new_legal_entity, new_start_dt, new_finish_dt, new_tariff_plan_series_id, new_tariff_plan_series_name,
       new_lk_service_is_active, which_crm, manager_group, lead_name, manager_name)
select person_inn, person_kpp,
       old_billing_client_id, old_corp_client_id, old_corp_contract_id, old_legal_entity, old_start_dt, old_finish_dt, old_tariff_plan_series_id, old_tariff_plan_series_name,
       new_billing_client_id, new_corp_client_id, new_corp_contract_id, new_legal_entity, new_start_dt, new_finish_dt, new_tariff_plan_series_id, new_tariff_plan_series_name,
       new_lk_service_is_active, which_crm, manager_group, lead_name, manager_name
from niksm_temp_dash_client_rebirth_637_res;

-- comment on table snb_b2b.niksm_dash_client_rebirth_637 is 'Связка нового и старого клиента Доставки через ИНН/КПП. Для дэша Client rebirth. LOGDATA-637';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_dash_client_rebirth_637', 'Finish', clock_timestamp());
