insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata496', 'Start', clock_timestamp());

drop table if exists niksm_b2b_logdata496_res;
create temporary table niksm_b2b_logdata496_res as
with blnc as (
    select billing_contract_id,
           contract_external_id,
           person_inn,
           client,
           contract_type,
           payment_type,
           is_active as billing_contract_is_active,
           start_dt,
           greatest(
               coalesce(start_dt, '2099-12-31'::date),
               least(
                   coalesce(faxed_dt, '2099-12-31'::date),
                   coalesce(signed_dt, '2099-12-31'::date)
                   )
               ) as start_dt_exp,
           case
               when contract_type = 'Договор-оферта' then min_payment_date_v2
               when payment_type = 'предоплата' then start_dt
               else least(signed_dt, faxed_dt, booked_dt)
            end as activated_dt,
           coalesce(least(finish_dt, cancelled_dt, suspended_dt), '2099-12-31'::date) as finish_dt_exp,
           legal_contract_cargo,
           legal_contract_taxi,
           start_dt = min(start_dt) over (partition by person_inn) as first_contract_flg
    from snb_b2b.niksm_b2b_balance_contract_info
)
select blnc.billing_contract_id,
       blnc.contract_external_id,
       person_inn,
       case
        when blnc.contract_type = 'Не агентский' then
           case when blnc.payment_type = 'постоплата' then 'Договор постоплата'
               when blnc.payment_type = 'предоплата' then
                case when coalesce(quasi_threshold_ccy_value<0,false)
                    then 'Договор квази постоплата' else 'Договор предоплата' end
               end
        when blnc.contract_type = 'Договор-оферта' then
            case when blnc.payment_type = 'предоплата' then
                case when coalesce(quasi_threshold_ccy_value<0,false)
                    then 'Оферта квази постоплата' else 'Оферта предоплата' end
               end
        end as contract_type_exp,
       blnc.contract_type,
       blnc.payment_type,
       blnc.billing_contract_is_active,
       case when legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
           when legal_contract_taxi = 1 then 'ООО Яндекс.Такси'
               end as legal_entity,
       start_dt,
       start_dt_exp,
       activated_dt,
       finish_dt_exp,
       first_contract_flg,
       --
       ((service_active_flg_dict->>'cargo')::bool)::int as lk_cargo_is_active,
       --
       manager_group,
       teamlead_name as lead_name,
       coalesce(manager_name,manager_login) as manager_name,
       6 as which_crm,
       lead_id as deal_id,
       COALESCE(holding_name, company_name::character varying)::text AS client_name,
       permissions
from blnc
  join snb_b2b.amo_contracts_info as crm
    on crm.contract_id = blnc.contract_external_id
  left join snb_b2b.dbcorp_contract_info as lk
    on lk.corp_contract_id = blnc.contract_external_id
where true
  and crm_source = 'yandexdelivery'
  and manager_metagroup in ('Тир 1','Тир 2','СНГ','Тир 3')
  and start_dt between current_date-90 and current_date-1;

-- drop table if exists snb_b2b.niksm_b2b_logdata496;
-- create table snb_b2b.niksm_b2b_logdata496 as
truncate table snb_b2b.niksm_b2b_logdata496;
insert into snb_b2b.niksm_b2b_logdata496
    (billing_contract_id, contract_external_id, person_inn, contract_type_exp, contract_type, payment_type,
       billing_contract_is_active, legal_entity, start_dt, start_dt_exp, activated_dt, finish_dt_exp,
       first_contract_flg, lk_cargo_is_active, manager_group, lead_name, manager_name,
       which_crm, deal_id, client_name, permissions)
select billing_contract_id, contract_external_id, person_inn, contract_type_exp, contract_type, payment_type,
       billing_contract_is_active, legal_entity, start_dt, start_dt_exp, activated_dt, finish_dt_exp,
       first_contract_flg, lk_cargo_is_active, manager_group, lead_name, manager_name,
       which_crm, deal_id, client_name, permissions
from niksm_b2b_logdata496_res;

-- comment on table snb_b2b.niksm_b2b_logdata496 is 'Витрина для дашборда Contract dynamics';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata496', 'Finish', clock_timestamp());
